/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.DelegatingBeanDefinition;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ParametrizedBeanFactory;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
class BeanDefinitionDelegate<T>
extends AbstractBeanContextConditional
implements DelegatingBeanDefinition<T>,
BeanFactory<T>,
NameResolver,
ValueResolver<String> {
    static final String PRIMARY_ATTRIBUTE = Primary.class.getName();
    protected final BeanDefinition<T> definition;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();

    private BeanDefinitionDelegate(BeanDefinition<T> definition) {
        if (!(definition instanceof BeanFactory)) {
            throw new IllegalArgumentException("Delegate can only be used for bean factories");
        }
        this.definition = definition;
    }

    @Override
    public boolean isAbstract() {
        return this.definition.isAbstract();
    }

    @Override
    public boolean isProxy() {
        return this.definition.isProxy();
    }

    BeanDefinition<T> getDelegate() {
        return this.definition;
    }

    @Override
    public Optional<Class<? extends Annotation>> getScope() {
        return this.definition.getScope();
    }

    @Override
    public boolean isSingleton() {
        return this.definition.isSingleton();
    }

    @Override
    public boolean isProvided() {
        return this.definition.isProvided();
    }

    @Override
    public boolean isIterable() {
        return this.get(EachProperty.class.getName(), Class.class) != null || this.definition.isIterable();
    }

    @Override
    public boolean isPrimary() {
        return this.definition.isPrimary() || this.get(PRIMARY_ATTRIBUTE, Boolean.class).orElse(false) != false;
    }

    @Override
    public Class<T> getBeanType() {
        return this.definition.getBeanType();
    }

    @Override
    public Optional<Class<?>> getDeclaringType() {
        return this.definition.getDeclaringType();
    }

    @Override
    public ConstructorInjectionPoint<T> getConstructor() {
        return this.definition.getConstructor();
    }

    @Override
    public Collection<Class> getRequiredComponents() {
        return this.definition.getRequiredComponents();
    }

    @Override
    public Collection<MethodInjectionPoint> getInjectedMethods() {
        return this.definition.getInjectedMethods();
    }

    @Override
    public Collection<FieldInjectionPoint> getInjectedFields() {
        return this.definition.getInjectedFields();
    }

    @Override
    public Collection<MethodInjectionPoint> getPostConstructMethods() {
        return this.definition.getPostConstructMethods();
    }

    @Override
    public Collection<MethodInjectionPoint> getPreDestroyMethods() {
        return this.definition.getPreDestroyMethods();
    }

    @Override
    public String getName() {
        return this.definition.getName();
    }

    @Override
    public <R> Optional<ExecutableMethod<T, R>> findMethod(String name, Class[] argumentTypes) {
        return this.definition.findMethod(name, argumentTypes);
    }

    @Override
    public <R> Stream<ExecutableMethod<T, R>> findPossibleMethods(String name) {
        return this.definition.findPossibleMethods(name);
    }

    @Override
    public T inject(BeanContext context, T bean) {
        return this.definition.inject(context, bean);
    }

    @Override
    public T inject(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
        return this.definition.inject(resolutionContext, context, bean);
    }

    @Override
    public Collection<ExecutableMethod<T, ?>> getExecutableMethods() {
        return this.definition.getExecutableMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T build(BeanResolutionContext resolutionContext, BeanContext context, BeanDefinition<T> definition) throws BeanInstantiationException {
        resolutionContext.putAll(this.attributes);
        try {
            if (this.definition instanceof ParametrizedBeanFactory) {
                ParametrizedBeanFactory parametrizedBeanFactory = (ParametrizedBeanFactory)((Object)this.definition);
                Argument<?>[] requiredArguments = parametrizedBeanFactory.getRequiredArguments();
                Object named = this.attributes.get(Named.class.getName());
                if (named != null) {
                    LinkedHashMap<String, Object> fulfilled = new LinkedHashMap<String, Object>();
                    for (Argument<?> argument : requiredArguments) {
                        Class argumentType = argument.getType();
                        Optional result = ConversionService.SHARED.convert(named, argumentType);
                        String argumentName = argument.getName();
                        if (result.isPresent()) {
                            fulfilled.put(argumentName, result.get());
                            continue;
                        }
                        Optional bean = context.findBean(argumentType, Qualifiers.byName(named.toString()));
                        if (!bean.isPresent()) continue;
                        fulfilled.put(argumentName, bean.get());
                    }
                    T t = parametrizedBeanFactory.build(resolutionContext, context, definition, fulfilled);
                    return t;
                }
            }
            T t = ((BeanFactory)((Object)this.definition)).build(resolutionContext, context, definition);
            return t;
        }
        finally {
            for (String key : this.attributes.keySet()) {
                resolutionContext.remove(key);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanDefinitionDelegate that = (BeanDefinitionDelegate)o;
        return Objects.equals(this.definition, that.definition) && Objects.equals(this.resolveName().orElse(null), that.resolveName().orElse(null));
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.resolveName().orElse(null));
    }

    @Override
    public BeanDefinition<T> getTarget() {
        return this.definition;
    }

    public Optional<String> resolveName() {
        return this.get(Named.class.getName(), String.class);
    }

    public void put(String name, Object value) {
        this.attributes.put(name, value);
    }

    public <T> Optional<T> get(String name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.attributes.get(name);
        if (value != null && conversionContext.getArgument().getType().isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.definition.toString();
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition) {
        if (definition instanceof InitializingBeanDefinition || definition instanceof DisposableBeanDefinition) {
            if (definition instanceof ValidatedBeanDefinition) {
                return new LifeCycleValidatingDelegate(definition);
            }
            return new LifeCycleDelegate(definition);
        }
        if (definition instanceof ValidatedBeanDefinition) {
            return new ValidatingDelegate(definition);
        }
        return new BeanDefinitionDelegate<T>(definition);
    }

    private static final class LifeCycleValidatingDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyValidatingBeanDefinition<T>,
    ProxyInitializingBeanDefinition<T>,
    ProxyDisposableBeanDefinition<T> {
        private LifeCycleValidatingDelegate(BeanDefinition<T> definition) {
            super(definition);
        }
    }

    private static final class ValidatingDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyValidatingBeanDefinition<T> {
        private ValidatingDelegate(BeanDefinition<T> definition) {
            super(definition);
        }
    }

    private static final class LifeCycleDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyInitializingBeanDefinition<T>,
    ProxyDisposableBeanDefinition<T> {
        private LifeCycleDelegate(BeanDefinition<T> definition) {
            super(definition);
        }
    }

    static interface ProxyValidatingBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    ValidatedBeanDefinition<T> {
        @Override
        default public T validate(BeanResolutionContext resolutionContext, T instance) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof ValidatedBeanDefinition) {
                return ((ValidatedBeanDefinition)definition).validate(resolutionContext, instance);
            }
            return instance;
        }
    }

    static interface ProxyDisposableBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    DisposableBeanDefinition<T> {
        @Override
        default public T dispose(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof DisposableBeanDefinition) {
                return ((DisposableBeanDefinition)definition).dispose(resolutionContext, context, bean);
            }
            return bean;
        }
    }

    static interface ProxyInitializingBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    InitializingBeanDefinition<T> {
        @Override
        default public T initialize(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof InitializingBeanDefinition) {
                return ((InitializingBeanDefinition)definition).initialize(resolutionContext, context, bean);
            }
            return bean;
        }
    }
}

