/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AnnotationProcessorListener;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.env.BootstrapPropertySourceLocator;
import io.micronaut.context.env.DefaultEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.naming.Named;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultApplicationContext
extends DefaultBeanContext
implements ApplicationContext {
    private final ConversionService conversionService;
    private final ClassPathResourceLoader resourceLoader;
    private Environment environment;
    private Iterable<BeanConfiguration> resolvedConfigurations;
    private List<BeanDefinitionReference> resolvedBeanReferences;

    public DefaultApplicationContext(final String ... environmentNames) {
        this(new ApplicationContextConfiguration(){

            @Override
            @Nonnull
            public List<String> getEnvironments() {
                ArgumentUtils.requireNonNull((String)"environmentNames", (Object)environmentNames);
                return Arrays.asList(environmentNames);
            }
        });
    }

    public DefaultApplicationContext(final @Nonnull ClassPathResourceLoader resourceLoader, final String ... environmentNames) {
        this(new ApplicationContextConfiguration(){

            @Override
            @Nonnull
            public ClassLoader getClassLoader() {
                return this.getResourceLoader().getClassLoader();
            }

            @Override
            @Nonnull
            public ClassPathResourceLoader getResourceLoader() {
                ArgumentUtils.requireNonNull((String)"resourceLoader", (Object)resourceLoader);
                return resourceLoader;
            }

            @Override
            @Nonnull
            public List<String> getEnvironments() {
                ArgumentUtils.requireNonNull((String)"environmentNames", (Object)environmentNames);
                return Arrays.asList(environmentNames);
            }
        });
    }

    public DefaultApplicationContext(@Nonnull ApplicationContextConfiguration configuration) {
        super(configuration);
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.conversionService = this.createConversionService();
        this.resourceLoader = configuration.getResourceLoader();
        this.environment = this.createEnvironment(configuration);
    }

    @Override
    @Nonnull
    public <T> ApplicationContext registerSingleton(@Nonnull Class<T> type, @Nonnull T singleton, @Nullable Qualifier<T> qualifier, boolean inject) {
        return (ApplicationContext)super.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, inject);
    }

    @Override
    @Nonnull
    protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
        if (this.resolvedConfigurations != null) {
            return this.resolvedConfigurations;
        }
        return super.resolveBeanConfigurations();
    }

    @Override
    @Nonnull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
        if (this.resolvedBeanReferences != null) {
            return this.resolvedBeanReferences;
        }
        return super.resolveBeanDefinitionReferences();
    }

    @Deprecated
    @Nonnull
    protected DefaultEnvironment createEnvironment(String ... environmentNames) {
        return this.createEnvironment(() -> Arrays.asList(environmentNames));
    }

    @Nonnull
    protected DefaultEnvironment createEnvironment(@Nonnull ApplicationContextConfiguration configuration) {
        return new RuntimeConfiguredEnvironment(configuration);
    }

    @Nonnull
    protected ConversionService createConversionService() {
        return ConversionService.SHARED;
    }

    @Override
    @Nonnull
    public ConversionService<?> getConversionService() {
        return this.conversionService;
    }

    @Override
    @Nonnull
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    @Nonnull
    public synchronized ApplicationContext start() {
        this.startEnvironment();
        return (ApplicationContext)super.start();
    }

    @Override
    @Nonnull
    public synchronized ApplicationContext stop() {
        return (ApplicationContext)super.stop();
    }

    public boolean containsProperty(String name) {
        return this.getEnvironment().containsProperty(name);
    }

    public boolean containsProperties(String name) {
        return this.getEnvironment().containsProperties(name);
    }

    public <T> Optional<T> getProperty(String name, ArgumentConversionContext<T> conversionContext) {
        return this.getEnvironment().getProperty(name, conversionContext);
    }

    @Nonnull
    public Map<String, Object> getProperties(@Nullable String name, @Nullable StringConvention keyFormat) {
        return this.getEnvironment().getProperties(name, keyFormat);
    }

    @Override
    protected void registerConfiguration(BeanConfiguration configuration) {
        if (this.getEnvironment().isActive(configuration)) {
            super.registerConfiguration(configuration);
        }
    }

    protected void startEnvironment() {
        Environment defaultEnvironment = this.getEnvironment();
        defaultEnvironment.start();
        this.registerSingleton(Environment.class, defaultEnvironment);
        this.registerSingleton(new AnnotationProcessorListener());
    }

    @Override
    protected void initializeContext(List<BeanDefinitionReference> contextScopeBeans, List<BeanDefinitionReference> processedBeans) {
        this.initializeTypeConverters(this);
        super.initializeContext(contextScopeBeans, processedBeans);
    }

    @Override
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(Class<T> beanType, BeanDefinition<?> filter) {
        Collection<BeanDefinition<T>> candidates = super.findBeanCandidates(beanType, filter);
        if (!candidates.isEmpty()) {
            ArrayList transformedCandidates = new ArrayList();
            for (BeanDefinition candidate : candidates) {
                if (candidate.hasDeclaredStereotype(EachProperty.class)) {
                    String property = candidate.getValue(EachProperty.class, String.class).orElse(null);
                    String primaryPrefix = candidate.getValue(EachProperty.class, "primary", String.class).orElse(null);
                    if (StringUtils.isNotEmpty((CharSequence)property)) {
                        Map entries = (Map)this.getProperty(property, Map.class, Collections.emptyMap());
                        if (entries.isEmpty()) continue;
                        for (Object key : entries.keySet()) {
                            BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(candidate);
                            if (primaryPrefix != null && primaryPrefix.equals(key.toString())) {
                                delegate.put(BeanDefinitionDelegate.PRIMARY_ATTRIBUTE, true);
                            }
                            delegate.put(EachProperty.class.getName(), delegate.getBeanType());
                            delegate.put(Named.class.getName(), key.toString());
                            if (!delegate.isEnabled(this)) continue;
                            transformedCandidates.add(delegate);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Blank value specified to @Each property for bean: " + candidate);
                }
                if (candidate.hasDeclaredStereotype(EachBean.class)) {
                    Class dependentType = candidate.getValue(EachBean.class, Class.class).orElse(null);
                    if (dependentType == null) {
                        transformedCandidates.add(candidate);
                        continue;
                    }
                    Collection<BeanDefinition<T>> dependentCandidates = this.findBeanCandidates(dependentType, null);
                    if (dependentCandidates.isEmpty()) continue;
                    for (BeanDefinition dependentCandidate : dependentCandidates) {
                        Optional<Qualifier> optional;
                        BeanDefinitionDelegate delegate = BeanDefinitionDelegate.create(candidate);
                        if (dependentCandidate instanceof BeanDefinitionDelegate) {
                            BeanDefinitionDelegate parentDelegate = (BeanDefinitionDelegate)dependentCandidate;
                            optional = parentDelegate.get(Named.class.getName(), String.class).map(Qualifiers::byName);
                        } else {
                            Optional qualifierName = dependentCandidate.getAnnotationNameByStereotype(javax.inject.Qualifier.class);
                            optional = qualifierName.map(name -> Qualifiers.byAnnotation((AnnotationMetadata)dependentCandidate, name));
                        }
                        if (dependentCandidate.isPrimary()) {
                            delegate.put(BeanDefinitionDelegate.PRIMARY_ATTRIBUTE, true);
                        }
                        optional.ifPresent(qualifier -> {
                            Argument<?>[] arguments;
                            String qualifierKey = javax.inject.Qualifier.class.getName();
                            for (Argument<?> argument : arguments = candidate.getConstructor().getArguments()) {
                                if (!argument.getType().equals(dependentType)) continue;
                                Map<Argument<?>, Qualifier> qualifedArg = Collections.singletonMap(argument, qualifier);
                                delegate.put(qualifierKey, qualifedArg);
                                break;
                            }
                            if (qualifier instanceof Named) {
                                delegate.put(Named.class.getName(), ((Named)qualifier).getName());
                            }
                            if (delegate.isEnabled(this)) {
                                transformedCandidates.add(delegate);
                            }
                        });
                    }
                    continue;
                }
                transformedCandidates.add(candidate);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finalized bean definitions candidates: {}", transformedCandidates);
            }
            return transformedCandidates;
        }
        return candidates;
    }

    @Override
    protected <T> BeanDefinition<T> findConcreteCandidate(Class<T> beanType, Qualifier<T> qualifier, Collection<BeanDefinition<T>> candidates) {
        if (candidates.stream().allMatch(BeanDefinition::isIterable)) {
            if (qualifier == null) {
                Optional<BeanDefinition<Object>> first = candidates.stream().findFirst();
                return first.orElse(null);
            }
            if (qualifier instanceof Named) {
                Named named = (Named)qualifier;
                String name = named.getName();
                for (BeanDefinition<T> candidate : candidates) {
                    Optional resolvedQualifier;
                    BeanDefinitionDelegate delegate;
                    Optional value;
                    if (!(candidate instanceof BeanDefinitionDelegate) || !((value = (delegate = (BeanDefinitionDelegate)candidate).get(Named.class.getName(), String.class)).isPresent() ? name.equals(value.get()) : (resolvedQualifier = delegate.get(javax.inject.Qualifier.class.getName(), Qualifier.class)).isPresent() && ((Qualifier)resolvedQualifier.get()).equals(qualifier))) continue;
                    return delegate;
                }
            }
        }
        return super.findConcreteCandidate(beanType, qualifier, candidates);
    }

    @Override
    public Optional<String> resolvePlaceholders(String str) {
        return this.getEnvironment().getPlaceholderResolver().resolvePlaceholders(str);
    }

    @Override
    public String resolveRequiredPlaceholders(String str) throws ConfigurationException {
        return this.getEnvironment().getPlaceholderResolver().resolveRequiredPlaceholders(str);
    }

    protected void initializeTypeConverters(BeanContext beanContext) {
        Collection<BeanRegistration<TypeConverter>> typeConverters = beanContext.getBeanRegistrations(TypeConverter.class);
        for (BeanRegistration<TypeConverter> typeConverterRegistration : typeConverters) {
            TypeConverter typeConverter = typeConverterRegistration.getBean();
            List<Argument<TypeConverter>> typeArguments = typeConverterRegistration.getBeanDefinition().getTypeArguments(TypeConverter.class);
            if (typeArguments.size() != 2) continue;
            Class source = typeArguments.get(0).getType();
            Class target = typeArguments.get(1).getType();
            if (source == null || target == null || source == Object.class && target == Object.class) continue;
            this.getConversionService().addConverter(source, target, typeConverter);
        }
        Collection<TypeConverterRegistrar> registrars = beanContext.getBeansOfType(TypeConverterRegistrar.class);
        for (TypeConverterRegistrar registrar : registrars) {
            registrar.register(this.conversionService);
        }
    }

    private class RuntimeConfiguredEnvironment
    extends DefaultEnvironment {
        private final boolean isRuntimeConfigured;
        private BootstrapPropertySourceLocator bootstrapPropertySourceLocator;
        private BootstrapEnvironment bootstrapEnvironment;

        RuntimeConfiguredEnvironment(ApplicationContextConfiguration configuration) {
            super(configuration);
            this.isRuntimeConfigured = Boolean.getBoolean("micronaut.bootstrap.context") || DefaultApplicationContext.this.resourceLoader.getResource("bootstrap.yml").isPresent() || DefaultApplicationContext.this.resourceLoader.getResource("bootstrap.properties").isPresent();
        }

        boolean isRuntimeConfigured() {
            return this.isRuntimeConfigured;
        }

        @Override
        public Environment stop() {
            return super.stop();
        }

        @Override
        protected synchronized List<PropertySource> readPropertySourceList(String name) {
            if (this.isRuntimeConfigured) {
                if (DefaultBeanContext.LOG.isInfoEnabled()) {
                    DefaultBeanContext.LOG.info("Reading Startup environment from bootstrap.yml");
                }
                Set<String> activeNames = this.getActiveNames();
                String[] environmentNamesArray = activeNames.toArray(new String[0]);
                if (this.bootstrapEnvironment == null) {
                    this.bootstrapEnvironment = this.createBootstrapEnvironment(environmentNamesArray);
                }
                BootstrapPropertySourceLocator bootstrapPropertySourceLocator = this.resolveBootstrapPropertySourceLocator(environmentNamesArray);
                for (PropertySource propertySource : bootstrapPropertySourceLocator.findPropertySources(this.bootstrapEnvironment)) {
                    this.addPropertySource(propertySource);
                }
                Collection<PropertySource> bootstrapPropertySources = this.bootstrapEnvironment.getPropertySources();
                for (PropertySource bootstrapPropertySource : bootstrapPropertySources) {
                    this.addPropertySource(new BootstrapPropertySource(bootstrapPropertySource));
                }
                return super.readPropertySourceList(name);
            }
            return super.readPropertySourceList(name);
        }

        private BootstrapPropertySourceLocator resolveBootstrapPropertySourceLocator(String ... environmentNames) {
            if (this.bootstrapPropertySourceLocator == null) {
                BootstrapApplicationContext bootstrapContext = new BootstrapApplicationContext(this.bootstrapEnvironment, environmentNames);
                bootstrapContext.start();
                if (bootstrapContext.containsBean(BootstrapPropertySourceLocator.class)) {
                    DefaultApplicationContext.this.initializeTypeConverters(bootstrapContext);
                    this.bootstrapPropertySourceLocator = bootstrapContext.getBean(BootstrapPropertySourceLocator.class);
                } else {
                    this.bootstrapPropertySourceLocator = BootstrapPropertySourceLocator.EMPTY_LOCATOR;
                }
            }
            return this.bootstrapPropertySourceLocator;
        }

        private BootstrapEnvironment createBootstrapEnvironment(String ... environmentNames) {
            BootstrapEnvironment bootstrapEnvironment = new BootstrapEnvironment(this.resourceLoader, this.conversionService, environmentNames);
            for (PropertySource source : this.propertySources.values()) {
                bootstrapEnvironment.addPropertySource(source);
            }
            bootstrapEnvironment.start();
            for (String pkg : bootstrapEnvironment.getPackages()) {
                this.addPackage(pkg);
            }
            return bootstrapEnvironment;
        }
    }

    private class BootstrapApplicationContext
    extends DefaultApplicationContext {
        private final BootstrapEnvironment bootstrapEnvironment;

        BootstrapApplicationContext(BootstrapEnvironment bootstrapEnvironment, String ... activeEnvironments) {
            super(DefaultApplicationContext.this.resourceLoader, activeEnvironments);
            this.bootstrapEnvironment = bootstrapEnvironment;
        }

        @Override
        @Nonnull
        public Environment getEnvironment() {
            return this.bootstrapEnvironment;
        }

        @Override
        @Nonnull
        protected BootstrapEnvironment createEnvironment(String ... environmentNames) {
            return this.bootstrapEnvironment;
        }

        @Override
        @Nonnull
        protected BootstrapEnvironment createEnvironment(@Nonnull ApplicationContextConfiguration configuration) {
            return this.bootstrapEnvironment;
        }

        @Override
        @Nonnull
        protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
            List<BeanDefinitionReference> refs = super.resolveBeanDefinitionReferences();
            DefaultApplicationContext.this.resolvedBeanReferences = refs;
            return refs.stream().filter(ref -> ref.isAnnotationPresent(BootstrapContextCompatible.class)).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
            Iterable<BeanConfiguration> beanConfigurations = super.resolveBeanConfigurations();
            DefaultApplicationContext.this.resolvedConfigurations = beanConfigurations;
            return beanConfigurations;
        }

        @Override
        protected void startEnvironment() {
            this.registerSingleton(Environment.class, this.bootstrapEnvironment);
        }

        @Override
        protected void initializeEventListeners() {
        }

        @Override
        protected void initializeContext(List<BeanDefinitionReference> contextScopeBeans, List<BeanDefinitionReference> processedBeans) {
        }

        @Override
        protected void processParallelBeans() {
        }

        @Override
        public void publishEvent(@Nonnull Object event) {
        }
    }

    private static class BootstrapEnvironment
    extends DefaultEnvironment {
        BootstrapEnvironment(final ClassPathResourceLoader resourceLoader, final ConversionService conversionService, final String ... activeEnvironments) {
            super(new ApplicationContextConfiguration(){

                @Override
                @Nonnull
                public List<String> getEnvironments() {
                    return Arrays.asList(activeEnvironments);
                }

                @Override
                @Nonnull
                public ConversionService<?> getConversionService() {
                    return conversionService;
                }

                @Override
                @Nonnull
                public ClassPathResourceLoader getResourceLoader() {
                    return resourceLoader;
                }
            });
        }

        @Override
        protected String getPropertySourceRootName() {
            String bootstrapName = System.getProperty("micronaut.bootstrap.name");
            return StringUtils.isNotEmpty((CharSequence)bootstrapName) ? bootstrapName : "bootstrap";
        }

        @Override
        protected boolean shouldDeduceEnvironments() {
            return false;
        }
    }

    private static class BootstrapPropertySource
    implements PropertySource {
        private final PropertySource delegate;

        BootstrapPropertySource(PropertySource bootstrapPropertySource) {
            this.delegate = bootstrapPropertySource;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public PropertySource.PropertyConvention getConvention() {
            return this.delegate.getConvention();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Object get(String key) {
            return this.delegate.get(key);
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegate.iterator();
        }

        public int getOrder() {
            return this.delegate.getOrder() + 10;
        }
    }
}

