/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultApplicationContextBuilder
implements ApplicationContextBuilder,
ApplicationContextConfiguration {
    private List<Object> singletons = new ArrayList<Object>();
    private List<String> environments = new ArrayList<String>();
    private List<String> packages = new ArrayList<String>();
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private List<PropertySource> propertySources = new ArrayList<PropertySource>();
    private ClassPathResourceLoader classPathResourceLoader;
    private Collection<String> configurationIncludes = new HashSet<String>();
    private Collection<String> configurationExcludes = new HashSet<String>();
    private Boolean deduceEnvironments = null;

    protected DefaultApplicationContextBuilder() {
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder singletons(Object ... beans) {
        if (beans != null) {
            this.singletons.addAll(Arrays.asList(beans));
        }
        return this;
    }

    @Override
    @Nonnull
    public ClassPathResourceLoader getResourceLoader() {
        if (this.classPathResourceLoader == null) {
            return ClassPathResourceLoader.defaultLoader((ClassLoader)this.getClassLoader());
        }
        return this.classPathResourceLoader;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder deduceEnvironment(@Nullable Boolean deduceEnvironments) {
        this.deduceEnvironments = deduceEnvironments;
        return this;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder environments(String ... environments) {
        if (environments != null) {
            this.environments.addAll(Arrays.asList(environments));
        }
        return this;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder packages(String ... packages) {
        if (packages != null) {
            this.packages.addAll(Arrays.asList(packages));
        }
        return this;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder properties(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder propertySources(PropertySource ... propertySources) {
        if (propertySources != null) {
            this.propertySources.addAll(Arrays.asList(propertySources));
        }
        return this;
    }

    @Override
    public Optional<Boolean> getDeduceEnvironments() {
        return Optional.ofNullable(this.deduceEnvironments);
    }

    @Override
    @Nonnull
    public List<String> getEnvironments() {
        return this.environments;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder mainClass(Class mainClass) {
        if (mainClass != null) {
            ClassLoader classLoader = mainClass.getClassLoader();
            this.classPathResourceLoader = ClassPathResourceLoader.defaultLoader((ClassLoader)classLoader);
            String name = mainClass.getPackage().getName();
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                this.packages(name);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder classLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classPathResourceLoader = ClassPathResourceLoader.defaultLoader((ClassLoader)classLoader);
        }
        return this;
    }

    @Override
    @Nonnull
    public ApplicationContext build() {
        DefaultApplicationContext applicationContext = new DefaultApplicationContext(this);
        Environment environment = applicationContext.getEnvironment();
        if (!this.packages.isEmpty()) {
            for (String aPackage : this.packages) {
                environment.addPackage(aPackage);
            }
        }
        if (!this.properties.isEmpty()) {
            PropertySource contextProperties = PropertySource.of("context", this.properties, 0);
            environment.addPropertySource(contextProperties);
        }
        if (!this.propertySources.isEmpty()) {
            for (PropertySource propertySource : this.propertySources) {
                environment.addPropertySource(propertySource);
            }
        }
        if (!this.singletons.isEmpty()) {
            for (Object singleton : this.singletons) {
                applicationContext.registerSingleton(singleton);
            }
        }
        if (!this.configurationIncludes.isEmpty()) {
            environment.addConfigurationIncludes(this.configurationIncludes.toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        if (!this.configurationExcludes.isEmpty()) {
            environment.addConfigurationExcludes(this.configurationExcludes.toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        return applicationContext;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder include(String ... configurations) {
        if (configurations != null) {
            this.configurationIncludes.addAll(Arrays.asList(configurations));
        }
        return this;
    }

    @Override
    @Nonnull
    public ApplicationContextBuilder exclude(String ... configurations) {
        if (configurations != null) {
            this.configurationExcludes.addAll(Arrays.asList(configurations));
        }
        return this;
    }
}

