/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.Toggleable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertySourceLoader
implements PropertySourceLoader,
Toggleable,
Ordered {
    public static final int DEFAULT_POSITION = -300;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertySourceLoader.class);

    public int getOrder() {
        return -300;
    }

    @Override
    public Optional<PropertySource> load(String resourceName, ResourceLoader resourceLoader, String environmentName) {
        if (this.isEnabled()) {
            Set extensions = this.getExtensions();
            for (String ext : extensions) {
                String fileName = resourceName;
                if (environmentName != null) {
                    fileName = fileName + "-" + environmentName;
                }
                String qualifiedName = fileName;
                fileName = fileName + "." + ext;
                Map<String, Object> finalMap = this.loadProperties(resourceLoader, qualifiedName, fileName);
                int order = this.getOrder();
                if (environmentName != null) {
                    ++order;
                }
                if (finalMap.isEmpty()) continue;
                final int finalOrder = order;
                MapPropertySource newPropertySource = new MapPropertySource(qualifiedName, finalMap){

                    public int getOrder() {
                        return finalOrder;
                    }
                };
                return Optional.of(newPropertySource);
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> loadProperties(ResourceLoader resourceLoader, String qualifiedName, String fileName) {
        Optional<InputStream> config = this.readInput(resourceLoader, fileName);
        if (!config.isPresent()) {
            if (!LOG.isDebugEnabled()) return Collections.emptyMap();
            LOG.debug("No PropertySource found for file name: " + fileName);
            return Collections.emptyMap();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found PropertySource for file name: " + fileName);
        }
        try (InputStream input = config.get();){
            Map<String, Object> map = this.read(qualifiedName, input);
            return map;
        }
        catch (IOException e) {
            throw new ConfigurationException("I/O exception occurred reading [" + fileName + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public Map<String, Object> read(String name, InputStream input) throws IOException {
        LinkedHashMap<String, Object> finalMap = new LinkedHashMap<String, Object>();
        this.processInput(name, input, finalMap);
        return finalMap;
    }

    protected Optional<InputStream> readInput(ResourceLoader resourceLoader, String fileName) {
        return resourceLoader.getResourceAsStream(fileName);
    }

    protected abstract void processInput(String var1, InputStream var2, Map<String, Object> var3) throws IOException;

    protected void processMap(Map<String, Object> finalMap, Map map, String prefix) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map && !((Map)value).isEmpty()) {
                this.processMap(finalMap, (Map)value, prefix + key + '.');
                continue;
            }
            finalMap.put(prefix + key, value);
        }
    }
}

