/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Configuration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Provided;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.annotation.Type;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AnnotationMetadataException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;

@Internal
class AnnotationMetadataSupport {
    private static final Map<String, Map<String, Object>> ANNOTATION_DEFAULTS = new ConcurrentHashMap<String, Map<String, Object>>(20);
    private static final Map<Class<? extends Annotation>, Optional<Constructor<InvocationHandler>>> ANNOTATION_PROXY_CACHE = new ConcurrentHashMap<Class<? extends Annotation>, Optional<Constructor<InvocationHandler>>>(20);
    private static final Map<String, Class<? extends Annotation>> ANNOTATION_TYPES = new ConcurrentHashMap<String, Class<? extends Annotation>>(20);

    AnnotationMetadataSupport() {
    }

    static Map<String, Object> getDefaultValues(String annotation) {
        return ANNOTATION_DEFAULTS.computeIfAbsent(annotation, s -> Collections.emptyMap());
    }

    static Optional<Class<? extends Annotation>> getAnnotationType(String name) {
        Class<? extends Annotation> type = ANNOTATION_TYPES.get(name);
        if (type != null) {
            return Optional.of(type);
        }
        Optional aClass = ClassUtils.forName((String)name, (ClassLoader)AnnotationMetadataSupport.class.getClassLoader());
        return aClass.flatMap(aClass1 -> {
            if (Annotation.class.isAssignableFrom((Class<?>)aClass1)) {
                ANNOTATION_TYPES.put(name, (Class<? extends Annotation>)aClass1);
                return Optional.of(aClass1);
            }
            return Optional.empty();
        });
    }

    static Optional<Class<? extends Annotation>> getRegisteredAnnotationType(String name) {
        Class<? extends Annotation> type = ANNOTATION_TYPES.get(name);
        if (type != null) {
            return Optional.of(type);
        }
        return Optional.empty();
    }

    static Map<String, Object> getDefaultValues(Class<? extends Annotation> annotation) {
        return AnnotationMetadataSupport.getDefaultValues(annotation.getName());
    }

    static boolean hasDefaultValues(String annotation) {
        return ANNOTATION_DEFAULTS.containsKey(annotation);
    }

    static void registerDefaultValues(String annotation, Map<String, Object> defaultValues) {
        if (StringUtils.isNotEmpty((CharSequence)annotation)) {
            ANNOTATION_DEFAULTS.put(annotation.intern(), defaultValues);
        }
    }

    static void registerDefaultValues(AnnotationClassValue<?> annotation, Map<String, Object> defaultValues) {
        if (defaultValues != null) {
            AnnotationMetadataSupport.registerDefaultValues(annotation.getName(), defaultValues);
        }
        AnnotationMetadataSupport.registerAnnotationType(annotation);
    }

    static void registerAnnotationType(AnnotationClassValue<?> annotationClassValue) {
        String name = annotationClassValue.getName();
        if (!ANNOTATION_TYPES.containsKey(name)) {
            annotationClassValue.getType().ifPresent(aClass -> {
                if (Annotation.class.isAssignableFrom((Class<?>)aClass)) {
                    ANNOTATION_TYPES.put(name, (Class<? extends Annotation>)aClass);
                }
            });
        }
    }

    static Optional<Constructor<InvocationHandler>> getProxyClass(Class<? extends Annotation> annotation) {
        return ANNOTATION_PROXY_CACHE.computeIfAbsent(annotation, aClass -> {
            Class<?> proxyClass = Proxy.getProxyClass(annotation.getClassLoader(), annotation);
            return ReflectionUtils.findConstructor(proxyClass, (Class[])new Class[]{InvocationHandler.class});
        });
    }

    static <T extends Annotation> T buildAnnotation(Class<T> annotationClass, ConvertibleValues<Object> annotationValues) {
        Optional<Constructor<InvocationHandler>> proxyClass = AnnotationMetadataSupport.getProxyClass(annotationClass);
        if (proxyClass.isPresent()) {
            Method[] declaredMethods = annotationClass.getDeclaredMethods();
            LinkedHashMap<CharSequence, Object> resolvedValues = new LinkedHashMap<CharSequence, Object>(declaredMethods.length);
            for (Method declaredMethod : declaredMethods) {
                String name = declaredMethod.getName();
                if (!annotationValues.contains(name)) continue;
                Optional converted = annotationValues.get((CharSequence)name, declaredMethod.getReturnType());
                converted.ifPresent(o -> resolvedValues.put(name, o));
            }
            HashMap<String, Object> values = new HashMap<String, Object>(AnnotationMetadataSupport.getDefaultValues(annotationClass));
            values.putAll(annotationValues.asMap());
            int hashCode = AnnotationUtil.calculateHashCode(values);
            Optional instantiated = InstantiationUtils.tryInstantiate(proxyClass.get(), (Object[])new Object[]{new AnnotationProxyHandler(hashCode, annotationClass, resolvedValues)});
            if (instantiated.isPresent()) {
                return (T)((Annotation)instantiated.get());
            }
        }
        throw new AnnotationMetadataException("Failed to build annotation for type: " + annotationClass.getName());
    }

    static {
        Arrays.asList(Nullable.class, Nonnull.class, PreDestroy.class, PostConstruct.class, Named.class, Singleton.class, Inject.class, Qualifier.class, Scope.class, Prototype.class, Executable.class, Bean.class, Primary.class, Value.class, Property.class, Provided.class, Requires.class, Secondary.class, Type.class, Context.class, EachBean.class, EachProperty.class, Configuration.class, ConfigurationProperties.class, ConfigurationBuilder.class, Introspected.class, Parameter.class, Replaces.class, Requirements.class, Factory.class).forEach(ann -> ANNOTATION_TYPES.put(ann.getName(), (Class<? extends Annotation>)ann));
    }

    private static class AnnotationProxyHandler
    implements InvocationHandler {
        private final int hashCode;
        private final Class<?> annotationClass;
        private final Map<CharSequence, Object> resolvedValues;

        AnnotationProxyHandler(int hashCode, Class<?> annotationClass, Map<CharSequence, Object> resolvedValues) {
            this.hashCode = hashCode;
            this.annotationClass = annotationClass;
            this.resolvedValues = resolvedValues;
        }

        public Map<CharSequence, Object> getValues() {
            return this.resolvedValues;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.annotationClass.isInstance(obj)) {
                return false;
            }
            Annotation other = (Annotation)this.annotationClass.cast(obj);
            Map<CharSequence, Object> otherValues = this.getAnnotationValues(other);
            if (this.resolvedValues.size() != otherValues.size()) {
                return false;
            }
            for (Map.Entry<CharSequence, Object> member : this.resolvedValues.entrySet()) {
                Object otherValue;
                Object value = member.getValue();
                if (AnnotationUtil.areEqual((Object)value, (Object)(otherValue = otherValues.get(member.getKey())))) continue;
                return false;
            }
            return true;
        }

        private Map<CharSequence, Object> getAnnotationValues(Annotation other) {
            if (other instanceof AnnotationProxyHandler) {
                return ((AnnotationProxyHandler)((Object)other)).resolvedValues;
            }
            return Collections.emptyMap();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String name = method.getName();
            if ((args == null || args.length == 0) && "hashCode".equals(name)) {
                return this.hashCode;
            }
            if (args != null && args.length == 1 && "equals".equals(name)) {
                return this.equals(args[0]);
            }
            if ("annotationType".equals(name)) {
                return this.annotationClass;
            }
            if (this.resolvedValues.containsKey(name)) {
                return this.resolvedValues.get(name);
            }
            return method.getDefaultValue();
        }
    }
}

