/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.qualifiers.AnnotationMetadataQualifier;
import io.micronaut.inject.qualifiers.AnnotationQualifier;
import io.micronaut.inject.qualifiers.AnnotationStereotypeQualifier;
import io.micronaut.inject.qualifiers.CompositeQualifier;
import io.micronaut.inject.qualifiers.NameQualifier;
import io.micronaut.inject.qualifiers.TypeAnnotationQualifier;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.inject.Named;

public class Qualifiers {
    public static <T> Qualifier<T> byQualifiers(Qualifier<T> ... qualifiers) {
        return new CompositeQualifier(qualifiers);
    }

    public static <T> Qualifier<T> byName(String name) {
        return new NameQualifier(name);
    }

    public static <T> Qualifier<T> byAnnotation(Annotation annotation) {
        if (annotation.annotationType() == Type.class) {
            Type typeAnn = (Type)annotation;
            return Qualifiers.byType(typeAnn.value());
        }
        if (annotation.annotationType() == Named.class) {
            Named nameAnn = (Named)annotation;
            return Qualifiers.byName(nameAnn.value());
        }
        return new AnnotationQualifier(annotation);
    }

    public static <T> Qualifier<T> byAnnotation(AnnotationMetadata metadata, Class<? extends Annotation> type) {
        Optional value;
        if (Type.class == type) {
            Optional aClass = metadata.classValue(type);
            if (aClass.isPresent()) {
                return Qualifiers.byType((Class)aClass.get());
            }
        } else if (Named.class == type && (value = metadata.getValue(type, String.class)).isPresent()) {
            return Qualifiers.byName((String)value.get());
        }
        return new AnnotationMetadataQualifier(metadata, type);
    }

    public static <T> Qualifier<T> byAnnotation(AnnotationMetadata metadata, String type) {
        Optional value;
        if (Type.class.getName().equals(type)) {
            Optional aClass = metadata.classValue(type);
            if (aClass.isPresent()) {
                return Qualifiers.byType((Class)aClass.get());
            }
        } else if (Named.class.getName().equals(type) && (value = metadata.getValue(type, String.class)).isPresent()) {
            return Qualifiers.byName((String)value.get());
        }
        return new AnnotationMetadataQualifier(metadata, type);
    }

    public static <T> Qualifier<T> byStereotype(Class<? extends Annotation> stereotype) {
        return new AnnotationStereotypeQualifier(stereotype);
    }

    public static <T> Qualifier<T> byTypeArguments(Class ... typeArguments) {
        return new TypeArgumentQualifier(typeArguments);
    }

    public static <T> Qualifier<T> byType(Class ... typeArguments) {
        return new TypeAnnotationQualifier(typeArguments);
    }
}

