/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanDefinitionReference;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfiguration;
import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanResolutionContext;
import io.micronaut.context.DefaultCustomScopeRegistry;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.ResolvedProvider;
import io.micronaut.context.UnresolvedProvider;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Infrastructure;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.context.exceptions.NonUniqueBeanException;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.context.scope.CustomScopeRegistry;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.async.subscriber.Completable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.ClassLoadingReporter;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StreamUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionMethodReference;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ParametrizedBeanFactory;
import io.micronaut.inject.ParametrizedProvider;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.qualifiers.Qualified;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanContext
implements BeanContext {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultBeanContext.class);
    protected static final Logger LOG_LIFECYCLE = LoggerFactory.getLogger((String)(DefaultBeanContext.class.getPackage().getName() + ".lifecycle"));
    private static final Logger EVENT_LOGGER = LoggerFactory.getLogger(ApplicationEventPublisher.class);
    private static final Qualifier PROXY_TARGET_QUALIFIER = new Qualifier<Object>(){

        @Override
        public <BT extends BeanType<Object>> Stream<BT> reduce(Class<Object> beanType, Stream<BT> candidates) {
            return candidates.filter(bt -> {
                if (bt instanceof BeanDefinitionDelegate) {
                    return !(((BeanDefinitionDelegate)bt).getDelegate() instanceof ProxyBeanDefinition);
                }
                return !(bt instanceof ProxyBeanDefinition);
            });
        }
    };
    private static final String SCOPED_PROXY_ANN = "io.micronaut.runtime.context.scope.ScopedProxy";
    private static final String AROUND_TYPE = "io.micronaut.aop.Around";
    private static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
    private static final String NAMED_MEMBER = "named";
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final AtomicBoolean initializing = new AtomicBoolean(false);
    protected final AtomicBoolean terminating = new AtomicBoolean(false);
    final Map<BeanKey, BeanRegistration> singletonObjects = new ConcurrentHashMap<BeanKey, BeanRegistration>(100);
    final Map<BeanKey, Object> scopedProxies = new ConcurrentHashMap<BeanKey, Object>(20);
    Collection<BeanRegistration<BeanInitializedEventListener>> beanInitializedEventListeners;
    private final Collection<BeanDefinitionReference> beanDefinitionsClasses = new ConcurrentLinkedQueue<BeanDefinitionReference>();
    private final Map<String, BeanConfiguration> beanConfigurations = new ConcurrentHashMap<String, BeanConfiguration>(4);
    private final Map<BeanKey, Boolean> containsBeanCache = new ConcurrentHashMap<BeanKey, Boolean>(30);
    private final Map<BeanKey, Collection<Object>> initializedObjectsByType = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<BeanKey, Optional<BeanDefinition>> beanConcreteCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Class, Collection<BeanDefinition>> beanCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Class, Collection<BeanDefinitionReference>> beanIndex = new ConcurrentHashMap<Class, Collection<BeanDefinitionReference>>(12);
    private final ClassLoader classLoader;
    private final Set<Class> thisInterfaces = ReflectionUtils.getAllInterfaces(this.getClass());
    private final Set<Class> indexedTypes = CollectionUtils.setOf((Object[])new Class[]{TypeConverter.class, TypeConverterRegistrar.class, ApplicationEventListener.class, BeanCreatedEventListener.class, BeanInitializedEventListener.class});
    private final CustomScopeRegistry customScopeRegistry;
    private Collection<BeanRegistration<BeanCreatedEventListener>> beanCreationEventListeners;

    public DefaultBeanContext() {
        this(BeanContext.class.getClassLoader());
    }

    public DefaultBeanContext(final @Nonnull ClassLoader classLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @Nonnull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull((String)"classLoader", (Object)classLoader);
                return classLoader;
            }
        });
    }

    public DefaultBeanContext(final @Nonnull ClassPathResourceLoader resourceLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @Nonnull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull((String)"resourceLoader", (Object)resourceLoader);
                return resourceLoader.getClassLoader();
            }
        });
    }

    public DefaultBeanContext(@Nonnull BeanContextConfiguration contextConfiguration) {
        ArgumentUtils.requireNonNull((String)"contextConfiguration", (Object)contextConfiguration);
        System.setProperty("micronaut.classloader.logging", "true");
        this.classLoader = contextConfiguration.getClassLoader();
        this.customScopeRegistry = new DefaultCustomScopeRegistry(this, this.classLoader);
        ClassUtils.forName((String)"com.fasterxml.jackson.databind.Module", (ClassLoader)this.classLoader).ifPresent(this.indexedTypes::add);
    }

    @Override
    public boolean isRunning() {
        return this.running.get() && !this.initializing.get();
    }

    @Override
    public synchronized BeanContext start() {
        if (!this.isRunning()) {
            if (this.initializing.compareAndSet(false, true)) {
                String activeConfigurations;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting BeanContext");
                }
                this.readAllBeanConfigurations();
                this.readAllBeanDefinitionClasses();
                if (LOG.isDebugEnabled() && StringUtils.isNotEmpty((CharSequence)(activeConfigurations = this.beanConfigurations.values().stream().filter(config -> config.isEnabled(this)).map(BeanConfiguration::getName).collect(Collectors.joining(","))))) {
                    LOG.debug("Loaded active configurations: {}", (Object)activeConfigurations);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("BeanContext Started.");
                }
                this.publishEvent(new StartupEvent(this));
            }
            this.processParallelBeans();
            this.running.set(true);
            this.initializing.set(false);
        }
        return this;
    }

    @Override
    public synchronized BeanContext stop() {
        if (this.terminating.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping BeanContext");
            }
            this.publishEvent(new ShutdownEvent(this));
            List<BeanRegistration> objects = this.topologicalSort(this.singletonObjects.values());
            HashSet<Integer> processed = new HashSet<Integer>();
            for (BeanRegistration beanRegistration : objects) {
                Object bean;
                block11: {
                    BeanDefinition def;
                    block10: {
                        def = beanRegistration.beanDefinition;
                        bean = beanRegistration.bean;
                        int sysId = System.identityHashCode(bean);
                        if (processed.contains(sysId)) continue;
                        if (LOG_LIFECYCLE.isDebugEnabled()) {
                            LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", bean, (Object)beanRegistration.identifier);
                        }
                        processed.add(sysId);
                        if (def instanceof DisposableBeanDefinition) {
                            try {
                                ((DisposableBeanDefinition)def).dispose(this, bean);
                            }
                            catch (Throwable e) {
                                if (!LOG.isErrorEnabled()) break block10;
                                LOG.error("Error disposing of bean registration [" + def.getName() + "]: " + e.getMessage(), e);
                            }
                        }
                    }
                    if (def instanceof Closeable) {
                        try {
                            ((Closeable)((Object)def)).close();
                        }
                        catch (Throwable e) {
                            if (!LOG.isErrorEnabled()) break block11;
                            LOG.error("Error disposing of bean registration [" + def.getName() + "]: " + e.getMessage(), e);
                        }
                    }
                }
                if (!(bean instanceof LifeCycle)) continue;
                ((LifeCycle)bean).stop();
            }
            this.terminating.set(false);
            this.running.set(false);
            ClassLoadingReporter.finish();
        }
        return this;
    }

    @Nonnull
    public AnnotationMetadata resolveMetadata(Class<?> type) {
        if (type == null) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        Optional<BeanDefinition<?>> candidate = this.findConcreteCandidate(type, null, false, false);
        return candidate.map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
    }

    @Override
    public <T> Optional<T> refreshBean(BeanIdentifier identifier) {
        BeanRegistration beanRegistration;
        if (identifier != null && (beanRegistration = this.singletonObjects.get(identifier)) != null) {
            BeanDefinition definition = beanRegistration.getBeanDefinition();
            return Optional.of(definition.inject(this, beanRegistration.getBean()));
        }
        return Optional.empty();
    }

    @Override
    public Collection<BeanRegistration<?>> getActiveBeanRegistrations(Qualifier<?> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        List<BeanRegistration<?>> result = this.singletonObjects.values().stream().filter(registration -> {
            BeanDefinition beanDefinition = registration.beanDefinition;
            return qualifier.reduce(beanDefinition.getBeanType(), Stream.of(beanDefinition)).findFirst().isPresent();
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getActiveBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        List<BeanRegistration<T>> result = this.singletonObjects.values().stream().filter(registration -> {
            BeanDefinition beanDefinition = registration.beanDefinition;
            return beanType.isAssignableFrom(beanDefinition.getBeanType());
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        this.getBeansOfType(beanType);
        return this.getActiveBeanRegistrations(beanType);
    }

    @Override
    public <T> Optional<BeanRegistration<T>> findBeanRegistration(T bean) {
        for (BeanRegistration beanRegistration : this.singletonObjects.values()) {
            if (bean != beanRegistration.getBean()) continue;
            return Optional.of(beanRegistration);
        }
        Collection<CustomScope> scopes = this.getBeansOfType(CustomScope.class);
        for (CustomScope scope : scopes) {
            Optional<BeanRegistration<T>> beanRegistration = scope.findBeanRegistration(bean);
            if (!beanRegistration.isPresent()) continue;
            return beanRegistration;
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, String method, Class ... arguments) {
        return this.findExecutionHandle(beanType, null, method, arguments);
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, Qualifier<?> qualifier, String method, Class ... arguments) {
        Optional<BeanDefinition<T>> foundBean = this.findBeanDefinition(beanType, qualifier);
        if (foundBean.isPresent()) {
            BeanDefinition<T> beanDefinition = foundBean.get();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod.map(executableMethod -> new BeanExecutionHandle(this, beanType, qualifier, executableMethod));
            }
            return beanDefinition.findPossibleMethods(method).findFirst().filter(m -> {
                Class[] argTypes = m.getArgumentTypes();
                if (argTypes.length == arguments.length) {
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (arguments[i].isAssignableFrom(argTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }).map(executableMethod -> new BeanExecutionHandle(this, beanType, qualifier, executableMethod));
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findExecutableMethod(Class<T> beanType, String method, Class[] arguments) {
        Collection<BeanDefinition<T>> definitions;
        if (beanType != null && !(definitions = this.getBeanDefinitions(beanType)).isEmpty()) {
            BeanDefinition<T> beanDefinition = definitions.iterator().next();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod;
            }
            return beanDefinition.findPossibleMethods(method).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(T bean, String method, Class[] arguments) {
        Optional<BeanDefinition<?>> foundBean;
        if (bean != null && (foundBean = this.findBeanDefinition(bean.getClass())).isPresent()) {
            BeanDefinition<?> beanDefinition = foundBean.get();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod.map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
            }
            return beanDefinition.findPossibleMethods(method).findFirst().map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> BeanContext registerSingleton(final @Nonnull Class<T> type, @Nonnull T singleton, Qualifier<T> qualifier, boolean inject) {
        ArgumentUtils.requireNonNull((String)"type", type);
        ArgumentUtils.requireNonNull((String)"singleton", singleton);
        BeanKey<T> beanKey = new BeanKey<T>(type, qualifier, new Class[0]);
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            BeanDefinition<T> beanDefinition;
            this.initializedObjectsByType.clear();
            this.beanCandidateCache.remove(type);
            BeanDefinition<T> beanDefinition2 = beanDefinition = inject ? (BeanDefinition)this.findConcreteCandidate(type, qualifier, false, false).orElse(null) : null;
            if (beanDefinition != null && beanDefinition.getBeanType().isInstance(singleton)) {
                this.doInject(new DefaultBeanResolutionContext(this, beanDefinition), singleton, beanDefinition);
                this.singletonObjects.put(beanKey, new BeanRegistration<T>(beanKey, beanDefinition, singleton));
                BeanKey concreteKey = new BeanKey(singleton.getClass(), qualifier, new Class[0]);
                this.singletonObjects.put(concreteKey, new BeanRegistration<T>(concreteKey, beanDefinition, singleton));
            } else {
                NoInjectionBeanDefinition<T> dynamicRegistration = new NoInjectionBeanDefinition<T>(singleton.getClass(), qualifier);
                if (qualifier instanceof Named) {
                    BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(dynamicRegistration);
                    delegate.put(Named.class.getName(), ((Named)qualifier).getName());
                    beanDefinition = delegate;
                } else {
                    beanDefinition = dynamicRegistration;
                }
                this.beanDefinitionsClasses.add(dynamicRegistration);
                this.singletonObjects.put(beanKey, new BeanRegistration<T>(beanKey, dynamicRegistration, singleton));
                BeanKey concreteKey = new BeanKey(singleton.getClass(), qualifier, new Class[0]);
                this.singletonObjects.put(concreteKey, new BeanRegistration<T>(concreteKey, dynamicRegistration, singleton));
                Optional<Class> indexedType = this.indexedTypes.stream().filter(t -> t.isAssignableFrom(type) || t == type).findFirst();
                if (indexedType.isPresent()) {
                    Collection<BeanDefinitionReference> indexed = this.resolveTypeIndex(indexedType.get());
                    final BeanDefinition<T> finalBeanDefinition = beanDefinition;
                    indexed.add(new AbstractBeanDefinitionReference(type.getName(), type.getName()){

                        @Override
                        protected Class<? extends BeanDefinition<?>> getBeanDefinitionType() {
                            return finalBeanDefinition.getClass();
                        }

                        public BeanDefinition load() {
                            return finalBeanDefinition;
                        }

                        @Override
                        public Class getBeanType() {
                            return type;
                        }
                    });
                }
            }
        }
        return this;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Optional<BeanConfiguration> findBeanConfiguration(String configurationName) {
        BeanConfiguration configuration = this.beanConfigurations.get(configurationName);
        if (configuration != null) {
            return Optional.of(configuration);
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Class<T> beanType, Qualifier<T> qualifier) {
        if (Object.class == beanType) {
            return Optional.empty();
        }
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier, new Class[0]);
        BeanRegistration reg = this.singletonObjects.get(beanKey);
        if (reg != null) {
            return Optional.of(reg.getBeanDefinition());
        }
        Collection<BeanDefinition<Object>> beanCandidates = new ArrayList<BeanDefinition<T>>(this.findBeanCandidatesInternal(beanType));
        if (qualifier != null) {
            beanCandidates = qualifier.reduce(beanType, beanCandidates.stream()).collect(Collectors.toList());
        }
        this.filterProxiedTypes(beanCandidates, true, true);
        if (beanCandidates.isEmpty()) {
            return Optional.empty();
        }
        if (beanCandidates.size() == 1) {
            return Optional.of(beanCandidates.iterator().next());
        }
        return this.findConcreteCandidate(beanType, null, false, true);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType) {
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(beanType);
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType, Qualifier<T> qualifier) {
        Collection candidates = this.findBeanCandidatesInternal(beanType);
        if (qualifier != null) {
            candidates = qualifier.reduce(beanType, new ArrayList<BeanDefinition<T>>(candidates).stream()).collect(Collectors.toList());
        }
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> boolean containsBean(@Nonnull Class<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier, new Class[0]);
        if (this.containsBeanCache.containsKey(beanKey)) {
            return this.containsBeanCache.get(beanKey);
        }
        boolean result = this.singletonObjects.containsKey(beanKey) || this.isCandidatePresent(beanType, qualifier);
        this.containsBeanCache.put(beanKey, result);
        return result;
    }

    @Override
    public <T> T getBean(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanInternal(null, beanType, qualifier, true, true);
    }

    @Override
    public <T> T getBean(Class<T> beanType) {
        return this.getBeanInternal(null, beanType, null, true, true);
    }

    @Override
    public <T> Optional<T> findBean(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType) {
        return this.getBeansOfType(null, beanType);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfTypeInternal(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    protected <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfTypeInternal(resolutionContext, beanType, qualifier).stream();
    }

    @Override
    @Nonnull
    public <T> T inject(@Nonnull T instance) {
        Objects.requireNonNull(instance, "Instance cannot be null");
        Collection<BeanDefinition> candidates = this.findBeanCandidatesForInstance(instance);
        if (candidates.size() == 1) {
            BeanDefinition beanDefinition = candidates.stream().findFirst().get();
            DefaultBeanResolutionContext resolutionContext = new DefaultBeanResolutionContext(this, beanDefinition);
            BeanKey beanKey = new BeanKey(beanDefinition.getBeanType(), null, new Class[0]);
            resolutionContext.addInFlightBean(beanKey, instance);
            this.doInject(resolutionContext, instance, beanDefinition);
        } else if (!candidates.isEmpty()) {
            Iterator iterator = candidates.iterator();
            throw new NonUniqueBeanException(instance.getClass(), iterator);
        }
        return instance;
    }

    @Override
    @Nonnull
    public <T> T createBean(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.createBean(null, beanType, qualifier);
    }

    @Override
    @Nonnull
    public <T> T createBean(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Optional<BeanDefinition<T>> candidate = this.findConcreteCandidate(beanType, qualifier, true, false);
        if (candidate.isPresent()) {
            T createdBean = this.doCreateBean((BeanResolutionContext)new DefaultBeanResolutionContext(this, candidate.get()), candidate.get(), qualifier, false, argumentValues);
            if (createdBean == null) {
                throw new NoSuchBeanException(beanType);
            }
            return createdBean;
        }
        throw new NoSuchBeanException(beanType);
    }

    @Override
    @Nonnull
    public <T> T createBean(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier, Object ... args) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Optional<BeanDefinition<T>> candidate = this.findConcreteCandidate(beanType, qualifier, true, false);
        if (candidate.isPresent()) {
            BeanDefinition<T> definition = candidate.get();
            DefaultBeanResolutionContext resolutionContext = new DefaultBeanResolutionContext(this, definition);
            return this.doCreateBean((BeanResolutionContext)resolutionContext, definition, beanType, qualifier, args);
        }
        throw new NoSuchBeanException(beanType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected <T> T doCreateBean(@Nonnull BeanResolutionContext resolutionContext, @Nonnull BeanDefinition<T> definition, @Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier, Object ... args) {
        T createdBean;
        Map<String, Object> argumentValues;
        if (definition instanceof ParametrizedBeanFactory) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating bean for parameters: {}", (Object)ArrayUtils.toString((Object[])args));
            }
            Argument<?>[] requiredArguments = ((ParametrizedBeanFactory)((Object)definition)).getRequiredArguments();
            argumentValues = new LinkedHashMap<String, Object>(requiredArguments.length);
            BeanResolutionContext.Path path = resolutionContext.getPath();
            for (int i = 0; i < requiredArguments.length; ++i) {
                Argument<?> requiredArgument = requiredArguments[i];
                try {
                    path.pushConstructorResolve(definition, requiredArgument);
                    if (args.length > i) {
                        Object val = args[i];
                        if (val != null) {
                            argumentValues.put(requiredArgument.getName(), ConversionService.SHARED.convert(val, requiredArgument).orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. Cannot convert object [" + val + "] to required type: " + requiredArgument.getType())));
                            continue;
                        }
                        if (requiredArgument.isDeclaredNullable()) continue;
                        throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. Argument cannot be null");
                    }
                    Optional<T> existingBean = this.findBean(resolutionContext, requiredArgument.getType(), null);
                    if (existingBean.isPresent()) {
                        argumentValues.put(requiredArgument.getName(), existingBean.get());
                        continue;
                    }
                    if (requiredArgument.isDeclaredNullable()) continue;
                    throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. No bean found for type: " + requiredArgument.getType());
                }
                finally {
                    path.pop();
                }
            }
        } else {
            argumentValues = Collections.emptyMap();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed bean argument values: {}", argumentValues);
        }
        if ((createdBean = this.doCreateBean(resolutionContext, definition, qualifier, false, argumentValues)) == null) {
            throw new NoSuchBeanException(beanType);
        }
        return createdBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T destroyBean(@Nonnull Class<T> beanType) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Object bean = null;
        BeanKey<T> beanKey = new BeanKey<T>(beanType, null, new Class[0]);
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            if (this.singletonObjects.containsKey(beanKey)) {
                BeanRegistration beanRegistration = this.singletonObjects.get(beanKey);
                bean = beanRegistration.bean;
                if (bean != null) {
                    if (LOG_LIFECYCLE.isDebugEnabled()) {
                        LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", bean, beanKey);
                    }
                    this.singletonObjects.remove(beanKey);
                    BeanKey concreteKey = new BeanKey(bean.getClass(), null, new Class[0]);
                    this.singletonObjects.remove(concreteKey);
                }
            }
        }
        if (bean != null) {
            Optional<BeanDefinition<BeanDefinition>> concreteCandidate = this.findConcreteCandidate(beanType, null, false, true);
            Object finalBean = bean;
            concreteCandidate.ifPresent(definition -> {
                if (definition instanceof DisposableBeanDefinition) {
                    ((DisposableBeanDefinition)definition).dispose(this, finalBean);
                }
            });
        }
        return (T)bean;
    }

    @Nullable
    protected <T> BeanRegistration<T> getActiveBeanRegistration(BeanDefinition<T> beanDefinition, Qualifier qualifier) {
        if (beanDefinition == null) {
            return null;
        }
        return this.singletonObjects.get(new BeanKey<T>(beanDefinition, qualifier));
    }

    @Nonnull
    protected <T> T createBean(@Nullable BeanResolutionContext resolutionContext, @Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Optional<BeanDefinition<T>> concreteCandidate = this.findConcreteCandidate(beanType, qualifier, true, false);
        if (concreteCandidate.isPresent()) {
            T createBean;
            BeanDefinition<T> candidate = concreteCandidate.get();
            if (resolutionContext == null) {
                resolutionContext = new DefaultBeanResolutionContext(this, candidate);
            }
            if ((createBean = this.doCreateBean(resolutionContext, candidate, qualifier, false, null)) == null) {
                throw new NoSuchBeanException(beanType);
            }
            return createBean;
        }
        throw new NoSuchBeanException(beanType);
    }

    @Nonnull
    protected <T> T inject(@Nonnull BeanResolutionContext resolutionContext, @Nullable BeanDefinition requestingBeanDefinition, @Nonnull T instance) {
        Class<?> beanType = instance.getClass();
        Optional<BeanDefinition<?>> concreteCandidate = this.findConcreteCandidate(beanType, null, false, true);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<?> definition = concreteCandidate.get();
            if (requestingBeanDefinition != null && requestingBeanDefinition.equals(definition)) {
                return instance;
            }
            this.doInject(resolutionContext, instance, definition);
        }
        return instance;
    }

    @Nonnull
    protected <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @Nonnull Class<T> beanType) {
        return this.getBeansOfTypeInternal(resolutionContext, beanType, null);
    }

    @Nonnull
    protected <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.getBeansOfTypeInternal(resolutionContext, beanType, qualifier);
    }

    @Nonnull
    protected <T> Provider<T> getBeanProvider(@Nullable BeanResolutionContext resolutionContext, @Nonnull Class<T> beanType) {
        return this.getBeanProvider(resolutionContext, beanType, null);
    }

    @Override
    @Nonnull
    public <T> T getProxyTargetBean(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Qualifier proxyQualifier = qualifier != null ? Qualifiers.byQualifiers(qualifier, PROXY_TARGET_QUALIFIER) : PROXY_TARGET_QUALIFIER;
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return this.getBeanForDefinition(new DefaultBeanResolutionContext(this, definition), beanType, proxyQualifier, true, definition);
    }

    @Override
    @Nonnull
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@Nonnull Class<T> beanType, @Nonnull String method, @Nonnull Class[] arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, null);
        return definition.findMethod(method, arguments);
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(Class<T> beanType, Qualifier<T> qualifier, String method, Class ... arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    @Nonnull
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Qualifier proxyQualifier = qualifier != null ? Qualifiers.byQualifiers(qualifier, PROXY_TARGET_QUALIFIER) : PROXY_TARGET_QUALIFIER;
        BeanKey<T> key = new BeanKey<T>(beanType, proxyQualifier, new Class[0]);
        return this.beanConcreteCandidateCache.computeIfAbsent(key, beanKey -> {
            BeanRegistration beanRegistration = this.singletonObjects.get(beanKey);
            if (beanRegistration != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved existing bean [{}] for type [{}] and qualifier [{}]", new Object[]{beanRegistration.bean, beanType, qualifier});
                }
                return Optional.of(beanRegistration.beanDefinition);
            }
            return this.findConcreteCandidateNoCache(beanType, proxyQualifier, true, false, false);
        });
    }

    @Override
    @Nonnull
    public Collection<BeanDefinition<?>> getBeanDefinitions(@Nullable Qualifier<Object> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for qualifier: {}", qualifier);
        }
        if (this.beanDefinitionsClasses.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Stream<BeanDefinitionReference> reduced = qualifier.reduce(Object.class, this.beanDefinitionsClasses.stream());
        Stream<BeanDefinition> candidateStream = qualifier.reduce(Object.class, reduced.map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)));
        Collection candidates = candidateStream.collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)candidates)) {
            this.filterProxiedTypes(candidates, true, true);
            this.filterReplacedBeans(candidates);
        }
        return candidates;
    }

    @Override
    @Nonnull
    public Collection<BeanDefinition<?>> getAllBeanDefinitions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding all bean definitions");
        }
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List<BeanDefinition<?>> collection = this.beanDefinitionsClasses.stream().map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)).collect(Collectors.toList());
            return collection;
        }
        return (Collection)((Object)Collections.EMPTY_MAP);
    }

    @Override
    @Nonnull
    public Collection<BeanDefinitionReference<?>> getBeanDefinitionReferences() {
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List refs = this.beanDefinitionsClasses.stream().filter(ref -> ref.isEnabled(this)).collect(Collectors.toList());
            return Collections.unmodifiableList(refs);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @Nonnull Class<T> beanType) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getBeanInternal(resolutionContext, beanType, null, true, true);
    }

    @Nonnull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getBeanInternal(resolutionContext, beanType, qualifier, true, true);
    }

    @Nonnull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        if (this.thisInterfaces.contains(beanType)) {
            return Optional.of(this);
        }
        T bean = this.getBeanInternal(resolutionContext, beanType, qualifier, true, false);
        if (bean == null) {
            return Optional.empty();
        }
        return Optional.of(bean);
    }

    @Override
    public void publishEvent(@Nonnull Object event) {
        if (event != null) {
            if (EVENT_LOGGER.isDebugEnabled()) {
                EVENT_LOGGER.debug("Publishing event: {}", event);
            }
            Collection eventListeners = this.getBeansOfType(ApplicationEventListener.class, Qualifiers.byTypeArguments(event.getClass()));
            if (!(eventListeners = (Collection)eventListeners.stream().sorted(OrderUtil.COMPARATOR).collect(Collectors.toList())).isEmpty()) {
                if (EVENT_LOGGER.isTraceEnabled()) {
                    EVENT_LOGGER.trace("Established event listeners {} for event: {}", (Object)eventListeners, event);
                }
                eventListeners.forEach(listener -> {
                    if (listener.supports(event)) {
                        try {
                            if (EVENT_LOGGER.isTraceEnabled()) {
                                EVENT_LOGGER.trace("Invoking event listener [{}] for event: {}", listener, event);
                            }
                            listener.onApplicationEvent(event);
                        }
                        catch (ClassCastException ex) {
                            String msg = ex.getMessage();
                            if (msg == null || msg.startsWith(event.getClass().getName())) {
                                if (EVENT_LOGGER.isDebugEnabled()) {
                                    EVENT_LOGGER.debug("Incompatible listener for event: " + listener, (Throwable)ex);
                                }
                            }
                            throw ex;
                        }
                    }
                });
            }
        }
    }

    @Override
    @Nonnull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getBeanDefinitions(beanType, qualifier).stream().filter(BeanDefinition::isProxy).findFirst();
    }

    protected void invalidateCaches() {
        this.beanCandidateCache.clear();
        this.initializedObjectsByType.clear();
    }

    @Nonnull
    protected <T> Provider<T> getBeanProvider(@Nullable BeanResolutionContext resolutionContext, @Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        BeanRegistration beanRegistration = this.singletonObjects.get(new BeanKey<T>(beanType, qualifier, new Class[0]));
        if (beanRegistration != null) {
            return new ResolvedProvider(beanRegistration.bean);
        }
        Optional<BeanDefinition<T>> concreteCandidate = this.findConcreteCandidate(beanType, qualifier, true, false);
        if (concreteCandidate.isPresent()) {
            return new UnresolvedProvider<T>(beanType, qualifier, this);
        }
        throw new NoSuchBeanException(beanType);
    }

    @Nonnull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
        SoftServiceLoader definitions = SoftServiceLoader.load(BeanDefinitionReference.class, (ClassLoader)this.classLoader);
        ArrayList<BeanDefinitionReference> list = new ArrayList<BeanDefinitionReference>(300);
        for (ServiceDefinition definition : definitions) {
            if (!definition.isPresent()) continue;
            BeanDefinitionReference ref = (BeanDefinitionReference)definition.load();
            list.add(ref);
        }
        return list;
    }

    @Nonnull
    protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
        SoftServiceLoader definitions = SoftServiceLoader.load(BeanConfiguration.class, (ClassLoader)this.classLoader);
        ArrayList<BeanConfiguration> list = new ArrayList<BeanConfiguration>(20);
        for (ServiceDefinition definition : definitions) {
            if (!definition.isPresent()) continue;
            list.add((BeanConfiguration)definition.load());
        }
        return list;
    }

    protected void initializeEventListeners() {
        this.beanCreationEventListeners = this.getBeanRegistrations(BeanCreatedEventListener.class);
        this.beanInitializedEventListeners = this.getBeanRegistrations(BeanInitializedEventListener.class);
    }

    protected void initializeContext(@Nonnull List<BeanDefinitionReference> contextScopeBeans, @Nonnull List<BeanDefinitionReference> processedBeans) {
        if (CollectionUtils.isNotEmpty(contextScopeBeans)) {
            ArrayList contextBeans = new ArrayList();
            for (BeanDefinitionReference beanDefinitionReference : contextScopeBeans) {
                try {
                    this.loadContextScopeBean(beanDefinitionReference, contextBeans::add);
                }
                catch (Throwable e) {
                    throw new BeanInstantiationException("Bean definition [" + beanDefinitionReference.getName() + "] could not be loaded: " + e.getMessage(), e);
                }
            }
            this.filterProxiedTypes(contextBeans, true, false);
            this.filterReplacedBeans(contextBeans);
            for (BeanDefinition beanDefinition2 : contextBeans) {
                try {
                    this.loadContextScopeBean(beanDefinition2);
                }
                catch (Throwable e) {
                    throw new BeanInstantiationException("Bean definition [" + beanDefinition2.getName() + "] could not be loaded: " + e.getMessage(), e);
                }
            }
            contextBeans.clear();
        }
        if (!processedBeans.isEmpty()) {
            Stream methodStream = processedBeans.stream().filter(ref -> ref.isEnabled(this)).map(reference -> {
                try {
                    return reference.load(this);
                }
                catch (Exception e) {
                    throw new BeanInstantiationException("Bean definition [" + reference.getName() + "] could not be loaded: " + e.getMessage(), (Throwable)e);
                }
            }).filter(bean -> bean.isEnabled(this)).flatMap(beanDefinition -> beanDefinition.getExecutableMethods().parallelStream().map(executableMethod -> BeanDefinitionMethodReference.of(beanDefinition, executableMethod)));
            HashMap byAnnotation = new HashMap();
            methodStream.collect(Collectors.toList()).forEach(reference -> {
                List annotations = reference.getAnnotationTypesByStereotype(Executable.class);
                if (annotations.isEmpty()) {
                    throw new IllegalStateException("BeanDefinition.requiresMethodProcessing() returned true but method has no @Executable definition. This should never happen. Please report an issue.");
                }
                annotations.forEach(annotation -> byAnnotation.compute(annotation, (ann, list) -> {
                    if (list == null) {
                        list = new ArrayList<BeanDefinitionMethodReference>();
                    }
                    list.add(reference);
                    return list;
                }));
            });
            for (Map.Entry entry : byAnnotation.entrySet()) {
                Class annotationType = (Class)entry.getKey();
                this.streamOfType(ExecutableMethodProcessor.class, Qualifiers.byTypeArguments(annotationType)).forEach(processor -> {
                    for (BeanDefinitionMethodReference method : (List)entry.getValue()) {
                        BeanDefinition beanDefinition = method.getBeanDefinition();
                        if (beanDefinition.hasStereotype(annotationType)) continue;
                        if (method.hasDeclaredStereotype(Parallel.class)) {
                            ForkJoinPool.commonPool().execute(() -> {
                                block3: {
                                    try {
                                        processor.process((BeanDefinition<?>)beanDefinition, method);
                                    }
                                    catch (Throwable e) {
                                        Boolean shutdownOnError;
                                        if (LOG.isErrorEnabled()) {
                                            LOG.error("Error processing bean method " + beanDefinition + "." + method + " with processor (" + processor + "): " + e.getMessage(), e);
                                        }
                                        if (!(shutdownOnError = method.booleanValue(Parallel.class, "shutdownOnError").orElse(true)).booleanValue()) break block3;
                                        this.stop();
                                    }
                                }
                            });
                            continue;
                        }
                        processor.process((BeanDefinition<?>)beanDefinition, method);
                    }
                    if (processor instanceof Completable) {
                        ((Completable)processor).onComplete();
                    }
                });
            }
        }
        Runnable runnable = () -> this.beanDefinitionsClasses.removeIf(beanDefinitionReference -> !beanDefinitionReference.isEnabled(this));
        if (ClassLoadingReporter.isReportingEnabled()) {
            runnable.run();
        } else {
            new Thread(runnable).start();
        }
    }

    @Nonnull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nonnull Class<T> beanType, @Nullable BeanDefinition<?> filter) {
        return this.findBeanCandidates(beanType, filter, true);
    }

    @Nonnull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nonnull Class<T> beanType, @Nullable BeanDefinition<?> filter, boolean filterProxied) {
        Collection<BeanDefinitionReference> beanDefinitionsClasses;
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for type: {}", beanType);
        }
        if (this.indexedTypes.contains(beanType)) {
            beanDefinitionsClasses = this.beanIndex.get(beanType);
            if (beanDefinitionsClasses == null) {
                beanDefinitionsClasses = Collections.emptyList();
            }
        } else {
            beanDefinitionsClasses = this.beanDefinitionsClasses;
        }
        if (!beanDefinitionsClasses.isEmpty()) {
            Set<BeanDefinition<T>> candidates;
            Stream<BeanDefinition> candidateStream = beanDefinitionsClasses.stream().filter(reference -> {
                if (reference.isPresent()) {
                    Class candidateType = reference.getBeanType();
                    boolean isCandidate = candidateType != null && (beanType.isAssignableFrom(candidateType) || beanType == candidateType);
                    return isCandidate && reference.isEnabled(this);
                }
                return false;
            }).map(ref -> {
                BeanDefinition loadedBean;
                try {
                    loadedBean = ref.load(this);
                }
                catch (Throwable e) {
                    throw new BeanContextException("Error loading bean [" + ref.getName() + "]: " + e.getMessage(), e);
                }
                return loadedBean;
            });
            if (filter != null) {
                candidateStream = candidateStream.filter(candidate -> !candidate.equals(filter));
            }
            if (!(candidates = candidateStream.filter(candidate -> candidate.isEnabled(this)).collect(Collectors.toSet())).isEmpty()) {
                if (filterProxied) {
                    this.filterProxiedTypes(candidates, true, false);
                }
                this.filterReplacedBeans(candidates);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved bean candidates {} for type: {}", candidates, beanType);
            }
            return candidates;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No bean candidates found for type: {}", beanType);
        }
        return Collections.emptySet();
    }

    @Nonnull
    protected <T> Collection<BeanDefinition> findBeanCandidatesForInstance(@Nonnull T instance) {
        ArgumentUtils.requireNonNull((String)"instance", instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for instance: {}", instance);
        }
        Collection<BeanDefinitionReference> beanDefinitionsClasses = this.beanDefinitionsClasses;
        return this.beanCandidateCache.computeIfAbsent(instance.getClass(), aClass -> {
            if (!beanDefinitionsClasses.isEmpty()) {
                List candidates = beanDefinitionsClasses.stream().filter(reference -> {
                    if (reference.isEnabled(this)) {
                        Class candidateType = reference.getBeanType();
                        return candidateType != null && candidateType.isInstance(instance);
                    }
                    return false;
                }).map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)).collect(Collectors.toList());
                if (candidates.size() > 1) {
                    candidates = candidates.stream().filter(candidate -> !(candidate instanceof NoInjectionBeanDefinition) && candidate.getBeanType() == instance.getClass()).collect(Collectors.toList());
                    return candidates;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved bean candidates {} for instance: {}", candidates, instance);
                }
                return candidates;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No bean candidates found for instance: {}", instance);
            }
            return Collections.emptySet();
        });
    }

    protected void registerConfiguration(@Nonnull BeanConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.beanConfigurations.put(configuration.getName(), configuration);
        ClassLoadingReporter.reportPresent(configuration.getClass());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected <T> T doCreateBean(@Nullable BeanResolutionContext resolutionContext, @Nonnull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, boolean isSingleton, @Nullable Map<String, Object> argumentValues) {
        declaredQualifier = this.resolveDeclaredQualifier(beanDefinition);
        beanType = beanDefinition.getBeanType();
        if (isSingleton) {
            beanRegistration = this.singletonObjects.get(new BeanKey<T>(beanDefinition, declaredQualifier));
            if (beanRegistration != null) {
                if (qualifier == null) {
                    return beanRegistration.bean;
                }
                if (qualifier.reduce(beanType, Stream.of(beanRegistration.beanDefinition)).findFirst().isPresent()) {
                    return beanRegistration.bean;
                }
            } else if (qualifier != null && (beanRegistration = this.singletonObjects.get(new BeanKey<T>(beanDefinition, null))) != null && qualifier.reduce(beanType, Stream.of(beanRegistration.beanDefinition)).findFirst().isPresent()) {
                return beanRegistration.bean;
            }
        }
        if (resolutionContext == null) {
            resolutionContext = new DefaultBeanResolutionContext(this, beanDefinition);
        }
        if (beanDefinition instanceof BeanFactory) {
            beanFactory = (BeanFactory)beanDefinition;
            try {
                if (beanFactory instanceof ParametrizedBeanFactory) {
                    parametrizedBeanFactory = (ParametrizedBeanFactory)beanFactory;
                    requiredArguments = parametrizedBeanFactory.getRequiredArguments();
                    if (argumentValues == null) {
                        throw new BeanInstantiationException(resolutionContext, "Missing bean arguments for type: " + beanType.getName() + ". Requires arguments: " + ArrayUtils.toString((Object[])requiredArguments));
                    }
                    convertedValues = new LinkedHashMap<String, Object>(argumentValues);
                    for (Object requiredArgument : requiredArguments) {
                        val = argumentValues.get(requiredArgument.getName());
                        if (val == null && !requiredArgument.isDeclaredNullable()) {
                            throw new BeanInstantiationException(resolutionContext, "Missing bean argument [" + requiredArgument + "].");
                        }
                        finalResolutionContext = resolutionContext;
                        convertedValue = null;
                        if (val != null) {
                            convertedValue = (V)ConversionService.SHARED.convert(val, (Argument)requiredArgument).orElseThrow((Supplier<BeanInstantiationException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doCreateBean$39(io.micronaut.context.BeanResolutionContext io.micronaut.core.type.Argument java.lang.Object ), ()Lio/micronaut/context/exceptions/BeanInstantiationException;)((BeanResolutionContext)finalResolutionContext, (Argument)requiredArgument, (Object)val));
                        }
                        convertedValues.put(requiredArgument.getName(), convertedValue);
                    }
                    bean = parametrizedBeanFactory.build(resolutionContext, this, beanDefinition, convertedValues);
                }
                bean = beanFactory.build(resolutionContext, this, beanDefinition);
                if (bean == null) {
                    if (beanDefinition.isIterable() || beanDefinition.getAnnotationMetadata().hasAnnotation(Factory.class)) ** GOTO lbl65
                    throw new BeanInstantiationException(resolutionContext, "Bean Factory [" + beanFactory + "] returned null");
                }
                if (!(bean instanceof Qualified)) ** GOTO lbl65
                ((Qualified)bean).$withBeanQualifier(declaredQualifier);
            }
            catch (Throwable e) {
                if (e instanceof DependencyInjectionException) {
                    throw e;
                }
                if (e instanceof BeanInstantiationException) {
                    throw e;
                }
                if (!resolutionContext.getPath().isEmpty()) {
                    throw new BeanInstantiationException(resolutionContext, e);
                }
                throw new BeanInstantiationException(beanDefinition, e);
            }
        } else {
            constructor = beanDefinition.getConstructor();
            requiredConstructorArguments = constructor.getArguments();
            if (requiredConstructorArguments.length == 0) {
                bean = constructor.invoke(new Object[0]);
            } else {
                constructorArgs = new Object[requiredConstructorArguments.length];
                for (i = 0; i < requiredConstructorArguments.length; ++i) {
                    argument = requiredConstructorArguments[i].getType();
                    constructorArgs[i] = this.getBean(resolutionContext, argument);
                }
                bean = constructor.invoke(constructorArgs);
            }
            this.inject(resolutionContext, null, bean);
        }
lbl65:
        // 5 sources

        if (bean != null) {
            if (!BeanCreatedEventListener.class.isInstance(bean) && CollectionUtils.isNotEmpty(this.beanCreationEventListeners)) {
                beanKey = new BeanKey<T>(beanDefinition, qualifier);
                for (BeanRegistration<BeanCreatedEventListener> registration : this.beanCreationEventListeners) {
                    definition = registration.getBeanDefinition();
                    typeArguments = definition.getTypeArguments(BeanCreatedEventListener.class);
                    if (!CollectionUtils.isEmpty(typeArguments) && !typeArguments.get(0).getType().isAssignableFrom(beanType) || (bean = (listener = registration.getBean()).onCreated(new BeanCreatedEvent<T>(this, beanDefinition, beanKey, bean))) != null) continue;
                    throw new BeanInstantiationException(resolutionContext, "Listener [" + listener + "] returned null from onCreated event");
                }
            }
            if (beanDefinition instanceof ValidatedBeanDefinition) {
                bean = ((ValidatedBeanDefinition)beanDefinition).validate(resolutionContext, bean);
            }
            if (DefaultBeanContext.LOG_LIFECYCLE.isDebugEnabled()) {
                DefaultBeanContext.LOG_LIFECYCLE.debug("Created bean [{}] from definition [{}] with qualifier [{}]", new Object[]{bean, beanDefinition, qualifier});
            }
        }
        return bean;
    }

    private <T> Qualifier resolveDeclaredQualifier(@Nonnull BeanDefinition<T> beanDefinition) {
        return beanDefinition.getAnnotationTypeByStereotype(javax.inject.Qualifier.class).map(aClass -> {
            if (aClass == Primary.class) {
                return null;
            }
            return Qualifiers.byAnnotation((AnnotationMetadata)beanDefinition, aClass.getName());
        }).orElseGet(() -> this.resolveDynamicQualifier(beanDefinition));
    }

    @Nonnull
    protected <T> BeanDefinition<T> findConcreteCandidate(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier, @Nonnull Collection<BeanDefinition<T>> candidates) {
        throw new NonUniqueBeanException(beanType, candidates.iterator());
    }

    protected void processParallelBeans() {
        new Thread(() -> {
            List<BeanDefinitionReference> parallelBeans = this.beanDefinitionsClasses.stream().filter(bd -> bd.getAnnotationMetadata().hasDeclaredStereotype(Parallel.class) && bd.isEnabled(this)).collect(Collectors.toList());
            ArrayList<BeanDefinition<BeanDefinition>> parallelDefinitions = new ArrayList<BeanDefinition<BeanDefinition>>();
            parallelBeans.forEach(beanDefinitionReference -> {
                block5: {
                    try {
                        if (!this.isRunning()) break block5;
                        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
                        synchronized (map) {
                            this.loadContextScopeBean((BeanDefinitionReference)beanDefinitionReference, parallelDefinitions::add);
                        }
                    }
                    catch (Throwable e) {
                        LOG.error("Parallel Bean definition [" + beanDefinitionReference.getName() + "] could not be loaded: " + e.getMessage(), e);
                        Boolean shutdownOnError = beanDefinitionReference.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                        if (!shutdownOnError.booleanValue()) break block5;
                        this.stop();
                    }
                }
            });
            this.filterProxiedTypes(parallelDefinitions, true, false);
            this.filterReplacedBeans(parallelDefinitions);
            parallelDefinitions.forEach(beanDefinition -> ForkJoinPool.commonPool().execute(() -> {
                block5: {
                    try {
                        if (!this.isRunning()) break block5;
                        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
                        synchronized (map) {
                            this.loadContextScopeBean((BeanDefinition)beanDefinition);
                        }
                    }
                    catch (Throwable e) {
                        LOG.error("Parallel Bean definition [" + beanDefinition.getName() + "] could not be loaded: " + e.getMessage(), e);
                        Boolean shutdownOnError = beanDefinition.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                        if (!shutdownOnError.booleanValue()) break block5;
                        this.stop();
                    }
                }
            }));
            parallelDefinitions.clear();
        }).start();
    }

    private <T> void filterReplacedBeans(Collection<? extends BeanType<T>> candidates) {
        ArrayList replacedTypes = new ArrayList(2);
        for (BeanType<T> candidate : candidates) {
            if (!candidate.getAnnotationMetadata().hasStereotype(Replaces.class)) continue;
            replacedTypes.add(candidate);
        }
        if (!replacedTypes.isEmpty()) {
            candidates.removeIf(definition -> {
                if (!definition.isEnabled(this)) {
                    return true;
                }
                AnnotationMetadata annotationMetadata = definition.getAnnotationMetadata();
                if (annotationMetadata.hasDeclaredStereotype(Infrastructure.class)) {
                    return false;
                }
                Optional<Object> declaringType = Optional.empty();
                if (definition instanceof BeanDefinition) {
                    declaringType = ((BeanDefinition)definition).getDeclaringType();
                }
                Function<Class, Boolean> comparisonFunction = this.typeMatches((BeanType)definition, annotationMetadata);
                Optional<Object> finalDeclaringType = declaringType;
                return replacedTypes.stream().anyMatch(replacingCandidate -> {
                    Optional<BeanType> qualified;
                    Class type;
                    String qualifier;
                    if (definition == replacingCandidate) {
                        return false;
                    }
                    if (replacingCandidate instanceof ProxyBeanDefinition && ((ProxyBeanDefinition)replacingCandidate).getTargetDefinitionType() == definition.getClass()) {
                        return false;
                    }
                    AnnotationValue replacesAnn = replacingCandidate.getAnnotation(Replaces.class);
                    Optional beanType = replacesAnn.classValue();
                    Optional factory = replacesAnn.classValue("factory");
                    if (replacesAnn.contains(NAMED_MEMBER) && (qualifier = (String)replacesAnn.stringValue(NAMED_MEMBER).orElse(null)) != null && (type = (Class)beanType.orElse(factory.orElse(null))) != null && (qualified = Qualifiers.byName(qualifier).qualify(type, Stream.of(definition))).isPresent()) {
                        return true;
                    }
                    if (LOG.isDebugEnabled()) {
                        if (factory.isPresent()) {
                            LOG.debug("Bean [{}] replaces existing bean of type [{}] in factory type [{}]", new Object[]{replacingCandidate.getBeanType(), beanType.orElse(null), factory.get()});
                        } else {
                            LOG.debug("Bean [{}] replaces existing bean of type [{}]", replacingCandidate.getBeanType(), beanType.orElse(null));
                        }
                    }
                    if (factory.isPresent() && finalDeclaringType.isPresent()) {
                        if (factory.get() == finalDeclaringType.get()) {
                            return !beanType.isPresent() || (Boolean)comparisonFunction.apply((Class)beanType.get()) != false;
                        }
                        return false;
                    }
                    return beanType.map(comparisonFunction).orElse(false);
                });
            });
        }
    }

    private <T> Function<Class, Boolean> typeMatches(BeanType<T> definition, AnnotationMetadata annotationMetadata) {
        Class bt = definition instanceof ProxyBeanDefinition ? ((ProxyBeanDefinition)definition).getTargetType() : definition.getBeanType();
        if (annotationMetadata.hasStereotype(INTRODUCTION_TYPE)) {
            Class superclass = bt.getSuperclass();
            if (superclass == Object.class) {
                return clazz -> clazz.isAssignableFrom(bt);
            }
            return clazz -> clazz == superclass;
        }
        if (annotationMetadata.hasStereotype(AROUND_TYPE)) {
            Class superclass = bt.getSuperclass();
            return clazz -> clazz == superclass || clazz == bt;
        }
        if (annotationMetadata.hasAnnotation(DefaultImplementation.class)) {
            Optional defaultImpl = annotationMetadata.classValue(DefaultImplementation.class);
            if (!defaultImpl.isPresent()) {
                defaultImpl = annotationMetadata.classValue(DefaultImplementation.class, "name");
            }
            if (defaultImpl.filter(impl -> impl == bt).isPresent()) {
                return clazz -> clazz.isAssignableFrom(bt);
            }
        }
        return clazz -> clazz == bt;
    }

    private <T> void doInject(BeanResolutionContext resolutionContext, T instance, BeanDefinition definition) {
        definition.inject(resolutionContext, this, instance);
        if (definition instanceof InitializingBeanDefinition) {
            ((InitializingBeanDefinition)definition).initialize(resolutionContext, this, instance);
        }
    }

    private void loadContextScopeBean(BeanDefinitionReference contextScopeBean, Consumer<BeanDefinition> beanDefinitionConsumer) {
        BeanDefinition beanDefinition;
        if (contextScopeBean.isEnabled(this) && (beanDefinition = contextScopeBean.load(this)).isEnabled(this)) {
            beanDefinitionConsumer.accept(beanDefinition);
        }
    }

    private void loadContextScopeBean(BeanDefinition beanDefinition) {
        if (beanDefinition.isIterable()) {
            Collection beanCandidates = this.findBeanCandidates(beanDefinition.getBeanType(), null, true);
            for (BeanDefinition beanCandidate : beanCandidates) {
                DefaultBeanResolutionContext resolutionContext = new DefaultBeanResolutionContext(this, beanDefinition);
                this.createAndRegisterSingleton(resolutionContext, beanCandidate, beanCandidate.getBeanType(), null);
            }
        } else {
            this.createAndRegisterSingleton(new DefaultBeanResolutionContext(this, beanDefinition), beanDefinition, beanDefinition.getBeanType(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getBeanInternal(@Nullable BeanResolutionContext resolutionContext, Class<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, boolean throwNoSuchBean) {
        T inFlightBean;
        if (this.thisInterfaces.contains(beanType)) {
            return (T)this;
        }
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier, new Class[0]);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing bean for key: {}", beanKey);
        }
        T t = inFlightBean = resolutionContext != null ? (T)resolutionContext.getInFlightBean(beanKey) : null;
        if (inFlightBean != null) {
            return inFlightBean;
        }
        BeanRegistration beanRegistration = this.singletonObjects.get(beanKey);
        if (beanRegistration != null) {
            Object bean = beanRegistration.bean;
            if (bean == null && throwNoSuchBean) {
                throw new NoSuchBeanException(beanType, qualifier);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved existing bean [{}] for type [{}] and qualifier [{}]", new Object[]{beanRegistration.bean, beanType, qualifier});
            }
            return bean;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No existing bean found for bean key: {}", beanKey);
        }
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            Optional<BeanDefinition<T>> concreteCandidate = this.findConcreteCandidate(beanType, qualifier, throwNonUnique, false);
            if (concreteCandidate.isPresent()) {
                BeanDefinition<T> definition = concreteCandidate.get();
                T bean = this.findExistingCompatibleSingleton(beanType, qualifier, definition);
                if (bean != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resolved existing bean [{}] for type [{}] and qualifier [{}]", new Object[]{bean, beanType, qualifier});
                    }
                    return bean;
                }
                if (resolutionContext == null) {
                    resolutionContext = new DefaultBeanResolutionContext(this, definition);
                }
                if (definition.isProvided() && beanType == definition.getBeanType()) {
                    if (throwNoSuchBean) {
                        throw new NoSuchBeanException(beanType, qualifier);
                    }
                    return null;
                }
                bean = this.getBeanForDefinition(resolutionContext, beanType, qualifier, throwNoSuchBean, definition);
                if (bean == null && throwNoSuchBean) {
                    throw new NoSuchBeanException(beanType, qualifier);
                }
                return bean;
            }
            T bean = this.findExistingCompatibleSingleton(beanType, qualifier, null);
            if (bean == null && throwNoSuchBean) {
                throw new NoSuchBeanException(beanType, qualifier);
            }
            return bean;
        }
    }

    private <T> T getBeanForDefinition(BeanResolutionContext resolutionContext, Class<T> beanType, Qualifier<T> qualifier, boolean throwNoSuchBean, BeanDefinition<T> definition) {
        if (definition.isSingleton() && !definition.hasStereotype(SCOPED_PROXY_ANN)) {
            return this.createAndRegisterSingleton(resolutionContext, definition, beanType, qualifier);
        }
        return this.getScopedBeanForDefinition(resolutionContext, beanType, qualifier, throwNoSuchBean, definition);
    }

    private <T> T getScopedBeanForDefinition(@Nullable BeanResolutionContext resolutionContext, final Class<T> beanType, final Qualifier<T> qualifier, final boolean throwNoSuchBean, BeanDefinition<T> definition) {
        T createBean;
        Object scope;
        boolean isProxy = definition.isProxy();
        boolean isScopedProxyDefinition = definition.hasStereotype(SCOPED_PROXY_ANN);
        if (qualifier != PROXY_TARGET_QUALIFIER && isProxy && isScopedProxyDefinition) {
            Class<?> proxiedType = this.resolveProxiedType(beanType, definition);
            BeanKey key = new BeanKey(proxiedType, qualifier, new Class[0]);
            BeanDefinition finalDefinition = definition;
            BeanResolutionContext finalResolutionContext1 = resolutionContext;
            return (T)this.scopedProxies.computeIfAbsent(key, beanKey -> {
                BeanDefinition proxyDefinition;
                BeanResolutionContext currentResolutionContext;
                Object createBean;
                Qualifier q = qualifier;
                if (q == null) {
                    q = this.resolveDeclaredQualifier(finalDefinition);
                }
                if ((createBean = this.doCreateBean(currentResolutionContext = finalResolutionContext1 != null ? finalResolutionContext1 : new DefaultBeanResolutionContext(this, proxyDefinition), proxyDefinition = this.findProxyBeanDefinition(proxiedType, q).orElse(finalDefinition), qualifier, false, null)) instanceof Qualified) {
                    ((Qualified)createBean).$withBeanQualifier(qualifier);
                }
                if (createBean == null && throwNoSuchBean) {
                    throw new NoSuchBeanException(proxyDefinition.getBeanType(), qualifier);
                }
                return createBean;
            });
        }
        Optional currentSegment = resolutionContext != null ? resolutionContext.getPath().currentSegment() : Optional.empty();
        Optional<Object> registeredScope = Optional.empty();
        if (currentSegment.isPresent()) {
            Argument argument = ((BeanResolutionContext.Segment)currentSegment.get()).getArgument();
            scope = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Scope.class);
            registeredScope = ((Optional)scope).flatMap(this.customScopeRegistry::findScope);
        }
        if (!isProxy && isScopedProxyDefinition && !registeredScope.isPresent()) {
            Class scope2;
            List scopeHierarchy = definition.getAnnotationTypesByStereotype(Scope.class);
            scope = scopeHierarchy.iterator();
            while (scope.hasNext() && !(registeredScope = this.customScopeRegistry.findScope(scope2 = (Class)scope.next())).isPresent()) {
            }
        }
        if (registeredScope.isPresent()) {
            CustomScope customScope = (CustomScope)registeredScope.get();
            if (isProxy) {
                definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
            }
            final BeanDefinition finalDefinition = definition;
            if (resolutionContext == null) {
                resolutionContext = new DefaultBeanResolutionContext(this, finalDefinition);
            }
            final BeanResolutionContext finalResolutionContext = resolutionContext;
            return customScope.get(resolutionContext, finalDefinition, new BeanKey<T>(beanType, qualifier, new Class[0]), new ParametrizedProvider(){

                public Object get(Map argumentValues) {
                    Object createBean = DefaultBeanContext.this.doCreateBean(finalResolutionContext, finalDefinition, qualifier, false, argumentValues);
                    if (createBean == null && throwNoSuchBean) {
                        throw new NoSuchBeanException(finalDefinition.getBeanType(), qualifier);
                    }
                    return createBean;
                }

                public Object get(Object ... argumentValues) {
                    Object createdBean = DefaultBeanContext.this.doCreateBean(finalResolutionContext, finalDefinition, beanType, qualifier, argumentValues);
                    if (createdBean == null && throwNoSuchBean) {
                        throw new NoSuchBeanException(finalDefinition.getBeanType(), qualifier);
                    }
                    return createdBean;
                }
            });
        }
        if (resolutionContext == null) {
            resolutionContext = new DefaultBeanResolutionContext(this, definition);
        }
        if ((createBean = this.doCreateBean(resolutionContext, definition, qualifier, false, null)) == null && throwNoSuchBean) {
            throw new NoSuchBeanException(definition.getBeanType(), qualifier);
        }
        return createBean;
    }

    private <T> Class<?> resolveProxiedType(Class<T> beanType, BeanDefinition<T> definition) {
        BeanDefinition delegate;
        Class proxiedType = definition instanceof ProxyBeanDefinition ? ((ProxyBeanDefinition)definition).getTargetType() : (definition instanceof BeanDefinitionDelegate ? ((delegate = ((BeanDefinitionDelegate)definition).getDelegate()) instanceof ProxyBeanDefinition ? ((ProxyBeanDefinition)delegate).getTargetType() : beanType) : beanType);
        return proxiedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T findExistingCompatibleSingleton(Class<T> beanType, Qualifier<T> qualifier, BeanDefinition<T> definition) {
        T bean = null;
        for (Map.Entry<BeanKey, BeanRegistration> entry : this.singletonObjects.entrySet()) {
            Optional candidate;
            BeanKey key = entry.getKey();
            if (qualifier == null || qualifier.equals(key.qualifier)) {
                BeanRegistration reg = entry.getValue();
                if (!beanType.isInstance(reg.bean)) continue;
                if (qualifier == null && definition != null && !reg.beanDefinition.equals(definition)) {
                    return null;
                }
                Map<BeanKey, BeanRegistration> map = this.singletonObjects;
                synchronized (map) {
                    bean = reg.bean;
                    this.registerSingletonBean(reg.beanDefinition, beanType, bean, qualifier, true);
                    continue;
                }
            }
            if (key.qualifier != null) continue;
            BeanRegistration registration = entry.getValue();
            Object existing = registration.bean;
            if (!beanType.isInstance(existing) || !(candidate = qualifier.reduce(beanType, Stream.of(registration.beanDefinition)).findFirst()).isPresent()) continue;
            Map<BeanKey, BeanRegistration> map = this.singletonObjects;
            synchronized (map) {
                bean = existing;
                this.registerSingletonBean(candidate.get(), beanType, bean, qualifier, true);
            }
        }
        return bean;
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidate(Class<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, boolean includeProvided) {
        return this.beanConcreteCandidateCache.computeIfAbsent(new BeanKey<T>(beanType, qualifier, new Class[0]), beanKey -> this.findConcreteCandidateNoCache(beanType, qualifier, throwNonUnique, includeProvided, true));
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidateNoCache(Class<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, boolean includeProvided, boolean filterProxied) {
        ArrayList<BeanDefinition<T>> candidates = new ArrayList<BeanDefinition<T>>(this.findBeanCandidates(beanType, null, filterProxied));
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        this.filterProxiedTypes(candidates, filterProxied, false);
        if (!includeProvided) {
            candidates.removeIf(BeanDefinition::isProvided);
        }
        int size = candidates.size();
        BeanDefinition<T> definition = null;
        if (size > 0) {
            if (qualifier != null) {
                Stream<BeanDefinition> candidateStream;
                Stream<BeanDefinition> qualified;
                List<BeanDefinition<T>> beanDefinitionList;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Qualifying bean [{}] for qualifier: {} ", (Object)beanType.getName(), qualifier);
                }
                if ((beanDefinitionList = (qualified = qualifier.reduce(beanType, candidateStream = candidates.stream().filter(c -> {
                    if (!c.isAbstract()) {
                        if (c instanceof NoInjectionBeanDefinition) {
                            NoInjectionBeanDefinition noInjectionBeanDefinition = (NoInjectionBeanDefinition)c;
                            return qualifier.contains(noInjectionBeanDefinition.qualifier);
                        }
                        return true;
                    }
                    return false;
                }))).collect(Collectors.toList())).isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No qualifying beans of type [{}] found for qualifier: {} ", (Object)beanType.getName(), qualifier);
                    }
                    return Optional.empty();
                }
                definition = this.lastChanceResolve(beanType, qualifier, throwNonUnique, beanDefinitionList);
            } else {
                candidates.removeIf(BeanDefinition::isAbstract);
                if (candidates.size() == 1) {
                    definition = (BeanDefinition<T>)candidates.iterator().next();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Searching for @Primary for type [{}] from candidates: {} ", (Object)beanType.getName(), candidates);
                    }
                    definition = this.lastChanceResolve(beanType, null, throwNonUnique, candidates);
                }
            }
        }
        if (LOG.isDebugEnabled() && definition != null) {
            if (qualifier != null) {
                LOG.debug("Found concrete candidate [{}] for type: {} {} ", new Object[]{definition, qualifier, beanType.getName()});
            } else {
                LOG.debug("Found concrete candidate [{}] for type: {} ", definition, (Object)beanType.getName());
            }
        }
        return Optional.ofNullable(definition);
    }

    private <T> void filterProxiedTypes(Collection<BeanDefinition<T>> candidates, boolean filterProxied, boolean filterDelegates) {
        ArrayList delegates;
        int count = candidates.size();
        HashSet proxiedTypes = new HashSet(count);
        Iterator<BeanDefinition<T>> i = candidates.iterator();
        ArrayList arrayList = delegates = filterDelegates ? new ArrayList(count) : Collections.emptyList();
        while (i.hasNext()) {
            BeanDefinition<T> candidate2 = i.next();
            if (candidate2 instanceof ProxyBeanDefinition) {
                if (filterProxied) {
                    proxiedTypes.add(((ProxyBeanDefinition)candidate2).getTargetDefinitionType());
                    continue;
                }
                proxiedTypes.add(candidate2.getClass());
                continue;
            }
            if (!(candidate2 instanceof BeanDefinitionDelegate)) continue;
            BeanDefinition delegate = ((BeanDefinitionDelegate)candidate2).getDelegate();
            if (filterDelegates) {
                i.remove();
                if (delegates.contains(delegate)) continue;
                delegates.add(delegate);
                continue;
            }
            if (!filterProxied || !(delegate instanceof ProxyBeanDefinition)) continue;
            proxiedTypes.add(((ProxyBeanDefinition)delegate).getTargetDefinitionType());
        }
        if (filterDelegates) {
            candidates.addAll(delegates);
        }
        if (!proxiedTypes.isEmpty()) {
            candidates.removeIf(candidate -> {
                if (candidate instanceof BeanDefinitionDelegate) {
                    return proxiedTypes.contains(((BeanDefinitionDelegate)candidate).getDelegate().getClass());
                }
                return proxiedTypes.contains(candidate.getClass());
            });
        }
    }

    private <T> BeanDefinition<T> lastChanceResolve(Class<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, Collection<BeanDefinition<T>> candidates) {
        List primary;
        if (candidates.size() > 1 && !(primary = candidates.stream().filter(BeanType::isPrimary).collect(Collectors.toList())).isEmpty()) {
            candidates = primary;
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        BeanDefinition<T> definition = null;
        if ((candidates = (Collection)candidates.stream().filter(candidate -> !candidate.hasDeclaredStereotype(Secondary.class)).collect(Collectors.toList())).size() == 1) {
            return (BeanDefinition)candidates.iterator().next();
        }
        Collection<BeanDefinition<T>> exactMatches = this.filterExactMatch(beanType, candidates);
        if (exactMatches.size() == 1) {
            definition = exactMatches.iterator().next();
        } else if (throwNonUnique) {
            definition = this.findConcreteCandidate(beanType, qualifier, candidates);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T createAndRegisterSingleton(BeanResolutionContext resolutionContext, BeanDefinition<T> definition, Class<T> beanType, Qualifier<T> qualifier) {
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            if (definition instanceof NoInjectionBeanDefinition) {
                NoInjectionBeanDefinition manuallyRegistered = (NoInjectionBeanDefinition)definition;
                BeanRegistration reg = this.singletonObjects.get(new BeanKey<T>(beanType, manuallyRegistered.getQualifier(), new Class[0]));
                if (reg == null) {
                    throw new IllegalStateException("Manually registered singleton no longer present in bean context");
                }
                this.registerSingletonBean(definition, beanType, reg.bean, qualifier, true);
                return reg.bean;
            }
            T createdBean = this.doCreateBean(resolutionContext, definition, qualifier, true, null);
            this.registerSingletonBean(definition, beanType, createdBean, qualifier, true);
            return createdBean;
        }
    }

    private void readAllBeanConfigurations() {
        Iterable<BeanConfiguration> beanConfigurations = this.resolveBeanConfigurations();
        for (BeanConfiguration beanConfiguration : beanConfigurations) {
            this.registerConfiguration(beanConfiguration);
        }
    }

    private <T> Collection<BeanDefinition<T>> filterExactMatch(Class<T> beanType, Collection<BeanDefinition<T>> candidates) {
        Stream<BeanDefinition> filteredResults = candidates.stream().filter(candidate -> candidate.getBeanType() == beanType);
        return filteredResults.collect(Collectors.toList());
    }

    private <T> void registerSingletonBean(BeanDefinition<T> beanDefinition, Class<T> beanType, T createdBean, Qualifier<T> qualifier, boolean singleCandidate) {
        boolean isNotProxyTarget;
        if (qualifier == null) {
            qualifier = this.resolveDynamicQualifier(beanDefinition);
        }
        BeanKey<T> key = new BeanKey<T>(beanDefinition, qualifier);
        if (LOG.isDebugEnabled()) {
            if (qualifier != null) {
                LOG.debug("Registering singleton bean {} for type [{} {}] using bean key {}", new Object[]{createdBean, qualifier, beanType.getName(), key});
            } else {
                LOG.debug("Registering singleton bean {} for type [{}] using bean key {}", new Object[]{createdBean, beanType.getName(), key});
            }
        }
        BeanRegistration<T> registration = new BeanRegistration<T>(key, beanDefinition, createdBean);
        if (singleCandidate || ((BeanKey)key).typeArguments != null) {
            this.singletonObjects.put(key, registration);
        }
        boolean bl = isNotProxyTarget = qualifier != PROXY_TARGET_QUALIFIER;
        if (isNotProxyTarget) {
            Class<Object> createdType = createdBean != null ? createdBean.getClass() : beanType;
            boolean createdTypeDiffers = !createdType.equals(beanType);
            BeanKey<Object> createdBeanKey = new BeanKey<Object>(createdType, qualifier, new Class[0]);
            Optional qualifierAnn = beanDefinition.getAnnotationTypeByStereotype(javax.inject.Qualifier.class);
            if (qualifierAnn.isPresent()) {
                Class annotation = (Class)qualifierAnn.get();
                if (Primary.class == annotation) {
                    BeanKey<T> primaryBeanKey = new BeanKey<T>(beanType, null, new Class[0]);
                    this.singletonObjects.put(primaryBeanKey, registration);
                    if (createdTypeDiffers) {
                        this.singletonObjects.put(new BeanKey<Object>(createdType, null, new Class[0]), registration);
                    }
                } else {
                    BeanKey<Object> qualifierKey = new BeanKey<Object>(createdType, Qualifiers.byAnnotation(beanDefinition, annotation.getName()), new Class[0]);
                    if (!qualifierKey.equals(createdBeanKey)) {
                        this.singletonObjects.put(qualifierKey, registration);
                    }
                }
            } else if (!beanDefinition.isIterable()) {
                BeanKey<Object> primaryBeanKey = new BeanKey<Object>(createdType, null, new Class[0]);
                this.singletonObjects.put(primaryBeanKey, registration);
                if (qualifier != null) {
                    BeanKey<T> qualifiedKey = new BeanKey<T>(beanType, qualifier, new Class[0]);
                    this.singletonObjects.put(qualifiedKey, registration);
                }
            } else if (beanDefinition.isPrimary()) {
                BeanKey<T> primaryBeanKey = new BeanKey<T>(beanType, null, new Class[0]);
                this.singletonObjects.put(primaryBeanKey, registration);
                if (createdTypeDiffers) {
                    this.singletonObjects.put(new BeanKey<Object>(createdType, null, new Class[0]), registration);
                }
            }
            this.singletonObjects.put(createdBeanKey, registration);
        }
    }

    private <T> Qualifier<T> resolveDynamicQualifier(BeanDefinition<T> beanDefinition) {
        String name2;
        Qualifier qualifier = null;
        if (beanDefinition instanceof BeanDefinitionDelegate && (name2 = (String)((BeanDefinitionDelegate)beanDefinition).get(Named.class.getName(), String.class, null)) != null) {
            qualifier = Qualifiers.byName(name2);
        }
        if (qualifier == null) {
            Optional optional = beanDefinition.stringValue(javax.inject.Named.class);
            qualifier = optional.map(name -> Qualifiers.byAnnotation((AnnotationMetadata)beanDefinition, name)).orElse(null);
        }
        return qualifier;
    }

    private void readAllBeanDefinitionClasses() {
        ArrayList<BeanDefinitionReference> contextScopeBeans = new ArrayList<BeanDefinitionReference>(20);
        ArrayList<BeanDefinitionReference> processedBeans = new ArrayList<BeanDefinitionReference>(10);
        List<BeanDefinitionReference> beanDefinitionReferences = this.resolveBeanDefinitionReferences();
        ArrayList<BeanDefinitionReference> disabled = new ArrayList<BeanDefinitionReference>(20);
        boolean reportingEnabled = ClassLoadingReporter.isReportingEnabled();
        this.beanDefinitionsClasses.addAll(beanDefinitionReferences);
        Map configurationEnabled = this.beanConfigurations.values().stream().collect(Collectors.toMap(Function.identity(), bc -> bc.isEnabled(this)));
        for (BeanDefinitionReference beanDefinitionReference : beanDefinitionReferences) {
            boolean disabledByConfiguration = this.beanConfigurations.values().stream().filter(c -> c.isWithin(beanDefinitionReference)).anyMatch(c -> (Boolean)configurationEnabled.get(c) == false);
            if (disabledByConfiguration) {
                disabled.add(beanDefinitionReference);
                if (!reportingEnabled) continue;
                ClassLoadingReporter.reportMissing((String)beanDefinitionReference.getBeanDefinitionName());
                ClassLoadingReporter.reportMissing((String)beanDefinitionReference.getName());
                continue;
            }
            List indexes = beanDefinitionReference.getAnnotationMetadata().getAnnotationValuesByType(Indexed.class);
            if (CollectionUtils.isNotEmpty((Collection)indexes)) {
                for (AnnotationValue index : indexes) {
                    Class indexedType = index.classValue().orElse(null);
                    if (indexedType == null) continue;
                    this.resolveTypeIndex(indexedType);
                }
            }
            if (beanDefinitionReference.isContextScope()) {
                contextScopeBeans.add(beanDefinitionReference);
            }
            if (!beanDefinitionReference.requiresMethodProcessing()) continue;
            processedBeans.add(beanDefinitionReference);
        }
        this.beanDefinitionsClasses.removeAll(disabled);
        this.indexBeanDefinitions();
        disabled.clear();
        this.initializeEventListeners();
        this.initializeContext(contextScopeBeans, processedBeans);
    }

    private void indexBeanDefinitions() {
        for (BeanDefinitionReference beanDefinitionReference : this.beanDefinitionsClasses) {
            if (!beanDefinitionReference.isPresent()) continue;
            Class beanType = beanDefinitionReference.getBeanType();
            this.indexedTypes.stream().filter(t -> t == beanType || t.isAssignableFrom(beanType)).forEach(indexedType -> {
                Collection<BeanDefinitionReference> indexed = this.resolveTypeIndex((Class<?>)indexedType);
                indexed.add(beanDefinitionReference);
            });
        }
    }

    @NotNull
    private Collection<BeanDefinitionReference> resolveTypeIndex(Class<?> indexedType) {
        return this.beanIndex.computeIfAbsent(indexedType, aClass -> {
            this.indexedTypes.add(indexedType);
            return new ArrayList(20);
        });
    }

    private <T> Collection<BeanDefinition<T>> findBeanCandidatesInternal(Class<T> beanType) {
        return this.beanCandidateCache.computeIfAbsent(beanType, aClass -> this.findBeanCandidates(beanType, null, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Collection<T> getBeansOfTypeInternal(@Nullable BeanResolutionContext resolutionContext, Class<T> beanType, Qualifier<T> qualifier) {
        Collection<Object> existing;
        boolean hasQualifier;
        boolean bl = hasQualifier = qualifier != null;
        if (LOG.isDebugEnabled()) {
            if (hasQualifier) {
                LOG.debug("Resolving beans for type: {} {} ", qualifier, (Object)beanType.getName());
            } else {
                LOG.debug("Resolving beans for type: {}", (Object)beanType.getName());
            }
        }
        BeanKey<T> key = new BeanKey<T>(beanType, qualifier, new Class[0]);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing beans for key: {}", key);
        }
        if ((existing = this.initializedObjectsByType.get(key)) != null) {
            this.logResolvedExisting(beanType, qualifier, hasQualifier, existing);
            return existing;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No beans found for key: {}", key);
        }
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            Collection beans;
            boolean hasCandidates;
            existing = this.initializedObjectsByType.get(key);
            if (existing != null) {
                this.logResolvedExisting(beanType, qualifier, hasQualifier, existing);
                return existing;
            }
            HashSet beansOfTypeList = new HashSet();
            boolean allCandidatesAreSingleton = false;
            Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(beanType);
            this.filterProxiedTypes(candidates, true, false);
            boolean bl2 = hasCandidates = !candidates.isEmpty();
            if (hasQualifier && hasCandidates) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Qualifying bean [{}] from candidates {} for qualifier: {} ", new Object[]{beanType.getName(), candidates, qualifier});
                }
                Stream<BeanDefinition<T>> candidateStream = candidates.stream();
                List reduced = qualifier.reduce(beanType, candidateStream = this.applyBeanResolutionFilters(resolutionContext, candidateStream)).collect(Collectors.toList());
                if (!reduced.isEmpty()) {
                    for (BeanDefinition definition : reduced) {
                        if (definition.isSingleton()) {
                            allCandidatesAreSingleton = true;
                        }
                        this.addCandidateToList(resolutionContext, beanType, definition, beansOfTypeList, qualifier, reduced.size() == 1);
                    }
                    beans = beansOfTypeList;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found no matching beans of type [{}] for qualifier: {} ", (Object)beanType.getName(), qualifier);
                    }
                    allCandidatesAreSingleton = true;
                    beans = beansOfTypeList;
                }
            } else if (hasCandidates) {
                boolean hasNonSingletonCandidate = false;
                int candidateCount = candidates.size();
                Stream candidateStream = candidates.stream();
                candidateStream = this.applyBeanResolutionFilters(resolutionContext, candidateStream);
                List candidateList = candidateStream.collect(Collectors.toList());
                for (BeanDefinition candidate : candidateList) {
                    if (!hasNonSingletonCandidate && !candidate.isSingleton()) {
                        hasNonSingletonCandidate = true;
                    }
                    this.addCandidateToList(resolutionContext, beanType, candidate, beansOfTypeList, qualifier, candidateCount == 1);
                }
                if (!hasNonSingletonCandidate) {
                    allCandidatesAreSingleton = true;
                }
                beans = beansOfTypeList;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found no possible candidate beans of type [{}] for qualifier: {} ", (Object)beanType.getName(), qualifier);
                }
                allCandidatesAreSingleton = true;
                beans = beansOfTypeList;
            }
            beans = Ordered.class.isAssignableFrom(beanType) ? (Collection)beans.stream().sorted(OrderUtil.COMPARATOR).collect(StreamUtils.toImmutableCollection()) : Collections.unmodifiableCollection(beans);
            if (allCandidatesAreSingleton) {
                this.initializedObjectsByType.put(key, beans);
            }
            if (LOG.isDebugEnabled() && !beans.isEmpty()) {
                if (hasQualifier) {
                    LOG.debug("Found {} beans for type [{} {}]: {} ", new Object[]{beans.size(), qualifier, beanType.getName(), beans});
                } else {
                    LOG.debug("Found {} beans for type [{}]: {} ", new Object[]{beans.size(), beanType.getName(), beans});
                }
            }
            return beans;
        }
    }

    private <T> void logResolvedExisting(Class<T> beanType, Qualifier<T> qualifier, boolean hasQualifier, Collection<T> existing) {
        if (LOG.isTraceEnabled()) {
            if (hasQualifier) {
                LOG.trace("Found {} existing beans for type [{} {}]: {} ", new Object[]{existing.size(), qualifier, beanType.getName(), existing});
            } else {
                LOG.trace("Found {} existing beans for type [{}]: {} ", new Object[]{existing.size(), beanType.getName(), existing});
            }
        }
    }

    private <T> Stream<BeanDefinition<T>> applyBeanResolutionFilters(@Nullable BeanResolutionContext resolutionContext, Stream<BeanDefinition<T>> candidateStream) {
        BeanResolutionContext.Segment segment;
        candidateStream = candidateStream.filter(c -> !c.isAbstract());
        BeanResolutionContext.Segment segment2 = segment = resolutionContext != null ? (BeanResolutionContext.Segment)resolutionContext.getPath().peek() : null;
        if (segment instanceof DefaultBeanResolutionContext.ConstructorSegment) {
            BeanDefinition declaringBean = segment.getDeclaringType();
            candidateStream = candidateStream.filter(c -> {
                if (c.equals(declaringBean)) {
                    return false;
                }
                if (declaringBean instanceof ProxyBeanDefinition) {
                    return !((ProxyBeanDefinition)declaringBean).getTargetDefinitionType().equals(c.getClass());
                }
                return true;
            });
        }
        return candidateStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addCandidateToList(@Nullable BeanResolutionContext resolutionContext, Class<T> beanType, BeanDefinition<T> candidate, Collection<T> beansOfTypeList, Qualifier<T> qualifier, boolean singleCandidate) {
        T bean;
        if (candidate.isSingleton()) {
            Map<BeanKey, BeanRegistration> map = this.singletonObjects;
            synchronized (map) {
                if (resolutionContext == null) {
                    resolutionContext = new DefaultBeanResolutionContext(this, candidate);
                }
                bean = this.doCreateBean(resolutionContext, candidate, qualifier, true, null);
                this.registerSingletonBean(candidate, beanType, bean, qualifier, singleCandidate);
            }
        } else {
            bean = this.getScopedBeanForDefinition(resolutionContext, beanType, qualifier, true, candidate);
        }
        if (bean != null) {
            beansOfTypeList.add(bean);
        }
    }

    private <T> boolean isCandidatePresent(Class<T> beanType, Qualifier<T> qualifier) {
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidates(beanType, null, true);
        if (!candidates.isEmpty()) {
            this.filterReplacedBeans(candidates);
            Stream<BeanDefinition<T>> stream = candidates.stream();
            if (qualifier != null) {
                stream = qualifier.reduce(beanType, stream);
            }
            return stream.count() > 0L;
        }
        return false;
    }

    private List<BeanRegistration> topologicalSort(Collection<BeanRegistration> beans) {
        ArrayList<BeanRegistration> sorted = new ArrayList<BeanRegistration>();
        ArrayList<BeanRegistration> unsorted = new ArrayList<BeanRegistration>(beans);
        while (!unsorted.isEmpty()) {
            boolean acyclic = false;
            Iterator i = unsorted.iterator();
            while (i.hasNext()) {
                BeanRegistration bean = (BeanRegistration)i.next();
                boolean found = false;
                Collection<Class> components = bean.getBeanDefinition().getRequiredComponents();
                for (Class clazz : components) {
                    if (!unsorted.stream().map(BeanRegistration::getBeanDefinition).map(BeanDefinition::getBeanType).anyMatch(bt -> clazz.isAssignableFrom((Class<?>)bt))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                acyclic = true;
                i.remove();
                sorted.add(0, bean);
            }
            if (acyclic) continue;
            sorted.add(0, (BeanRegistration)unsorted.remove(0));
        }
        return sorted;
    }

    private static /* synthetic */ BeanInstantiationException lambda$doCreateBean$39(BeanResolutionContext finalResolutionContext, Argument requiredArgument, Object val) {
        return new BeanInstantiationException(finalResolutionContext, "Invalid bean argument [" + requiredArgument + "]. Cannot convert object [" + val + "] to required type: " + requiredArgument.getType());
    }

    private static class NoInjectionBeanDefinition<T>
    implements BeanDefinition<T>,
    BeanDefinitionReference<T> {
        private final Class<?> singletonClass;
        private final Map<Class<?>, List<Argument<?>>> typeArguments = new HashMap();
        private final Qualifier<T> qualifier;

        NoInjectionBeanDefinition(Class singletonClass, Qualifier<T> qualifier) {
            this.singletonClass = singletonClass;
            this.qualifier = qualifier;
        }

        @Nullable
        public Qualifier<T> getQualifier() {
            return this.qualifier;
        }

        @Override
        public Optional<Class<? extends Annotation>> getScope() {
            return Optional.of(Singleton.class);
        }

        @Override
        @Nonnull
        public List<Argument<?>> getTypeArguments(Class<?> type) {
            List<Object> result = this.typeArguments.get(type);
            if (result == null) {
                Class[] classes = type.isInterface() ? GenericTypeUtils.resolveInterfaceTypeArguments(this.singletonClass, type) : GenericTypeUtils.resolveSuperTypeGenericArguments(this.singletonClass, type);
                result = Arrays.stream(classes).map(Argument::of).collect(Collectors.toList());
                this.typeArguments.put(type, result);
            }
            return result;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public boolean isProvided() {
            return false;
        }

        @Override
        public boolean isIterable() {
            return false;
        }

        @Override
        public boolean isPrimary() {
            return true;
        }

        @Override
        public Class getBeanType() {
            return this.singletonClass;
        }

        @Override
        public Optional<Class<?>> getDeclaringType() {
            return Optional.empty();
        }

        @Override
        public ConstructorInjectionPoint getConstructor() {
            throw new UnsupportedOperationException("Runtime singleton's cannot be constructed at runtime");
        }

        @Override
        public Collection<Class> getRequiredComponents() {
            return Collections.emptyList();
        }

        @Override
        public Collection<MethodInjectionPoint> getInjectedMethods() {
            return Collections.emptyList();
        }

        @Override
        public Collection<FieldInjectionPoint> getInjectedFields() {
            return Collections.emptyList();
        }

        @Override
        public Collection<MethodInjectionPoint> getPostConstructMethods() {
            return Collections.emptyList();
        }

        @Override
        public Collection<MethodInjectionPoint> getPreDestroyMethods() {
            return Collections.emptyList();
        }

        @Override
        public String getName() {
            return this.singletonClass.getName();
        }

        @Override
        public boolean isEnabled(BeanContext beanContext) {
            return true;
        }

        @Override
        public <R> Optional<ExecutableMethod<T, R>> findMethod(String name, Class[] argumentTypes) {
            return Optional.empty();
        }

        @Override
        public T inject(BeanContext context, T bean) {
            return bean;
        }

        @Override
        public T inject(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
            return bean;
        }

        @Override
        public Collection<ExecutableMethod<T, ?>> getExecutableMethods() {
            return Collections.emptyList();
        }

        @Override
        public Stream<ExecutableMethod<T, ?>> findPossibleMethods(String name) {
            return Stream.empty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NoInjectionBeanDefinition that = (NoInjectionBeanDefinition)o;
            return this.singletonClass.equals(that.singletonClass);
        }

        public int hashCode() {
            return this.singletonClass.hashCode();
        }

        @Override
        public String getBeanDefinitionName() {
            return this.singletonClass.getName();
        }

        @Override
        public BeanDefinition<T> load() {
            return this;
        }

        @Override
        public BeanDefinition<T> load(BeanContext context) {
            return this;
        }

        @Override
        public boolean isContextScope() {
            return false;
        }

        @Override
        public boolean isPresent() {
            return true;
        }
    }

    static final class BeanKey<T>
    implements BeanIdentifier {
        private final Class beanType;
        private final Qualifier qualifier;
        private final Class[] typeArguments;
        private final int hashCode;

        BeanKey(BeanDefinition<T> definition, Qualifier<T> qualifier) {
            this(definition.getBeanType(), qualifier, definition.getTypeParameters());
        }

        BeanKey(Class<T> beanType, Qualifier<T> qualifier, Class ... typeArguments) {
            this.beanType = beanType;
            this.qualifier = qualifier;
            this.typeArguments = ArrayUtils.isEmpty((Object[])typeArguments) ? null : typeArguments;
            int result = Objects.hash(beanType, qualifier);
            this.hashCode = result = 31 * result + Arrays.hashCode(this.typeArguments);
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            return (this.qualifier != null ? this.qualifier.toString() + " " : "") + this.beanType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanKey beanKey = (BeanKey)o;
            return this.beanType.equals(beanKey.beanType) && Objects.equals(this.qualifier, beanKey.qualifier) && Arrays.equals(this.typeArguments, beanKey.typeArguments);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String getName() {
            if (this.qualifier instanceof Named) {
                return ((Named)this.qualifier).getName();
            }
            return Primary.class.getSimpleName();
        }
    }

    private static final class BeanExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R> {
        private final BeanContext beanContext;
        private final Class<T> beanType;
        private final Qualifier<T> qualifier;
        private final boolean isSingleton;
        private T target;

        BeanExecutionHandle(BeanContext beanContext, Class<T> beanType, Qualifier<T> qualifier, ExecutableMethod<T, R> method) {
            super(method);
            this.beanContext = beanContext;
            this.beanType = beanType;
            this.qualifier = qualifier;
            this.isSingleton = beanContext.findBeanDefinition(beanType, qualifier).map(BeanDefinition::isSingleton).orElse(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getTarget() {
            T target = this.target;
            if (target == null) {
                BeanExecutionHandle beanExecutionHandle = this;
                synchronized (beanExecutionHandle) {
                    target = this.target;
                    if (target == null) {
                        this.target = target = this.beanContext.getBean(this.beanType, this.qualifier);
                    }
                }
            }
            return target;
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.beanType;
        }

        @Override
        public R invoke(Object ... arguments) {
            if (this.isSingleton) {
                T target = this.getTarget();
                return (R)this.method.invoke(target, arguments);
            }
            return (R)this.method.invoke(this.beanContext.getBean(this.beanType, this.qualifier), arguments);
        }
    }

    private static final class ObjectExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R> {
        private final T target;

        ObjectExecutionHandle(T target, ExecutableMethod<T, R> method) {
            super(method);
            this.target = target;
        }

        @Override
        public T getTarget() {
            return this.target;
        }

        @Override
        public R invoke(Object ... arguments) {
            return (R)this.method.invoke(this.target, arguments);
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.target.getClass();
        }
    }

    private static abstract class AbstractExecutionHandle<T, R>
    implements MethodExecutionHandle<T, R> {
        protected final ExecutableMethod<T, R> method;

        AbstractExecutionHandle(ExecutableMethod<T, R> method) {
            this.method = method;
        }

        @Override
        @Nonnull
        public ExecutableMethod<?, R> getExecutableMethod() {
            return this.method;
        }

        @Override
        public Argument[] getArguments() {
            return this.method.getArguments();
        }

        public String toString() {
            return this.method.toString();
        }

        @Override
        public String getMethodName() {
            return this.method.getMethodName();
        }

        @Override
        public ReturnType<R> getReturnType() {
            return this.method.getReturnType();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }
}

