/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.beans.visitor.BeanIntrospectionWriter;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.ClassGenerationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
public class IntrospectedTypeElementVisitor
implements TypeElementVisitor<Introspected, Object> {
    public static final int POSITION = -100;
    private static final String JAVAX_VALIDATION_CONSTRAINT = "javax.validation.Constraint";
    private static final AnnotationValue<Introspected.IndexedAnnotation> ANN_CONSTRAINT = AnnotationValue.builder(Introspected.IndexedAnnotation.class).member("annotation", new AnnotationClassValue[]{new AnnotationClassValue("javax.validation.Constraint")}).build();
    private static final String JAVAX_VALIDATION_VALID = "javax.validation.Valid";
    private static final AnnotationValue<Introspected.IndexedAnnotation> ANN_VALID = AnnotationValue.builder(Introspected.IndexedAnnotation.class).member("annotation", new AnnotationClassValue[]{new AnnotationClassValue("javax.validation.Valid")}).build();
    private Map<String, BeanIntrospectionWriter> writers = new LinkedHashMap<String, BeanIntrospectionWriter>(10);

    public int getOrder() {
        return -100;
    }

    @Override
    public void visitClass(ClassElement element, VisitorContext context) {
        AnnotationValue introspected = element.getAnnotation(Introspected.class);
        if (introspected != null && !this.writers.containsKey(element.getName()) && !element.isAbstract()) {
            Set indexedAnnotations;
            Object[] packages = (String[])introspected.get((CharSequence)"packages", String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY);
            Object[] classes = (AnnotationClassValue[])introspected.get((CharSequence)"classes", AnnotationClassValue[].class, (Object)new AnnotationClassValue[0]);
            boolean metadata = (Boolean)introspected.get((CharSequence)"annotationMetadata", Boolean.TYPE, (Object)true);
            Set includes = CollectionUtils.setOf((Object[])((Object[])introspected.get((CharSequence)"includes", String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY)));
            Set excludes = CollectionUtils.setOf((Object[])((Object[])introspected.get((CharSequence)"excludes", String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY)));
            Set excludedAnnotations = CollectionUtils.setOf((Object[])((Object[])introspected.get((CharSequence)"excludedAnnotations", String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY)));
            Set includedAnnotations = CollectionUtils.setOf((Object[])((Object[])introspected.get((CharSequence)"includedAnnotations", String[].class, (Object)StringUtils.EMPTY_STRING_ARRAY)));
            Set toIndex = CollectionUtils.setOf((Object[])((Object[])introspected.get((CharSequence)"indexed", AnnotationValue[].class, (Object)new AnnotationValue[0])));
            if (CollectionUtils.isEmpty((Collection)toIndex)) {
                indexedAnnotations = CollectionUtils.setOf((Object[])new AnnotationValue[]{ANN_CONSTRAINT, ANN_VALID});
            } else {
                toIndex.addAll(CollectionUtils.setOf((Object[])new AnnotationValue[]{ANN_CONSTRAINT, ANN_VALID}));
                indexedAnnotations = toIndex;
            }
            if (ArrayUtils.isNotEmpty((Object[])classes)) {
                AtomicInteger index = new AtomicInteger(0);
                for (Object aClass : classes) {
                    Optional<ClassElement> classElement = context.getClassElement(aClass.getName());
                    classElement.ifPresent(ce -> {
                        if (!ce.isAbstract() && ce.isPublic()) {
                            BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element.getName(), index.getAndIncrement(), ce.getName(), metadata ? element.getAnnotationMetadata() : null);
                            this.processElement(context, metadata, includes, excludes, excludedAnnotations, indexedAnnotations, (ClassElement)ce, writer);
                        }
                    });
                }
            } else if (ArrayUtils.isNotEmpty((Object[])packages)) {
                if (includedAnnotations.isEmpty()) {
                    context.fail("When specifying 'packages' you must also specify 'includedAnnotations' to limit scanning", element);
                } else {
                    for (Object aPackage : packages) {
                        ClassElement[] elements = context.getClassElements((String)aPackage, includedAnnotations.toArray(new String[0]));
                        int j = 0;
                        for (ClassElement classElement : elements) {
                            if (classElement.isAbstract() || !classElement.isPublic()) continue;
                            BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element.getName(), j++, classElement.getName(), metadata ? element.getAnnotationMetadata() : null);
                            this.processElement(context, metadata, includes, excludes, excludedAnnotations, indexedAnnotations, classElement, writer);
                        }
                    }
                }
            } else {
                BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element.getName(), metadata ? element.getAnnotationMetadata() : null);
                this.processElement(context, metadata, includes, excludes, excludedAnnotations, indexedAnnotations, element, writer);
            }
        }
    }

    @Override
    public void finish(VisitorContext visitorContext) {
        for (BeanIntrospectionWriter writer : this.writers.values()) {
            try {
                writer.accept(visitorContext);
            }
            catch (IOException e) {
                throw new ClassGenerationException("I/O error occurred during class generation: " + e.getMessage(), e);
            }
        }
    }

    private void processElement(VisitorContext context, boolean metadata, Set<String> includes, Set<String> excludes, Set<String> excludedAnnotations, Set<AnnotationValue> indexedAnnotations, ClassElement ce, BeanIntrospectionWriter writer) {
        List<PropertyElement> beanProperties = ce.getBeanProperties();
        Optional<ConstructorElement> constructorElement = ce.getPrimaryConstructor();
        if (!constructorElement.isPresent()) {
            context.fail("Introspected types must have a single public constructor", ce);
        } else {
            ConstructorElement constructor = constructorElement.get();
            if (Arrays.stream(constructor.getParameters()).anyMatch(p -> p.getType() == null)) {
                context.fail("Introspected constructor includes unsupported argument types", ce);
            } else {
                this.process(constructor, writer, beanProperties, includes, excludes, excludedAnnotations, indexedAnnotations, metadata);
            }
        }
    }

    private void process(ConstructorElement constructorElement, BeanIntrospectionWriter writer, List<PropertyElement> beanProperties, Set<String> includes, Set<String> excludes, Set<String> ignored, Set<AnnotationValue> indexedAnnotations, boolean metadata) {
        Object[] parameters = constructorElement.getParameters();
        if (ArrayUtils.isNotEmpty((Object[])parameters)) {
            writer.visitConstructorArguments((ParameterElement[])parameters);
        }
        for (PropertyElement beanProperty : beanProperties) {
            ClassElement type = beanProperty.getType();
            if (type == null) continue;
            String name = beanProperty.getName();
            if (!includes.isEmpty() && !includes.contains(name) || !excludes.isEmpty() && excludes.contains(name)) continue;
            if (!ignored.isEmpty()) {
                if (ignored.stream().anyMatch(arg_0 -> ((PropertyElement)beanProperty).hasAnnotation(arg_0))) continue;
            }
            writer.visitProperty(type, name, beanProperty.getReadMethod().orElse(null), beanProperty.getWriteMethod().orElse(null), beanProperty.isReadOnly(), metadata ? beanProperty.getAnnotationMetadata() : null, beanProperty.getType().getTypeArguments());
            for (AnnotationValue indexedAnnotation : indexedAnnotations) {
                indexedAnnotation.get((CharSequence)"annotation", String.class).ifPresent(annotationName -> {
                    if (beanProperty.hasStereotype((String)annotationName)) {
                        writer.indexProperty(new AnnotationValue(annotationName), name, indexedAnnotation.get((CharSequence)"member", String.class).flatMap(m -> beanProperty.getValue((String)annotationName, (String)m, String.class)).orElse(null));
                    }
                });
            }
        }
        this.writers.put(writer.getBeanType().getClassName(), writer);
    }
}

