/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractExecutable;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractExecutableMethod
extends AbstractExecutable
implements ExecutableMethod,
EnvironmentConfigurable {
    private final ReturnType returnType;
    private final Argument<?> genericReturnType;
    private final int hashCode;
    private Environment environment;
    private AnnotationMetadata methodAnnotationMetadata;

    protected AbstractExecutableMethod(Class<?> declaringType, String methodName, Argument genericReturnType, Argument ... arguments) {
        super(declaringType, methodName, arguments);
        this.genericReturnType = genericReturnType;
        this.returnType = new ReturnTypeImpl();
        int result = Objects.hash(declaringType, methodName);
        this.hashCode = result = 31 * result + Arrays.hashCode(this.argTypes);
    }

    protected AbstractExecutableMethod(Class<?> declaringType, String methodName, Argument genericReturnType) {
        this(declaringType, methodName, genericReturnType, Argument.ZERO_ARGUMENTS);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        if (this.methodAnnotationMetadata == null) {
            this.methodAnnotationMetadata = this.initializeAnnotationMetadata();
        }
        return this.methodAnnotationMetadata;
    }

    @Override
    public void configure(Environment environment) {
        this.environment = environment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractExecutableMethod that = (AbstractExecutableMethod)o;
        return Objects.equals(this.declaringType, that.declaringType) && Objects.equals(this.methodName, that.methodName) && Arrays.equals(this.argTypes, that.argTypes);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String text = Argument.toString((Argument[])this.getArguments());
        return this.getReturnType().getType().getSimpleName() + " " + this.getMethodName() + "(" + text + ")";
    }

    @Override
    public ReturnType getReturnType() {
        return this.returnType;
    }

    @Override
    public Class[] getArgumentTypes() {
        return this.argTypes;
    }

    @Override
    public Class getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public final Object invoke(Object instance, Object ... arguments) {
        this.validateArguments(arguments);
        return this.invokeInternal(instance, arguments);
    }

    protected abstract Object invokeInternal(Object var1, Object[] var2);

    protected AnnotationMetadata resolveAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private AnnotationMetadata initializeAnnotationMetadata() {
        AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata();
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            return new MethodAnnotationMetadata((DefaultAnnotationMetadata)annotationMetadata);
        }
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private void validateArguments(Object[] argArray) {
        int actualCount;
        Argument[] arguments = this.getArguments();
        int requiredCount = arguments.length;
        int n = actualCount = argArray == null ? 0 : argArray.length;
        if (requiredCount != actualCount) {
            throw new IllegalArgumentException("Wrong number of arguments to method: " + this.getMethodName());
        }
        if (requiredCount > 0) {
            for (int i = 0; i < arguments.length; ++i) {
                Argument argument = arguments[i];
                Class type = ReflectionUtils.getWrapperType((Class)argument.getType());
                Object value = argArray[i];
                if (value == null || type.isInstance(value)) continue;
                throw new IllegalArgumentException("Invalid type [" + argArray[i].getClass().getName() + "] for argument [" + argument + "] of method: " + this.getMethodName());
            }
        }
    }

    private final class MethodAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        MethodAnnotationMetadata(DefaultAnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return AbstractExecutableMethod.this.environment;
        }
    }

    class ReturnTypeImpl
    implements ReturnType {
        ReturnTypeImpl() {
        }

        public Class<?> getType() {
            if (AbstractExecutableMethod.this.genericReturnType != null) {
                return AbstractExecutableMethod.this.genericReturnType.getType();
            }
            return Void.TYPE;
        }

        public Argument[] getTypeParameters() {
            if (AbstractExecutableMethod.this.genericReturnType != null) {
                return AbstractExecutableMethod.this.genericReturnType.getTypeParameters();
            }
            return Argument.ZERO_ARGUMENTS;
        }

        public Map<String, Argument<?>> getTypeVariables() {
            if (AbstractExecutableMethod.this.genericReturnType != null) {
                return AbstractExecutableMethod.this.genericReturnType.getTypeVariables();
            }
            return Collections.emptyMap();
        }
    }
}

