/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.AbstractBeanIntrospection;
import io.micronaut.core.beans.AbstractBeanIntrospectionReference;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionReference;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.beans.visitor.BeanPropertyWriter;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

@Internal
class BeanIntrospectionWriter
extends AbstractAnnotationMetadataWriter {
    private static final Method METHOD_ADD_PROPERTY = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanIntrospection.class, (String)"addProperty", (Class[])new Class[]{BeanProperty.class}));
    private static final Method METHOD_INDEX_PROPERTY = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanIntrospection.class, (String)"indexProperty", (Class[])new Class[]{Class.class, String.class, String.class}));
    private static final String REFERENCE_SUFFIX = "$IntrospectionRef";
    private static final String INTROSPECTION_SUFFIX = "$Introspection";
    private final ClassWriter referenceWriter;
    private final String introspectionName;
    private final Type introspectionType;
    private final Type beanType;
    private final ClassWriter introspectionWriter;
    private final List<BeanPropertyWriter> propertyDefinitions = new ArrayList<BeanPropertyWriter>();
    private final Map<String, Collection<AnnotationValueIndex>> indexes = new HashMap<String, Collection<AnnotationValueIndex>>(2);
    private int propertyIndex = 0;
    private ParameterElement[] constructorArguments;
    private final HashMap<String, GeneratorAdapter> loadTypeMethods = new HashMap();

    BeanIntrospectionWriter(String className, AnnotationMetadata beanAnnotationMetadata) {
        super(BeanIntrospectionWriter.computeReferenceName(className), beanAnnotationMetadata, true);
        this.referenceWriter = new ClassWriter(1);
        this.introspectionWriter = new ClassWriter(1);
        this.introspectionName = BeanIntrospectionWriter.computeIntrospectionName(className);
        this.introspectionType = BeanIntrospectionWriter.getTypeReference(this.introspectionName);
        this.beanType = BeanIntrospectionWriter.getTypeReference(className);
    }

    BeanIntrospectionWriter(String generatingType, int index, String className, AnnotationMetadata beanAnnotationMetadata) {
        super(BeanIntrospectionWriter.computeReferenceName(generatingType) + index, beanAnnotationMetadata, true);
        this.referenceWriter = new ClassWriter(1);
        this.introspectionWriter = new ClassWriter(1);
        this.introspectionName = BeanIntrospectionWriter.computeIntrospectionName(className);
        this.introspectionType = BeanIntrospectionWriter.getTypeReference(this.introspectionName);
        this.beanType = BeanIntrospectionWriter.getTypeReference(className);
    }

    Type getIntrospectionType() {
        return this.introspectionType;
    }

    public Type getBeanType() {
        return this.beanType;
    }

    void visitProperty(@Nonnull TypedElement type, @Nonnull String name, @Nullable MethodElement readMethod, @Nullable MethodElement writeMethod, boolean isReadOnly, @Nullable AnnotationMetadata annotationMetadata, @Nullable Map<String, ClassElement> typeArguments) {
        Type propertyType = this.getTypeForElement(type);
        this.propertyDefinitions.add(new BeanPropertyWriter(this, type, propertyType, name, readMethod, writeMethod, isReadOnly, this.propertyIndex++, annotationMetadata, typeArguments));
    }

    void indexProperty(AnnotationValue<?> annotation, String property, @Nullable String value) {
        this.indexes.computeIfAbsent(property, s -> new HashSet(2)).add(new AnnotationValueIndex(annotation, property, value));
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        if (this.annotationMetadataWriter != null) {
            this.annotationMetadataWriter.accept(classWriterOutputVisitor);
        }
        this.writeIntrospectionReference(classWriterOutputVisitor);
        this.writeIntrospectionClass(classWriterOutputVisitor);
    }

    private void writeIntrospectionClass(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        Type superType = Type.getType(AbstractBeanIntrospection.class);
        try (OutputStream introspectionStream = classWriterOutputVisitor.visitClass(this.introspectionName);){
            this.startFinalClass((ClassVisitor)this.introspectionWriter, this.introspectionType.getInternalName(), superType);
            GeneratorAdapter constructorWriter = this.startConstructor((ClassVisitor)this.introspectionWriter);
            constructorWriter.loadThis();
            constructorWriter.push(this.beanType);
            if (this.annotationMetadata == null || this.annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
                constructorWriter.visitInsn(1);
            } else {
                constructorWriter.getStatic(this.targetClassType, "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
            }
            constructorWriter.push(this.propertyDefinitions.size());
            this.invokeConstructor((MethodVisitor)constructorWriter, AbstractBeanIntrospection.class, Class.class, AnnotationMetadata.class, Integer.TYPE);
            for (BeanPropertyWriter propertyWriter : this.propertyDefinitions) {
                propertyWriter.accept(classWriterOutputVisitor);
                Type writerType = propertyWriter.getType();
                constructorWriter.loadThis();
                constructorWriter.newInstance(writerType);
                constructorWriter.dup();
                constructorWriter.loadThis();
                constructorWriter.invokeConstructor(writerType, new Method("<init>", BeanIntrospectionWriter.getConstructorDescriptor(BeanIntrospection.class)));
                constructorWriter.visitMethodInsn(183, superType.getInternalName(), METHOD_ADD_PROPERTY.getName(), METHOD_ADD_PROPERTY.getDescriptor(), false);
                String propertyName = propertyWriter.getPropertyName();
                if (!this.indexes.containsKey(propertyName)) continue;
                Collection<AnnotationValueIndex> annotations = this.indexes.get(propertyName);
                for (AnnotationValueIndex index : annotations) {
                    constructorWriter.loadThis();
                    Type typeReference = BeanIntrospectionWriter.getTypeReference(index.annotationValue.getAnnotationName());
                    constructorWriter.push(typeReference);
                    constructorWriter.push(propertyName);
                    constructorWriter.push(index.value);
                    constructorWriter.visitMethodInsn(183, superType.getInternalName(), METHOD_INDEX_PROPERTY.getName(), METHOD_INDEX_PROPERTY.getDescriptor(), false);
                }
            }
            constructorWriter.visitInsn(177);
            constructorWriter.visitMaxs(2, 1);
            this.writeInstantiateMethod();
            if (ArrayUtils.isNotEmpty((Object[])this.constructorArguments)) {
                this.writeConstructorArguments();
            }
            for (GeneratorAdapter generatorAdapter : this.loadTypeMethods.values()) {
                generatorAdapter.visitMaxs(3, 1);
            }
            introspectionStream.write(this.introspectionWriter.toByteArray());
        }
    }

    private void writeConstructorArguments() {
        GeneratorAdapter getConstructorArguments = this.startPublicMethodZeroArgs(this.introspectionWriter, Argument[].class, "getConstructorArguments");
        Map<String, Object> args = this.toParameterTypes(this.constructorArguments);
        LinkedHashMap<String, AnnotationMetadata> annotationMetadataMap = new LinkedHashMap<String, AnnotationMetadata>(args.size());
        for (ParameterElement constructorArgument : this.constructorArguments) {
            annotationMetadataMap.put(constructorArgument.getName(), constructorArgument.getAnnotationMetadata());
        }
        BeanIntrospectionWriter.pushBuildArgumentsForMethod(this.introspectionType, this.introspectionWriter, getConstructorArguments, args, annotationMetadataMap, this.toTypeArguments(this.constructorArguments), this.loadTypeMethods);
        getConstructorArguments.returnValue();
        getConstructorArguments.visitMaxs(1, 1);
        getConstructorArguments.endMethod();
        String desc = BeanIntrospectionWriter.getMethodDescriptor(Object.class, Collections.singleton(Object[].class));
        GeneratorAdapter instantiateInternal = new GeneratorAdapter(this.introspectionWriter.visitMethod(1, "instantiateInternal", desc, null, null), 1, "instantiateInternal", desc);
        Collection argumentTypes = Arrays.stream(this.constructorArguments).map(pe -> this.getTypeForElement(pe.getType())).collect(Collectors.toList());
        instantiateInternal.newInstance(this.beanType);
        instantiateInternal.dup();
        int i = 0;
        for (Type argumentType : argumentTypes) {
            instantiateInternal.loadArg(0);
            instantiateInternal.push(i++);
            instantiateInternal.arrayLoad(TYPE_OBJECT);
            BeanIntrospectionWriter.pushCastToType((MethodVisitor)instantiateInternal, argumentType);
        }
        String constructorDescriptor = BeanIntrospectionWriter.getConstructorDescriptor(argumentTypes);
        instantiateInternal.invokeConstructor(this.beanType, new Method("<init>", constructorDescriptor));
        instantiateInternal.visitInsn(176);
        instantiateInternal.visitMaxs(2, 1);
        instantiateInternal.visitEnd();
    }

    private void writeInstantiateMethod() {
        GeneratorAdapter instantiateMethod = this.startPublicMethod(this.introspectionWriter, "instantiate", Object.class.getName(), new String[0]);
        this.pushNewInstance(instantiateMethod, this.beanType);
        instantiateMethod.visitInsn(176);
        instantiateMethod.visitMaxs(2, 1);
        instantiateMethod.visitEnd();
    }

    private void writeIntrospectionReference(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        Type superType = Type.getType(AbstractBeanIntrospectionReference.class);
        String referenceName = this.targetClassType.getClassName();
        classWriterOutputVisitor.visitServiceDescriptor(BeanIntrospectionReference.class, referenceName);
        try (OutputStream referenceStream = classWriterOutputVisitor.visitClass(referenceName);){
            this.startPublicFinalClass((ClassVisitor)this.referenceWriter, this.targetClassType.getInternalName(), superType);
            ClassWriter classWriter = this.generateClassBytes(this.referenceWriter);
            referenceStream.write(classWriter.toByteArray());
        }
    }

    private ClassWriter generateClassBytes(ClassWriter classWriter) {
        this.writeAnnotationMetadataStaticInitializer(classWriter);
        GeneratorAdapter cv = this.startConstructor((ClassVisitor)classWriter);
        cv.loadThis();
        this.invokeConstructor((MethodVisitor)cv, AbstractBeanIntrospectionReference.class, new Class[0]);
        cv.visitInsn(177);
        cv.visitMaxs(2, 1);
        GeneratorAdapter loadMethod = this.startPublicMethodZeroArgs(classWriter, BeanIntrospection.class, "load");
        this.pushNewInstance(loadMethod, this.introspectionType);
        loadMethod.returnValue();
        loadMethod.visitMaxs(2, 1);
        loadMethod.endMethod();
        GeneratorAdapter nameMethod = this.startPublicMethodZeroArgs(classWriter, String.class, "getName");
        nameMethod.push(this.beanType.getClassName());
        nameMethod.returnValue();
        nameMethod.visitMaxs(1, 1);
        nameMethod.endMethod();
        GeneratorAdapter getBeanType = this.startPublicMethodZeroArgs(classWriter, Class.class, "getBeanType");
        getBeanType.push(this.beanType);
        getBeanType.returnValue();
        getBeanType.visitMaxs(2, 1);
        getBeanType.endMethod();
        this.writeGetAnnotationMetadataMethod(classWriter);
        return classWriter;
    }

    @NotNull
    private static String computeReferenceName(String className) {
        String packageName = NameUtils.getPackageName((String)className);
        String shortName = NameUtils.getSimpleName((String)className);
        return packageName + ".$" + shortName + REFERENCE_SUFFIX;
    }

    @NotNull
    private static String computeIntrospectionName(String className) {
        String packageName = NameUtils.getPackageName((String)className);
        String shortName = NameUtils.getSimpleName((String)className);
        return packageName + ".$" + shortName + INTROSPECTION_SUFFIX;
    }

    void visitConstructorArguments(ParameterElement ... parameters) {
        this.constructorArguments = parameters;
    }

    private class AnnotationValueIndex {
        @Nonnull
        final AnnotationValue annotationValue;
        @Nonnull
        final String property;
        @Nullable
        final String value;

        public AnnotationValueIndex(@Nonnull AnnotationValue annotationValue, @Nullable String property, String value) {
            this.annotationValue = annotationValue;
            this.property = property;
            this.value = value;
        }
    }
}

