/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.asm.signature.SignatureVisitor;
import io.micronaut.asm.signature.SignatureWriter;
import io.micronaut.context.AbstractBeanDefinition;
import io.micronaut.context.AbstractParametrizedBeanDefinition;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.ConfigBuilderState;
import io.micronaut.inject.writer.ExecutableMethodWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Internal
public class BeanDefinitionWriter
extends AbstractClassFileWriter
implements BeanDefinitionVisitor {
    private static final Constructor<AbstractBeanDefinition> CONSTRUCTOR_ABSTRACT_BEAN_DEFINITION = (Constructor)ReflectionUtils.findConstructor(AbstractBeanDefinition.class, (Class[])new Class[]{Class.class, AnnotationMetadata.class, Boolean.TYPE, Argument[].class}).orElseThrow(() -> new ClassGenerationException("Invalid version of Micronaut present on the class path"));
    private static final Method METHOD_MAP_OF = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(CollectionUtils.class, (String)"mapOf", (Class[])new Class[]{Object[].class}));
    private static final java.lang.reflect.Method POST_CONSTRUCT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"postConstruct", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Object.class});
    private static final java.lang.reflect.Method INJECT_BEAN_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"injectBean", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Object.class});
    private static final java.lang.reflect.Method PRE_DESTROY_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"preDestroy", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Object.class});
    private static final java.lang.reflect.Method ADD_FIELD_INJECTION_POINT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addInjectionPoint", (Class[])new Class[]{Class.class, Class.class, String.class, AnnotationMetadata.class, Argument[].class, Boolean.TYPE});
    private static final java.lang.reflect.Method ADD_METHOD_INJECTION_POINT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addInjectionPoint", (Class[])new Class[]{Class.class, String.class, Argument[].class, AnnotationMetadata.class, Boolean.TYPE});
    private static final java.lang.reflect.Method ADD_POST_CONSTRUCT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addPostConstruct", (Class[])new Class[]{Class.class, String.class, Argument[].class, AnnotationMetadata.class, Boolean.TYPE});
    private static final java.lang.reflect.Method ADD_PRE_DESTROY_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addPreDestroy", (Class[])new Class[]{Class.class, String.class, Argument[].class, AnnotationMetadata.class, Boolean.TYPE});
    private static final java.lang.reflect.Method ADD_EXECUTABLE_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addExecutableMethod", (Class[])new Class[]{ExecutableMethod.class});
    private static final java.lang.reflect.Method GET_BEAN_FOR_CONSTRUCTOR_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"getBeanForConstructorArgument", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE});
    private static final java.lang.reflect.Method GET_VALUE_FOR_CONSTRUCTOR_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"getValueForConstructorArgument", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE});
    private static final java.lang.reflect.Method GET_BEAN_FOR_FIELD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"getBeanForField", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE});
    private static final java.lang.reflect.Method GET_VALUE_FOR_FIELD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"getValueForField", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE});
    private static final java.lang.reflect.Method GET_VALUE_FOR_PATH = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"getValueForPath", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Argument.class, String.class});
    private static final java.lang.reflect.Method CONTAINS_VALUE_FOR_FIELD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"containsValueForField", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE});
    private static final java.lang.reflect.Method CONTAINS_PROPERTIES_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"containsProperties", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class});
    private static final java.lang.reflect.Method GET_BEAN_FOR_METHOD_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"getBeanForMethodArgument", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Integer.TYPE});
    private static final java.lang.reflect.Method GET_VALUE_FOR_METHOD_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"getValueForMethodArgument", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Integer.TYPE});
    private static final java.lang.reflect.Method CONTAINS_VALUE_FOR_METHOD_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"containsValueForMethodArgument", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Integer.TYPE});
    private static final Method BEAN_DEFINITION_CLASS_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, AnnotationMetadata.class, Boolean.TYPE, Argument[].class));
    private static final Method BEAN_DEFINITION_METHOD_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, Class.class, String.class, AnnotationMetadata.class, Boolean.TYPE, Argument[].class));
    private static final Type TYPE_ABSTRACT_BEAN_DEFINITION = Type.getType(AbstractBeanDefinition.class);
    private static final Type TYPE_ABSTRACT_PARAMETRIZED_BEAN_DEFINITION = Type.getType(AbstractParametrizedBeanDefinition.class);
    private final ClassWriter classWriter;
    private final String beanFullClassName;
    private final String beanDefinitionName;
    private final String beanDefinitionInternalName;
    private final Type beanType;
    private final Type providedType;
    private final Set<Class> interfaceTypes;
    private final Map<String, GeneratorAdapter> loadTypeMethods = new HashMap<String, GeneratorAdapter>();
    private final Map<String, ExecutableMethodWriter> methodExecutors = new LinkedHashMap<String, ExecutableMethodWriter>();
    private final String providedBeanClassName;
    private final String packageName;
    private final String beanSimpleClassName;
    private final Type beanDefinitionType;
    private final boolean isInterface;
    private final boolean isConfigurationProperties;
    private GeneratorAdapter constructorVisitor;
    private GeneratorAdapter buildMethodVisitor;
    private GeneratorAdapter injectMethodVisitor;
    private Label injectEnd = null;
    private GeneratorAdapter preDestroyMethodVisitor;
    private GeneratorAdapter postConstructMethodVisitor;
    private int methodExecutorIndex = 0;
    private int currentFieldIndex = 0;
    private int currentMethodIndex = 0;
    private int buildMethodLocalCount = 4;
    private int injectMethodLocalCount = 4;
    private int postConstructMethodLocalCount = 4;
    private int preDestroyMethodLocalCount = 4;
    private int buildInstanceIndex;
    private int argsIndex = -1;
    private int injectInstanceIndex;
    private int postConstructInstanceIndex;
    private int preDestroyInstanceIndex;
    private boolean beanFinalized = false;
    private Type superType = TYPE_ABSTRACT_BEAN_DEFINITION;
    private boolean isSuperFactory = false;
    private final AnnotationMetadata annotationMetadata;
    private ConfigBuilderState currentConfigBuilderState;
    private int optionalInstanceIndex;
    private boolean preprocessMethods = false;
    private Map<String, Map<String, Object>> typeArguments;
    private List<MethodVisitData> postConstructMethodVisits = new ArrayList<MethodVisitData>(2);
    private List<MethodVisitData> preDestroyMethodVisits = new ArrayList<MethodVisitData>(2);

    public BeanDefinitionWriter(String packageName, String className, AnnotationMetadata annotationMetadata) {
        this(packageName, className, packageName + '.' + className, false, annotationMetadata);
    }

    public BeanDefinitionWriter(String packageName, String className, boolean isInterface, AnnotationMetadata annotationMetadata) {
        this(packageName, className, packageName + '.' + className, isInterface, annotationMetadata);
    }

    public BeanDefinitionWriter(String packageName, String className, String providedClassName, boolean isInterface, AnnotationMetadata annotationMetadata) {
        this(packageName, className, packageName + ".$" + className + "Definition", providedClassName, isInterface, annotationMetadata);
    }

    public BeanDefinitionWriter(String packageName, String className, String beanDefinitionName, String providedClassName, boolean isInterface, AnnotationMetadata annotationMetadata) {
        this.classWriter = new ClassWriter(3);
        this.packageName = packageName;
        this.isInterface = isInterface;
        this.beanFullClassName = packageName + '.' + className;
        this.annotationMetadata = annotationMetadata;
        this.beanSimpleClassName = className;
        this.providedBeanClassName = providedClassName;
        this.beanDefinitionName = beanDefinitionName;
        this.beanDefinitionType = BeanDefinitionWriter.getTypeReference(this.beanDefinitionName);
        this.beanType = BeanDefinitionWriter.getTypeReference(this.beanFullClassName);
        this.providedType = BeanDefinitionWriter.getTypeReference(this.providedBeanClassName);
        this.beanDefinitionInternalName = BeanDefinitionWriter.getInternalName(this.beanDefinitionName);
        this.interfaceTypes = new HashSet<Class>();
        this.interfaceTypes.add(BeanFactory.class);
        this.isConfigurationProperties = annotationMetadata.hasDeclaredStereotype(ConfigurationProperties.class);
    }

    @Override
    @Nonnull
    public String getBeanDefinitionReferenceClassName() {
        return this.beanDefinitionName + "Class";
    }

    public final List<MethodVisitData> getPostConstructMethodVisits() {
        return Collections.unmodifiableList(this.postConstructMethodVisits);
    }

    public List<MethodVisitData> getPreDestroyMethodVisits() {
        return Collections.unmodifiableList(this.preDestroyMethodVisits);
    }

    public ClassVisitor getClassWriter() {
        return this.classWriter;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isSingleton() {
        return this.annotationMetadata.hasDeclaredStereotype(Singleton.class);
    }

    @Override
    public void visitBeanDefinitionInterface(Class<? extends BeanDefinition> interfaceType) {
        this.interfaceTypes.add(interfaceType);
    }

    @Override
    public void visitSuperBeanDefinition(String name) {
        this.superType = BeanDefinitionWriter.getTypeReference(name);
    }

    @Override
    public void visitSuperBeanDefinitionFactory(String beanName) {
        this.visitSuperBeanDefinition(beanName);
        this.isSuperFactory = true;
    }

    @Override
    public String getBeanTypeName() {
        return this.beanFullClassName;
    }

    @Override
    public Type getProvidedType() {
        return this.providedType;
    }

    @Override
    public void setValidated(boolean validated) {
        if (validated) {
            this.interfaceTypes.add(ValidatedBeanDefinition.class);
        } else {
            this.interfaceTypes.remove(ValidatedBeanDefinition.class);
        }
    }

    @Override
    public boolean isValidated() {
        return this.interfaceTypes.contains(ValidatedBeanDefinition.class);
    }

    @Override
    public String getBeanDefinitionName() {
        return this.beanDefinitionName;
    }

    public String getBeanDefinitionClassFile() {
        String className = this.getBeanDefinitionName();
        return this.getClassFileName(className);
    }

    public void visitBeanFactoryMethod(Object factoryClass, Object producedType, String methodName, AnnotationMetadata methodAnnotationMetadata, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes) {
        if (this.constructorVisitor != null) {
            throw new IllegalStateException("Only a single call to visitBeanFactoryMethod(..) is permitted");
        }
        this.visitBuildFactoryMethodDefinition(factoryClass, methodName, argumentTypes, argumentAnnotationMetadata, methodAnnotationMetadata);
        this.buildFactoryMethodClassConstructor(factoryClass, producedType, methodName, methodAnnotationMetadata, argumentTypes, argumentAnnotationMetadata, genericTypes);
        this.visitInjectMethodDefinition();
    }

    @Override
    public void visitBeanDefinitionConstructor(AnnotationMetadata annotationMetadata, boolean requiresReflection, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes) {
        if (this.constructorVisitor == null) {
            this.visitBeanDefinitionConstructorInternal(annotationMetadata, requiresReflection, argumentTypes, argumentAnnotationMetadata, genericTypes);
            this.visitBuildMethodDefinition(annotationMetadata, argumentTypes, argumentAnnotationMetadata);
            this.visitInjectMethodDefinition();
        }
    }

    @Override
    public void visitBeanDefinitionConstructor(AnnotationMetadata annotationMetadata, boolean requiresReflection) {
        if (this.constructorVisitor == null) {
            this.visitBeanDefinitionConstructorInternal(annotationMetadata, requiresReflection, Collections.emptyMap(), null, null);
            this.visitBuildMethodDefinition(annotationMetadata, Collections.emptyMap(), Collections.emptyMap());
            this.visitInjectMethodDefinition();
        }
    }

    @Override
    public void visitBeanDefinitionEnd() {
        if (this.classWriter == null) {
            throw new IllegalStateException("At least one called to visitBeanDefinitionConstructor(..) is required");
        }
        String[] interfaceInternalNames = new String[this.interfaceTypes.size()];
        Iterator<Class> j = this.interfaceTypes.iterator();
        for (int i = 0; i < interfaceInternalNames.length; ++i) {
            interfaceInternalNames[i] = Type.getInternalName((Class)j.next());
        }
        this.classWriter.visit(52, 4096, this.beanDefinitionInternalName, this.generateBeanDefSig(this.providedType.getInternalName()), this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName(), interfaceInternalNames);
        if (this.buildMethodVisitor == null) {
            throw new IllegalStateException("At least one call to visitBeanDefinitionConstructor() is required");
        }
        this.finalizeInjectMethod();
        this.finalizeBuildMethod();
        this.finalizeAnnotationMetadata();
        this.finalizeTypeArguments();
        if (this.preprocessMethods) {
            GeneratorAdapter requiresMethodProcessing = this.startPublicMethod(this.classWriter, "requiresMethodProcessing", Boolean.TYPE.getName(), new String[0]);
            requiresMethodProcessing.push(true);
            requiresMethodProcessing.visitInsn(172);
            requiresMethodProcessing.visitMaxs(1, 1);
            requiresMethodProcessing.visitEnd();
        }
        this.constructorVisitor.visitInsn(177);
        this.constructorVisitor.visitMaxs(13, 1);
        if (this.buildMethodVisitor != null) {
            this.buildMethodVisitor.visitInsn(176);
            this.buildMethodVisitor.visitMaxs(13, this.buildMethodLocalCount);
        }
        if (this.injectMethodVisitor != null) {
            this.injectMethodVisitor.visitMaxs(13, this.injectMethodLocalCount);
        }
        if (this.postConstructMethodVisitor != null) {
            this.postConstructMethodVisitor.visitVarInsn(25, this.postConstructInstanceIndex);
            this.postConstructMethodVisitor.visitInsn(176);
            this.postConstructMethodVisitor.visitMaxs(13, this.postConstructMethodLocalCount);
        }
        if (this.preDestroyMethodVisitor != null) {
            this.preDestroyMethodVisitor.visitVarInsn(25, this.preDestroyInstanceIndex);
            this.preDestroyMethodVisitor.visitInsn(176);
            this.preDestroyMethodVisitor.visitMaxs(13, this.preDestroyMethodLocalCount);
        }
        for (GeneratorAdapter method : this.loadTypeMethods.values()) {
            method.visitMaxs(3, 1);
            method.visitEnd();
        }
        this.classWriter.visitEnd();
        this.beanFinalized = true;
    }

    private void finalizeTypeArguments() {
        if (CollectionUtils.isNotEmpty(this.typeArguments)) {
            GeneratorAdapter visitor = this.startPublicMethodZeroArgs(this.classWriter, Map.class, "getTypeArgumentsMap");
            int totalSize = this.typeArguments.size() * 2;
            BeanDefinitionWriter.pushNewArray(visitor, Object.class, totalSize);
            int i = 0;
            for (Map.Entry<String, Map<String, Object>> entry : this.typeArguments.entrySet()) {
                String typeName = entry.getKey();
                BeanDefinitionWriter.pushStoreStringInArray(visitor, i++, totalSize, typeName);
                BeanDefinitionWriter.pushStoreInArray(visitor, i++, totalSize, () -> BeanDefinitionWriter.pushTypeArguments(visitor, (Map)entry.getValue()));
            }
            visitor.invokeStatic(Type.getType(CollectionUtils.class), METHOD_MAP_OF);
            visitor.returnValue();
            visitor.visitMaxs(1, 1);
            visitor.visitEnd();
        }
    }

    private void finalizeAnnotationMetadata() {
        if (this.annotationMetadata != null) {
            GeneratorAdapter annotationMetadataMethod = this.startProtectedMethod(this.classWriter, "resolveAnnotationMetadata", AnnotationMetadata.class.getName(), new String[0]);
            annotationMetadataMethod.loadThis();
            annotationMetadataMethod.getStatic(BeanDefinitionWriter.getTypeReference(this.getBeanDefinitionReferenceClassName()), "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
            annotationMetadataMethod.returnValue();
            annotationMetadataMethod.visitMaxs(1, 1);
            annotationMetadataMethod.visitEnd();
        }
    }

    public byte[] toByteArray() {
        if (!this.beanFinalized) {
            throw new IllegalStateException("Bean definition not finalized. Call visitBeanDefinitionEnd() first.");
        }
        return this.classWriter.toByteArray();
    }

    @Override
    public void accept(ClassWriterOutputVisitor visitor) throws IOException {
        try (OutputStream out = visitor.visitClass(this.getBeanDefinitionName());){
            try {
                for (ExecutableMethodWriter methodWriter : this.methodExecutors.values()) {
                    methodWriter.accept(visitor);
                }
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw e;
            }
            out.write(this.toByteArray());
        }
    }

    @Override
    public void visitSetterValue(Object declaringType, Object returnType, AnnotationMetadata annotationMetadata, boolean requiresReflection, Object fieldType, String fieldName, String setterName, Map<String, Object> genericTypes, boolean isOptional) {
        Type declaringTypeRef = BeanDefinitionWriter.getTypeReference(declaringType);
        this.addInjectionPointForSetterInternal(annotationMetadata, requiresReflection, fieldType, fieldName, setterName, genericTypes, declaringTypeRef);
        if (!requiresReflection) {
            this.resolveBeanOrValueForSetter(declaringTypeRef, returnType, setterName, fieldType, GET_VALUE_FOR_METHOD_ARGUMENT, isOptional);
        }
        ++this.currentMethodIndex;
    }

    @Override
    public void visitSetterValue(Object declaringType, Object returnType, AnnotationMetadata annotationMetadata, boolean requiresReflection, Object valueType, String setterName, Map<String, Object> genericTypes, AnnotationMetadata setterArgumentMetadata, boolean isOptional) {
        Type declaringTypeRef = BeanDefinitionWriter.getTypeReference(declaringType);
        this.constructorVisitor.visitVarInsn(25, 0);
        this.constructorVisitor.push(declaringTypeRef);
        this.constructorVisitor.push(setterName);
        String propertyName = NameUtils.getPropertyNameForSetter((String)setterName);
        BeanDefinitionWriter.pushBuildArgumentsForMethod(this.beanDefinitionType, this.classWriter, this.constructorVisitor, Collections.singletonMap(propertyName, valueType), Collections.singletonMap(propertyName, setterArgumentMetadata), Collections.singletonMap(propertyName, genericTypes), this.loadTypeMethods);
        if (annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
            this.constructorVisitor.visitInsn(1);
        } else {
            AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, this.constructorVisitor, (DefaultAnnotationMetadata)annotationMetadata, this.loadTypeMethods);
        }
        this.constructorVisitor.visitInsn(requiresReflection ? 4 : 3);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)this.constructorVisitor, ADD_METHOD_INJECTION_POINT_METHOD);
        if (!requiresReflection) {
            this.resolveBeanOrValueForSetter(declaringTypeRef, returnType, setterName, valueType, GET_VALUE_FOR_METHOD_ARGUMENT, isOptional);
        }
        ++this.currentMethodIndex;
    }

    @Override
    public void visitPostConstructMethod(Object declaringType, boolean requiresReflection, Object returnType, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        this.visitPostConstructMethodDefinition();
        MethodVisitData methodVisitData = new MethodVisitData(declaringType, requiresReflection, returnType, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes, annotationMetadata);
        this.postConstructMethodVisits.add(methodVisitData);
        this.visitMethodInjectionPointInternal(methodVisitData, this.constructorVisitor, this.postConstructMethodVisitor, this.postConstructInstanceIndex, ADD_POST_CONSTRUCT_METHOD);
    }

    public void visitPreDestroyMethod(Object declaringType, String methodName) {
        this.visitPreDestroyMethod(declaringType, Void.TYPE, methodName);
    }

    public void visitPreDestroyMethod(Object declaringType, Object returnType, String methodName) {
        this.visitPreDestroyMethodDefinition();
        MethodVisitData methodVisitData = new MethodVisitData(declaringType, false, returnType, methodName, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), AnnotationMetadata.EMPTY_METADATA);
        this.preDestroyMethodVisits.add(methodVisitData);
        this.visitMethodInjectionPointInternal(methodVisitData, this.constructorVisitor, this.preDestroyMethodVisitor, this.preDestroyInstanceIndex, ADD_PRE_DESTROY_METHOD);
    }

    @Override
    public void visitPreDestroyMethod(Object declaringType, boolean requiresReflection, Object returnType, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        this.visitPreDestroyMethodDefinition();
        MethodVisitData methodVisitData = new MethodVisitData(declaringType, requiresReflection, returnType, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes, annotationMetadata);
        this.preDestroyMethodVisits.add(methodVisitData);
        this.visitMethodInjectionPointInternal(methodVisitData, this.constructorVisitor, this.preDestroyMethodVisitor, this.preDestroyInstanceIndex, ADD_PRE_DESTROY_METHOD);
    }

    @Override
    public void visitMethodInjectionPoint(Object declaringType, boolean requiresReflection, Object returnType, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        GeneratorAdapter constructorVisitor = this.constructorVisitor;
        GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor;
        int injectInstanceIndex = this.injectInstanceIndex;
        this.visitMethodInjectionPointInternal(new MethodVisitData(declaringType, requiresReflection, returnType, methodName, argumentTypes, argumentAnnotationMetadata, genericTypes, annotationMetadata), constructorVisitor, injectMethodVisitor, injectInstanceIndex, ADD_METHOD_INJECTION_POINT_METHOD);
    }

    @Override
    public ExecutableMethodWriter visitExecutableMethod(Object declaringType, Object returnType, Object genericReturnType, Map<String, Object> returnTypeGenericTypes, String methodName, Map<String, Object> argumentTypes, Map<String, Object> genericArgumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        if (argumentAnnotationMetadata != null) {
            for (AnnotationMetadata metadata : argumentAnnotationMetadata.values()) {
                DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, metadata);
            }
        }
        String methodProxyShortName = "$exec" + ++this.methodExecutorIndex;
        String methodExecutorClassName = this.beanDefinitionName + "$" + methodProxyShortName;
        boolean isSuspend = "kotlin.coroutines.Continuation".equals(CollectionUtils.last(argumentTypes.values()));
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{new AnnotationMetadataReference(this.getBeanDefinitionReferenceClassName(), this.annotationMetadata), ((AnnotationMetadataHierarchy)annotationMetadata).getDeclaredMetadata()});
        }
        ExecutableMethodWriter executableMethodWriter = new ExecutableMethodWriter(this.beanFullClassName, methodExecutorClassName, methodProxyShortName, this.isInterface, isSuspend, annotationMetadata);
        executableMethodWriter.visitMethod(declaringType, returnType, genericReturnType, returnTypeGenericTypes, methodName, argumentTypes, genericArgumentTypes, argumentAnnotationMetadata, genericTypes);
        this.methodExecutors.put(methodExecutorClassName, executableMethodWriter);
        if (this.constructorVisitor == null) {
            throw new IllegalStateException("Method visitBeanDefinitionConstructor(..) should be called first!");
        }
        this.constructorVisitor.visitVarInsn(25, 0);
        String methodExecutorInternalName = executableMethodWriter.getInternalName();
        this.constructorVisitor.visitTypeInsn(187, methodExecutorInternalName);
        this.constructorVisitor.visitInsn(89);
        this.constructorVisitor.visitMethodInsn(183, methodExecutorInternalName, "<init>", "()V", false);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)this.constructorVisitor, ADD_EXECUTABLE_METHOD);
        return executableMethodWriter;
    }

    public String toString() {
        return "BeanDefinitionWriter{beanFullClassName='" + this.beanFullClassName + '\'' + '}';
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getBeanSimpleName() {
        return this.beanSimpleClassName;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public void visitConfigBuilderField(Object type, String field, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder) {
        String factoryMethod = annotationMetadata.getValue(ConfigurationBuilder.class, "factoryMethod", String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)factoryMethod)) {
            Type builderType = BeanDefinitionWriter.getTypeReference(type);
            this.injectMethodVisitor.visitVarInsn(25, this.injectInstanceIndex);
            this.injectMethodVisitor.invokeStatic(builderType, Method.getMethod((String)(builderType.getClassName() + " " + factoryMethod + "()")));
            this.injectMethodVisitor.putField(this.beanType, field, builderType);
        }
        this.currentConfigBuilderState = new ConfigBuilderState(type, field, false, annotationMetadata, metadataBuilder);
    }

    @Override
    public void visitConfigBuilderMethod(Object type, String methodName, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder) {
        String factoryMethod = annotationMetadata.getValue(ConfigurationBuilder.class, "factoryMethod", String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)factoryMethod)) {
            Type builderType = BeanDefinitionWriter.getTypeReference(type);
            this.injectMethodVisitor.visitVarInsn(25, this.injectInstanceIndex);
            this.injectMethodVisitor.invokeStatic(builderType, Method.getMethod((String)(builderType.getClassName() + " " + factoryMethod + "()")));
            String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
            String setterName = NameUtils.setterNameFor((String)propertyName);
            this.injectMethodVisitor.invokeVirtual(this.beanType, Method.getMethod((String)("void " + setterName + "(" + builderType.getClassName() + ")")));
        }
        this.currentConfigBuilderState = new ConfigBuilderState(type, methodName, true, annotationMetadata, metadataBuilder);
    }

    @Override
    public void visitConfigBuilderDurationMethod(String prefix, Object returnType, String methodName, String path) {
        this.visitConfigBuilderMethodInternal(prefix, returnType, methodName, Duration.class, Collections.emptyMap(), true, path);
    }

    @Override
    public void visitConfigBuilderMethod(String prefix, Object returnType, String methodName, Object paramType, Map<String, Object> generics, String path) {
        this.visitConfigBuilderMethodInternal(prefix, returnType, methodName, paramType, generics, false, path);
    }

    @Override
    public void visitConfigBuilderEnd() {
        this.currentConfigBuilderState = null;
    }

    @Override
    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.preprocessMethods = shouldPreProcess;
    }

    @Override
    public void visitTypeArguments(Map<String, Map<String, Object>> typeArguments) {
        this.typeArguments = typeArguments;
    }

    @Override
    public boolean requiresMethodProcessing() {
        return this.preprocessMethods;
    }

    @Override
    public void visitFieldInjectionPoint(Object declaringType, Object fieldType, String fieldName, boolean requiresReflection, AnnotationMetadata annotationMetadata, @Nullable Map<String, Object> typeArguments) {
        this.visitFieldInjectionPointInternal(declaringType, annotationMetadata, typeArguments, requiresReflection, fieldType, fieldName, GET_BEAN_FOR_FIELD, false);
    }

    @Override
    public void visitFieldValue(Object declaringType, Object fieldType, String fieldName, boolean requiresReflection, AnnotationMetadata annotationMetadata, @Nullable Map<String, Object> typeArguments, boolean isOptional) {
        this.visitFieldInjectionPointInternal(declaringType, annotationMetadata, typeArguments, requiresReflection, fieldType, fieldName, GET_VALUE_FOR_FIELD, isOptional);
    }

    private void visitConfigBuilderMethodInternal(String prefix, Object returnType, String methodName, Object paramType, Map<String, Object> generics, boolean isDurationWithTimeUnit, String propertyPath) {
        if (this.currentConfigBuilderState != null) {
            Type builderType = this.currentConfigBuilderState.getType();
            String builderName = this.currentConfigBuilderState.getName();
            boolean isResolveBuilderViaMethodCall = this.currentConfigBuilderState.isMethod();
            GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor;
            String propertyName = NameUtils.hyphenate((String)NameUtils.decapitalize((String)methodName.substring(prefix.length())), (boolean)true);
            boolean zeroArgs = paramType == null;
            this.pushGetValueForPathCall(injectMethodVisitor, paramType, propertyName, propertyPath, zeroArgs, generics);
            Label ifEnd = new Label();
            injectMethodVisitor.invokeVirtual(Type.getType(Optional.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Optional.class, (String)"isPresent", (Class[])new Class[0])));
            injectMethodVisitor.push(false);
            injectMethodVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, ifEnd);
            if (zeroArgs) {
                this.pushOptionalGet(injectMethodVisitor);
                BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, Boolean.TYPE);
                injectMethodVisitor.push(false);
                injectMethodVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, ifEnd);
            }
            injectMethodVisitor.visitLabel(new Label());
            String methodDescriptor = zeroArgs ? BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.emptyList()) : (isDurationWithTimeUnit ? BeanDefinitionWriter.getMethodDescriptor(returnType, Arrays.asList(Long.TYPE, TimeUnit.class)) : BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.singleton(paramType)));
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label exceptionHandler = new Label();
            injectMethodVisitor.visitTryCatchBlock(tryStart, tryEnd, exceptionHandler, Type.getInternalName(NoSuchMethodError.class));
            injectMethodVisitor.visitLabel(tryStart);
            injectMethodVisitor.visitVarInsn(25, this.injectInstanceIndex);
            if (isResolveBuilderViaMethodCall) {
                String desc = builderType.getClassName() + " " + builderName + "()";
                injectMethodVisitor.invokeVirtual(this.beanType, Method.getMethod((String)desc));
            } else {
                injectMethodVisitor.getField(this.beanType, builderName, builderType);
            }
            if (!zeroArgs) {
                this.pushOptionalGet(injectMethodVisitor);
                BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, paramType);
            }
            if (zeroArgs) {
                injectMethodVisitor.invokeVirtual(builderType, new Method(methodName, methodDescriptor));
            } else if (isDurationWithTimeUnit) {
                injectMethodVisitor.invokeVirtual(Type.getType(Duration.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Duration.class, (String)"toMillis", (Class[])new Class[0])));
                Type tu = Type.getType(TimeUnit.class);
                injectMethodVisitor.getStatic(tu, "MILLISECONDS", tu);
                injectMethodVisitor.invokeVirtual(builderType, new Method(methodName, methodDescriptor));
            } else {
                injectMethodVisitor.invokeVirtual(builderType, new Method(methodName, methodDescriptor));
            }
            if (returnType != Void.TYPE) {
                injectMethodVisitor.pop();
            }
            injectMethodVisitor.visitJumpInsn(167, tryEnd);
            injectMethodVisitor.visitLabel(exceptionHandler);
            injectMethodVisitor.pop();
            injectMethodVisitor.visitLabel(tryEnd);
            injectMethodVisitor.visitLabel(ifEnd);
        }
    }

    private void pushOptionalGet(GeneratorAdapter injectMethodVisitor) {
        injectMethodVisitor.visitVarInsn(25, this.optionalInstanceIndex);
        injectMethodVisitor.invokeVirtual(Type.getType(Optional.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Optional.class, (String)"get", (Class[])new Class[0])));
    }

    private void pushGetValueForPathCall(GeneratorAdapter injectMethodVisitor, Object propertyType, String propertyName, String propertyPath, boolean zeroArgs, Map<String, Object> generics) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        if (zeroArgs) {
            BeanDefinitionWriter.buildArgument(injectMethodVisitor, propertyName, Boolean.class);
        } else {
            BeanDefinitionWriter.buildArgumentWithGenerics(injectMethodVisitor, propertyName, Collections.singletonMap(propertyType, generics));
        }
        injectMethodVisitor.push(propertyPath);
        injectMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod((java.lang.reflect.Method)GET_VALUE_FOR_PATH));
        injectMethodVisitor.visitVarInsn(58, this.optionalInstanceIndex);
        injectMethodVisitor.visitVarInsn(25, this.optionalInstanceIndex);
    }

    private void buildFactoryMethodClassConstructor(Object factoryClass, Object producedType, String methodName, AnnotationMetadata methodAnnotationMetadata, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes) {
        Type factoryTypeRef = BeanDefinitionWriter.getTypeReference(factoryClass);
        Type producedTypeRef = BeanDefinitionWriter.getTypeReference(producedType);
        this.constructorVisitor = this.buildProtectedConstructor(BEAN_DEFINITION_METHOD_CONSTRUCTOR);
        GeneratorAdapter defaultConstructor = new GeneratorAdapter((MethodVisitor)this.startConstructor((ClassVisitor)this.classWriter), 1, "<init>", "()V");
        defaultConstructor.loadThis();
        defaultConstructor.push(producedTypeRef);
        defaultConstructor.push(factoryTypeRef);
        defaultConstructor.push(methodName);
        this.pushAnnotationMetadata(methodAnnotationMetadata, defaultConstructor);
        defaultConstructor.push(false);
        if (CollectionUtils.isNotEmpty(argumentTypes)) {
            BeanDefinitionWriter.pushBuildArgumentsForMethod(this.beanDefinitionType, this.classWriter, defaultConstructor, argumentTypes, argumentAnnotationMetadata, genericTypes, this.loadTypeMethods);
        } else {
            defaultConstructor.visitInsn(1);
        }
        defaultConstructor.invokeConstructor(this.beanDefinitionType, BEAN_DEFINITION_METHOD_CONSTRUCTOR);
        defaultConstructor.visitInsn(177);
        defaultConstructor.visitMaxs(13, 1);
        defaultConstructor.visitEnd();
    }

    private void visitFieldInjectionPointInternal(Object declaringType, AnnotationMetadata annotationMetadata, Map<String, Object> typeArguments, boolean requiresReflection, Object fieldType, String fieldName, java.lang.reflect.Method methodToInvoke, boolean isValueOptional) {
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        GeneratorAdapter constructorVisitor = this.constructorVisitor;
        constructorVisitor.loadThis();
        Type declaringTypeRef = BeanDefinitionWriter.getTypeReference(declaringType);
        constructorVisitor.push(declaringTypeRef);
        constructorVisitor.push(BeanDefinitionWriter.getTypeReference(fieldType));
        constructorVisitor.push(fieldName);
        this.pushAnnotationMetadata(annotationMetadata, constructorVisitor);
        if (CollectionUtils.isNotEmpty(typeArguments)) {
            BeanDefinitionWriter.pushTypeArguments(constructorVisitor, typeArguments);
        } else {
            constructorVisitor.visitInsn(1);
        }
        constructorVisitor.visitInsn(requiresReflection ? 4 : 3);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)constructorVisitor, ADD_FIELD_INJECTION_POINT_METHOD);
        GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor;
        Label falseCondition = null;
        if (isValueOptional) {
            Label trueCondition = new Label();
            falseCondition = new Label();
            injectMethodVisitor.loadThis();
            injectMethodVisitor.loadArg(0);
            injectMethodVisitor.loadArg(1);
            injectMethodVisitor.push(this.currentFieldIndex);
            injectMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod((java.lang.reflect.Method)CONTAINS_VALUE_FOR_FIELD));
            injectMethodVisitor.push(false);
            injectMethodVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, falseCondition);
            injectMethodVisitor.visitLabel(trueCondition);
        }
        if (!requiresReflection) {
            injectMethodVisitor.visitVarInsn(25, this.injectInstanceIndex);
            injectMethodVisitor.loadThis();
            injectMethodVisitor.visitVarInsn(25, 1);
            injectMethodVisitor.visitVarInsn(25, 2);
            injectMethodVisitor.push(this.currentFieldIndex);
            this.pushInvokeMethodOnSuperClass((MethodVisitor)injectMethodVisitor, methodToInvoke);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, fieldType);
            injectMethodVisitor.visitFieldInsn(181, declaringTypeRef.getInternalName(), fieldName, BeanDefinitionWriter.getTypeDescriptor(fieldType));
        } else {
            this.pushInjectMethodForIndex(injectMethodVisitor, this.injectInstanceIndex, this.currentFieldIndex, "injectBeanField");
        }
        if (falseCondition != null) {
            injectMethodVisitor.visitLabel(falseCondition);
        }
        ++this.currentFieldIndex;
    }

    private void pushAnnotationMetadata(AnnotationMetadata annotationMetadata, GeneratorAdapter constructorVisitor) {
        if (!(annotationMetadata instanceof DefaultAnnotationMetadata)) {
            constructorVisitor.visitInsn(1);
        } else {
            AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, constructorVisitor, (DefaultAnnotationMetadata)annotationMetadata, this.loadTypeMethods);
        }
    }

    private void addInjectionPointForSetterInternal(AnnotationMetadata fieldAnnotationMetadata, boolean requiresReflection, Object fieldType, String fieldName, String setterName, Map<String, Object> genericTypes, Type declaringTypeRef) {
        GeneratorAdapter constructorVisitor = this.constructorVisitor;
        constructorVisitor.visitVarInsn(25, 0);
        constructorVisitor.push(declaringTypeRef);
        constructorVisitor.push(setterName);
        BeanDefinitionWriter.pushBuildArgumentsForMethod(this.beanDefinitionType, this.classWriter, constructorVisitor, Collections.singletonMap(fieldName, fieldType), Collections.singletonMap(fieldName, fieldAnnotationMetadata), Collections.singletonMap(fieldName, genericTypes), this.loadTypeMethods);
        if (fieldAnnotationMetadata == null || fieldAnnotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
            constructorVisitor.visitInsn(1);
        } else {
            AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, constructorVisitor, (DefaultAnnotationMetadata)fieldAnnotationMetadata, this.loadTypeMethods);
        }
        constructorVisitor.visitInsn(requiresReflection ? 4 : 3);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)constructorVisitor, ADD_METHOD_INJECTION_POINT_METHOD);
    }

    private void visitMethodInjectionPointInternal(MethodVisitData methodVisitData, GeneratorAdapter constructorVisitor, GeneratorAdapter injectMethodVisitor, int injectInstanceIndex, java.lang.reflect.Method addMethodInjectionPointMethod) {
        AnnotationMetadata annotationMetadata = methodVisitData.annotationMetadata;
        Map argumentTypes = methodVisitData.argumentTypes;
        Object declaringType = methodVisitData.declaringType;
        String methodName = methodVisitData.methodName;
        Map argumentMetadata = methodVisitData.argumentAnnotationMetadata;
        Map genericTypes = methodVisitData.genericTypes;
        boolean requiresReflection = methodVisitData.requiresReflection;
        Object returnType = methodVisitData.returnType;
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        boolean hasArguments = argumentTypes != null && !argumentTypes.isEmpty();
        int argCount = hasArguments ? argumentTypes.size() : 0;
        Type declaringTypeRef = BeanDefinitionWriter.getTypeReference(declaringType);
        constructorVisitor.visitVarInsn(25, 0);
        constructorVisitor.push(declaringTypeRef);
        constructorVisitor.push(methodName);
        if (hasArguments) {
            BeanDefinitionWriter.pushBuildArgumentsForMethod(this.beanDefinitionType, this.classWriter, constructorVisitor, argumentTypes, argumentMetadata, genericTypes, this.loadTypeMethods);
            for (AnnotationMetadata value : argumentMetadata.values()) {
                DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, value);
            }
        } else {
            constructorVisitor.visitInsn(1);
        }
        this.pushAnnotationMetadata(this.annotationMetadata, constructorVisitor);
        constructorVisitor.visitInsn(requiresReflection ? 4 : 3);
        List<Object> argumentTypeClasses = hasArguments ? argumentTypes.values() : Collections.emptyList();
        this.pushInvokeMethodOnSuperClass((MethodVisitor)constructorVisitor, addMethodInjectionPointMethod);
        if (!requiresReflection) {
            String methodDescriptor;
            injectMethodVisitor.visitVarInsn(25, injectInstanceIndex);
            if (hasArguments) {
                methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(returnType, argumentTypeClasses);
                Iterator argIterator = argumentTypes.entrySet().iterator();
                for (int i = 0; i < argCount; ++i) {
                    Map.Entry entry = argIterator.next();
                    AnnotationMetadata argMetadata = (AnnotationMetadata)argumentMetadata.get(entry.getKey());
                    injectMethodVisitor.visitVarInsn(25, 0);
                    injectMethodVisitor.visitVarInsn(25, 1);
                    injectMethodVisitor.visitVarInsn(25, 2);
                    injectMethodVisitor.push(this.currentMethodIndex);
                    injectMethodVisitor.push(i);
                    java.lang.reflect.Method methodToInvoke = argMetadata.hasDeclaredStereotype(Value.class) || argMetadata.hasDeclaredStereotype(Property.class) ? GET_VALUE_FOR_METHOD_ARGUMENT : GET_BEAN_FOR_METHOD_ARGUMENT;
                    this.pushInvokeMethodOnSuperClass((MethodVisitor)injectMethodVisitor, methodToInvoke);
                    BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry.getValue());
                }
            } else {
                methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.emptyList());
            }
            injectMethodVisitor.visitMethodInsn(this.isInterface ? 185 : 182, declaringTypeRef.getInternalName(), methodName, methodDescriptor, this.isInterface);
            if (this.isConfigurationProperties && returnType != Void.TYPE) {
                injectMethodVisitor.pop();
            }
        } else {
            this.pushInjectMethodForIndex(injectMethodVisitor, injectInstanceIndex, this.currentMethodIndex, "injectBeanMethod");
        }
        ++this.currentMethodIndex;
    }

    private void pushInvokeMethodOnSuperClass(MethodVisitor constructorVisitor, java.lang.reflect.Method methodToInvoke) {
        constructorVisitor.visitMethodInsn(183, this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName(), methodToInvoke.getName(), Type.getMethodDescriptor((java.lang.reflect.Method)methodToInvoke), false);
    }

    private void resolveBeanOrValueForSetter(Type declaringTypeRef, Object returnType, String setterName, Object fieldType, java.lang.reflect.Method resolveMethod, boolean isValueOptional) {
        GeneratorAdapter injectVisitor = this.injectMethodVisitor;
        Label falseCondition = null;
        if (isValueOptional) {
            Label trueCondition = new Label();
            falseCondition = new Label();
            injectVisitor.loadThis();
            injectVisitor.loadArg(0);
            injectVisitor.loadArg(1);
            injectVisitor.push(this.currentMethodIndex);
            injectVisitor.push(0);
            injectVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod((java.lang.reflect.Method)CONTAINS_VALUE_FOR_METHOD_ARGUMENT));
            injectVisitor.push(false);
            injectVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, falseCondition);
            injectVisitor.visitLabel(trueCondition);
        }
        injectVisitor.visitVarInsn(25, this.injectInstanceIndex);
        String methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.singletonList(fieldType));
        this.injectMethodVisitor.visitVarInsn(25, 0);
        this.injectMethodVisitor.visitVarInsn(25, 1);
        this.injectMethodVisitor.visitVarInsn(25, 2);
        this.injectMethodVisitor.push(this.currentMethodIndex);
        injectVisitor.push(0);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)injectVisitor, resolveMethod);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectVisitor, fieldType);
        injectVisitor.visitMethodInsn(182, declaringTypeRef.getInternalName(), setterName, methodDescriptor, false);
        if (returnType != Void.TYPE) {
            injectVisitor.pop();
        }
        if (falseCondition != null) {
            injectVisitor.visitLabel(falseCondition);
        }
    }

    private void visitInjectMethodDefinition() {
        if (this.injectMethodVisitor == null) {
            String desc = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), Object.class.getName());
            GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor = new GeneratorAdapter(this.classWriter.visitMethod(4, "injectBean", desc, null, null), 4, "injectBean", desc);
            if (this.isConfigurationProperties) {
                injectMethodVisitor.loadThis();
                injectMethodVisitor.loadArg(0);
                injectMethodVisitor.loadArg(1);
                injectMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod((java.lang.reflect.Method)CONTAINS_PROPERTIES_METHOD));
                injectMethodVisitor.push(false);
                this.injectEnd = new Label();
                injectMethodVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, this.injectEnd);
                injectMethodVisitor.visitLabel(new Label());
            }
            injectMethodVisitor.visitVarInsn(25, 3);
            injectMethodVisitor.visitTypeInsn(192, this.beanType.getInternalName());
            this.injectInstanceIndex = this.pushNewInjectLocalVariable();
            injectMethodVisitor.visitInsn(1);
            this.optionalInstanceIndex = this.pushNewInjectLocalVariable();
        }
    }

    private void visitPostConstructMethodDefinition() {
        if (this.postConstructMethodVisitor == null) {
            GeneratorAdapter postConstructMethodVisitor;
            this.interfaceTypes.add(InitializingBeanDefinition.class);
            this.postConstructMethodVisitor = postConstructMethodVisitor = this.newLifeCycleMethod("initialize");
            postConstructMethodVisitor.visitVarInsn(25, 3);
            postConstructMethodVisitor.visitTypeInsn(192, this.beanType.getInternalName());
            this.postConstructInstanceIndex = this.pushNewPostConstructLocalVariable();
            this.invokeSuperInjectMethod((MethodVisitor)postConstructMethodVisitor, POST_CONSTRUCT_METHOD);
            this.pushBeanDefinitionMethodInvocation((MethodVisitor)this.buildMethodVisitor, "initialize");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)this.buildMethodVisitor, this.beanFullClassName);
            this.buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
        }
    }

    private void pushInjectMethodForIndex(GeneratorAdapter methodVisitor, int instanceIndex, int injectIndex, String injectMethodName) {
        java.lang.reflect.Method injectBeanMethod = ReflectionUtils.getRequiredMethod(AbstractBeanDefinition.class, (String)injectMethodName, (Class[])new Class[]{BeanResolutionContext.class, DefaultBeanContext.class, Integer.TYPE, Object.class});
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)methodVisitor, DefaultBeanContext.class);
        methodVisitor.push(injectIndex);
        methodVisitor.visitVarInsn(25, instanceIndex);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)methodVisitor, injectBeanMethod);
    }

    private void visitPreDestroyMethodDefinition() {
        if (this.preDestroyMethodVisitor == null) {
            GeneratorAdapter preDestroyMethodVisitor;
            this.interfaceTypes.add(DisposableBeanDefinition.class);
            this.preDestroyMethodVisitor = preDestroyMethodVisitor = this.newLifeCycleMethod("dispose");
            preDestroyMethodVisitor.visitVarInsn(25, 3);
            preDestroyMethodVisitor.visitTypeInsn(192, this.beanType.getInternalName());
            this.preDestroyInstanceIndex = this.pushNewPreDestroyLocalVariable();
            this.invokeSuperInjectMethod((MethodVisitor)preDestroyMethodVisitor, PRE_DESTROY_METHOD);
        }
    }

    private GeneratorAdapter newLifeCycleMethod(String methodName) {
        String desc = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), Object.class.getName());
        return new GeneratorAdapter(this.classWriter.visitMethod(1, methodName, desc, BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.providedBeanClassName), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(this.providedBeanClassName)), null), 1, methodName, desc);
    }

    private void finalizeBuildMethod() {
        if (!this.providedBeanClassName.equals(this.beanFullClassName)) {
            this.buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
            this.buildMethodVisitor.visitVarInsn(25, this.buildInstanceIndex);
            this.buildMethodVisitor.visitMethodInsn(182, this.beanType.getInternalName(), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]), false);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)this.buildMethodVisitor, this.providedBeanClassName);
            this.buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
            this.pushBeanDefinitionMethodInvocation((MethodVisitor)this.buildMethodVisitor, "injectAnother");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)this.buildMethodVisitor, this.providedBeanClassName);
        }
    }

    private void finalizeInjectMethod() {
        if (this.injectEnd != null) {
            this.injectMethodVisitor.visitLabel(this.injectEnd);
        }
        this.invokeSuperInjectMethod((MethodVisitor)this.injectMethodVisitor, INJECT_BEAN_METHOD);
        this.injectMethodVisitor.visitInsn(176);
    }

    private void invokeSuperInjectMethod(MethodVisitor methodVisitor, java.lang.reflect.Method methodToInvoke) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        BeanDefinitionWriter.pushCastToType(methodVisitor, DefaultBeanContext.class);
        methodVisitor.visitVarInsn(25, 3);
        this.pushInvokeMethodOnSuperClass(methodVisitor, methodToInvoke);
    }

    private void visitBuildFactoryMethodDefinition(Object factoryClass, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, AnnotationMetadata methodAnnotationMetadata) {
        if (this.buildMethodVisitor == null) {
            boolean isParametrized = this.isParametrized(argumentAnnotationMetadata);
            this.defineBuilderMethod(isParametrized);
            GeneratorAdapter buildMethodVisitor = this.buildMethodVisitor;
            buildMethodVisitor.visitVarInsn(25, 2);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, DefaultBeanContext.class);
            buildMethodVisitor.visitVarInsn(25, 1);
            Type factoryType = BeanDefinitionWriter.getTypeReference(factoryClass);
            buildMethodVisitor.visitLdcInsn((Object)factoryType);
            java.lang.reflect.Method getBeanMethod = ReflectionUtils.getRequiredInternalMethod(DefaultBeanContext.class, (String)"getBean", (Class[])new Class[]{BeanResolutionContext.class, Class.class});
            buildMethodVisitor.visitMethodInsn(182, Type.getInternalName(DefaultBeanContext.class), "getBean", Type.getMethodDescriptor((java.lang.reflect.Method)getBeanMethod), false);
            int factoryVar = this.pushNewBuildLocalVariable();
            Map<Object, Object> variableReplacements = isParametrized ? Collections.emptyMap() : this.processEachBeanArgument(methodAnnotationMetadata, argumentTypes, argumentAnnotationMetadata, buildMethodVisitor);
            buildMethodVisitor.visitVarInsn(25, factoryVar);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, factoryClass);
            if (argumentTypes.isEmpty()) {
                buildMethodVisitor.visitMethodInsn(182, factoryType.getInternalName(), methodName, Type.getMethodDescriptor((Type)this.beanType, (Type[])new Type[0]), false);
            } else {
                this.pushConstructorArguments(buildMethodVisitor, argumentTypes, argumentAnnotationMetadata, variableReplacements);
                String methodDescriptor = BeanDefinitionWriter.getMethodDescriptor((Object)this.beanFullClassName, argumentTypes.values());
                buildMethodVisitor.visitMethodInsn(182, factoryType.getInternalName(), methodName, methodDescriptor, false);
            }
            this.buildInstanceIndex = this.pushNewBuildLocalVariable();
            this.pushBeanDefinitionMethodInvocation((MethodVisitor)buildMethodVisitor, "injectBean");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanFullClassName);
            buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
            buildMethodVisitor.visitVarInsn(25, this.buildInstanceIndex);
        }
    }

    private void visitBuildMethodDefinition(AnnotationMetadata classMetadata, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata) {
        if (this.buildMethodVisitor == null) {
            boolean isParametrized = this.isParametrized(argumentAnnotationMetadata);
            this.defineBuilderMethod(isParametrized);
            GeneratorAdapter buildMethodVisitor = this.buildMethodVisitor;
            Map<Object, Object> variableReplacements = isParametrized ? Collections.emptyMap() : this.processEachBeanArgument(classMetadata, argumentTypes, argumentAnnotationMetadata, buildMethodVisitor);
            buildMethodVisitor.visitTypeInsn(187, this.beanType.getInternalName());
            buildMethodVisitor.visitInsn(89);
            this.pushConstructorArguments(buildMethodVisitor, argumentTypes, argumentAnnotationMetadata, variableReplacements);
            String constructorDescriptor = BeanDefinitionWriter.getConstructorDescriptor(argumentTypes.values());
            buildMethodVisitor.visitMethodInsn(183, this.beanType.getInternalName(), "<init>", constructorDescriptor, false);
            this.buildInstanceIndex = this.pushNewBuildLocalVariable();
            this.pushBeanDefinitionMethodInvocation((MethodVisitor)buildMethodVisitor, "injectBean");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanFullClassName);
            buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
            buildMethodVisitor.visitVarInsn(25, this.buildInstanceIndex);
        }
    }

    private Map<String, Integer> processEachBeanArgument(AnnotationMetadata ownerMetadata, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, GeneratorAdapter buildMethodVisitor) {
        Optional eachBeanArgument;
        HashMap<String, Integer> variableReplacements = new HashMap<String, Integer>();
        if (!argumentTypes.isEmpty() && (eachBeanArgument = ownerMetadata.stringValue(EachBean.class)).isPresent()) {
            int size = argumentTypes.size();
            Iterator<Map.Entry<String, Object>> iterator = argumentTypes.entrySet().iterator();
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, Object> entry = iterator.next();
                if (!entry.getValue().equals(eachBeanArgument.get())) continue;
                AnnotationMetadata argMetadata = argumentAnnotationMetadata.get(entry.getKey());
                buildMethodVisitor.visitInsn(1);
                int eachBeanVar = this.pushNewBuildLocalVariable();
                Label tryStart = new Label();
                Label tryEnd = new Label();
                Label catchStart = new Label();
                Label catchEnd = new Label();
                buildMethodVisitor.visitTryCatchBlock(tryStart, tryEnd, catchStart, Type.getInternalName(BeanContextException.class));
                buildMethodVisitor.visitLabel(tryStart);
                this.pushConstructorArgument(buildMethodVisitor, entry.getKey(), entry.getValue(), argMetadata, i);
                buildMethodVisitor.visitVarInsn(58, eachBeanVar);
                buildMethodVisitor.visitLabel(tryEnd);
                buildMethodVisitor.visitJumpInsn(167, catchEnd);
                buildMethodVisitor.visitLabel(catchStart);
                if (!argMetadata.hasAnnotation("javax.annotation.Nullable")) {
                    buildMethodVisitor.visitInsn(1);
                    buildMethodVisitor.visitInsn(176);
                } else {
                    buildMethodVisitor.pop();
                }
                buildMethodVisitor.visitLabel(catchEnd);
                variableReplacements.put(entry.getKey(), eachBeanVar);
                break;
            }
        }
        return variableReplacements;
    }

    private void pushConstructorArguments(GeneratorAdapter buildMethodVisitor, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Integer> variableReplacements) {
        int size = argumentTypes.size();
        if (size > 0) {
            Iterator<Map.Entry<String, Object>> iterator = argumentTypes.entrySet().iterator();
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, Object> entry = iterator.next();
                AnnotationMetadata argMetadata = argumentAnnotationMetadata.get(entry.getKey());
                Integer variable = variableReplacements.get(entry.getKey());
                if (variable != null) {
                    buildMethodVisitor.visitVarInsn(25, variable.intValue());
                    continue;
                }
                this.pushConstructorArgument(buildMethodVisitor, entry.getKey(), entry.getValue(), argMetadata, i);
            }
        }
    }

    private void pushConstructorArgument(GeneratorAdapter buildMethodVisitor, String argumentName, Object argumentType, AnnotationMetadata annotationMetadata, int index) {
        if (this.isArgumentType(annotationMetadata) && this.argsIndex > -1) {
            buildMethodVisitor.visitVarInsn(25, this.argsIndex);
            buildMethodVisitor.push(argumentName);
            buildMethodVisitor.invokeInterface(Type.getType(Map.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Map.class, (String)"get", (Class[])new Class[]{Object.class})));
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, argumentType);
        } else {
            buildMethodVisitor.visitVarInsn(25, 0);
            buildMethodVisitor.visitVarInsn(25, 1);
            buildMethodVisitor.visitVarInsn(25, 2);
            buildMethodVisitor.push(index);
            java.lang.reflect.Method methodToInvoke = this.isValueType(annotationMetadata) ? GET_VALUE_FOR_CONSTRUCTOR_ARGUMENT : GET_BEAN_FOR_CONSTRUCTOR_ARGUMENT;
            this.pushInvokeMethodOnSuperClass((MethodVisitor)buildMethodVisitor, methodToInvoke);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, argumentType);
        }
    }

    private boolean isValueType(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            return annotationMetadata.hasDeclaredStereotype(Value.class) || annotationMetadata.hasDeclaredStereotype(Property.class);
        }
        return false;
    }

    private boolean isArgumentType(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            return annotationMetadata.hasDeclaredAnnotation(Parameter.class);
        }
        return false;
    }

    private boolean isParametrized(Map<String, AnnotationMetadata> argumentAnnotationMetadata) {
        Optional argumentQualifier = argumentAnnotationMetadata != null ? argumentAnnotationMetadata.values().stream().filter(this::isArgumentType).findFirst() : Optional.empty();
        return argumentQualifier.isPresent();
    }

    private void defineBuilderMethod(boolean isParametrized) {
        String methodSignature;
        String methodDescriptor;
        if (isParametrized) {
            this.superType = TYPE_ABSTRACT_PARAMETRIZED_BEAN_DEFINITION;
            this.argsIndex = this.buildMethodLocalCount++;
        }
        if (isParametrized) {
            methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), BeanDefinition.class.getName(), Map.class.getName());
            methodSignature = BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.providedBeanClassName), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanDefinition.class.getName(), this.providedBeanClassName), BeanDefinitionWriter.getTypeDescriptor(Map.class.getName()));
        } else {
            methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), BeanDefinition.class.getName());
            methodSignature = BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.providedBeanClassName), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanDefinition.class.getName(), this.providedBeanClassName));
        }
        String methodName = isParametrized ? "doBuild" : "build";
        this.buildMethodVisitor = new GeneratorAdapter(this.classWriter.visitMethod(1, methodName, methodDescriptor, methodSignature, null), 1, methodName, methodDescriptor);
    }

    private void pushBeanDefinitionMethodInvocation(MethodVisitor buildMethodVisitor, String methodName) {
        buildMethodVisitor.visitVarInsn(25, 0);
        buildMethodVisitor.visitVarInsn(25, 1);
        buildMethodVisitor.visitVarInsn(25, 2);
        buildMethodVisitor.visitVarInsn(25, this.buildInstanceIndex);
        buildMethodVisitor.visitMethodInsn(182, this.beanDefinitionInternalName, methodName, Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(BeanResolutionContext.class), Type.getType(BeanContext.class), Type.getType(Object.class)}), false);
    }

    private int pushNewBuildLocalVariable() {
        this.buildMethodVisitor.visitVarInsn(58, this.buildMethodLocalCount);
        return this.buildMethodLocalCount++;
    }

    private int pushNewInjectLocalVariable() {
        this.injectMethodVisitor.visitVarInsn(58, this.injectMethodLocalCount);
        return this.injectMethodLocalCount++;
    }

    private int pushNewPostConstructLocalVariable() {
        this.postConstructMethodVisitor.visitVarInsn(58, this.postConstructMethodLocalCount);
        return this.postConstructMethodLocalCount++;
    }

    private int pushNewPreDestroyLocalVariable() {
        this.preDestroyMethodVisitor.visitVarInsn(58, this.preDestroyMethodLocalCount);
        return this.preDestroyMethodLocalCount++;
    }

    private void visitBeanDefinitionConstructorInternal(AnnotationMetadata constructorMetadata, boolean requiresReflection, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes) {
        if (this.constructorVisitor == null) {
            GeneratorAdapter protectedConstructor;
            DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, constructorMetadata);
            Optional argumentQualifier = argumentAnnotationMetadata != null ? argumentAnnotationMetadata.values().stream().filter(this::isArgumentType).findFirst() : Optional.empty();
            boolean isParametrized = argumentQualifier.isPresent();
            if (isParametrized) {
                this.superType = TYPE_ABSTRACT_PARAMETRIZED_BEAN_DEFINITION;
            }
            Method constructorMethod = Method.getMethod(CONSTRUCTOR_ABSTRACT_BEAN_DEFINITION);
            this.constructorVisitor = protectedConstructor = new GeneratorAdapter(this.classWriter.visitMethod(4, "<init>", constructorMethod.getDescriptor(), null, null), 4, "<init>", constructorMethod.getDescriptor());
            Type[] beanDefinitionConstructorArgumentTypes = constructorMethod.getArgumentTypes();
            protectedConstructor.loadThis();
            for (int i = 0; i < beanDefinitionConstructorArgumentTypes.length; ++i) {
                protectedConstructor.loadArg(i);
            }
            protectedConstructor.invokeConstructor(this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION : this.superType, BEAN_DEFINITION_CLASS_CONSTRUCTOR);
            GeneratorAdapter defaultConstructor = this.startConstructor((ClassVisitor)this.classWriter);
            GeneratorAdapter defaultConstructorVisitor = new GeneratorAdapter((MethodVisitor)defaultConstructor, 1, "<init>", "()V");
            defaultConstructor.visitVarInsn(25, 0);
            defaultConstructor.visitLdcInsn((Object)this.beanType);
            if (constructorMetadata == null || constructorMetadata == AnnotationMetadata.EMPTY_METADATA) {
                defaultConstructor.visitInsn(1);
            } else if (constructorMetadata instanceof AnnotationMetadataHierarchy) {
                AnnotationMetadataWriter.instantiateNewMetadataHierarchy(this.beanDefinitionType, this.classWriter, defaultConstructor, (AnnotationMetadataHierarchy)constructorMetadata, this.loadTypeMethods);
            } else {
                AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, defaultConstructor, (DefaultAnnotationMetadata)constructorMetadata, this.loadTypeMethods);
            }
            defaultConstructor.visitInsn(requiresReflection ? 4 : 3);
            if (argumentAnnotationMetadata == null || argumentAnnotationMetadata.isEmpty()) {
                defaultConstructor.visitInsn(1);
            } else {
                BeanDefinitionWriter.pushBuildArgumentsForMethod(this.beanDefinitionType, this.classWriter, defaultConstructorVisitor, argumentTypes, argumentAnnotationMetadata, genericTypes, this.loadTypeMethods);
                for (AnnotationMetadata value : argumentAnnotationMetadata.values()) {
                    DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, value);
                }
            }
            defaultConstructorVisitor.invokeConstructor(this.beanDefinitionType, BEAN_DEFINITION_CLASS_CONSTRUCTOR);
            defaultConstructorVisitor.visitInsn(177);
            defaultConstructorVisitor.visitMaxs(13, 1);
            defaultConstructorVisitor.visitEnd();
        }
    }

    private GeneratorAdapter buildProtectedConstructor(Method constructorType) {
        GeneratorAdapter protectedConstructor = new GeneratorAdapter(this.classWriter.visitMethod(4, "<init>", constructorType.getDescriptor(), null, null), 4, "<init>", constructorType.getDescriptor());
        Type[] arguments = constructorType.getArgumentTypes();
        protectedConstructor.loadThis();
        for (int i = 0; i < arguments.length; ++i) {
            protectedConstructor.loadArg(i);
        }
        if (this.isSuperFactory) {
            protectedConstructor.invokeConstructor(TYPE_ABSTRACT_BEAN_DEFINITION, constructorType);
        } else {
            protectedConstructor.invokeConstructor(this.superType, constructorType);
        }
        return protectedConstructor;
    }

    private String generateBeanDefSig(String typeParameter) {
        SignatureWriter sv = new SignatureWriter();
        this.visitSuperTypeParameters((SignatureVisitor)sv, typeParameter);
        String beanTypeInternalName = BeanDefinitionWriter.getInternalName(typeParameter);
        for (Class interfaceType : this.interfaceTypes) {
            SignatureVisitor bfi = sv.visitInterface();
            bfi.visitClassType(Type.getInternalName((Class)interfaceType));
            SignatureVisitor iisv = bfi.visitTypeArgument('=');
            iisv.visitClassType(beanTypeInternalName);
            iisv.visitEnd();
            bfi.visitEnd();
        }
        return sv.toString();
    }

    private void visitSuperTypeParameters(SignatureVisitor sv, String ... typeParameters) {
        SignatureVisitor psv = sv.visitSuperclass();
        psv.visitClassType(this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName());
        if (this.superType == TYPE_ABSTRACT_BEAN_DEFINITION || this.superType == TYPE_ABSTRACT_PARAMETRIZED_BEAN_DEFINITION || this.isSuperFactory) {
            for (String typeParameter : typeParameters) {
                SignatureVisitor ppsv = psv.visitTypeArgument('=');
                String beanTypeInternalName = BeanDefinitionWriter.getInternalName(typeParameter);
                ppsv.visitClassType(beanTypeInternalName);
                ppsv.visitEnd();
            }
        }
        psv.visitEnd();
    }

    @Internal
    public static final class MethodVisitData {
        private Object declaringType;
        private boolean requiresReflection;
        private Object returnType;
        private String methodName;
        private Map<String, Object> argumentTypes;
        private Map<String, AnnotationMetadata> argumentAnnotationMetadata;
        private Map<String, Map<String, Object>> genericTypes;
        private AnnotationMetadata annotationMetadata;

        MethodVisitData(Object declaringType, boolean requiresReflection, Object returnType, String methodName, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, AnnotationMetadata annotationMetadata) {
            this.declaringType = declaringType;
            this.requiresReflection = requiresReflection;
            this.returnType = returnType;
            this.methodName = methodName;
            this.argumentTypes = argumentTypes;
            this.argumentAnnotationMetadata = argumentAnnotationMetadata;
            this.genericTypes = genericTypes;
            this.annotationMetadata = annotationMetadata;
        }

        public Object getDeclaringType() {
            return this.declaringType;
        }

        public boolean isRequiresReflection() {
            return this.requiresReflection;
        }

        public Object getReturnType() {
            return this.returnType;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Map<String, Object> getArgumentTypes() {
            return this.argumentTypes;
        }

        public Map<String, AnnotationMetadata> getArgumentAnnotationMetadata() {
            return this.argumentAnnotationMetadata;
        }

        public Map<String, Map<String, Object>> getGenericTypes() {
            return this.genericTypes;
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.annotationMetadata;
        }
    }
}

