/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

public interface ExecutionHandle<T, R>
extends AnnotationMetadataDelegate {
    public T getTarget();

    public Class getDeclaringType();

    public Argument[] getArguments();

    public R invoke(Object ... var1);

    public static <T2, R2> MethodExecutionHandle<T2, R2> of(final T2 bean, final ExecutableMethod<T2, R2> method) {
        return new MethodExecutionHandle<T2, R2>(){

            @Override
            @Nonnull
            public ExecutableMethod<?, R2> getExecutableMethod() {
                return method;
            }

            @Override
            public T2 getTarget() {
                return bean;
            }

            @Override
            public Class getDeclaringType() {
                return bean.getClass();
            }

            @Override
            public String getMethodName() {
                return method.getMethodName();
            }

            @Override
            public Argument[] getArguments() {
                return method.getArguments();
            }

            @Override
            public Method getTargetMethod() {
                return method.getTargetMethod();
            }

            public ReturnType getReturnType() {
                return method.getReturnType();
            }

            @Override
            public R2 invoke(Object ... arguments) {
                return method.invoke(bean, arguments);
            }

            public AnnotationMetadata getAnnotationMetadata() {
                return method.getAnnotationMetadata();
            }
        };
    }
}

