/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.EnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.EnvironmentAnnotationValue;
import io.micronaut.inject.annotation.EnvironmentOptionalValuesMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractEnvironmentAnnotationMetadata
implements AnnotationMetadata {
    private final EnvironmentAnnotationMetadata environmentAnnotationMetadata;

    protected AbstractEnvironmentAnnotationMetadata(AnnotationMetadata targetMetadata) {
        this.environmentAnnotationMetadata = targetMetadata instanceof EnvironmentAnnotationMetadata ? (EnvironmentAnnotationMetadata)targetMetadata : new AnnotationMetadataHierarchy(targetMetadata);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.environmentAnnotationMetadata;
    }

    @Nullable
    public <T extends Annotation> T synthesize(@Nonnull Class<T> annotationClass) {
        return (T)this.environmentAnnotationMetadata.synthesize(annotationClass);
    }

    @Nullable
    public <T extends Annotation> T synthesizeDeclared(@Nonnull Class<T> annotationClass) {
        return (T)this.environmentAnnotationMetadata.synthesizeDeclared(annotationClass);
    }

    public <T> Optional<T> getValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return this.environmentAnnotationMetadata.getValue(annotation, member, requiredType, o -> {
                PropertyPlaceholderResolver placeholderResolver = environment.getPlaceholderResolver();
                if (o instanceof String) {
                    String v = (String)o;
                    if (v.contains("${")) {
                        return placeholderResolver.resolveRequiredPlaceholders(v);
                    }
                } else if (o instanceof String[]) {
                    return AnnotationValue.resolveStringArray((String[])((String[])o), o1 -> {
                        String v = (String)o1;
                        if (v.contains("${")) {
                            return placeholderResolver.resolveRequiredPlaceholders(v);
                        }
                        return v;
                    });
                }
                return o;
            });
        }
        return this.environmentAnnotationMetadata.getValue(annotation, member, requiredType);
    }

    public <T> Class<T>[] classValues(@Nonnull String annotation, @Nonnull String member) {
        return this.environmentAnnotationMetadata.classValues(annotation, member);
    }

    public <T> Class<T>[] classValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.environmentAnnotationMetadata.classValues(annotation, member);
    }

    public boolean isTrue(@Nonnull String annotation, @Nonnull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return this.environmentAnnotationMetadata.isTrue(annotation, member, o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return environment.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            });
        }
        return this.environmentAnnotationMetadata.isTrue(annotation, member);
    }

    public boolean isFalse(@Nonnull String annotation, @Nonnull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return !this.environmentAnnotationMetadata.isTrue(annotation, member, o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return environment.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            });
        }
        return !this.environmentAnnotationMetadata.isTrue(annotation, member);
    }

    @Nonnull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nonnull Class<? extends Annotation> stereotype) {
        return this.environmentAnnotationMetadata.getAnnotationTypeByStereotype(stereotype);
    }

    @Nonnull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nullable String stereotype) {
        return this.environmentAnnotationMetadata.getAnnotationTypeByStereotype(stereotype);
    }

    @Nonnull
    public Optional<Class> classValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.classValue(annotation, member, valueMapper);
    }

    @Nonnull
    public Optional<Class> classValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.classValue(annotation, member, valueMapper);
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull String annotation, @Nonnull String member, Class<E> enumType) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.enumValue(annotation, member, enumType, valueMapper);
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Class<E> enumType) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.enumValue(annotation, member, enumType, valueMapper);
    }

    public <E extends Enum> E[] enumValues(@Nonnull String annotation, @Nonnull String member, Class<E> enumType) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.enumValues(annotation, member, enumType, valueMapper);
    }

    public Optional<Boolean> booleanValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.booleanValue(annotation, member, valueMapper);
    }

    public Optional<Boolean> booleanValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.booleanValue(annotation, member, valueMapper);
    }

    @Nonnull
    public Optional<String> stringValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.stringValue(annotation, member, valueMapper);
    }

    @Nonnull
    public String[] stringValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            PropertyPlaceholderResolver resolver = environment.getPlaceholderResolver();
            Function<Object, Object> valueMapper = val -> {
                String[] values;
                if (val instanceof CharSequence) {
                    values = new String[]{val.toString()};
                } else if (val instanceof String[]) {
                    values = (String[])val;
                } else {
                    return null;
                }
                return Arrays.stream(values).flatMap(value -> {
                    try {
                        return Arrays.stream((Object[])resolver.resolveRequiredPlaceholder((String)value, String[].class));
                    }
                    catch (ConfigurationException e) {
                        if (value.contains(resolver.getPrefix())) {
                            value = resolver.resolveRequiredPlaceholders((String)value);
                        }
                        return Stream.of(value);
                    }
                }).toArray(String[]::new);
            };
            return this.environmentAnnotationMetadata.stringValues(annotation, member, valueMapper);
        }
        return this.environmentAnnotationMetadata.stringValues(annotation, member, null);
    }

    @Nonnull
    public Optional<String> stringValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.stringValue(annotation, member, valueMapper);
    }

    public OptionalLong longValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.longValue(annotation, member, valueMapper);
    }

    public OptionalLong longValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.longValue(annotation, member, valueMapper);
    }

    @Nonnull
    public OptionalInt intValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.intValue(annotation, member, valueMapper);
    }

    @Nonnull
    public OptionalInt intValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.intValue(annotation, member, valueMapper);
    }

    @Nonnull
    public OptionalDouble doubleValue(@Nonnull String annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.doubleValue(annotation, member, valueMapper);
    }

    @Nonnull
    public OptionalDouble doubleValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.doubleValue(annotation, member, valueMapper);
    }

    public boolean isTrue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.isTrue(annotation, member, valueMapper);
    }

    public boolean isFalse(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return !this.environmentAnnotationMetadata.isTrue(annotation, member, valueMapper);
    }

    @Nonnull
    public Optional<Class<? extends Annotation>> getAnnotationType(@Nonnull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        return this.environmentAnnotationMetadata.getAnnotationType(name);
    }

    @Nonnull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        Environment environment = this.getEnvironment();
        List values = this.environmentAnnotationMetadata.getAnnotationValuesByType(annotationType);
        if (environment != null) {
            return values.stream().map(entries -> new EnvironmentAnnotationValue(environment, entries)).collect(Collectors.toList());
        }
        return values;
    }

    @Nonnull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        Environment environment = this.getEnvironment();
        List values = this.environmentAnnotationMetadata.getDeclaredAnnotationValuesByType(annotationType);
        if (environment != null) {
            return values.stream().map(entries -> new EnvironmentAnnotationValue(environment, entries)).collect(Collectors.toList());
        }
        return values;
    }

    @Nonnull
    public <T extends Annotation> T[] synthesizeAnnotationsByType(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull((String)"annotationClass", annotationClass);
        Environment environment = this.getEnvironment();
        if (environment != null) {
            List values = this.environmentAnnotationMetadata.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, new EnvironmentAnnotationValue(environment, entries))).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return this.environmentAnnotationMetadata.synthesizeAnnotationsByType(annotationClass);
    }

    @Nonnull
    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull((String)"annotationClass", annotationClass);
        Environment environment = this.getEnvironment();
        if (environment != null) {
            List values = this.environmentAnnotationMetadata.getDeclaredAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, new EnvironmentAnnotationValue(environment, entries))).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return this.environmentAnnotationMetadata.synthesizeDeclaredAnnotationsByType(annotationClass);
    }

    public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        return this.environmentAnnotationMetadata.hasDeclaredAnnotation(annotation);
    }

    public boolean hasAnnotation(@Nullable String annotation) {
        return this.environmentAnnotationMetadata.hasAnnotation(annotation);
    }

    public boolean hasStereotype(@Nullable String annotation) {
        return this.environmentAnnotationMetadata.hasStereotype(annotation);
    }

    public boolean hasDeclaredStereotype(@Nullable String annotation) {
        return this.environmentAnnotationMetadata.hasDeclaredStereotype(annotation);
    }

    @Nonnull
    public List<String> getAnnotationNamesByStereotype(String stereotype) {
        return this.environmentAnnotationMetadata.getAnnotationNamesByStereotype(stereotype);
    }

    @Nonnull
    public Set<String> getAnnotationNames() {
        return this.environmentAnnotationMetadata.getAnnotationNames();
    }

    @Nonnull
    public Set<String> getDeclaredAnnotationNames() {
        return this.environmentAnnotationMetadata.getDeclaredAnnotationNames();
    }

    @Nonnull
    public List<String> getDeclaredAnnotationNamesByStereotype(String stereotype) {
        return this.environmentAnnotationMetadata.getDeclaredAnnotationNamesByStereotype(stereotype);
    }

    @Nonnull
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        Environment env = this.getEnvironment();
        Optional values = this.environmentAnnotationMetadata.findAnnotation(annotation);
        if (env != null) {
            return values.map(av -> new EnvironmentAnnotationValue(env, av));
        }
        return values;
    }

    @Nonnull
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        Environment env = this.getEnvironment();
        Optional values = this.environmentAnnotationMetadata.findDeclaredAnnotation(annotation);
        if (env != null) {
            return values.map(av -> new EnvironmentAnnotationValue(env, av));
        }
        return values;
    }

    @Nonnull
    public <T> OptionalValues<T> getValues(@Nonnull String annotation, @Nonnull Class<T> valueType) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"valueType", valueType);
        if (this.environmentAnnotationMetadata instanceof DefaultAnnotationMetadata) {
            Environment environment = this.getEnvironment();
            return this.resolveOptionalValuesForEnvironment(annotation, valueType, Collections.singleton(this.environmentAnnotationMetadata), environment);
        }
        if (this.environmentAnnotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy hierarchy = (AnnotationMetadataHierarchy)this.environmentAnnotationMetadata;
            Environment environment = this.getEnvironment();
            return this.resolveOptionalValuesForEnvironment(annotation, valueType, hierarchy, environment);
        }
        return OptionalValues.empty();
    }

    @Nonnull
    public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Class<T> requiredType) {
        return this.environmentAnnotationMetadata.getDefaultValue(annotation, member, requiredType);
    }

    @Nonnull
    public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        return this.environmentAnnotationMetadata.getDefaultValue(annotation, member, requiredType);
    }

    @Nullable
    protected abstract Environment getEnvironment();

    @Nullable
    private Function<Object, Object> getEnvironmentValueMapper() {
        Environment env = this.getEnvironment();
        if (env != null) {
            return o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return env.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            };
        }
        return null;
    }

    private <T> OptionalValues<T> resolveOptionalValuesForEnvironment(String annotation, Class<T> valueType, Iterable<AnnotationMetadata> metadata, Environment environment) {
        LinkedHashMap<CharSequence, Object> finalValues = new LinkedHashMap<CharSequence, Object>();
        for (AnnotationMetadata annotationMetadata : metadata) {
            if (!(annotationMetadata instanceof DefaultAnnotationMetadata)) continue;
            Map<String, Map<CharSequence, Object>> allAnnotations = ((DefaultAnnotationMetadata)annotationMetadata).allAnnotations;
            Map<String, Map<CharSequence, Object>> allStereotypes = ((DefaultAnnotationMetadata)annotationMetadata).allStereotypes;
            if (allAnnotations == null || !StringUtils.isNotEmpty((CharSequence)annotation)) continue;
            this.processMap(annotation, finalValues, allStereotypes);
            this.processMap(annotation, finalValues, allAnnotations);
        }
        if (environment != null) {
            return new EnvironmentOptionalValuesMap(valueType, finalValues, environment);
        }
        return OptionalValues.of(valueType, finalValues);
    }

    private void processMap(String annotation, Map<CharSequence, Object> finalValues, Map<String, Map<CharSequence, Object>> allStereotypes) {
        Map<CharSequence, Object> values;
        if (allStereotypes != null && (values = allStereotypes.get(annotation)) != null) {
            for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
                finalValues.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
    }
}

