/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Map;

public interface ApplicationContextBuilder {
    @NonNull
    public ApplicationContextBuilder eagerInitConfiguration(boolean var1);

    @NonNull
    public ApplicationContextBuilder eagerInitSingletons(boolean var1);

    @NonNull
    public ApplicationContextBuilder singletons(Object ... var1);

    @NonNull
    public ApplicationContextBuilder deduceEnvironment(@Nullable Boolean var1);

    @NonNull
    public ApplicationContextBuilder environments(String ... var1);

    @NonNull
    public ApplicationContextBuilder packages(String ... var1);

    @NonNull
    public ApplicationContextBuilder properties(@Nullable Map<String, Object> var1);

    @NonNull
    public ApplicationContextBuilder propertySources(PropertySource ... var1);

    @NonNull
    public ApplicationContextBuilder environmentPropertySource(boolean var1);

    @NonNull
    public ApplicationContextBuilder environmentVariableIncludes(String ... var1);

    @NonNull
    public ApplicationContextBuilder environmentVariableExcludes(String ... var1);

    @NonNull
    public ApplicationContextBuilder mainClass(@Nullable Class var1);

    @NonNull
    public ApplicationContextBuilder classLoader(@Nullable ClassLoader var1);

    @NonNull
    public ApplicationContext build();

    @NonNull
    public ApplicationContextBuilder include(String ... var1);

    @NonNull
    public ApplicationContextBuilder exclude(String ... var1);

    @NonNull
    default public ApplicationContextBuilder args(String ... args) {
        return this;
    }

    @NonNull
    default public ApplicationContext start() {
        return this.build().start();
    }

    @NonNull
    default public <T extends AutoCloseable> T run(@NonNull Class<T> type) {
        LifeCycle lifeCycle;
        ArgumentUtils.requireNonNull((String)"type", type);
        ApplicationContext applicationContext = this.start();
        AutoCloseable bean = (AutoCloseable)applicationContext.getBean(type);
        if (bean instanceof LifeCycle && !(lifeCycle = (LifeCycle)bean).isRunning()) {
            lifeCycle.start();
        }
        return (T)bean;
    }
}

