/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.Qualifier;
import io.micronaut.core.reflect.InstantiationUtils;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public interface BeanLocator {
    @NonNull
    public <T> T getBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> Optional<T> findBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> Collection<T> getBeansOfType(@NonNull Class<T> var1);

    @NonNull
    public <T> Collection<T> getBeansOfType(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> Stream<T> streamOfType(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> T getProxyTargetBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    default public <T> Stream<T> streamOfType(@NonNull Class<T> beanType) {
        return this.streamOfType(beanType, null);
    }

    @NonNull
    default public <T> T getBean(@NonNull Class<T> beanType) {
        return this.getBean(beanType, null);
    }

    @NonNull
    default public <T> Optional<T> findBean(@NonNull Class<T> beanType) {
        return this.findBean(beanType, null);
    }

    @NonNull
    default public <T> Optional<T> findOrInstantiateBean(@NonNull Class<T> beanType) {
        Optional<T> bean = this.findBean(beanType, null);
        if (bean.isPresent()) {
            return bean;
        }
        return InstantiationUtils.tryInstantiate(beanType);
    }
}

