/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.Failure;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
class DefaultConditionContext<T extends AnnotationMetadataProvider>
implements ConditionContext<T> {
    private final BeanContext beanContext;
    private final T component;
    private final List<Failure> failures = new ArrayList<Failure>(2);

    DefaultConditionContext(BeanContext beanContext, T component) {
        this.beanContext = beanContext;
        this.component = component;
    }

    @Override
    public T getComponent() {
        return this.component;
    }

    @Override
    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    @Override
    public ConditionContext<T> fail(@NonNull Failure failure) {
        this.failures.add(failure);
        return this;
    }

    public String toString() {
        return this.component.toString();
    }

    @Override
    public List<Failure> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }
}

