/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.AbstractBeanProperty;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.beans.visitor.BeanIntrospectionWriter;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Internal
class BeanPropertyWriter
extends AbstractClassFileWriter
implements Named {
    private static final Type TYPE_BEAN_PROPERTY = BeanPropertyWriter.getTypeReference(AbstractBeanProperty.class);
    private static final Method METHOD_READ_INTERNAL = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanProperty.class, (String)"readInternal", (Class[])new Class[]{Object.class}));
    private static final Method METHOD_WRITE_INTERNAL = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanProperty.class, (String)"writeInternal", (Class[])new Class[]{Object.class, Object.class}));
    private final Type propertyType;
    private final String propertyName;
    private final AnnotationMetadata annotationMetadata;
    private final Type type;
    private final ClassWriter classWriter;
    private final Map<String, ClassElement> typeArguments;
    private final Type beanType;
    private final boolean readOnly;
    private final MethodElement readMethod;
    private final MethodElement writeMethod;
    private final HashMap<String, GeneratorAdapter> loadTypeMethods = new HashMap();
    private final TypedElement typeElement;
    private final ClassElement declaringElement;

    BeanPropertyWriter(@NonNull BeanIntrospectionWriter introspectionWriter, @NonNull TypedElement typeElement, @NonNull Type propertyType, @NonNull String propertyName, @Nullable MethodElement readMethod, @Nullable MethodElement writeMethod, boolean isReadOnly, int index, @Nullable AnnotationMetadata annotationMetadata, @Nullable Map<String, ClassElement> typeArguments) {
        Type introspectionType = introspectionWriter.getIntrospectionType();
        this.declaringElement = introspectionWriter.getClassElement();
        this.typeElement = typeElement;
        this.beanType = introspectionWriter.getBeanType();
        this.propertyType = propertyType;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.propertyName = propertyName;
        this.readOnly = isReadOnly;
        this.annotationMetadata = annotationMetadata == AnnotationMetadata.EMPTY_METADATA ? null : annotationMetadata;
        this.type = BeanPropertyWriter.getTypeReference(introspectionType.getClassName() + "$$" + index);
        this.classWriter = new ClassWriter(3);
        this.typeArguments = CollectionUtils.isNotEmpty(typeArguments) ? typeArguments : null;
    }

    @NonNull
    public String getName() {
        return this.type.getClassName();
    }

    @NonNull
    public String getPropertyName() {
        return this.propertyName;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        try (OutputStream classOutput = classWriterOutputVisitor.visitClass(this.getName());){
            this.startFinalClass((ClassVisitor)this.classWriter, this.type.getInternalName(), TYPE_BEAN_PROPERTY);
            this.writeConstructor();
            this.writeReadMethod();
            this.writeWriteMethod();
            if (this.readOnly) {
                GeneratorAdapter isReadOnly = this.startPublicMethodZeroArgs(this.classWriter, Boolean.TYPE, "isReadOnly");
                isReadOnly.push(true);
                isReadOnly.returnValue();
                isReadOnly.visitMaxs(1, 1);
                isReadOnly.endMethod();
            }
            if (this.writeMethod != null && this.readMethod == null) {
                GeneratorAdapter isWriteOnly = this.startPublicMethodZeroArgs(this.classWriter, Boolean.TYPE, "isWriteOnly");
                isWriteOnly.push(true);
                isWriteOnly.returnValue();
                isWriteOnly.visitMaxs(1, 1);
                isWriteOnly.endMethod();
            }
            for (GeneratorAdapter generator : this.loadTypeMethods.values()) {
                generator.visitMaxs(3, 1);
                generator.visitEnd();
            }
            classOutput.write(this.classWriter.toByteArray());
        }
    }

    private void writeWriteMethod() {
        Type returnType;
        GeneratorAdapter writeMethod = this.startPublicMethod(this.classWriter, METHOD_WRITE_INTERNAL.getName(), Void.TYPE.getName(), Object.class.getName(), Object.class.getName());
        writeMethod.loadArg(0);
        writeMethod.checkCast(this.beanType);
        writeMethod.loadArg(1);
        BeanPropertyWriter.pushCastToType((MethodVisitor)writeMethod, this.propertyType);
        boolean hasWriteMethod = this.writeMethod != null;
        String methodName = hasWriteMethod ? this.writeMethod.getName() : NameUtils.setterNameFor((String)this.propertyName);
        Type type = returnType = hasWriteMethod ? this.getTypeForElement(this.writeMethod.getReturnType()) : Void.TYPE;
        if (this.declaringElement.isInterface()) {
            writeMethod.invokeInterface(this.beanType, new Method(methodName, BeanPropertyWriter.getMethodDescriptor(returnType, Collections.singleton(this.propertyType))));
        } else {
            writeMethod.invokeVirtual(this.beanType, new Method(methodName, BeanPropertyWriter.getMethodDescriptor(returnType, Collections.singleton(this.propertyType))));
        }
        writeMethod.visitInsn(177);
        writeMethod.visitMaxs(1, 1);
        writeMethod.visitEnd();
    }

    private void writeReadMethod() {
        String methodName;
        GeneratorAdapter readMethod = this.startPublicMethod(this.classWriter, METHOD_READ_INTERNAL.getName(), Object.class.getName(), Object.class.getName());
        readMethod.loadArg(0);
        BeanPropertyWriter.pushCastToType((MethodVisitor)readMethod, this.beanType.getClassName());
        boolean isBoolean = this.propertyType.getClassName().equals("boolean");
        String string = methodName = this.readMethod != null ? this.readMethod.getName() : NameUtils.getterNameFor((String)this.propertyName, (boolean)isBoolean);
        if (this.declaringElement.isInterface()) {
            readMethod.invokeInterface(this.beanType, new Method(methodName, BeanPropertyWriter.getMethodDescriptor(this.propertyType, Collections.emptyList())));
        } else {
            readMethod.invokeVirtual(this.beanType, new Method(methodName, BeanPropertyWriter.getMethodDescriptor(this.propertyType, Collections.emptyList())));
        }
        BeanPropertyWriter.pushBoxPrimitiveIfNecessary(this.propertyType, (MethodVisitor)readMethod);
        readMethod.returnValue();
        readMethod.visitMaxs(1, 1);
        readMethod.visitEnd();
    }

    private void writeConstructor() {
        GeneratorAdapter constructor = this.startConstructor((ClassVisitor)this.classWriter, BeanIntrospection.class);
        constructor.loadThis();
        constructor.loadArg(0);
        constructor.push(this.propertyType);
        constructor.push(this.propertyName);
        if (this.annotationMetadata != null && this.annotationMetadata instanceof DefaultAnnotationMetadata) {
            DefaultAnnotationMetadata annotationMetadata = (DefaultAnnotationMetadata)this.annotationMetadata;
            if (annotationMetadata.isEmpty()) {
                constructor.visitInsn(1);
            } else {
                AnnotationMetadataWriter.instantiateNewMetadata(this.type, this.classWriter, constructor, annotationMetadata, this.loadTypeMethods);
            }
        } else {
            constructor.visitInsn(1);
        }
        if (this.typeArguments != null) {
            BeanPropertyWriter.pushTypeArgumentElements(constructor, this.typeElement, this.typeArguments);
        } else {
            constructor.visitInsn(1);
        }
        this.invokeConstructor((MethodVisitor)constructor, AbstractBeanProperty.class, BeanIntrospection.class, Class.class, String.class, AnnotationMetadata.class, Argument[].class);
        constructor.visitInsn(177);
        constructor.visitMaxs(20, 2);
        constructor.visitEnd();
    }
}

