/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.AbstractBeanResolutionContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class DefaultBeanResolutionContext
extends AbstractBeanResolutionContext {
    private final Map<BeanIdentifier, Object> singlesInCreation = new ConcurrentHashMap<BeanIdentifier, Object>(5);

    public DefaultBeanResolutionContext(BeanContext context, BeanDefinition rootDefinition) {
        super(context, rootDefinition);
    }

    @Override
    public void close() {
        this.singlesInCreation.clear();
    }

    @Override
    public <T> void addInFlightBean(BeanIdentifier beanIdentifier, T instance) {
        this.singlesInCreation.put(beanIdentifier, instance);
    }

    @Override
    public <T> void removeInFlightBean(BeanIdentifier beanIdentifier) {
        this.singlesInCreation.remove(beanIdentifier);
    }

    @Override
    @Nullable
    public <T> T getInFlightBean(BeanIdentifier beanIdentifier) {
        return (T)this.singlesInCreation.get(beanIdentifier);
    }
}

