/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.asm.AnnotationVisitor;
import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Opcodes;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.DirectoryClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

@Internal
public abstract class AbstractClassFileWriter
implements Opcodes {
    protected static final Type TYPE_ARGUMENT = Type.getType(Argument.class);
    protected static final Type TYPE_ARGUMENT_ARRAY = Type.getType(Argument[].class);
    protected static final String ZERO_ARGUMENTS_CONSTANT = "ZERO_ARGUMENTS";
    protected static final String CONSTRUCTOR_NAME = "<init>";
    protected static final String DESCRIPTOR_DEFAULT_CONSTRUCTOR = "()V";
    protected static final Method METHOD_DEFAULT_CONSTRUCTOR = new Method("<init>", "()V");
    protected static final Type TYPE_OBJECT = Type.getType(Object.class);
    protected static final Type TYPE_CLASS = Type.getType(Class.class);
    protected static final int DEFAULT_MAX_STACK = 13;
    protected static final Type TYPE_GENERATED = Type.getType(Generated.class);
    protected static final Map<String, String> NAME_TO_TYPE_MAP = new HashMap<String, String>();
    private static final Method METHOD_CREATE_ARGUMENT_SIMPLE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"of", (Class[])new Class[]{Class.class, String.class}));
    private static final Method METHOD_CREATE_ARGUMENT_WITH_GENERICS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"of", (Class[])new Class[]{Class.class, String.class, Argument[].class}));
    private static final Method METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_GENERICS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Argument.class, (String)"of", (Class[])new Class[]{Class.class, String.class, AnnotationMetadata.class, Argument[].class}));
    protected final Element originatingElement;

    protected AbstractClassFileWriter(Element originatingElement) {
        this.originatingElement = originatingElement;
    }

    protected static void pushTypeArgumentElements(GeneratorAdapter generatorAdapter, TypedElement declaringElement, Map<String, ClassElement> types) {
        if (types == null || types.isEmpty()) {
            generatorAdapter.visitInsn(1);
            return;
        }
        HashSet<String> visitedTypes = new HashSet<String>(5);
        AbstractClassFileWriter.pushTypeArgumentElements(generatorAdapter, declaringElement, types, visitedTypes);
    }

    private static void pushTypeArgumentElements(GeneratorAdapter generatorAdapter, TypedElement declaringElement, Map<String, ClassElement> types, Set<String> visitedTypes) {
        if (visitedTypes.contains(declaringElement.getName())) {
            generatorAdapter.getStatic(TYPE_ARGUMENT, ZERO_ARGUMENTS_CONSTANT, TYPE_ARGUMENT_ARRAY);
        } else {
            visitedTypes.add(declaringElement.getName());
            int len = types.size();
            AbstractClassFileWriter.pushNewArray(generatorAdapter, Argument.class, len);
            int i = 0;
            for (Map.Entry<String, ClassElement> entry : types.entrySet()) {
                generatorAdapter.push(i);
                String argumentName = entry.getKey();
                ClassElement classElement = entry.getValue();
                Object classReference = AbstractClassFileWriter.toClassReference(classElement);
                Map<String, ClassElement> typeArguments = null;
                if (!classElement.getName().equals(declaringElement.getName())) {
                    typeArguments = classElement.getTypeArguments();
                }
                if (CollectionUtils.isNotEmpty(typeArguments)) {
                    AbstractClassFileWriter.buildArgumentWithGenerics(generatorAdapter, argumentName, classReference, classElement, typeArguments, visitedTypes);
                } else {
                    AbstractClassFileWriter.buildArgument(generatorAdapter, argumentName, classReference);
                }
                generatorAdapter.visitInsn(83);
                if (i != len - 1) {
                    generatorAdapter.visitInsn(89);
                }
                ++i;
            }
        }
    }

    private static Object toClassReference(ClassElement classElement) {
        String n = classElement.getName();
        Object classReference = classElement.isPrimitive() ? (classElement.isArray() ? ClassUtils.arrayTypeForPrimitive((String)n).map(t -> t).orElse(n) : ClassUtils.getPrimitiveType((String)n).map(t -> t).orElse(n)) : (classElement.isArray() ? n + "[]" : n);
        return classReference;
    }

    protected static void pushTypeArguments(GeneratorAdapter generatorAdapter, Map<String, Object> types) {
        if (types == null || types.isEmpty()) {
            generatorAdapter.visitInsn(1);
            return;
        }
        int len = types.size();
        AbstractClassFileWriter.pushNewArray(generatorAdapter, Argument.class, len);
        int i = 0;
        for (Map.Entry<String, Object> entry : types.entrySet()) {
            generatorAdapter.push(i);
            String typeParameterName = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                AbstractClassFileWriter.buildArgumentWithGenerics(generatorAdapter, typeParameterName, (Map)value);
            } else {
                AbstractClassFileWriter.buildArgument(generatorAdapter, typeParameterName, value);
            }
            generatorAdapter.visitInsn(83);
            if (i != len - 1) {
                generatorAdapter.visitInsn(89);
            }
            ++i;
        }
    }

    protected static void buildArgument(GeneratorAdapter generatorAdapter, String argumentName, Object objectType) {
        generatorAdapter.push(AbstractClassFileWriter.getTypeReference(objectType));
        generatorAdapter.push(argumentName);
        AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_SIMPLE);
    }

    private static void buildArgumentWithGenerics(GeneratorAdapter generatorAdapter, String argumentName, Object typeReference, ClassElement classElement, Map<String, ClassElement> typeArguments, Set<String> visitedTypes) {
        generatorAdapter.push(AbstractClassFileWriter.getTypeReference(typeReference));
        generatorAdapter.push(argumentName);
        AbstractClassFileWriter.pushTypeArgumentElements(generatorAdapter, classElement, typeArguments, visitedTypes);
        AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_WITH_GENERICS);
    }

    static void buildArgumentWithGenerics(GeneratorAdapter generatorAdapter, String argumentName, Map nestedTypeObject) {
        boolean hasGenerics;
        Object objectType;
        Map nestedTypes = null;
        Optional nestedEntry = nestedTypeObject.entrySet().stream().findFirst();
        if (nestedEntry.isPresent()) {
            Map.Entry data = (Map.Entry)nestedEntry.get();
            Object key = data.getKey();
            Object map = data.getValue();
            objectType = key;
            if (map instanceof Map) {
                nestedTypes = (Map)map;
            }
        } else {
            throw new IllegalArgumentException("Must be a map with a single key containing the argument type and a map of generics as the value");
        }
        generatorAdapter.push(AbstractClassFileWriter.getTypeReference(objectType));
        generatorAdapter.push(argumentName);
        boolean bl = hasGenerics = nestedTypes != null && !nestedTypes.isEmpty();
        if (hasGenerics) {
            AbstractClassFileWriter.pushTypeArguments(generatorAdapter, nestedTypes);
        }
        AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, hasGenerics ? METHOD_CREATE_ARGUMENT_WITH_GENERICS : METHOD_CREATE_ARGUMENT_SIMPLE);
    }

    protected static void pushBuildArgumentsForMethod(Type owningType, ClassWriter declaringClassWriter, GeneratorAdapter generatorAdapter, Map<String, Object> argumentTypes, Map<String, AnnotationMetadata> argumentAnnotationMetadata, Map<String, Map<String, Object>> genericTypes, Map<String, GeneratorAdapter> loadTypeMethods) {
        int len = argumentTypes.size();
        AbstractClassFileWriter.pushNewArray(generatorAdapter, Argument.class, len);
        int i = 0;
        for (Map.Entry<String, Object> entry : argumentTypes.entrySet()) {
            generatorAdapter.push(i);
            String argumentName = entry.getKey();
            Object value = entry.getValue();
            Type argumentType = value instanceof Map ? AbstractClassFileWriter.getTypeReference(((Map)value).keySet().iterator().next()) : AbstractClassFileWriter.getTypeReference(value);
            generatorAdapter.push(argumentType);
            generatorAdapter.push(argumentName);
            AnnotationMetadata annotationMetadata = argumentAnnotationMetadata.get(argumentName);
            if (annotationMetadata == null || annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
                generatorAdapter.visitInsn(1);
            } else {
                AnnotationMetadataWriter.instantiateNewMetadata(owningType, declaringClassWriter, generatorAdapter, (DefaultAnnotationMetadata)annotationMetadata, loadTypeMethods);
            }
            if (genericTypes != null && genericTypes.containsKey(argumentName)) {
                Map<String, Object> types = genericTypes.get(argumentName);
                AbstractClassFileWriter.pushTypeArguments(generatorAdapter, types);
            } else {
                generatorAdapter.visitInsn(1);
            }
            AbstractClassFileWriter.invokeInterfaceStaticMethod((MethodVisitor)generatorAdapter, Argument.class, METHOD_CREATE_ARGUMENT_WITH_ANNOTATION_METADATA_GENERICS);
            generatorAdapter.visitInsn(83);
            if (i != len - 1) {
                generatorAdapter.visitInsn(89);
            }
            ++i;
        }
    }

    public void writeTo(File targetDir) throws IOException {
        this.accept(this.newClassWriterOutputVisitor(targetDir));
    }

    protected Type getTypeForElement(@NonNull TypedElement type) {
        String typeName = type.getName();
        Optional pt = type.isPrimitive() ? (type.isArray() ? ClassUtils.arrayTypeForPrimitive((String)typeName) : ClassUtils.getPrimitiveType((String)typeName)) : Optional.empty();
        Type propertyType = pt.isPresent() ? AbstractClassFileWriter.getTypeReference(pt.get()) : (type.isArray() ? AbstractClassFileWriter.getTypeReference(typeName + "[]") : AbstractClassFileWriter.getTypeReference(typeName));
        return propertyType;
    }

    @NotNull
    protected Map<String, Object> toTypeArguments(@NotNull Map<String, ClassElement> typeArguments) {
        HashSet<String> visitedTypes = new HashSet<String>(5);
        return this.toTypeArguments(typeArguments, visitedTypes);
    }

    @NotNull
    private Map<String, Object> toTypeArguments(@NotNull Map<String, ClassElement> typeArguments, Set<String> visitedTypes) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(typeArguments.size());
        for (Map.Entry<String, ClassElement> entry : typeArguments.entrySet()) {
            ClassElement ce = entry.getValue();
            String className = ce.getName();
            if (visitedTypes.contains(entry.getKey())) continue;
            visitedTypes.add(entry.getKey());
            Map<String, ClassElement> subArgs = ce.getTypeArguments();
            if (CollectionUtils.isNotEmpty(subArgs)) {
                Map<String, Object> m = this.toTypeArguments(subArgs, visitedTypes);
                if (CollectionUtils.isNotEmpty(m)) {
                    map.put(entry.getKey(), m);
                    continue;
                }
                map.put(entry.getKey(), Collections.singletonMap(entry.getKey(), className));
                continue;
            }
            Type typeReference = this.getTypeForElement(ce);
            map.put(entry.getKey(), typeReference);
        }
        return map;
    }

    @NotNull
    protected Map<String, Map<String, Object>> toTypeArguments(ParameterElement ... parameters) {
        LinkedHashMap<String, Map<String, Object>> map = new LinkedHashMap<String, Map<String, Object>>(parameters.length);
        for (ParameterElement ce : parameters) {
            ClassElement type = ce.getType();
            Map<String, ClassElement> subArgs = type.getTypeArguments();
            if (!CollectionUtils.isNotEmpty(subArgs)) continue;
            map.put(ce.getName(), this.toTypeArguments(subArgs));
        }
        return map;
    }

    @NotNull
    protected Map<String, Object> toParameterTypes(ParameterElement ... parameters) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(parameters.length);
        for (ParameterElement ce : parameters) {
            ClassElement type = ce.getType();
            if (type == null) continue;
            Type typeReference = this.getTypeForElement(type);
            map.put(ce.getName(), typeReference);
        }
        return map;
    }

    protected void writeBooleanMethod(ClassWriter classWriter, String methodName, Supplier<Boolean> valueSupplier) {
        GeneratorAdapter isSingletonMethod = this.startPublicMethodZeroArgs(classWriter, Boolean.TYPE, methodName);
        isSingletonMethod.loadThis();
        isSingletonMethod.push(valueSupplier.get().booleanValue());
        isSingletonMethod.returnValue();
        isSingletonMethod.visitMaxs(1, 1);
        isSingletonMethod.visitEnd();
    }

    @Nullable
    public Element getOriginatingElement() {
        return this.originatingElement;
    }

    public abstract void accept(ClassWriterOutputVisitor var1) throws IOException;

    protected static String getTypeDescriptor(Object type) {
        if (type instanceof Class) {
            return Type.getDescriptor((Class)((Class)type));
        }
        if (type instanceof Type) {
            return ((Type)type).getDescriptor();
        }
        String className = type.toString();
        return AbstractClassFileWriter.getTypeDescriptor(className, new String[0]);
    }

    protected static Type getTypeReferenceForName(String className, String ... genericTypes) {
        String referenceString = AbstractClassFileWriter.getTypeDescriptor(className, genericTypes);
        return Type.getType((String)referenceString);
    }

    protected static Type getTypeReference(Object type) {
        if (type instanceof Type) {
            return (Type)type;
        }
        if (type instanceof Class) {
            return Type.getType((Class)((Class)type));
        }
        if (type instanceof String) {
            String className = type.toString();
            String internalName = AbstractClassFileWriter.getInternalName(className);
            if (className.endsWith("[]")) {
                internalName = "[L" + internalName + ";";
            }
            return Type.getObjectType((String)internalName);
        }
        throw new IllegalArgumentException("Type reference [" + type + "] should be a Class or a String representing the class name");
    }

    protected static void pushBoxPrimitiveIfNecessary(Object fieldType, MethodVisitor injectMethodVisitor) {
        if (fieldType instanceof Type) {
            Type t = (Type)fieldType;
            Optional pt = ClassUtils.getPrimitiveType((String)t.getClassName());
            Class wrapperType = pt.map(ReflectionUtils::getWrapperType).orElse(null);
            if (wrapperType != null) {
                Type wrapper = Type.getType((Class)wrapperType);
                String primitiveName = t.getClassName();
                String sig = wrapperType.getName() + " valueOf(" + primitiveName + ")";
                Method valueOfMethod = Method.getMethod((String)sig);
                injectMethodVisitor.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", valueOfMethod.getDescriptor(), false);
            }
        } else {
            Class wrapperType = AbstractClassFileWriter.getWrapperType(fieldType);
            if (wrapperType != null) {
                Class primitiveType = (Class)fieldType;
                Type wrapper = Type.getType((Class)wrapperType);
                String primitiveName = primitiveType.getName();
                String sig = wrapperType.getName() + " valueOf(" + primitiveName + ")";
                Method valueOfMethod = Method.getMethod((String)sig);
                injectMethodVisitor.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", valueOfMethod.getDescriptor(), false);
            }
        }
    }

    protected static void pushCastToType(MethodVisitor methodVisitor, Object type) {
        Optional pt;
        String internalName = AbstractClassFileWriter.getInternalNameForCast(type);
        methodVisitor.visitTypeInsn(192, internalName);
        Type primitiveType = null;
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            if (typeClass.isPrimitive()) {
                primitiveType = Type.getType((Class)typeClass);
            }
        } else if (type instanceof Type && (pt = ClassUtils.getPrimitiveType((String)((Type)type).getClassName())).isPresent()) {
            primitiveType = Type.getType((Class)((Class)pt.get()));
        }
        if (primitiveType != null) {
            Method valueMethod = null;
            switch (primitiveType.getSort()) {
                case 1: {
                    valueMethod = Method.getMethod((String)"boolean booleanValue()");
                    break;
                }
                case 2: {
                    valueMethod = Method.getMethod((String)"char charValue()");
                    break;
                }
                case 3: {
                    valueMethod = Method.getMethod((String)"byte byteValue()");
                    break;
                }
                case 4: {
                    valueMethod = Method.getMethod((String)"short shortValue()");
                    break;
                }
                case 5: {
                    valueMethod = Method.getMethod((String)"int intValue()");
                    break;
                }
                case 7: {
                    valueMethod = Method.getMethod((String)"long longValue()");
                    break;
                }
                case 8: {
                    valueMethod = Method.getMethod((String)"double doubleValue()");
                    break;
                }
                case 6: {
                    valueMethod = Method.getMethod((String)"float floatValue()");
                    break;
                }
            }
            if (valueMethod != null) {
                methodVisitor.visitMethodInsn(182, internalName, valueMethod.getName(), valueMethod.getDescriptor(), false);
            }
        }
    }

    protected static void pushReturnValue(MethodVisitor methodVisitor, Object type) {
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            if (typeClass.isPrimitive()) {
                Type primitiveType = Type.getType((Class)typeClass);
                switch (primitiveType.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        methodVisitor.visitInsn(172);
                        break;
                    }
                    case 0: {
                        methodVisitor.visitInsn(177);
                        break;
                    }
                    case 7: {
                        methodVisitor.visitInsn(173);
                        break;
                    }
                    case 8: {
                        methodVisitor.visitInsn(175);
                        break;
                    }
                    case 6: {
                        methodVisitor.visitInsn(174);
                        break;
                    }
                }
            } else {
                methodVisitor.visitInsn(176);
            }
        } else {
            methodVisitor.visitInsn(176);
        }
    }

    protected static Class getWrapperType(Object type) {
        if (AbstractClassFileWriter.isPrimitive(type)) {
            return ReflectionUtils.getWrapperType((Class)((Class)type));
        }
        return null;
    }

    protected static boolean isPrimitive(Object type) {
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            return typeClass.isPrimitive();
        }
        return false;
    }

    protected static void pushMethodNameAndTypesArguments(GeneratorAdapter methodVisitor, String methodName, Collection<Object> argumentTypes) {
        methodVisitor.visitLdcInsn((Object)methodName);
        int argTypeCount = argumentTypes.size();
        if (!argumentTypes.isEmpty()) {
            AbstractClassFileWriter.pushNewArray(methodVisitor, Class.class, argTypeCount);
            Iterator<Object> argIterator = argumentTypes.iterator();
            for (int i = 0; i < argTypeCount; ++i) {
                AbstractClassFileWriter.pushStoreTypeInArray(methodVisitor, i, argTypeCount, argIterator.next());
            }
        } else {
            AbstractClassFileWriter.pushNewArray(methodVisitor, Class.class, 0);
        }
    }

    protected static void pushNewArray(GeneratorAdapter methodVisitor, Class arrayType, int size) {
        methodVisitor.push(size);
        methodVisitor.visitTypeInsn(189, Type.getInternalName((Class)arrayType));
        if (size > 0) {
            methodVisitor.visitInsn(89);
        }
    }

    protected static void pushStoreStringInArray(GeneratorAdapter methodVisitor, int index, int size, String string) {
        methodVisitor.push(index);
        methodVisitor.push(string);
        methodVisitor.visitInsn(83);
        if (index != size - 1) {
            methodVisitor.dup();
        }
    }

    protected static void pushStoreInArray(GeneratorAdapter methodVisitor, int index, int size, Runnable runnable) {
        methodVisitor.push(index);
        runnable.run();
        methodVisitor.visitInsn(83);
        if (index != size - 1) {
            methodVisitor.dup();
        }
    }

    protected static void pushStoreTypeInArray(GeneratorAdapter methodVisitor, int index, int size, Object type) {
        methodVisitor.push(index);
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            if (typeClass.isPrimitive()) {
                Type wrapperType = Type.getType((Class)ReflectionUtils.getWrapperType((Class)typeClass));
                methodVisitor.visitFieldInsn(178, wrapperType.getInternalName(), "TYPE", Type.getDescriptor(Class.class));
            } else {
                methodVisitor.push(Type.getType((Class)typeClass));
            }
        } else {
            methodVisitor.push(AbstractClassFileWriter.getObjectType(type.toString()));
        }
        methodVisitor.arrayStore(TYPE_CLASS);
        if (index < size - 1) {
            methodVisitor.dup();
        }
    }

    protected Type[] getObjectTypes(Collection types) {
        Type[] converted = new Type[types.size()];
        Iterator iter = types.iterator();
        for (int i = 0; i < converted.length; ++i) {
            Object type = iter.next();
            converted[i] = AbstractClassFileWriter.getObjectType(type);
        }
        return converted;
    }

    protected static Type getObjectType(Object type) {
        if (type instanceof Class) {
            return Type.getType((Class)((Class)type));
        }
        if (type instanceof String) {
            String className = type.toString();
            String internalName = AbstractClassFileWriter.getTypeDescriptor(className);
            return Type.getType((String)internalName);
        }
        throw new IllegalArgumentException("Type reference [" + type + "] should be a Class or a String representing the class name");
    }

    protected static String getTypeDescriptor(String className, String ... genericTypes) {
        if (NAME_TO_TYPE_MAP.containsKey(className)) {
            return NAME_TO_TYPE_MAP.get(className);
        }
        String internalName = AbstractClassFileWriter.getInternalName(className);
        StringBuilder start = className.endsWith("[]") ? new StringBuilder("[L" + internalName) : new StringBuilder('L' + internalName);
        if (genericTypes != null && genericTypes.length > 0) {
            start.append('<');
            for (String genericType : genericTypes) {
                start.append(AbstractClassFileWriter.getTypeDescriptor(genericType));
            }
            start.append('>');
        }
        return start.append(';').toString();
    }

    protected static String getMethodDescriptor(String returnType, String ... argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (String argumentType : argumentTypes) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        builder.append(")");
        builder.append(AbstractClassFileWriter.getTypeDescriptor(returnType));
        return builder.toString();
    }

    protected static String getMethodDescriptor(Object returnType, Collection<Object> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Object argumentType : argumentTypes) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        builder.append(")");
        builder.append(AbstractClassFileWriter.getTypeDescriptor(returnType));
        return builder.toString();
    }

    protected static String getMethodSignature(String returnTypeReference, String ... argReferenceTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (String argumentType : argReferenceTypes) {
            builder.append(argumentType);
        }
        builder.append(")");
        builder.append(returnTypeReference);
        return builder.toString();
    }

    protected static String getConstructorDescriptor(Object ... argumentTypes) {
        return AbstractClassFileWriter.getConstructorDescriptor(Arrays.asList(argumentTypes));
    }

    protected static String getConstructorDescriptor(Collection<Object> argList) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Object argumentType : argList) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        return builder.append(")V").toString();
    }

    protected void writeClassToDisk(File targetDir, ClassWriter classWriter, String className) throws IOException {
        if (targetDir != null) {
            String fileName = className.replace('.', '/') + ".class";
            File targetFile = new File(targetDir, fileName);
            targetFile.getParentFile().mkdirs();
            try (OutputStream outputStream = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
                this.writeClassToDisk(outputStream, classWriter);
            }
        }
    }

    protected void writeClassToDisk(OutputStream out, ClassWriter classWriter) throws IOException {
        byte[] bytes = classWriter.toByteArray();
        out.write(bytes);
    }

    protected GeneratorAdapter startConstructor(ClassVisitor classWriter) {
        MethodVisitor defaultConstructor = classWriter.visitMethod(1, CONSTRUCTOR_NAME, DESCRIPTOR_DEFAULT_CONSTRUCTOR, null, null);
        return new GeneratorAdapter(defaultConstructor, 1, CONSTRUCTOR_NAME, DESCRIPTOR_DEFAULT_CONSTRUCTOR);
    }

    protected GeneratorAdapter startConstructor(ClassVisitor classWriter, Object ... argumentTypes) {
        String descriptor = AbstractClassFileWriter.getConstructorDescriptor(argumentTypes);
        return new GeneratorAdapter(classWriter.visitMethod(1, CONSTRUCTOR_NAME, descriptor, null, null), 1, CONSTRUCTOR_NAME, descriptor);
    }

    protected void startClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(52, 4096, className, null, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void startPublicClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(52, 4097, className, null, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void startService(ClassVisitor classWriter, Class<?> serviceType, String internalClassName, Type superType) {
        this.startService(classWriter, serviceType.getName(), internalClassName, superType);
    }

    protected void startService(ClassVisitor classWriter, String serviceName, String internalClassName, Type superType) {
        classWriter.visit(52, 4113, internalClassName, null, superType.getInternalName(), null);
        AnnotationVisitor annotationVisitor = classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
        annotationVisitor.visit("service", (Object)serviceName);
        annotationVisitor.visitEnd();
    }

    protected void startFinalClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(52, 4112, className, null, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void startPublicFinalClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(52, 4113, className, null, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void startClass(ClassWriter classWriter, String className, Type superType, String genericSignature) {
        classWriter.visit(52, 4096, className, genericSignature, superType.getInternalName(), null);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
    }

    protected void invokeConstructor(MethodVisitor cv, Class superClass, Class ... argumentTypes) {
        try {
            Type superType = Type.getType((Class)superClass);
            Type superConstructor = Type.getType(superClass.getDeclaredConstructor(argumentTypes));
            cv.visitMethodInsn(183, superType.getInternalName(), CONSTRUCTOR_NAME, superConstructor.getDescriptor(), false);
        }
        catch (NoSuchMethodException e) {
            throw new ClassGenerationException("Micronaut version on compile classpath doesn't match", e);
        }
    }

    protected static void invokeInterfaceStaticMethod(MethodVisitor visitor, Class targetType, Method method) {
        Type type = Type.getType((Class)targetType);
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        visitor.visitMethodInsn(184, owner, method.getName(), method.getDescriptor(), true);
    }

    protected GeneratorAdapter startPublicMethodZeroArgs(ClassWriter classWriter, Class returnType, String methodName) {
        Type methodType = Type.getMethodType((Type)Type.getType((Class)returnType), (Type[])new Type[0]);
        return new GeneratorAdapter(classWriter.visitMethod(1, methodName, methodType.getDescriptor(), null, null), 1, methodName, methodType.getDescriptor());
    }

    protected GeneratorAdapter startPublicFinalMethodZeroArgs(ClassWriter classWriter, Class returnType, String methodName) {
        Type methodType = Type.getMethodType((Type)Type.getType((Class)returnType), (Type[])new Type[0]);
        return new GeneratorAdapter(classWriter.visitMethod(17, methodName, methodType.getDescriptor(), null, null), 1, methodName, methodType.getDescriptor());
    }

    protected static String getInternalName(String className) {
        String newClassName = className.replace('.', '/');
        if (newClassName.endsWith("[]")) {
            return newClassName.substring(0, newClassName.length() - 2);
        }
        return newClassName;
    }

    protected static String getInternalNameForCast(Object type) {
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            if (typeClass.isPrimitive()) {
                typeClass = ReflectionUtils.getWrapperType((Class)typeClass);
            }
            return Type.getInternalName((Class)typeClass);
        }
        if (type instanceof Type) {
            Type t = (Type)type;
            Optional pt = ClassUtils.getPrimitiveType((String)t.getClassName());
            if (pt.isPresent()) {
                return Type.getInternalName((Class)ReflectionUtils.getWrapperType((Class)((Class)pt.get())));
            }
            return t.getInternalName();
        }
        String className = type.toString();
        if (className.endsWith("[]")) {
            return AbstractClassFileWriter.getTypeDescriptor(type);
        }
        return AbstractClassFileWriter.getInternalName(className);
    }

    protected String getClassFileName(String className) {
        return className.replace('.', File.separatorChar) + ".class";
    }

    protected ClassWriterOutputVisitor newClassWriterOutputVisitor(File compilationDir) {
        return new DirectoryClassWriterOutputVisitor(compilationDir);
    }

    protected void returnVoid(GeneratorAdapter overriddenMethodGenerator) {
        overriddenMethodGenerator.pop();
        overriddenMethodGenerator.visitInsn(177);
    }

    protected GeneratorAdapter visitStaticInitializer(ClassVisitor classWriter) {
        MethodVisitor mv = classWriter.visitMethod(8, "<clinit>", DESCRIPTOR_DEFAULT_CONSTRUCTOR, null, null);
        return new GeneratorAdapter(mv, 8, "<clinit>", DESCRIPTOR_DEFAULT_CONSTRUCTOR);
    }

    protected GeneratorAdapter startPublicMethod(ClassWriter writer, String methodName, String returnType, String ... argumentTypes) {
        return new GeneratorAdapter(writer.visitMethod(1, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes), null, null), 1, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes));
    }

    protected GeneratorAdapter startProtectedMethod(ClassWriter writer, String methodName, String returnType, String ... argumentTypes) {
        return new GeneratorAdapter(writer.visitMethod(4, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes), null, null), 4, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes));
    }

    protected void generateServiceDescriptor(String className, GeneratedFile generatedFile) throws IOException {
        CharSequence contents = generatedFile.getTextContent();
        if (contents != null) {
            String[] entries = contents.toString().split("\\n");
            if (!Arrays.asList(entries).contains(className)) {
                try (BufferedWriter w = new BufferedWriter(generatedFile.openWriter());){
                    w.newLine();
                    w.write(className);
                }
            }
        } else {
            try (BufferedWriter w = new BufferedWriter(generatedFile.openWriter());){
                w.write(className);
            }
        }
    }

    protected void pushNewInstance(GeneratorAdapter generatorAdapter, Type typeToInstantiate) {
        generatorAdapter.newInstance(typeToInstantiate);
        generatorAdapter.dup();
        generatorAdapter.invokeConstructor(typeToInstantiate, METHOD_DEFAULT_CONSTRUCTOR);
    }

    static {
        NAME_TO_TYPE_MAP.put("void", "V");
        NAME_TO_TYPE_MAP.put("boolean", "Z");
        NAME_TO_TYPE_MAP.put("char", "C");
        NAME_TO_TYPE_MAP.put("int", "I");
        NAME_TO_TYPE_MAP.put("byte", "B");
        NAME_TO_TYPE_MAP.put("long", "J");
        NAME_TO_TYPE_MAP.put("double", "D");
        NAME_TO_TYPE_MAP.put("float", "F");
    }
}

