/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public interface ClassElement
extends TypedElement {
    public boolean isAssignable(String var1);

    default public boolean isEnum() {
        return this instanceof EnumElement;
    }

    @NonNull
    default public Optional<MethodElement> getPrimaryConstructor() {
        return Optional.empty();
    }

    @NonNull
    default public Optional<MethodElement> getDefaultConstructor() {
        return Optional.empty();
    }

    default public Optional<ClassElement> getSuperType() {
        return Optional.empty();
    }

    @Override
    @NonNull
    default public ClassElement getType() {
        return this;
    }

    @Override
    default public String getSimpleName() {
        return NameUtils.getSimpleName((String)this.getName());
    }

    default public String getPackageName() {
        return NameUtils.getPackageName((String)this.getName());
    }

    default public List<PropertyElement> getBeanProperties() {
        return Collections.emptyList();
    }

    default public List<FieldElement> getFields() {
        return this.getFields(modifiers -> true);
    }

    default public List<FieldElement> getFields(@NonNull Predicate<Set<ElementModifier>> modifierFilter) {
        return Collections.emptyList();
    }

    @Override
    default public boolean isAbstract() {
        return false;
    }

    default public boolean isInterface() {
        return false;
    }

    @Override
    default public boolean isArray() {
        return false;
    }

    default public boolean isIterable() {
        return this.isArray() || this.isAssignable(Iterable.class);
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        return Collections.emptyMap();
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments(@NonNull Class<?> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return this.getTypeArguments(type.getName());
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments() {
        return Collections.emptyMap();
    }

    default public Optional<ClassElement> getFirstTypeArgument() {
        return this.getTypeArguments().values().stream().findFirst();
    }

    default public boolean isAssignable(Class<?> type) {
        return this.isAssignable(type.getName());
    }
}

