/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.env.CommandLinePropertySource;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.cli.CommandLine;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DefaultApplicationContextBuilder
implements ApplicationContextBuilder,
ApplicationContextConfiguration {
    private List<Object> singletons = new ArrayList<Object>();
    private List<String> environments = new ArrayList<String>();
    private List<String> packages = new ArrayList<String>();
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private List<PropertySource> propertySources = new ArrayList<PropertySource>();
    private Collection<String> configurationIncludes = new HashSet<String>();
    private Collection<String> configurationExcludes = new HashSet<String>();
    private Boolean deduceEnvironments = null;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private boolean envPropertySource = true;
    private List<String> envVarIncludes = new ArrayList<String>();
    private List<String> envVarExcludes = new ArrayList<String>();
    private String[] args = new String[0];
    private Set<Class<? extends Annotation>> eagerInitAnnotated = new HashSet<Class<? extends Annotation>>(3);
    private String[] overrideConfigLocations;

    protected DefaultApplicationContextBuilder() {
    }

    @Override
    @NonNull
    public ApplicationContextBuilder eagerInitAnnotated(Class<? extends Annotation> ... annotations) {
        if (annotations != null) {
            this.eagerInitAnnotated.addAll(Arrays.asList(annotations));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder overrideConfigLocations(String ... configLocations) {
        this.overrideConfigLocations = configLocations;
        return this;
    }

    @Override
    @Nullable
    public List<String> getOverrideConfigLocations() {
        return this.overrideConfigLocations == null ? null : Arrays.asList(this.overrideConfigLocations);
    }

    @Override
    public Set<Class<? extends Annotation>> getEagerInitAnnotated() {
        return Collections.unmodifiableSet(this.eagerInitAnnotated);
    }

    @Override
    @NonNull
    public ApplicationContextBuilder singletons(Object ... beans) {
        if (beans != null) {
            this.singletons.addAll(Arrays.asList(beans));
        }
        return this;
    }

    @Override
    @NonNull
    public ClassPathResourceLoader getResourceLoader() {
        if (this.classLoader != null) {
            return ClassPathResourceLoader.defaultLoader((ClassLoader)this.classLoader);
        }
        return ClassPathResourceLoader.defaultLoader((ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    @NonNull
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder deduceEnvironment(@Nullable Boolean deduceEnvironments) {
        this.deduceEnvironments = deduceEnvironments;
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder environments(String ... environments) {
        if (environments != null) {
            this.environments.addAll(Arrays.asList(environments));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder packages(String ... packages) {
        if (packages != null) {
            this.packages.addAll(Arrays.asList(packages));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder properties(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder propertySources(PropertySource ... propertySources) {
        if (propertySources != null) {
            this.propertySources.addAll(Arrays.asList(propertySources));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder environmentPropertySource(boolean environmentPropertySource) {
        this.envPropertySource = environmentPropertySource;
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder environmentVariableIncludes(String ... environmentVariables) {
        if (environmentVariables != null) {
            this.envVarIncludes.addAll(Arrays.asList(environmentVariables));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder environmentVariableExcludes(String ... environmentVariables) {
        if (environmentVariables != null) {
            this.envVarExcludes.addAll(Arrays.asList(environmentVariables));
        }
        return this;
    }

    @Override
    public Optional<Boolean> getDeduceEnvironments() {
        return Optional.ofNullable(this.deduceEnvironments);
    }

    @Override
    @NonNull
    public List<String> getEnvironments() {
        return this.environments;
    }

    @Override
    public boolean isEnvironmentPropertySource() {
        return this.envPropertySource;
    }

    @Override
    @Nullable
    public List<String> getEnvironmentVariableIncludes() {
        return this.envVarIncludes.isEmpty() ? null : this.envVarIncludes;
    }

    @Override
    @Nullable
    public List<String> getEnvironmentVariableExcludes() {
        return this.envVarExcludes.isEmpty() ? null : this.envVarExcludes;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder mainClass(Class mainClass) {
        if (mainClass != null) {
            String name;
            if (this.classLoader == null) {
                this.classLoader = mainClass.getClassLoader();
            }
            if (StringUtils.isNotEmpty((CharSequence)(name = mainClass.getPackage().getName()))) {
                this.packages(name);
            }
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder classLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder args(String ... args) {
        if (args != null) {
            this.args = args;
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContext build() {
        ApplicationContext applicationContext = this.newApplicationContext();
        Environment environment = applicationContext.getEnvironment();
        if (!this.packages.isEmpty()) {
            for (String aPackage : this.packages) {
                environment.addPackage(aPackage);
            }
        }
        if (!this.properties.isEmpty()) {
            PropertySource contextProperties = PropertySource.of("context", this.properties, 0);
            environment.addPropertySource(contextProperties);
        }
        if (this.args.length > 0) {
            CommandLine commandLine = CommandLine.parse((String[])this.args);
            environment.addPropertySource(new CommandLinePropertySource(commandLine));
        }
        if (!this.propertySources.isEmpty()) {
            for (PropertySource propertySource : this.propertySources) {
                environment.addPropertySource(propertySource);
            }
        }
        if (!this.singletons.isEmpty()) {
            for (Object singleton : this.singletons) {
                applicationContext.registerSingleton(singleton);
            }
        }
        if (!this.configurationIncludes.isEmpty()) {
            environment.addConfigurationIncludes(this.configurationIncludes.toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        if (!this.configurationExcludes.isEmpty()) {
            environment.addConfigurationExcludes(this.configurationExcludes.toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        return applicationContext;
    }

    @NonNull
    protected ApplicationContext newApplicationContext() {
        return new DefaultApplicationContext(this);
    }

    @Override
    @NonNull
    public ApplicationContextBuilder include(String ... configurations) {
        if (configurations != null) {
            this.configurationIncludes.addAll(Arrays.asList(configurations));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder exclude(String ... configurations) {
        if (configurations != null) {
            this.configurationExcludes.addAll(Arrays.asList(configurations));
        }
        return this;
    }
}

