/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import io.micronaut.core.reflect.ReflectionUtils;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;

public class JavaModelUtils {
    private static final ElementKind RECORD_KIND = ReflectionUtils.findDeclaredField(ElementKind.class, (String)"RECORD").flatMap(field -> {
        try {
            return Optional.of((ElementKind)((Object)((Object)field.get(ElementKind.class))));
        }
        catch (IllegalAccessException e) {
            return Optional.empty();
        }
    }).orElse(null);

    public static Optional<ElementKind> resolveKind(Element element) {
        if (element != null) {
            try {
                ElementKind kind = element.getKind();
                return Optional.of(kind);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<ElementKind> resolveKind(Element element, ElementKind expected) {
        Optional<ElementKind> elementKind = JavaModelUtils.resolveKind(element);
        if (elementKind.isPresent() && elementKind.get() == expected) {
            return elementKind;
        }
        return Optional.empty();
    }

    public static boolean isInterface(Element element) {
        return JavaModelUtils.resolveKind(element, ElementKind.INTERFACE).isPresent();
    }

    public static boolean isRecord(Element element) {
        return JavaModelUtils.resolveKind(element, RECORD_KIND).isPresent();
    }

    public static boolean isClass(Element element) {
        return JavaModelUtils.resolveKind(element, ElementKind.CLASS).isPresent();
    }

    public static boolean isEnum(Element element) {
        return JavaModelUtils.resolveKind(element, ElementKind.ENUM).isPresent();
    }

    public static boolean isClassOrInterface(Element element) {
        return JavaModelUtils.isInterface(element) || JavaModelUtils.isClass(element);
    }

    public static String getClassName(TypeElement typeElement) {
        Name qualifiedName = typeElement.getQualifiedName();
        try {
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.MEMBER) {
                TypeElement enclosingElement = typeElement;
                StringBuilder builder = new StringBuilder();
                while (nestingKind == NestingKind.MEMBER) {
                    builder.insert(0, '$').insert(1, enclosingElement.getSimpleName());
                    Element enclosing = enclosingElement.getEnclosingElement();
                    if (!(enclosing instanceof TypeElement)) break;
                    enclosingElement = (TypeElement)enclosing;
                    nestingKind = enclosingElement.getNestingKind();
                }
                Name enclosingName = enclosingElement.getQualifiedName();
                return enclosingName.toString() + builder;
            }
            return qualifiedName.toString();
        }
        catch (RuntimeException e) {
            return qualifiedName.toString();
        }
    }

    public static String getClassArrayName(TypeElement typeElement) {
        return "[L" + JavaModelUtils.getClassName(typeElement) + ";";
    }
}

