/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public abstract class AbstractClassWriterOutputVisitor
implements ClassWriterOutputVisitor {
    private final Map<String, Set<String>> serviceDescriptors = new HashMap<String, Set<String>>();
    private final boolean isWriteOnFinish;

    protected AbstractClassWriterOutputVisitor(boolean isWriteOnFinish) {
        this.isWriteOnFinish = isWriteOnFinish;
    }

    public AbstractClassWriterOutputVisitor() {
        this.isWriteOnFinish = false;
    }

    @Override
    public final Map<String, Set<String>> getServiceEntries() {
        return this.serviceDescriptors;
    }

    @Override
    public final void visitServiceDescriptor(String type, String classname) {
        if (StringUtils.isNotEmpty((CharSequence)type) && StringUtils.isNotEmpty((CharSequence)classname)) {
            this.serviceDescriptors.computeIfAbsent(type, s -> new HashSet()).add(classname);
        }
    }

    @Override
    public final void finish() {
        if (this.isWriteOnFinish) {
            Map<String, Set<String>> serviceEntries = this.getServiceEntries();
            this.writeServiceEntries(serviceEntries);
        }
    }

    public void writeServiceEntries(Map<String, Set<String>> serviceEntries) {
        for (Map.Entry<String, Set<String>> entry : serviceEntries.entrySet()) {
            Throwable throwable;
            GeneratedFile generatedFile;
            Set<String> serviceTypes;
            block32: {
                String serviceName = entry.getKey();
                serviceTypes = entry.getValue();
                Optional<GeneratedFile> serviceFile = this.visitMetaInfFile("services/" + serviceName);
                if (!serviceFile.isPresent()) continue;
                generatedFile = serviceFile.get();
                try {
                    throwable = null;
                    try (BufferedReader bufferedReader = new BufferedReader(generatedFile.openReader());){
                        String line = bufferedReader.readLine();
                        while (line != null) {
                            serviceTypes.add(line);
                            line = bufferedReader.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (FileNotFoundException | NoSuchFileException bufferedReader) {
                }
                catch (IOException x) {
                    Throwable cause = x.getCause();
                    if (this.isNotEclipseNotFound(cause)) {
                        throw new ClassGenerationException("Failed to load existing service definition files: " + x, x);
                    }
                }
                catch (Throwable e) {
                    if (!this.isNotEclipseNotFound(e)) break block32;
                    throw new ClassGenerationException("Failed to load existing service definition files: " + e, e);
                }
            }
            try {
                BufferedWriter writer = new BufferedWriter(generatedFile.openWriter());
                throwable = null;
                try {
                    for (String serviceType : serviceTypes) {
                        writer.write(serviceType);
                        writer.newLine();
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException x) {
                throw new ClassGenerationException("Failed to open writer for service definition files: " + x);
            }
        }
    }

    private boolean isNotEclipseNotFound(Throwable e) {
        if (this.isWriteOnFinish) {
            return false;
        }
        String message = e.getMessage();
        return !message.contains("does not exist") || !e.getClass().getName().startsWith("org.eclipse");
    }
}

