/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface MethodElement
extends MemberElement {
    @NonNull
    public ClassElement getReturnType();

    @NonNull
    public ParameterElement[] getParameters();

    @NonNull
    public MethodElement withNewParameters(ParameterElement ... var1);

    @NonNull
    default public ParameterElement[] getSuspendParameters() {
        return this.getParameters();
    }

    default public boolean hasParameters() {
        return this.getParameters().length > 0;
    }

    default public boolean isSuspend() {
        return false;
    }

    default public boolean isDefault() {
        return false;
    }

    @NonNull
    default public ClassElement getGenericReturnType() {
        return this.getReturnType();
    }

    @NonNull
    default public String getDescription(boolean simple) {
        String typeString = simple ? this.getReturnType().getSimpleName() : this.getReturnType().getName();
        String args = Arrays.stream(this.getParameters()).map(arg -> simple ? arg.getType().getSimpleName() : arg.getType().getName() + " " + arg.getName()).collect(Collectors.joining(","));
        return typeString + " " + this.getName() + "(" + args + ")";
    }

    @NonNull
    public static MethodElement of(final @NonNull ClassElement declaredType, final @NonNull AnnotationMetadata annotationMetadata, final @NonNull ClassElement returnType, final @NonNull ClassElement genericReturnType, final @NonNull String name, final ParameterElement ... parameterElements) {
        return new MethodElement(){

            @Override
            @NotNull
            public ClassElement getReturnType() {
                return returnType;
            }

            @Override
            @NotNull
            public ClassElement getGenericReturnType() {
                return genericReturnType;
            }

            @Override
            public ParameterElement[] getParameters() {
                return parameterElements;
            }

            @Override
            public MethodElement withNewParameters(ParameterElement ... newParameters) {
                return MethodElement.of(declaredType, annotationMetadata, returnType, genericReturnType, name, (ParameterElement[])ArrayUtils.concat((Object[])parameterElements, (Object[])newParameters));
            }

            @NotNull
            public AnnotationMetadata getAnnotationMetadata() {
                return annotationMetadata;
            }

            @Override
            public ClassElement getDeclaringType() {
                return declaredType;
            }

            @Override
            @NotNull
            public String getName() {
                return name;
            }

            @Override
            public boolean isPackagePrivate() {
                return false;
            }

            @Override
            public boolean isProtected() {
                return false;
            }

            @Override
            public boolean isPublic() {
                return true;
            }

            @Override
            @NotNull
            public Object getNativeType() {
                throw new UnsupportedOperationException("No native method type present");
            }
        };
    }
}

