/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ParameterElement;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class ReflectParameterElement
implements ParameterElement {
    private final ClassElement classElement;
    private final String name;
    private AnnotationMetadata annotationMetadata = AnnotationMetadata.EMPTY_METADATA;

    ReflectParameterElement(ClassElement classElement, String name) {
        this.classElement = classElement;
        this.name = name;
    }

    @Override
    public boolean isPrimitive() {
        return this.classElement.isPrimitive();
    }

    @Override
    public boolean isArray() {
        return this.classElement.isArray();
    }

    @Override
    public int getArrayDimensions() {
        return this.classElement.getArrayDimensions();
    }

    @Override
    @NotNull
    public ClassElement getType() {
        return this.classElement;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    @NotNull
    public Object getNativeType() {
        return this.classElement.getNativeType();
    }

    @NotNull
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    @NotNull
    public <T extends Annotation> Element annotate(final @NotNull String annotationType, final @NotNull Consumer<AnnotationValueBuilder<T>> consumer) {
        if (this.annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
            this.annotationMetadata = new DefaultAnnotationMetadata(){
                {
                    AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
                    consumer.accept(builder);
                    this.addDeclaredAnnotation(annotationType, builder.build().getValues());
                }
            };
        } else {
            AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
            consumer.accept(builder);
            this.annotationMetadata = DefaultAnnotationMetadata.mutateMember(this.annotationMetadata, annotationType, builder.build().getValues());
        }
        return this;
    }
}

