/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;

public final class PrimitiveElement
implements ArrayableClassElement {
    public static final PrimitiveElement VOID = new PrimitiveElement("void");
    private static final PrimitiveElement INT = new PrimitiveElement("int");
    private static final PrimitiveElement CHAR = new PrimitiveElement("char");
    private static final PrimitiveElement BOOLEAN = new PrimitiveElement("boolean");
    private static final PrimitiveElement LONG = new PrimitiveElement("long");
    private static final PrimitiveElement FLOAT = new PrimitiveElement("float");
    private static final PrimitiveElement DOUBLE = new PrimitiveElement("double");
    private static final PrimitiveElement SHORT = new PrimitiveElement("short");
    private static final PrimitiveElement BYTE = new PrimitiveElement("byte");
    private static final PrimitiveElement[] PRIMITIVES = new PrimitiveElement[]{INT, CHAR, BOOLEAN, LONG, FLOAT, DOUBLE, SHORT, BYTE, VOID};
    private final String typeName;
    private final int arrayDimensions;

    private PrimitiveElement(String name) {
        this(name, 0);
    }

    private PrimitiveElement(String name, int arrayDimensions) {
        this.typeName = name;
        this.arrayDimensions = arrayDimensions;
    }

    @Override
    public boolean isAssignable(String type) {
        return this.typeName.equals(type);
    }

    @Override
    public boolean isAssignable(ClassElement type) {
        return this.typeName.equals(type.getName());
    }

    @Override
    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    @Override
    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    @Override
    @NonNull
    public String getName() {
        return this.typeName;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    @NonNull
    public Object getNativeType() {
        throw new UnsupportedOperationException("There is no native types for primitives");
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new PrimitiveElement(this.typeName, arrayDimensions);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public static PrimitiveElement valueOf(String name) {
        for (PrimitiveElement element : PRIMITIVES) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            return element;
        }
        throw new IllegalArgumentException(String.format("No primitive found for name: %s", name));
    }
}

