/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultPropertyPlaceholderResolver
implements PropertyPlaceholderResolver {
    public static final String PREFIX = "${";
    public static final String SUFFIX = "}";
    private static final Pattern ESCAPE_SEQUENCE = Pattern.compile("(.+)?:`([^`]+?)`");
    private static final char COLON = ':';
    private final PropertyResolver environment;
    private final ConversionService<?> conversionService;
    private final String prefix;

    public DefaultPropertyPlaceholderResolver(PropertyResolver environment, ConversionService conversionService) {
        this.environment = environment;
        this.conversionService = conversionService;
        this.prefix = PREFIX;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Optional<String> resolvePlaceholders(String str) {
        try {
            return Optional.of(this.resolveRequiredPlaceholders(str));
        }
        catch (ConfigurationException e) {
            return Optional.empty();
        }
    }

    @Override
    public String resolveRequiredPlaceholders(String str) throws ConfigurationException {
        List<Segment> segments = this.buildSegments(str);
        StringBuilder value = new StringBuilder();
        for (Segment segment : segments) {
            value.append(segment.getValue(String.class));
        }
        return value.toString();
    }

    @Override
    public <T> T resolveRequiredPlaceholder(String str, Class<T> type) throws ConfigurationException {
        List<Segment> segments = this.buildSegments(str);
        if (segments.size() == 1) {
            return segments.get(0).getValue(type);
        }
        throw new ConfigurationException("Cannot convert a multi segment placeholder to a specified type");
    }

    public List<Segment> buildSegments(String str) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        String value = str;
        int i = value.indexOf(PREFIX);
        while (i > -1) {
            int suffixIdx;
            if (i > 0) {
                String rawSegment = value.substring(0, i);
                segments.add(new RawSegment(rawSegment));
            }
            if ((suffixIdx = (value = value.substring(i + PREFIX.length())).indexOf(SUFFIX)) > -1) {
                String expr = value.substring(0, suffixIdx).trim();
                segments.add(new PlaceholderSegment(expr));
                if (value.length() > suffixIdx) {
                    value = value.substring(suffixIdx + SUFFIX.length());
                }
            } else {
                throw new ConfigurationException("Incomplete placeholder definitions detected: " + str);
            }
            i = value.indexOf(PREFIX);
        }
        if (value.length() > 0) {
            segments.add(new RawSegment(value));
        }
        return segments;
    }

    @Nullable
    protected <T> T resolveExpression(String context, String expression, Class<T> type) {
        String envVar;
        if (this.environment.containsProperty(expression)) {
            return this.environment.getProperty(expression, type).orElseThrow(() -> new ConfigurationException("Could not resolve expression: [" + expression + "] in placeholder ${" + context + SUFFIX));
        }
        if (NameUtils.isEnvironmentName((String)expression) && StringUtils.isNotEmpty((CharSequence)(envVar = System.getenv(expression)))) {
            return this.conversionService.convert((Object)envVar, type).orElseThrow(() -> new ConfigurationException("Could not resolve expression: [" + expression + "] in placeholder ${" + context + SUFFIX));
        }
        return null;
    }

    public class PlaceholderSegment
    implements Segment {
        private final String placeholder;
        private final List<String> expressions = new ArrayList<String>();
        private String defaultValue;

        PlaceholderSegment(String placeholder) {
            this.placeholder = placeholder;
            this.findExpressions(placeholder);
        }

        public List<String> getExpressions() {
            return Collections.unmodifiableList(this.expressions);
        }

        @Override
        public <T> T getValue(Class<T> type) throws ConfigurationException {
            for (String expression : this.expressions) {
                T value = DefaultPropertyPlaceholderResolver.this.resolveExpression(this.placeholder, expression, type);
                if (value == null) continue;
                return value;
            }
            if (this.defaultValue != null) {
                return DefaultPropertyPlaceholderResolver.this.conversionService.convert((Object)this.defaultValue, type).orElseThrow(() -> new ConfigurationException(String.format("Could not convert default value [%s] in placeholder ${%s}", this.defaultValue, this.placeholder)));
            }
            throw new ConfigurationException("Could not resolve placeholder ${" + this.placeholder + DefaultPropertyPlaceholderResolver.SUFFIX);
        }

        private void findExpressions(String placeholder) {
            String expression;
            String defaultValue = null;
            Matcher matcher = ESCAPE_SEQUENCE.matcher(placeholder);
            boolean escaped = false;
            if (matcher.find()) {
                defaultValue = matcher.group(2);
                expression = matcher.group(1);
                escaped = true;
            } else {
                int j = placeholder.indexOf(58);
                if (j > -1) {
                    defaultValue = placeholder.substring(j + 1);
                    expression = placeholder.substring(0, j);
                } else {
                    expression = placeholder;
                }
            }
            this.expressions.add(expression);
            if (defaultValue != null) {
                if (!escaped && (ESCAPE_SEQUENCE.matcher(defaultValue).find() || defaultValue.indexOf(58) > -1)) {
                    this.findExpressions(defaultValue);
                } else {
                    this.defaultValue = defaultValue;
                }
            }
        }
    }

    public class RawSegment
    implements Segment {
        private final String text;

        RawSegment(String text) {
            this.text = text;
        }

        @Override
        public <T> T getValue(Class<T> type) throws ConfigurationException {
            if (type.isInstance(this.text)) {
                return (T)this.text;
            }
            return DefaultPropertyPlaceholderResolver.this.conversionService.convert((Object)this.text, type).orElseThrow(() -> new ConfigurationException("Could not convert: [" + this.text + "] to the required type: [" + type.getName() + "]"));
        }
    }

    public static interface Segment {
        public <T> T getValue(Class<T> var1) throws ConfigurationException;
    }
}

