/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface BeanDefinition<T>
extends AnnotationMetadataDelegate,
Named,
BeanType<T> {
    public static final String NAMED_ATTRIBUTE = Named.class.getName();

    public Optional<Class<? extends Annotation>> getScope();

    public boolean isSingleton();

    public boolean isProvided();

    public boolean isIterable();

    @Override
    public Class<T> getBeanType();

    public Optional<Class<?>> getDeclaringType();

    public ConstructorInjectionPoint<T> getConstructor();

    public Collection<Class> getRequiredComponents();

    public Collection<MethodInjectionPoint> getInjectedMethods();

    public Collection<FieldInjectionPoint> getInjectedFields();

    public Collection<MethodInjectionPoint> getPostConstructMethods();

    public Collection<MethodInjectionPoint> getPreDestroyMethods();

    @Override
    public String getName();

    public <R> Optional<ExecutableMethod<T, R>> findMethod(String var1, Class ... var2);

    public <R> Stream<ExecutableMethod<T, R>> findPossibleMethods(String var1);

    public T inject(BeanContext var1, T var2);

    public T inject(BeanResolutionContext var1, BeanContext var2, T var3);

    public Collection<ExecutableMethod<T, ?>> getExecutableMethods();

    default public boolean isProxy() {
        return this instanceof ProxyBeanDefinition;
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments() {
        return this.getTypeArguments(this.getBeanType());
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments(Class<?> type) {
        if (type == null) {
            return Collections.emptyList();
        }
        return this.getTypeArguments(type.getName());
    }

    @NonNull
    default public Class[] getTypeParameters(@Nullable Class<?> type) {
        if (type == null) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        List<Argument<?>> typeArguments = this.getTypeArguments(type);
        return (Class[])typeArguments.stream().map(TypeInformation::getType).toArray(Class[]::new);
    }

    @NonNull
    default public Class[] getTypeParameters() {
        return this.getTypeParameters(this.getBeanType());
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments(String type) {
        return Collections.emptyList();
    }

    default public <R> ExecutableMethod<T, R> getRequiredMethod(String name, Class ... argumentTypes) {
        return this.findMethod(name, argumentTypes).orElseThrow(() -> ReflectionUtils.newNoSuchMethodError(this.getBeanType(), (String)name, (Class[])argumentTypes));
    }

    default public boolean isAbstract() {
        return Modifier.isAbstract(this.getBeanType().getModifiers());
    }

    @Nullable
    default public Qualifier<T> getDeclaredQualifier() {
        String annotation = this.getAnnotationNameByStereotype(javax.inject.Qualifier.class).orElse(null);
        if (annotation != null) {
            if (annotation.equals(Qualifier.PRIMARY)) {
                return null;
            }
            return Qualifiers.byAnnotation((AnnotationMetadata)this, annotation);
        }
        Qualifier<T> qualifier = this.resolveDynamicQualifier();
        if (qualifier == null) {
            String name = this.stringValue(javax.inject.Named.class).orElse(null);
            qualifier = name != null ? Qualifiers.byAnnotation((AnnotationMetadata)this, name) : null;
        }
        return qualifier;
    }

    @Nullable
    default public Qualifier<T> resolveDynamicQualifier() {
        return null;
    }
}

