/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.EnvironmentAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AnnotationMetadataHierarchy
implements AnnotationMetadata,
EnvironmentAnnotationMetadata,
Iterable<AnnotationMetadata> {
    public static final AnnotationMetadata[] EMPTY_HIERARCHY = new AnnotationMetadata[]{AnnotationMetadata.EMPTY_METADATA, AnnotationMetadata.EMPTY_METADATA};
    private final AnnotationMetadata[] hierarchy;

    public AnnotationMetadataHierarchy(AnnotationMetadata ... hierarchy) {
        if (ArrayUtils.isNotEmpty((Object[])hierarchy)) {
            int len = hierarchy.length;
            if (len > 1) {
                for (int i = 0; i < len / 2; ++i) {
                    AnnotationMetadata temp = hierarchy[i];
                    int pos = len - i - 1;
                    hierarchy[i] = hierarchy[pos];
                    hierarchy[pos] = temp;
                }
            }
            this.hierarchy = hierarchy;
        } else {
            this.hierarchy = EMPTY_HIERARCHY;
        }
    }

    private AnnotationMetadataHierarchy(AnnotationMetadata[] existing, AnnotationMetadata newChild) {
        this.hierarchy = new AnnotationMetadata[existing.length];
        System.arraycopy(existing, 0, this.hierarchy, 0, existing.length);
        this.hierarchy[0] = newChild;
    }

    @Override
    public boolean hasPropertyExpressions() {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasPropertyExpressions()) continue;
            return true;
        }
        return false;
    }

    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name) {
        return this.getAnnotationType((AnnotationMetadata metadata) -> metadata.getAnnotationType(name));
    }

    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name, @NonNull ClassLoader classLoader) {
        return this.getAnnotationType((AnnotationMetadata metadata) -> metadata.getAnnotationType(name, classLoader));
    }

    @NonNull
    public AnnotationMetadata getDeclaredMetadata() {
        return this.hierarchy[0];
    }

    @NonNull
    public AnnotationMetadata getRootMetadata() {
        return this.hierarchy[this.hierarchy.length - 1];
    }

    @NonNull
    public AnnotationMetadata createSibling(@NonNull AnnotationMetadata child) {
        if (this.hierarchy.length > 1) {
            return new AnnotationMetadataHierarchy(this.hierarchy, child);
        }
        return child;
    }

    @Nullable
    public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Annotation a = annotationMetadata.synthesize(annotationClass);
            if (a == null) continue;
            return (T)a;
        }
        return null;
    }

    @Nullable
    public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass) {
        return (T)this.hierarchy[0].synthesize(annotationClass);
    }

    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@NonNull String annotation) {
        AnnotationValue ann = null;
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            AnnotationValue av = annotationMetadata.getAnnotation(annotation);
            if (av == null) continue;
            if (ann == null) {
                ann = av;
                continue;
            }
            Map values = av.getValues();
            Map existing = ann.getValues();
            LinkedHashMap newValues = new LinkedHashMap(values.size() + existing.size());
            newValues.putAll(existing);
            for (Map.Entry entry : values.entrySet()) {
                newValues.putIfAbsent(entry.getKey(), entry.getValue());
            }
            ann = new AnnotationValue(annotation, newValues);
        }
        return Optional.ofNullable(ann);
    }

    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@NonNull String annotation) {
        return this.hierarchy[0].findDeclaredAnnotation(annotation);
    }

    @NonNull
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Object[] values = this.hierarchy[0].stringValues(annotation, member);
        for (int i = 1; i < this.hierarchy.length; ++i) {
            AnnotationMetadata annotationMetadata = this.hierarchy[i];
            Object[] moreValues = annotationMetadata.stringValues(annotation, member);
            if (!ArrayUtils.isNotEmpty((Object[])moreValues)) continue;
            values = (String[])ArrayUtils.concat((Object[])values, (Object[])moreValues);
        }
        return values;
    }

    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.booleanValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public boolean isTrue(@NonNull String annotation, @NonNull String member) {
        return Arrays.stream(this.hierarchy).anyMatch(am -> am.isTrue(annotation, member));
    }

    public OptionalLong longValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalLong o = annotationMetadata.longValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalLong.empty();
    }

    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.stringValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public OptionalInt intValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalInt o = annotationMetadata.intValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalInt.empty();
    }

    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    public <E extends Enum> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.enumValue(annotation, member, enumType);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @NonNull
    public <T> Class<T>[] classValues(@NonNull String annotation, @NonNull String member) {
        Class[] classes = (Class[])Arrays.stream(this.hierarchy).flatMap(am -> Stream.of(am.classValues(annotation, member))).toArray(Class[]::new);
        return classes;
    }

    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.classValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @NonNull
    public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getAnnotationNamesByStereotype(stereotype).stream()).collect(Collectors.toList());
    }

    @NonNull
    public Set<String> getDeclaredAnnotationNames() {
        return this.hierarchy[0].getDeclaredAnnotationNames();
    }

    @NonNull
    public Set<String> getAnnotationNames() {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getAnnotationNames().stream()).collect(Collectors.toSet());
    }

    @NonNull
    public <T> OptionalValues<T> getValues(@NonNull String annotation, @NonNull Class<T> valueType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalValues values = annotationMetadata.getValues(annotation, valueType);
            if (values.isEmpty()) continue;
            return values;
        }
        return OptionalValues.empty();
    }

    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional defaultValue = annotationMetadata.getDefaultValue(annotation, member, requiredType);
            if (!defaultValue.isPresent()) continue;
            return defaultValue;
        }
        return Optional.empty();
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@NonNull Class<T> annotationType) {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getAnnotationValuesByType(annotationType).stream()).distinct().collect(Collectors.toList());
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@NonNull Class<T> annotationType) {
        return this.hierarchy[0].getDeclaredAnnotationValuesByType(annotationType);
    }

    public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        return this.hierarchy[0].hasDeclaredAnnotation(annotation);
    }

    public boolean hasAnnotation(@Nullable String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStereotype(@Nullable String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredStereotype(@Nullable String annotation) {
        return this.hierarchy[0].hasDeclaredStereotype(annotation);
    }

    public <E extends Enum> Optional<E> enumValue(String annotation, String member, Class<E> enumType) {
        return this.enumValue(annotation, member, enumType, null);
    }

    public <E extends Enum> E[] enumValues(String annotation, String member, Class<E> enumType) {
        return this.enumValues(annotation, member, enumType, null);
    }

    public OptionalInt intValue(Class<? extends Annotation> annotation, String member) {
        return this.intValue(annotation, member, null);
    }

    public boolean isFalse(Class<? extends Annotation> annotation, String member) {
        return this.booleanValue(annotation, member, null).orElse(false) == false;
    }

    @NonNull
    public Map<String, Object> getDefaultValues(@NonNull String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Map defaultValues = annotationMetadata.getDefaultValues(annotation);
            if (defaultValues.isEmpty()) continue;
            return defaultValues;
        }
        return Collections.emptyMap();
    }

    @Override
    public <E extends Enum> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<E> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).enumValue(annotation, member, enumType, valueMapper) : annotationMetadata.enumValue(annotation, member, enumType);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public <E extends Enum> Optional<E> enumValue(@NonNull String annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<E> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).enumValue(annotation, member, enumType, valueMapper) : annotationMetadata.enumValue(annotation, member, enumType);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public <E extends Enum> E[] enumValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        Object[] values = this.hierarchy[0].enumValues(annotation, member, enumType);
        for (int i = 1; i < this.hierarchy.length; ++i) {
            AnnotationMetadata annotationMetadata = this.hierarchy[i];
            Object[] moreValues = annotationMetadata.enumValues(annotation, member, enumType);
            if (!ArrayUtils.isNotEmpty((Object[])moreValues)) continue;
            values = (Enum[])ArrayUtils.concat((Object[])values, (Object[])moreValues);
        }
        return values;
    }

    @Override
    public <E extends Enum> E[] enumValues(@NonNull String annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        Object[] values = this.hierarchy[0].enumValues(annotation, member, enumType);
        for (int i = 1; i < this.hierarchy.length; ++i) {
            AnnotationMetadata annotationMetadata = this.hierarchy[i];
            Object[] moreValues = annotationMetadata.enumValues(annotation, member, enumType);
            if (!ArrayUtils.isNotEmpty((Object[])moreValues)) continue;
            values = (Enum[])ArrayUtils.concat((Object[])values, (Object[])moreValues);
        }
        return values;
    }

    @Override
    public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<Class> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).classValue(annotation, member, valueMapper) : annotationMetadata.classValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<Class> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).classValue(annotation, member, valueMapper) : annotationMetadata.classValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalInt o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).intValue(annotation, member, valueMapper) : annotationMetadata.intValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalInt.empty();
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<Boolean> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).booleanValue(annotation, member, valueMapper) : annotationMetadata.booleanValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<Boolean> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).booleanValue(annotation, member, valueMapper) : annotationMetadata.booleanValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public OptionalLong longValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalLong o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).longValue(annotation, member, valueMapper) : annotationMetadata.longValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalLong.empty();
    }

    @Override
    @NonNull
    public OptionalLong longValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalLong o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).longValue(annotation, member, valueMapper) : annotationMetadata.longValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalLong.empty();
    }

    @Override
    @NonNull
    public OptionalInt intValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalInt o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).intValue(annotation, member, valueMapper) : annotationMetadata.intValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalInt.empty();
    }

    public OptionalLong longValue(Class<? extends Annotation> annotation, String member) {
        return this.longValue(annotation, member, null);
    }

    public <E extends Enum> E[] enumValues(Class<? extends Annotation> annotation, String member, Class<E> enumType) {
        return this.enumValues(annotation, member, enumType, null);
    }

    public <T> Class<T>[] classValues(Class<? extends Annotation> annotation, String member) {
        Class[] classes = (Class[])Arrays.stream(this.hierarchy).flatMap(am -> Stream.of(am.classValues(annotation, member))).toArray(Class[]::new);
        return classes;
    }

    public Optional<Class> classValue(Class<? extends Annotation> annotation, String member) {
        return this.classValue(annotation, member, null);
    }

    public Optional<String> stringValue(Class<? extends Annotation> annotation, String member) {
        return this.stringValue(annotation, member, null);
    }

    public Optional<Boolean> booleanValue(Class<? extends Annotation> annotation, String member) {
        return this.booleanValue(annotation, member, null);
    }

    public boolean isTrue(Class<? extends Annotation> annotation, String member) {
        return this.isTrue(annotation, member, null);
    }

    public boolean isPresent(Class<? extends Annotation> annotation, String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.isPresent(annotation, member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<String> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).stringValue(annotation, member, valueMapper) : annotationMetadata.stringValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        return (String[])Arrays.stream(this.hierarchy).flatMap(am -> {
            if (am instanceof EnvironmentAnnotationMetadata) {
                return Stream.of(((EnvironmentAnnotationMetadata)am).stringValues(annotation, member, valueMapper));
            }
            return Stream.of(am.stringValues(annotation, member));
        }).toArray(String[]::new);
    }

    @Override
    @NonNull
    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<String> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).stringValue(annotation, member, valueMapper) : annotationMetadata.stringValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    public boolean isTrue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        return this.booleanValue(annotation, member, valueMapper).orElse(false);
    }

    @Override
    public boolean isTrue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        return this.booleanValue(annotation, member, valueMapper).orElse(false);
    }

    @Override
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).doubleValue(annotation, member, valueMapper) : annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    @Override
    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).doubleValue(annotation, member, valueMapper) : annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    @Override
    @NonNull
    public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType, @Nullable Function<Object, Object> valueMapper) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional<T> o = annotationMetadata instanceof EnvironmentAnnotationMetadata ? ((EnvironmentAnnotationMetadata)annotationMetadata).getValue(annotation, member, requiredType, valueMapper) : annotationMetadata.getValue(annotation, member, requiredType);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public Iterator<AnnotationMetadata> iterator() {
        return ArrayUtils.reverseIterator((Object[])this.hierarchy);
    }

    private Optional<Class<? extends Annotation>> getAnnotationType(Function<AnnotationMetadata, Optional<Class<? extends Annotation>>> annotationTypeSupplier) {
        for (AnnotationMetadata metadata : this.hierarchy) {
            Optional<Class<? extends Annotation>> annotationType = annotationTypeSupplier.apply(metadata);
            if (!annotationType.isPresent()) continue;
            return annotationType;
        }
        return Optional.empty();
    }
}

