/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@Internal
class DefaultMethodInjectionPoint<B, T>
implements MethodInjectionPoint<B, T>,
EnvironmentConfigurable {
    private final BeanDefinition declaringBean;
    private final AnnotationMetadata annotationMetadata;
    private final Class<?> declaringType;
    private final String methodName;
    private final Class[] argTypes;
    private final Argument[] arguments;
    private Environment environment;

    DefaultMethodInjectionPoint(BeanDefinition declaringBean, Class<?> declaringType, String methodName, @Nullable Argument[] arguments) {
        this(declaringBean, declaringType, methodName, arguments, AnnotationMetadata.EMPTY_METADATA);
    }

    DefaultMethodInjectionPoint(BeanDefinition declaringBean, Class<?> declaringType, String methodName, @Nullable Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata) {
        Objects.requireNonNull(declaringBean, "Declaring bean cannot be null");
        this.declaringType = declaringType;
        this.methodName = methodName;
        this.arguments = arguments == null ? Argument.ZERO_ARGUMENTS : arguments;
        this.argTypes = Argument.toClassArray((Argument[])arguments);
        this.declaringBean = declaringBean;
        this.annotationMetadata = this.initAnnotationMetadata(annotationMetadata);
    }

    @Override
    public final boolean hasPropertyExpressions() {
        return this.annotationMetadata.hasPropertyExpressions();
    }

    public String toString() {
        String text = Argument.toString(this.getArguments());
        return this.declaringType.getSimpleName() + "." + this.methodName + "(" + text + ")";
    }

    @Override
    public void configure(Environment environment) {
        this.environment = environment;
    }

    @Override
    public Method getMethod() {
        Method method = (Method)ReflectionUtils.getMethod(this.declaringType, (String)this.methodName, (Class[])this.argTypes).orElseThrow(() -> ReflectionUtils.newNoSuchMethodError(this.declaringType, (String)this.methodName, (Class[])this.argTypes));
        method.setAccessible(true);
        return method;
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public boolean isPreDestroyMethod() {
        return this.annotationMetadata.hasDeclaredAnnotation(PreDestroy.class);
    }

    @Override
    public boolean isPostConstructMethod() {
        return this.annotationMetadata.hasDeclaredAnnotation(PostConstruct.class);
    }

    @Override
    public Object invoke(Object instance, Object ... args) {
        Method targetMethod = this.getMethod();
        return ReflectionUtils.invokeMethod((Object)instance, (Method)targetMethod, (Object[])args);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public BeanDefinition getDeclaringBean() {
        return this.declaringBean;
    }

    @Override
    public boolean requiresReflection() {
        return false;
    }

    @Override
    public Argument<?>[] getArguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMethodInjectionPoint that = (DefaultMethodInjectionPoint)o;
        return Objects.equals(this.declaringType, that.declaringType) && Objects.equals(this.methodName, that.methodName) && Arrays.equals(this.argTypes, that.argTypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.declaringType, this.methodName);
        result = 31 * result + Arrays.hashCode(this.argTypes);
        return result;
    }

    private AnnotationMetadata initAnnotationMetadata(@Nullable AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != AnnotationMetadata.EMPTY_METADATA) {
            return new MethodAnnotationMetadata(annotationMetadata);
        }
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private final class MethodAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        MethodAnnotationMetadata(AnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return DefaultMethodInjectionPoint.this.environment;
        }
    }
}

