/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Internal
class ReflectClassElement
implements ClassElement {
    private final Class<?> type;

    ReflectClassElement(Class<?> type) {
        this.type = type;
    }

    public String toString() {
        return this.type.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReflectClassElement that = (ReflectClassElement)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    @Override
    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    @Override
    public boolean isArray() {
        return this.type.isArray();
    }

    @Override
    public int getArrayDimensions() {
        return this.computeDimensions(this.type);
    }

    private int computeDimensions(Class<?> type) {
        int i = 0;
        while (type.isArray()) {
            ++i;
            type = type.getComponentType();
        }
        return i;
    }

    @Override
    public boolean isAssignable(Class<?> type) {
        return type.isAssignableFrom(this.type);
    }

    @Override
    public boolean isAssignable(String type) {
        return false;
    }

    @Override
    public boolean isAssignable(ClassElement type) {
        return false;
    }

    @Override
    public ClassElement toArray() {
        Class<?> arrayType = Array.newInstance(this.type, 0).getClass();
        return ClassElement.of(arrayType);
    }

    @Override
    public ClassElement fromArray() {
        return new ReflectClassElement(this.type.getComponentType());
    }

    @Override
    @NotNull
    public String getName() {
        return this.type.getName();
    }

    @Override
    public boolean isPackagePrivate() {
        int modifiers = this.type.getModifiers();
        return !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers);
    }

    @Override
    public boolean isProtected() {
        return !this.isPublic();
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.type.getModifiers());
    }

    @Override
    @NotNull
    public Object getNativeType() {
        return this.type;
    }
}

