/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Experimental;
import io.micronaut.core.annotation.InstantiatedMember;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.annotation.AnnotationMapper;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.annotation.AnnotationTransformer;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.annotation.NamedAnnotationTransformer;
import io.micronaut.inject.annotation.TypedAnnotationMapper;
import io.micronaut.inject.annotation.TypedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.inject.Scope;

public abstract class AbstractAnnotationMetadataBuilder<T, A> {
    private static final Map<String, String> DEPRECATED_ANNOTATION_NAMES = CollectionUtils.mapOf((Object[])new Object[]{"javax.annotation.Nullable", Nullable.class.getName(), "javax.annotation.Nonnull", NonNull.class.getName()});
    private static final Map<String, List<AnnotationMapper<?>>> ANNOTATION_MAPPERS = new HashMap(10);
    private static final Map<String, List<AnnotationTransformer<Annotation>>> ANNOTATION_TRANSFORMERS = new HashMap<String, List<AnnotationTransformer<Annotation>>>(5);
    private static final Map<String, List<AnnotationRemapper>> ANNOTATION_REMAPPERS = new HashMap<String, List<AnnotationRemapper>>(5);
    private static final Map<MetadataKey, AnnotationMetadata> MUTATED_ANNOTATION_METADATA = new HashMap<MetadataKey, AnnotationMetadata>(100);
    private static final List<String> DEFAULT_ANNOTATE_EXCLUDES = Arrays.asList(Internal.class.getName(), Experimental.class.getName());
    private boolean validating = true;
    private final Set<T> erroneousElements = new HashSet<T>();

    protected AbstractAnnotationMetadataBuilder() {
    }

    public AnnotationMetadata buildDeclared(T element) {
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, true, true, true);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            if ("org.eclipse.jdt.internal.compiler.problem.AbortCompilation".equals(e.getClass().getName())) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            throw e;
        }
    }

    public AnnotationMetadata buildDeclared(T element, List<? extends A> annotations, boolean includeTypeAnnotations) {
        if (CollectionUtils.isEmpty(annotations)) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        if (includeTypeAnnotations) {
            this.buildInternal(element, element, annotationMetadata, false, true, true);
        }
        try {
            this.includeAnnotations(annotationMetadata, element, true, annotations, true);
            if (annotationMetadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return annotationMetadata;
        }
        catch (RuntimeException e) {
            if ("org.eclipse.jdt.internal.compiler.problem.AbortCompilation".equals(e.getClass().getName())) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            throw e;
        }
    }

    public AnnotationMetadata buildOverridden(T element) {
        AnnotationMetadata existing = MUTATED_ANNOTATION_METADATA.get(new MetadataKey<T>(this.getDeclaringType(element), element));
        if (existing != null) {
            return existing;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, false, false, true);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            if ("org.eclipse.jdt.internal.compiler.problem.AbortCompilation".equals(e.getClass().getName())) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            throw e;
        }
    }

    public AnnotationMetadata build(T element) {
        String declaringType = this.getDeclaringType(element);
        return this.build(declaringType, element);
    }

    public AnnotationMetadata build(String declaringType, T element) {
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        if (existing != null) {
            return existing;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, true, false, true);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            if ("org.eclipse.jdt.internal.compiler.problem.AbortCompilation".equals(e.getClass().getName())) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            throw e;
        }
    }

    protected abstract boolean isMethodOrClassElement(T var1);

    @NonNull
    protected abstract String getDeclaringType(@NonNull T var1);

    public AnnotationMetadata buildForMethod(T element) {
        String declaringType = this.getDeclaringType(element);
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        if (existing != null) {
            return existing;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        return this.buildInternal(null, element, annotationMetadata, false, false, true);
    }

    public AnnotationMetadata buildForParent(T parent, T element) {
        String declaringType = this.getDeclaringType(element);
        return this.buildForParent(declaringType, parent, element);
    }

    public AnnotationMetadata buildForParent(String declaringType, T parent, T element) {
        AnnotationMetadata declaredMetadata;
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        DefaultAnnotationMetadata annotationMetadata = existing instanceof DefaultAnnotationMetadata ? ((DefaultAnnotationMetadata)existing).clone() : (existing instanceof AnnotationMetadataHierarchy ? ((declaredMetadata = ((AnnotationMetadataHierarchy)existing).getDeclaredMetadata()) instanceof DefaultAnnotationMetadata ? ((DefaultAnnotationMetadata)declaredMetadata).clone() : new MutableAnnotationMetadata()) : new MutableAnnotationMetadata());
        return this.buildInternal(parent, element, annotationMetadata, false, false, true);
    }

    public AnnotationMetadata buildForParent(T parent, T element, boolean inheritTypeAnnotations) {
        AnnotationMetadata declaredMetadata;
        String declaringType = this.getDeclaringType(element);
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        DefaultAnnotationMetadata annotationMetadata = existing instanceof DefaultAnnotationMetadata ? ((DefaultAnnotationMetadata)existing).clone() : (existing instanceof AnnotationMetadataHierarchy ? ((declaredMetadata = ((AnnotationMetadataHierarchy)existing).getDeclaredMetadata()) instanceof DefaultAnnotationMetadata ? ((DefaultAnnotationMetadata)declaredMetadata).clone() : new MutableAnnotationMetadata()) : new MutableAnnotationMetadata());
        return this.buildInternal(parent, element, annotationMetadata, inheritTypeAnnotations, false, true);
    }

    protected abstract T getTypeForAnnotation(A var1);

    protected abstract boolean hasAnnotation(T var1, Class<? extends Annotation> var2);

    protected abstract String getAnnotationTypeName(A var1);

    protected abstract String getElementName(T var1);

    protected abstract List<? extends A> getAnnotationsForType(T var1);

    protected abstract List<T> buildHierarchy(T var1, boolean var2, boolean var3);

    protected abstract void readAnnotationRawValues(T var1, String var2, T var3, String var4, Object var5, Map<CharSequence, Object> var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAnnotationValue(T originatingElement, String annotationName, T member, final String memberName, Object resolvedValue) {
        if (!this.validating) {
            return;
        }
        AnnotatedElementValidator elementValidator = this.getElementValidator();
        if (elementValidator != null && !this.erroneousElements.contains(member)) {
            boolean shouldValidate;
            boolean bl = shouldValidate = !annotationName.equals(AliasFor.class.getName()) && (!(resolvedValue instanceof String) || !resolvedValue.toString().contains("${"));
            if (shouldValidate) {
                shouldValidate = this.isValidationRequired(member);
            }
            if (shouldValidate) {
                AnnotationMetadata metadata;
                try {
                    this.validating = false;
                    metadata = this.buildDeclared(member);
                }
                finally {
                    this.validating = true;
                }
                Set<String> errors = elementValidator.validatedAnnotatedElement(new AnnotatedElement(){

                    @NonNull
                    public String getName() {
                        return memberName;
                    }

                    public AnnotationMetadata getAnnotationMetadata() {
                        return metadata;
                    }
                }, resolvedValue);
                if (CollectionUtils.isNotEmpty(errors)) {
                    this.erroneousElements.add(member);
                    for (String error : errors) {
                        error = "@" + NameUtils.getSimpleName((String)annotationName) + "." + memberName + ": " + error;
                        this.addError(originatingElement, error);
                    }
                }
            }
        }
    }

    protected abstract boolean isValidationRequired(T var1);

    @Nullable
    protected AnnotatedElementValidator getElementValidator() {
        return null;
    }

    protected abstract void addError(@NonNull T var1, @NonNull String var2);

    protected abstract void addWarning(@NonNull T var1, @NonNull String var2);

    protected abstract Object readAnnotationValue(T var1, T var2, String var3, Object var4);

    protected abstract Map<? extends T, ?> readAnnotationDefaultValues(A var1);

    protected abstract Map<? extends T, ?> readAnnotationDefaultValues(String var1, T var2);

    protected abstract Map<? extends T, ?> readAnnotationRawValues(A var1);

    protected abstract OptionalValues<?> getAnnotationValues(T var1, T var2, Class<?> var3);

    protected abstract String getAnnotationMemberName(T var1);

    @Nullable
    protected abstract String getRepeatableName(A var1);

    @Nullable
    protected abstract String getRepeatableNameForType(T var1);

    protected AnnotationValue readNestedAnnotationValue(T originatingElement, A annotationMirror) {
        AnnotationValue av;
        Map<T, ?> annotationValues = this.readAnnotationRawValues(annotationMirror);
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        if (annotationValues.isEmpty()) {
            av = new AnnotationValue(annotationTypeName);
        } else {
            LinkedHashMap<CharSequence, Object> resolvedValues = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<T, ?> entry : annotationValues.entrySet()) {
                T member = entry.getKey();
                OptionalValues<AliasFor> aliasForValues = this.getAnnotationValues(originatingElement, member, AliasFor.class);
                Object annotationValue = entry.getValue();
                Optional aliasMember = aliasForValues.get((CharSequence)"member");
                Optional aliasAnnotation = aliasForValues.get((CharSequence)"annotation");
                Optional aliasAnnotationName = aliasForValues.get((CharSequence)"annotationName");
                if (aliasMember.isPresent() && !aliasAnnotation.isPresent() && !aliasAnnotationName.isPresent()) {
                    String aliasedNamed = aliasMember.get().toString();
                    this.readAnnotationRawValues(originatingElement, annotationTypeName, member, aliasedNamed, annotationValue, resolvedValues);
                }
                String memberName = this.getAnnotationMemberName(member);
                this.readAnnotationRawValues(originatingElement, annotationTypeName, member, memberName, annotationValue, resolvedValues);
            }
            av = new AnnotationValue(annotationTypeName, resolvedValues);
        }
        return av;
    }

    protected abstract Optional<T> getAnnotationMirror(String var1);

    protected Map<CharSequence, Object> populateAnnotationData(T originatingElement, A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared, RetentionPolicy retentionPolicy, boolean allowAliases) {
        LinkedHashMap<CharSequence, Object> annotationValues;
        String annotationName = this.getAnnotationTypeName(annotationMirror);
        if (retentionPolicy == RetentionPolicy.RUNTIME) {
            this.processAnnotationDefaults(originatingElement, annotationMirror, metadata, annotationName);
        }
        ArrayList<String> parentAnnotations = new ArrayList<String>();
        parentAnnotations.add(annotationName);
        Map<T, ?> elementValues = this.readAnnotationRawValues(annotationMirror);
        if (CollectionUtils.isEmpty(elementValues)) {
            annotationValues = new LinkedHashMap<CharSequence, Object>(3);
        } else {
            annotationValues = new LinkedHashMap(5);
            for (Map.Entry<T, ?> entry : elementValues.entrySet()) {
                String memberName;
                Object rawValue;
                T member = entry.getKey();
                if (member == null) continue;
                boolean isInstantiatedMember = this.hasAnnotation(member, InstantiatedMember.class);
                Object annotationValue = entry.getValue();
                if (isInstantiatedMember && (rawValue = this.readAnnotationValue(originatingElement, member, memberName = this.getAnnotationMemberName(member), annotationValue)) instanceof AnnotationClassValue) {
                    AnnotationClassValue acv = (AnnotationClassValue)rawValue;
                    annotationValues.put(memberName, new AnnotationClassValue(acv.getName(), true));
                }
                if (!allowAliases) continue;
                this.handleAnnotationAlias(originatingElement, metadata, isDeclared, annotationName, parentAnnotations, annotationValues, member, annotationValue);
            }
        }
        List<AnnotationMapper<Annotation>> mappers = this.getAnnotationMappers(annotationName);
        if (mappers != null) {
            AnnotationValue annotationValue = new AnnotationValue(annotationName, annotationValues);
            VisitorContext visitorContext = this.createVisitorContext();
            for (AnnotationMapper<Annotation> mapper : mappers) {
                List<AnnotationValue<?>> mapped = mapper.map((AnnotationValue<Annotation>)annotationValue, visitorContext);
                if (mapped == null) continue;
                for (AnnotationValue<?> o : mapped) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue<?> av = o;
                    retentionPolicy = av.getRetentionPolicy();
                    String mappedAnnotationName = av.getAnnotationName();
                    Optional<Object> mappedMirror = this.getAnnotationMirror(mappedAnnotationName);
                    String repeatableName = mappedMirror.map(this::getRepeatableNameForType).orElse(null);
                    if (repeatableName != null) {
                        if (isDeclared) {
                            metadata.addDeclaredRepeatable(repeatableName, av, retentionPolicy);
                        } else {
                            metadata.addRepeatable(repeatableName, av, retentionPolicy);
                        }
                    } else {
                        Map values = av.getValues();
                        if (isDeclared) {
                            metadata.addDeclaredAnnotation(mappedAnnotationName, values, retentionPolicy);
                        } else {
                            metadata.addAnnotation(mappedAnnotationName, values, retentionPolicy);
                        }
                    }
                    RetentionPolicy finalRetentionPolicy = retentionPolicy;
                    mappedMirror.ifPresent(annMirror -> {
                        Map values = av.getValues();
                        values.forEach((key, value) -> {
                            Object member = this.getAnnotationMember((T)annMirror, (CharSequence)key);
                            if (member != null) {
                                this.handleAnnotationAlias(originatingElement, metadata, isDeclared, mappedAnnotationName, Collections.emptyList(), annotationValues, member, value);
                            }
                        });
                        Map<Object, ?> defaultValues = this.readAnnotationDefaultValues(mappedAnnotationName, annMirror);
                        if (finalRetentionPolicy == RetentionPolicy.RUNTIME) {
                            this.processAnnotationDefaults(originatingElement, metadata, mappedAnnotationName, defaultValues);
                        }
                        ArrayList<String> parents = new ArrayList<String>();
                        this.processAnnotationStereotype(parents, annMirror, mappedAnnotationName, metadata, isDeclared);
                    });
                }
            }
        }
        return annotationValues;
    }

    private void handleAnnotationAlias(T originatingElement, DefaultAnnotationMetadata metadata, boolean isDeclared, String annotationName, List<String> parentAnnotations, Map<CharSequence, Object> annotationValues, T member, Object annotationValue) {
        Optional aliases = this.getAnnotationValues(originatingElement, member, Aliases.class).get((CharSequence)"value");
        if (aliases.isPresent()) {
            Object value = aliases.get();
            if (value instanceof AnnotationValue[]) {
                AnnotationValue[] values;
                for (AnnotationValue av : values = (AnnotationValue[])value) {
                    OptionalValues aliasForValues = OptionalValues.of(Object.class, (Map)av.getValues());
                    this.processAnnotationAlias(originatingElement, annotationName, member, metadata, isDeclared, parentAnnotations, annotationValues, annotationValue, aliasForValues);
                }
            }
            this.readAnnotationRawValues(originatingElement, annotationName, member, this.getAnnotationMemberName(member), annotationValue, annotationValues);
        } else {
            OptionalValues<AliasFor> aliasForValues = this.getAnnotationValues(originatingElement, member, AliasFor.class);
            this.processAnnotationAlias(originatingElement, annotationName, member, metadata, isDeclared, parentAnnotations, annotationValues, annotationValue, aliasForValues);
            this.readAnnotationRawValues(originatingElement, annotationName, member, this.getAnnotationMemberName(member), annotationValue, annotationValues);
        }
    }

    @Nullable
    protected abstract T getAnnotationMember(T var1, CharSequence var2);

    @NonNull
    protected List<AnnotationMapper<? extends Annotation>> getAnnotationMappers(@NonNull String annotationName) {
        return ANNOTATION_MAPPERS.get(annotationName);
    }

    @NonNull
    protected List<AnnotationTransformer<Annotation>> getAnnotationTransformers(@NonNull String annotationName) {
        return ANNOTATION_TRANSFORMERS.get(annotationName);
    }

    protected abstract VisitorContext createVisitorContext();

    private void processAnnotationDefaults(T originatingElement, A annotationMirror, DefaultAnnotationMetadata metadata, String annotationName) {
        Map<T, ?> elementDefaultValues = this.readAnnotationDefaultValues(annotationMirror);
        this.processAnnotationDefaults(originatingElement, metadata, annotationName, elementDefaultValues);
    }

    private void processAnnotationDefaults(T originatingElement, DefaultAnnotationMetadata metadata, String annotationName, Map<? extends T, ?> elementDefaultValues) {
        Map<String, Object> annotationDefaults = this.getAnnotationDefaults(originatingElement, metadata, annotationName, elementDefaultValues);
        if (annotationDefaults != null) {
            DefaultAnnotationMetadata.registerAnnotationDefaults(annotationName, annotationDefaults);
        } else {
            metadata.addDefaultAnnotationValues(annotationName, Collections.emptyMap());
        }
    }

    private Map<String, Object> getAnnotationDefaults(T originatingElement, DefaultAnnotationMetadata metadata, String annotationName, Map<? extends T, ?> elementDefaultValues) {
        if (elementDefaultValues != null) {
            LinkedHashMap<CharSequence, Object> defaultValues = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<T, ?> entry : elementDefaultValues.entrySet()) {
                T member = entry.getKey();
                String memberName = this.getAnnotationMemberName(member);
                if (defaultValues.containsKey(memberName)) continue;
                Object annotationValue = entry.getValue();
                this.readAnnotationRawValues(originatingElement, annotationName, member, memberName, annotationValue, defaultValues);
            }
            metadata.addDefaultAnnotationValues(annotationName, defaultValues);
            HashMap<String, Object> annotationDefaults = new HashMap<String, Object>(defaultValues.size());
            for (Map.Entry entry : defaultValues.entrySet()) {
                annotationDefaults.put(((CharSequence)entry.getKey()).toString(), entry.getValue());
            }
            return annotationDefaults;
        }
        return null;
    }

    private AnnotationMetadata lookupExisting(String declaringType, T element) {
        return MUTATED_ANNOTATION_METADATA.get(new MetadataKey<T>(declaringType, element));
    }

    private void processAnnotationAlias(T originatingElement, String annotationName, T member, DefaultAnnotationMetadata metadata, boolean isDeclared, List<String> parentAnnotations, Map<CharSequence, Object> annotationValues, Object annotationValue, OptionalValues<?> aliasForValues) {
        Optional aliasAnnotation = aliasForValues.get((CharSequence)"annotation");
        Optional aliasAnnotationName = aliasForValues.get((CharSequence)"annotationName");
        Optional aliasMember = aliasForValues.get((CharSequence)"member");
        if (aliasAnnotation.isPresent() || aliasAnnotationName.isPresent()) {
            if (aliasMember.isPresent()) {
                String aliasedAnnotation = aliasAnnotation.isPresent() ? aliasAnnotation.get().toString() : aliasAnnotationName.get().toString();
                String aliasedMemberName = aliasMember.get().toString();
                Object v = this.readAnnotationValue(originatingElement, member, aliasedMemberName, annotationValue);
                if (v != null) {
                    List<AnnotationValue<?>> remappedValues = this.remapAnnotation(aliasedAnnotation);
                    for (AnnotationValue<?> remappedAnnotation : remappedValues) {
                        String aliasedAnnotationName = remappedAnnotation.getAnnotationName();
                        Optional<T> annotationMirror = this.getAnnotationMirror(aliasedAnnotationName);
                        RetentionPolicy retentionPolicy = RetentionPolicy.RUNTIME;
                        String repeatableName = null;
                        if (annotationMirror.isPresent()) {
                            T annotationTypeMirror = annotationMirror.get();
                            Map<T, ?> defaultValues = this.readAnnotationDefaultValues(aliasedAnnotationName, annotationTypeMirror);
                            this.processAnnotationDefaults(originatingElement, metadata, aliasedAnnotationName, defaultValues);
                            retentionPolicy = this.getRetentionPolicy(annotationTypeMirror);
                            repeatableName = this.getRepeatableNameForType(annotationTypeMirror);
                        }
                        if (isDeclared) {
                            if (StringUtils.isNotEmpty(repeatableName)) {
                                metadata.addDeclaredRepeatableStereotype(parentAnnotations, repeatableName, AnnotationValue.builder((String)aliasedAnnotationName, (RetentionPolicy)retentionPolicy).members(Collections.singletonMap(aliasedMemberName, v)).build());
                            } else {
                                metadata.addDeclaredStereotype(Collections.emptyList(), aliasedAnnotationName, Collections.singletonMap(aliasedMemberName, v), retentionPolicy);
                            }
                        } else if (StringUtils.isNotEmpty(repeatableName)) {
                            metadata.addRepeatableStereotype(parentAnnotations, repeatableName, AnnotationValue.builder((String)aliasedAnnotationName, (RetentionPolicy)retentionPolicy).members(Collections.singletonMap(aliasedMemberName, v)).build());
                        } else {
                            metadata.addStereotype(Collections.emptyList(), aliasedAnnotationName, Collections.singletonMap(aliasedMemberName, v), retentionPolicy);
                        }
                        if (annotationMirror.isPresent()) {
                            this.processAnnotationStereotype(Collections.singletonList(aliasedAnnotationName), annotationMirror.get(), aliasedAnnotationName, metadata, isDeclared);
                            continue;
                        }
                        this.processAnnotationStereotype(Collections.singletonList(aliasedAnnotationName), remappedAnnotation, metadata, isDeclared);
                    }
                }
            }
        } else if (aliasMember.isPresent()) {
            String aliasedNamed = aliasMember.get().toString();
            Object v = this.readAnnotationValue(originatingElement, member, aliasedNamed, annotationValue);
            if (v != null) {
                annotationValues.put(aliasedNamed, v);
            }
            this.readAnnotationRawValues(originatingElement, annotationName, member, aliasedNamed, annotationValue, annotationValues);
        }
    }

    @NonNull
    protected abstract RetentionPolicy getRetentionPolicy(@NonNull T var1);

    private AnnotationMetadata buildInternal(T parent, T element, DefaultAnnotationMetadata annotationMetadata, boolean inheritTypeAnnotations, boolean declaredOnly, boolean allowAliases) {
        Object parentHierarchy;
        Object hierarchy = this.buildHierarchy(element, inheritTypeAnnotations, declaredOnly);
        if (parent != null) {
            parentHierarchy = this.buildHierarchy(parent, inheritTypeAnnotations, declaredOnly);
            if (hierarchy.isEmpty() && !parentHierarchy.isEmpty()) {
                hierarchy = parentHierarchy;
            } else {
                hierarchy.addAll(0, parentHierarchy);
            }
        }
        Collections.reverse(hierarchy);
        parentHierarchy = hierarchy.iterator();
        while (parentHierarchy.hasNext()) {
            List<A> annotationHierarchy;
            Object currentElement = parentHierarchy.next();
            if (currentElement == null || (annotationHierarchy = this.getAnnotationsForType(currentElement)).isEmpty()) continue;
            boolean isDeclared = currentElement == element;
            this.includeAnnotations(annotationMetadata, currentElement, isDeclared, annotationHierarchy, allowAliases);
        }
        if (!annotationMetadata.hasDeclaredStereotype(Scope.class) && annotationMetadata.hasDeclaredStereotype(DefaultScope.class)) {
            Optional value = annotationMetadata.stringValue(DefaultScope.class);
            value.ifPresent(name -> annotationMetadata.addDeclaredAnnotation((String)name, Collections.emptyMap()));
        }
        return annotationMetadata;
    }

    private void includeAnnotations(DefaultAnnotationMetadata annotationMetadata, T element, boolean isDeclared, List<? extends A> annotationHierarchy, boolean allowAliases) {
        ArrayList<A> hierarchyCopy = new ArrayList<A>(annotationHierarchy);
        ListIterator<A> listIterator = hierarchyCopy.listIterator();
        while (listIterator.hasNext()) {
            A annotationMirror = listIterator.next();
            String annotationName = this.getAnnotationTypeName(annotationMirror);
            if (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName)) continue;
            if (DEPRECATED_ANNOTATION_NAMES.containsKey(annotationName)) {
                this.addWarning(element, "Usages of deprecated annotation " + annotationName + " found. You should use " + DEPRECATED_ANNOTATION_NAMES.get(annotationName) + " instead.");
            }
            T annotationType = this.getTypeForAnnotation(annotationMirror);
            RetentionPolicy retentionPolicy = this.getRetentionPolicy(annotationType);
            Map<CharSequence, Object> annotationValues = this.populateAnnotationData(element, annotationMirror, annotationMetadata, isDeclared, retentionPolicy, allowAliases);
            if (isDeclared) {
                this.applyTransformations(listIterator, annotationMetadata, isDeclared, annotationMirror, annotationValues, Collections.emptyList(), annotationMetadata::addDeclaredRepeatable, annotationMetadata::addDeclaredAnnotation);
                continue;
            }
            this.applyTransformations(listIterator, annotationMetadata, isDeclared, annotationMirror, annotationValues, Collections.emptyList(), annotationMetadata::addRepeatable, annotationMetadata::addAnnotation);
        }
        for (A annotationMirror : hierarchyCopy) {
            String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
            String packageName = NameUtils.getPackageName((String)annotationTypeName);
            if (AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName)) continue;
            this.processAnnotationStereotype(annotationMirror, annotationMetadata, isDeclared);
        }
    }

    private void buildStereotypeHierarchy(List<String> parents, AnnotationValue<?> annotationValue, DefaultAnnotationMetadata metadata, boolean isDeclared, List<String> excludes) {
        List annotationMirrors = annotationValue.getStereotypes();
        LinkedList<AnnotationValueBuilder> interceptorBindings = new LinkedList<AnnotationValueBuilder>();
        String lastParent = (String)CollectionUtils.last(parents);
        if (CollectionUtils.isNotEmpty((Collection)annotationMirrors)) {
            ArrayList<AnnotationValue> topLevel = new ArrayList<AnnotationValue>();
            ListIterator listIterator = annotationMirrors.listIterator();
            while (listIterator.hasNext()) {
                boolean hasInterceptorBinding;
                AnnotationValue annotationMirror = (AnnotationValue)listIterator.next();
                String annotationName = annotationMirror.getAnnotationName();
                if (annotationName.equals(annotationValue.getAnnotationName()) || AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName) || excludes.contains(annotationName) || ("io.micronaut.aop.Around".equals(lastParent) || "io.micronaut.aop.Introduction".equals(lastParent)) && "io.micronaut.aop.InterceptorBinding".equals(annotationName)) continue;
                if (lastParent != null) {
                    AnnotationValueBuilder interceptorBinding = null;
                    if ("io.micronaut.aop.Around".equals(annotationName) || "io.micronaut.aop.InterceptorBinding".equals(annotationName)) {
                        interceptorBinding = AnnotationValue.builder((String)"io.micronaut.aop.InterceptorBinding").member("value", new AnnotationClassValue[]{new AnnotationClassValue(lastParent)}).member("kind", "AROUND");
                    } else if ("io.micronaut.aop.Introduction".equals(annotationName)) {
                        interceptorBinding = AnnotationValue.builder((String)"io.micronaut.aop.InterceptorBinding").member("value", new AnnotationClassValue[]{new AnnotationClassValue(lastParent)}).member("kind", "INTRODUCTION");
                    }
                    if (interceptorBinding != null) {
                        interceptorBindings.add(interceptorBinding);
                    }
                }
                RetentionPolicy retentionPolicy = annotationMirror.getRetentionPolicy();
                topLevel.add(annotationMirror);
                Map data = annotationMirror.getValues();
                boolean bl = hasInterceptorBinding = !interceptorBindings.isEmpty();
                if (hasInterceptorBinding && "io.micronaut.aop.InterceptorBinding".equals(annotationName)) {
                    ((AnnotationValueBuilder)interceptorBindings.getLast()).members(data);
                    continue;
                }
                if (hasInterceptorBinding && Type.class.getName().equals(annotationName)) {
                    AnnotationClassValue[] values;
                    Object o = data.get("value");
                    AnnotationClassValue interceptorType = null;
                    if (o instanceof AnnotationClassValue) {
                        interceptorType = (AnnotationClassValue)o;
                    } else if (o instanceof AnnotationClassValue[] && (values = (AnnotationClassValue[])o).length > 0) {
                        interceptorType = values[0];
                    }
                    if (interceptorType != null) {
                        for (AnnotationValueBuilder interceptorBinding : interceptorBindings) {
                            interceptorBinding.member("interceptorType", new AnnotationClassValue[]{interceptorType});
                        }
                    }
                }
                if (isDeclared) {
                    metadata.addDeclaredStereotype(parents, annotationName, data, retentionPolicy);
                    continue;
                }
                metadata.addStereotype(parents, annotationName, data, retentionPolicy);
            }
            for (AnnotationValue annotationMirror : topLevel) {
                this.processAnnotationStereotype(parents, annotationMirror, metadata, isDeclared);
            }
        }
        if (!interceptorBindings.isEmpty()) {
            for (AnnotationValueBuilder interceptorBinding : interceptorBindings) {
                if (isDeclared) {
                    metadata.addDeclaredRepeatable("io.micronaut.aop.InterceptorBindingDefinitions", interceptorBinding.build());
                    continue;
                }
                metadata.addRepeatable("io.micronaut.aop.InterceptorBindingDefinitions", interceptorBinding.build());
            }
        }
    }

    private void buildStereotypeHierarchy(List<String> parents, T element, DefaultAnnotationMetadata metadata, boolean isDeclared, boolean allowAliases, List<String> excludes) {
        List<A> annotationMirrors = this.getAnnotationsForType(element);
        AnnotationValueBuilder interceptorBinding = null;
        AnnotationClassValue interceptorType = null;
        String lastParent = (String)CollectionUtils.last(parents);
        if (!annotationMirrors.isEmpty()) {
            ArrayList<Object> topLevel = new ArrayList<Object>();
            ListIterator<A> listIterator = annotationMirrors.listIterator();
            while (listIterator.hasNext()) {
                A annotationMirror = listIterator.next();
                String string2 = this.getAnnotationTypeName(annotationMirror);
                if (string2.equals(this.getElementName(element)) || AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(string2) || excludes.contains(string2) || ("io.micronaut.aop.Around".equals(lastParent) || "io.micronaut.aop.Introduction".equals(lastParent)) && "io.micronaut.aop.InterceptorBinding".equals(string2)) continue;
                if (lastParent != null && interceptorBinding == null) {
                    if ("io.micronaut.aop.Around".equals(string2) || "io.micronaut.aop.InterceptorBinding".equals(string2)) {
                        interceptorBinding = AnnotationValue.builder((String)"io.micronaut.aop.InterceptorBinding").member("value", new AnnotationClassValue[]{new AnnotationClassValue(lastParent)}).member("kind", "AROUND");
                    } else if ("io.micronaut.aop.Introduction".equals(string2)) {
                        interceptorBinding = AnnotationValue.builder((String)"io.micronaut.aop.InterceptorBinding").member("value", new AnnotationClassValue[]{new AnnotationClassValue(lastParent)}).member("kind", "INTRODUCTION");
                    }
                }
                T annotationTypeMirror = this.getTypeForAnnotation(annotationMirror);
                RetentionPolicy retentionPolicy = this.getRetentionPolicy(annotationTypeMirror);
                topLevel.add(annotationMirror);
                Map<CharSequence, Object> data = this.populateAnnotationData(element, annotationMirror, metadata, isDeclared, retentionPolicy, allowAliases);
                if (interceptorBinding != null && "io.micronaut.aop.InterceptorBinding".equals(string2)) {
                    interceptorBinding.members(data);
                    continue;
                }
                if (Type.class.getName().equals(string2)) {
                    AnnotationClassValue[] values2;
                    Object o = data.get("value");
                    if (o instanceof AnnotationClassValue) {
                        interceptorType = (AnnotationClassValue)o;
                    } else if (o instanceof AnnotationClassValue[] && (values2 = (AnnotationClassValue[])o).length > 0) {
                        interceptorType = values2[0];
                    }
                }
                if (isDeclared) {
                    this.applyTransformations(listIterator, metadata, isDeclared, annotationMirror, data, parents, (string, av) -> metadata.addDeclaredRepeatableStereotype(parents, (String)string, (AnnotationValue)av), (string, values, rp) -> metadata.addDeclaredStereotype(parents, (String)string, (Map<CharSequence, Object>)values, (RetentionPolicy)((Object)((Object)rp))));
                    continue;
                }
                this.applyTransformations(listIterator, metadata, isDeclared, annotationMirror, data, parents, (string, av) -> metadata.addRepeatableStereotype(parents, (String)string, (AnnotationValue)av), (string, values, rp) -> metadata.addStereotype(parents, (String)string, (Map<CharSequence, Object>)values, (RetentionPolicy)((Object)((Object)rp))));
            }
            topLevel.removeIf(a -> !annotationMirrors.contains(a));
            for (Object e : topLevel) {
                this.processAnnotationStereotype(parents, e, metadata, isDeclared);
            }
        }
        if (interceptorBinding != null) {
            if (interceptorType != null) {
                interceptorBinding.member("interceptorType", new AnnotationClassValue[]{interceptorType});
            }
            if (isDeclared) {
                metadata.addDeclaredRepeatable("io.micronaut.aop.InterceptorBindingDefinitions", interceptorBinding.build());
            } else {
                metadata.addRepeatable("io.micronaut.aop.InterceptorBindingDefinitions", interceptorBinding.build());
            }
        }
    }

    private void processAnnotationStereotype(A annotationMirror, DefaultAnnotationMetadata annotationMetadata, boolean isDeclared) {
        T annotationType = this.getTypeForAnnotation(annotationMirror);
        String parentAnnotationName = this.getAnnotationTypeName(annotationMirror);
        if (!parentAnnotationName.endsWith(".Nullable")) {
            this.processAnnotationStereotypes(annotationMetadata, isDeclared, annotationType, parentAnnotationName, Collections.emptyList());
        }
    }

    private void processAnnotationStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, T annotationType, String annotationName, List<String> excludes) {
        ArrayList<String> parentAnnotations = new ArrayList<String>();
        parentAnnotations.add(annotationName);
        this.buildStereotypeHierarchy(parentAnnotations, annotationType, annotationMetadata, isDeclared, true, excludes);
    }

    private void processAnnotationStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, AnnotationValue<?> annotation, List<String> parents) {
        ArrayList<String> parentAnnotations = new ArrayList<String>(parents);
        parentAnnotations.add(annotation.getAnnotationName());
        this.buildStereotypeHierarchy(parentAnnotations, annotation, annotationMetadata, isDeclared, Collections.emptyList());
    }

    private void processAnnotationStereotype(List<String> parents, A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        T typeForAnnotation = this.getTypeForAnnotation(annotationMirror);
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        this.processAnnotationStereotype(parents, typeForAnnotation, annotationTypeName, metadata, isDeclared);
    }

    private void processAnnotationStereotype(List<String> parents, T annotationType, String annotationTypeName, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        ArrayList<String> stereoTypeParents = new ArrayList<String>(parents);
        stereoTypeParents.add(annotationTypeName);
        this.buildStereotypeHierarchy(stereoTypeParents, annotationType, metadata, isDeclared, true, Collections.emptyList());
    }

    private void processAnnotationStereotype(List<String> parents, AnnotationValue<?> annotationType, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        ArrayList<String> stereoTypeParents = new ArrayList<String>(parents);
        stereoTypeParents.add(annotationType.getAnnotationName());
        this.buildStereotypeHierarchy(stereoTypeParents, annotationType, metadata, isDeclared, Collections.emptyList());
    }

    private void applyTransformations(ListIterator<? extends A> hierarchyIterator, DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, A annotationMirror, Map<CharSequence, Object> data, List<String> parents, BiConsumer<String, AnnotationValue> addRepeatableAnnotation, TriConsumer<String, Map<CharSequence, Object>, RetentionPolicy> addAnnotation) {
        block28: {
            List<AnnotationTransformer<Annotation>> annotationTransformers;
            String annotationName;
            block31: {
                boolean remapped;
                List<AnnotationRemapper> annotationRemappers;
                RetentionPolicy retentionPolicy;
                block30: {
                    boolean transformed;
                    block26: {
                        String repeatableName;
                        block29: {
                            block27: {
                                annotationName = this.getAnnotationTypeName(annotationMirror);
                                repeatableName = this.getRepeatableName(annotationMirror);
                                String packageName = NameUtils.getPackageName((String)annotationName);
                                T annotationType = this.getTypeForAnnotation(annotationMirror);
                                retentionPolicy = this.getRetentionPolicy(annotationType);
                                annotationRemappers = ANNOTATION_REMAPPERS.get(packageName);
                                annotationTransformers = this.getAnnotationTransformers(annotationName);
                                remapped = CollectionUtils.isNotEmpty(annotationRemappers);
                                transformed = CollectionUtils.isNotEmpty(annotationTransformers);
                                if (repeatableName == null) break block26;
                                if (remapped || transformed) break block27;
                                AnnotationValue av = new AnnotationValue(annotationName, data);
                                addRepeatableAnnotation.accept(repeatableName, av);
                                break block28;
                            }
                            if (!remapped) break block29;
                            VisitorContext visitorContext = this.createVisitorContext();
                            AnnotationValue av = new AnnotationValue(annotationName, data);
                            AnnotationValue repeatableAnn = AnnotationValue.builder((String)repeatableName).values(new AnnotationValue[]{av}).build();
                            boolean wasRemapped = false;
                            for (AnnotationRemapper annotationRemapper : annotationRemappers) {
                                List<AnnotationValue<?>> remappedRepeatable = annotationRemapper.remap(repeatableAnn, visitorContext);
                                List<AnnotationValue<?>> remappedValue = annotationRemapper.remap(av, visitorContext);
                                if (!CollectionUtils.isNotEmpty(remappedRepeatable)) continue;
                                block3: for (AnnotationValue<?> repeatable : remappedRepeatable) {
                                    for (AnnotationValue<?> rmv : remappedValue) {
                                        if (rmv == av && remappedValue.size() == 1) {
                                            addRepeatableAnnotation.accept(repeatableName, av);
                                            continue block3;
                                        }
                                        wasRemapped = true;
                                        addRepeatableAnnotation.accept(repeatable.getAnnotationName(), rmv);
                                    }
                                }
                            }
                            if (!wasRemapped) break block28;
                            hierarchyIterator.remove();
                            break block28;
                        }
                        VisitorContext visitorContext = this.createVisitorContext();
                        AnnotationValue av = new AnnotationValue(annotationName, data);
                        AnnotationValue repeatableAnn = AnnotationValue.builder((String)repeatableName).values(new AnnotationValue[]{av}).build();
                        List<AnnotationTransformer<Annotation>> repeatableTransformers = this.getAnnotationTransformers(repeatableName);
                        hierarchyIterator.remove();
                        if (CollectionUtils.isNotEmpty(repeatableTransformers)) {
                            for (AnnotationTransformer<Annotation> repeatableTransformer : repeatableTransformers) {
                                List<AnnotationValue<?>> transformedRepeatable = repeatableTransformer.transform((AnnotationValue<Annotation>)repeatableAnn, visitorContext);
                                for (AnnotationValue<?> annotationValue : transformedRepeatable) {
                                    for (AnnotationTransformer<Annotation> transformer : annotationTransformers) {
                                        List<AnnotationValue<?>> tav = transformer.transform((AnnotationValue<Annotation>)av, visitorContext);
                                        for (AnnotationValue<?> value : tav) {
                                            addRepeatableAnnotation.accept(annotationValue.getAnnotationName(), value);
                                            if (CollectionUtils.isNotEmpty((Collection)value.getStereotypes())) {
                                                this.addTransformedStereotypes(annotationMetadata, isDeclared, value, parents);
                                                continue;
                                            }
                                            this.addTransformedStereotypes(annotationMetadata, isDeclared, value.getAnnotationName(), parents);
                                        }
                                    }
                                }
                            }
                        } else {
                            for (AnnotationTransformer<Annotation> transformer : annotationTransformers) {
                                List<AnnotationValue<?>> tav = transformer.transform((AnnotationValue<Annotation>)av, visitorContext);
                                for (AnnotationValue<?> value : tav) {
                                    addRepeatableAnnotation.accept(repeatableName, value);
                                    if (CollectionUtils.isNotEmpty((Collection)value.getStereotypes())) {
                                        this.addTransformedStereotypes(annotationMetadata, isDeclared, value, parents);
                                        continue;
                                    }
                                    this.addTransformedStereotypes(annotationMetadata, isDeclared, value.getAnnotationName(), parents);
                                }
                            }
                        }
                        break block28;
                    }
                    if (remapped || transformed) break block30;
                    addAnnotation.accept(annotationName, data, retentionPolicy);
                    break block28;
                }
                if (!remapped) break block31;
                AnnotationValue av = new AnnotationValue(annotationName, data);
                VisitorContext visitorContext = this.createVisitorContext();
                boolean wasRemapped = false;
                block11: for (AnnotationRemapper annotationRemapper : annotationRemappers) {
                    List<AnnotationValue<?>> remappedValues = annotationRemapper.remap(av, visitorContext);
                    if (!CollectionUtils.isNotEmpty(remappedValues)) continue;
                    for (AnnotationValue<?> annotationValue : remappedValues) {
                        if (annotationValue == av && remappedValues.size() == 1) {
                            addAnnotation.accept(annotationName, data, retentionPolicy);
                            continue block11;
                        }
                        wasRemapped = true;
                        String transformedAnnotationName = annotationValue.getAnnotationName();
                        addAnnotation.accept(transformedAnnotationName, annotationValue.getValues(), annotationValue.getRetentionPolicy());
                        if (CollectionUtils.isNotEmpty((Collection)annotationValue.getStereotypes())) {
                            this.addTransformedStereotypes(annotationMetadata, isDeclared, annotationValue, parents);
                            continue;
                        }
                        this.addTransformedStereotypes(annotationMetadata, isDeclared, transformedAnnotationName, parents);
                    }
                }
                if (!wasRemapped) break block28;
                hierarchyIterator.remove();
                break block28;
            }
            AnnotationValue av = new AnnotationValue(annotationName, data);
            VisitorContext visitorContext = this.createVisitorContext();
            hierarchyIterator.remove();
            for (AnnotationTransformer<Annotation> annotationTransformer : annotationTransformers) {
                List<AnnotationValue<?>> transformedValues = annotationTransformer.transform((AnnotationValue<Annotation>)av, visitorContext);
                for (AnnotationValue<?> transformedValue : transformedValues) {
                    String transformedRepeatableName;
                    String transformedAnnotationName = transformedValue.getAnnotationName();
                    if (this.isRepeatableCandidate(transformedAnnotationName)) {
                        String resolvedName = null;
                        try {
                            resolvedName = this.getAnnotationMirror(transformedAnnotationName).map(this::getRepeatableNameForType).orElse(null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        transformedRepeatableName = resolvedName;
                    } else {
                        transformedRepeatableName = null;
                    }
                    if (transformedRepeatableName != null) {
                        addRepeatableAnnotation.accept(transformedRepeatableName, transformedValue);
                    } else {
                        addAnnotation.accept(transformedAnnotationName, transformedValue.getValues(), transformedValue.getRetentionPolicy());
                    }
                    this.addTransformedStereotypes(annotationMetadata, isDeclared, transformedAnnotationName, parents);
                }
            }
        }
    }

    private List<AnnotationValue<?>> remapAnnotation(String annotationName) {
        String packageName = NameUtils.getPackageName((String)annotationName);
        List<AnnotationRemapper> annotationRemappers = ANNOTATION_REMAPPERS.get(packageName);
        ArrayList mappedAnnotations = new ArrayList();
        if (annotationRemappers == null || annotationRemappers.isEmpty()) {
            mappedAnnotations.add(AnnotationValue.builder((String)annotationName).build());
            return mappedAnnotations;
        }
        VisitorContext visitorContext = this.createVisitorContext();
        AnnotationValue av = new AnnotationValue(annotationName);
        for (AnnotationRemapper annotationRemapper : annotationRemappers) {
            List<AnnotationValue<?>> remappedValues = annotationRemapper.remap(av, visitorContext);
            if (!CollectionUtils.isNotEmpty(remappedValues)) continue;
            for (AnnotationValue<?> annotationValue : remappedValues) {
                if (annotationValue == av && remappedValues.size() == 1) break;
                mappedAnnotations.add(annotationValue);
            }
        }
        return mappedAnnotations;
    }

    private boolean isRepeatableCandidate(String transformedAnnotationName) {
        return !AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(transformedAnnotationName) && !"javax.annotation.Nullable".equals(transformedAnnotationName) && !"javax.annotation.Nonnull".equals(transformedAnnotationName);
    }

    private void addTransformedStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, String transformedAnnotationName, List<String> parents) {
        String packageName;
        if (!AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(transformedAnnotationName) && !AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName = NameUtils.getPackageName((String)transformedAnnotationName))) {
            this.getAnnotationMirror(transformedAnnotationName).ifPresent(a -> this.processAnnotationStereotypes(annotationMetadata, isDeclared, a, transformedAnnotationName, parents));
        }
    }

    private void addTransformedStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, AnnotationValue<?> transformedAnnotation, List<String> parents) {
        String packageName;
        String transformedAnnotationName = transformedAnnotation.getAnnotationName();
        if (!AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(transformedAnnotationName) && !AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName = NameUtils.getPackageName((String)transformedAnnotationName))) {
            this.processAnnotationStereotypes(annotationMetadata, isDeclared, transformedAnnotation, parents);
        }
    }

    @Internal
    public static void addMutatedMetadata(String declaringType, Object element, AnnotationMetadata metadata) {
        if (element != null && metadata != null) {
            MUTATED_ANNOTATION_METADATA.put(new MetadataKey<Object>(declaringType, element), metadata);
        }
    }

    @Internal
    public static boolean isMetadataMutated(String declaringType, Object element) {
        if (element != null) {
            return MUTATED_ANNOTATION_METADATA.containsKey(new MetadataKey<Object>(declaringType, element));
        }
        return false;
    }

    @Internal
    public static void clearMutated() {
        MUTATED_ANNOTATION_METADATA.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Internal
    public static boolean isAnnotationMapped(@Nullable String annotationName) {
        if (annotationName == null) return false;
        if (ANNOTATION_MAPPERS.containsKey(annotationName)) return true;
        if (ANNOTATION_TRANSFORMERS.containsKey(annotationName)) return true;
        if (!ANNOTATION_TRANSFORMERS.keySet().stream().anyMatch(annotationName::startsWith)) return false;
        return true;
    }

    @Internal
    public static Set<String> getMappedAnnotationNames() {
        HashSet<String> all = new HashSet<String>(ANNOTATION_MAPPERS.keySet());
        all.addAll(ANNOTATION_TRANSFORMERS.keySet());
        return all;
    }

    @Internal
    public static Set<String> getMappedAnnotationPackages() {
        return ANNOTATION_REMAPPERS.keySet();
    }

    public <A2 extends Annotation> AnnotationMetadata annotate(AnnotationMetadata annotationMetadata, AnnotationValue<A2> annotationValue) {
        String annotationName = annotationValue.getAnnotationName();
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            T annotationMirror = this.getAnnotationMirror(annotationName).orElse(null);
            DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)annotationMetadata;
            if (annotationMirror != null) {
                String repeatableName = this.getRepeatableNameForType(annotationMirror);
                RetentionPolicy retentionPolicy = this.getRetentionPolicy(annotationMirror);
                if (repeatableName != null) {
                    defaultMetadata.addDeclaredRepeatable(repeatableName, annotationValue, retentionPolicy);
                } else {
                    defaultMetadata.addDeclaredAnnotation(annotationName, annotationValue.getValues(), retentionPolicy);
                }
            } else {
                defaultMetadata.addDeclaredAnnotation(annotationName, annotationValue.getValues());
            }
            if (annotationMirror != null) {
                Map<Object, ?> defaultValues = this.readAnnotationDefaultValues(annotationName, annotationMirror);
                this.processAnnotationDefaults(annotationMirror, defaultMetadata, annotationName, defaultValues);
                this.processAnnotationStereotypes(defaultMetadata, true, annotationMirror, annotationName, DEFAULT_ANNOTATE_EXCLUDES);
            }
        } else {
            if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
                AnnotationMetadataHierarchy hierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
                AnnotationMetadata declaredMetadata = this.annotate(hierarchy.getDeclaredMetadata(), annotationValue);
                return hierarchy.createSibling(declaredMetadata);
            }
            if (annotationMetadata == AnnotationMetadata.EMPTY_METADATA || annotationMetadata instanceof AnnotationMetadataReference) {
                T annotationMirror = this.getAnnotationMirror(annotationName).orElse(null);
                MutableAnnotationMetadata newMetadata = new MutableAnnotationMetadata();
                if (annotationMirror != null) {
                    String repeatableName = this.getRepeatableNameForType(annotationMirror);
                    RetentionPolicy retentionPolicy = this.getRetentionPolicy(annotationMirror);
                    if (repeatableName != null) {
                        ((DefaultAnnotationMetadata)newMetadata).addDeclaredRepeatable(repeatableName, annotationValue, retentionPolicy);
                    } else {
                        ((DefaultAnnotationMetadata)newMetadata).addDeclaredAnnotation(annotationName, annotationValue.getValues(), retentionPolicy);
                    }
                } else {
                    ((DefaultAnnotationMetadata)newMetadata).addDeclaredAnnotation(annotationName, annotationValue.getValues());
                }
                if (annotationMirror != null) {
                    this.processAnnotationStereotypes(newMetadata, true, annotationMirror, annotationName, DEFAULT_ANNOTATE_EXCLUDES);
                }
                if (annotationMetadata instanceof AnnotationMetadataReference) {
                    AnnotationMetadataReference ref = (AnnotationMetadataReference)annotationMetadata;
                    return new AnnotationMetadataHierarchy(new AnnotationMetadata[]{ref, newMetadata});
                }
                return newMetadata;
            }
        }
        return annotationMetadata;
    }

    static {
        SoftServiceLoader serviceLoader = SoftServiceLoader.load(AnnotationMapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (Object definition : serviceLoader) {
            if (!definition.isPresent()) continue;
            AnnotationMapper mapper = (AnnotationMapper)definition.load();
            try {
                String name = null;
                if (mapper instanceof TypedAnnotationMapper) {
                    name = ((TypedAnnotationMapper)mapper).annotationType().getName();
                } else if (mapper instanceof NamedAnnotationMapper) {
                    name = ((NamedAnnotationMapper)mapper).getName();
                }
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_MAPPERS.computeIfAbsent(name, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable name) {}
        }
        SoftServiceLoader transformerSoftServiceLoader = SoftServiceLoader.load(AnnotationTransformer.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (ServiceDefinition definition : transformerSoftServiceLoader) {
            if (!definition.isPresent()) continue;
            AnnotationTransformer transformer = (AnnotationTransformer)definition.load();
            try {
                String name = null;
                if (transformer instanceof TypedAnnotationTransformer) {
                    name = ((TypedAnnotationTransformer)transformer).annotationType().getName();
                } else if (transformer instanceof NamedAnnotationTransformer) {
                    name = ((NamedAnnotationTransformer)transformer).getName();
                }
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_TRANSFORMERS.computeIfAbsent(name, s -> new ArrayList(2)).add(transformer);
            }
            catch (Throwable name) {}
        }
        SoftServiceLoader remapperLoader = SoftServiceLoader.load(AnnotationRemapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (ServiceDefinition definition : remapperLoader) {
            if (!definition.isPresent()) continue;
            AnnotationRemapper mapper = (AnnotationRemapper)definition.load();
            try {
                String name = mapper.getPackageName();
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_REMAPPERS.computeIfAbsent(name, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable throwable) {}
        }
    }

    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }

    private static class MetadataKey<T> {
        final String declaringName;
        final T element;

        MetadataKey(String declaringName, T element) {
            this.declaringName = declaringName;
            this.element = element;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataKey that = (MetadataKey)o;
            return this.declaringName.equals(that.declaringName) && this.element.equals(that.element);
        }

        public int hashCode() {
            return Objects.hash(this.declaringName, this.element);
        }
    }
}

