/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public final class InterceptorBindingQualifier<T>
implements Qualifier<T> {
    private final Set<String> supportedAnnotationNames;
    private final Set<Class<?>> supportedInterceptorTypes;

    InterceptorBindingQualifier(AnnotationMetadata annotationMetadata) {
        List annotationValues = annotationMetadata.findAnnotation("io.micronaut.inject.qualifiers.InterceptorBindingQualifier").map(av -> av.getAnnotations("value")).orElse(Collections.emptyList());
        this.supportedAnnotationNames = annotationValues.stream().flatMap(av -> av.stringValue().map(Stream::of).orElse(Stream.empty())).collect(Collectors.toSet());
        this.supportedInterceptorTypes = annotationValues.stream().flatMap(av -> av.classValue("interceptorType").map(Stream::of).orElse(Stream.empty())).collect(Collectors.toSet());
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> {
            if (this.supportedInterceptorTypes.contains(candidate.getBeanType())) {
                return true;
            }
            ArrayList<String> annotationNames = new ArrayList<String>(InterceptorBindingQualifier.resolveInterceptorValues(candidate.getAnnotationMetadata()));
            annotationNames.retainAll(this.supportedAnnotationNames);
            return !annotationNames.isEmpty();
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorBindingQualifier that = (InterceptorBindingQualifier)o;
        return this.supportedAnnotationNames.equals(that.supportedAnnotationNames) && this.supportedInterceptorTypes.equals(that.supportedInterceptorTypes);
    }

    public int hashCode() {
        return Objects.hash(this.supportedAnnotationNames, this.supportedInterceptorTypes);
    }

    public static List<String> resolveInterceptorValues(AnnotationMetadata annotationMetadata) {
        AnnotationValue bindings = annotationMetadata.getAnnotation("io.micronaut.aop.InterceptorBindingDefinitions");
        if (bindings != null) {
            return bindings.getAnnotations("value").stream().map(AnnotationValue::stringValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

