/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Provider;

@Internal
public class ProviderFactory {
    private static Map<Class, Function<Supplier<?>, ?>> providers = new HashMap(3);

    @NonNull
    public static <P> Optional<P> createProvider(Class<P> providerType, @NonNull BeanProvider<?> beanProvider) {
        if (providerType == BeanProvider.class) {
            return Optional.of(beanProvider);
        }
        Function<Supplier<?>, ?> function = providers.get(providerType);
        if (function != null) {
            return Optional.ofNullable(function.apply(beanProvider::get));
        }
        return Optional.empty();
    }

    public static boolean isProvider(String clazz) {
        if (clazz.equals(BeanProvider.class.getName())) {
            return true;
        }
        for (Class provider : ProviderFactory.getProviders()) {
            if (!provider.getName().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProvider(Class clazz) {
        if (BeanProvider.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Class provider : ProviderFactory.getProviders()) {
            if (!provider.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Set<Class> getProviders() {
        return providers.keySet();
    }

    static {
        try {
            providers.put(Provider.class, supplier -> ((Supplier)supplier)::get);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            providers.put(jakarta.inject.Provider.class, supplier -> ((Supplier)supplier)::get);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

