/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.InjectScope;
import io.micronaut.context.exceptions.CircularDependencyException;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.inject.ArgumentInjectionPoint;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.CallableInjectionPoint;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ProxyBeanDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
public abstract class AbstractBeanResolutionContext
implements BeanResolutionContext {
    protected final BeanContext context;
    protected final BeanDefinition rootDefinition;
    private final BeanResolutionContext.Path path;
    private Map<CharSequence, Object> attributes;
    private Qualifier<?> qualifier;
    private List<BeanRegistration<?>> dependentBeans;

    @Internal
    public AbstractBeanResolutionContext(BeanContext context, BeanDefinition rootDefinition) {
        this.context = context;
        this.rootDefinition = rootDefinition;
        this.path = new DefaultPath();
    }

    public void copyStateFrom(@NonNull AbstractBeanResolutionContext context) {
        this.path.addAll(context.path);
        this.qualifier = context.qualifier;
        if (context.attributes != null) {
            this.getAttributesOrCreate().putAll(context.attributes);
        }
    }

    @Override
    public <T> void addDependentBean(BeanIdentifier identifier, BeanDefinition<T> definition, T bean) {
        if (this.dependentBeans == null) {
            this.dependentBeans = new ArrayList(3);
        }
        this.dependentBeans.add(new BeanRegistration<T>(identifier, definition, bean));
    }

    @Override
    public void destroyInjectScopedBeans() {
        CustomScope injectScope = ((DefaultBeanContext)this.context).getCustomScopeRegistry().findScope(InjectScope.class.getName()).orElse(null);
        if (injectScope instanceof LifeCycle) {
            ((LifeCycle)((Object)injectScope)).stop();
        }
    }

    @Override
    @NonNull
    public List<BeanRegistration<?>> getAndResetDependentBeans() {
        if (this.dependentBeans == null) {
            return Collections.emptyList();
        }
        List<BeanRegistration<?>> registrations = Collections.unmodifiableList(new ArrayList(this.dependentBeans));
        this.dependentBeans.clear();
        return registrations;
    }

    @Override
    public final BeanContext getContext() {
        return this.context;
    }

    @Override
    public final BeanDefinition getRootDefinition() {
        return this.rootDefinition;
    }

    @Override
    public final BeanResolutionContext.Path getPath() {
        return this.path;
    }

    @Override
    public final Object setAttribute(CharSequence key, Object value) {
        return this.getAttributesOrCreate().put(key, value);
    }

    @Override
    public final Object getAttribute(CharSequence key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public final Object removeAttribute(CharSequence key) {
        if (this.attributes != null && key != null) {
            return this.attributes.remove(key);
        }
        return null;
    }

    @Override
    @Nullable
    public Qualifier<?> getCurrentQualifier() {
        return this.qualifier;
    }

    @Override
    public void setCurrentQualifier(@Nullable Qualifier<?> qualifier) {
        this.qualifier = qualifier;
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        Object value = this.attributes.get(name);
        if (value != null && conversionContext.getArgument().getType().isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        Object value = this.attributes.get(name);
        if (requiredType.isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @NonNull
    private Map<CharSequence, Object> getAttributesOrCreate() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<CharSequence, Object>(2);
        }
        return this.attributes;
    }

    static abstract class AbstractSegment
    implements BeanResolutionContext.Segment,
    Named {
        private final BeanDefinition declaringComponent;
        private final String name;
        private final Argument argument;

        AbstractSegment(BeanDefinition declaringClass, String name, Argument argument) {
            this.declaringComponent = declaringClass;
            this.name = name;
            this.argument = argument;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public BeanDefinition getDeclaringType() {
            return this.declaringComponent;
        }

        @Override
        public Argument getArgument() {
            return this.argument;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractSegment that = (AbstractSegment)o;
            return this.declaringComponent.equals(that.declaringComponent) && this.name.equals(that.name) && this.argument.equals(that.argument);
        }

        public int hashCode() {
            int result = this.declaringComponent.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.argument.hashCode();
            return result;
        }

        void outputArguments(StringBuilder baseString, Argument[] arguments) {
            baseString.append('(');
            for (int i = 0; i < arguments.length; ++i) {
                Argument argument = arguments[i];
                boolean isInjectedArgument = argument.equals(this.getArgument());
                if (isInjectedArgument) {
                    baseString.append('[');
                }
                baseString.append(argument);
                if (isInjectedArgument) {
                    baseString.append(']');
                }
                if (i == arguments.length - 1) continue;
                baseString.append(',');
            }
            baseString.append(')');
        }
    }

    public static class FieldSegment
    extends AbstractSegment
    implements InjectionPoint,
    ArgumentCoercible,
    ArgumentInjectionPoint {
        private final boolean requiresReflection;

        FieldSegment(BeanDefinition declaringClass, Argument argument, boolean requiresReflection) {
            super(declaringClass, argument.getName(), argument);
            this.requiresReflection = requiresReflection;
        }

        public String toString() {
            return this.getDeclaringType().getBeanType().getSimpleName() + "." + this.getName();
        }

        public InjectionPoint getInjectionPoint() {
            return this;
        }

        @Override
        public BeanDefinition getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public boolean requiresReflection() {
            return this.requiresReflection;
        }

        public CallableInjectionPoint getOuterInjectionPoint() {
            throw new UnsupportedOperationException("Outer injection point not retrievable from here");
        }

        public Argument asArgument() {
            return this.getArgument();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }
    }

    public static class MethodSegment
    extends AbstractSegment
    implements CallableInjectionPoint {
        private final Argument[] arguments;
        private final boolean requiresReflection;

        MethodSegment(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments, boolean requiresReflection) {
            super(declaringType, methodName, argument);
            this.arguments = arguments;
            this.requiresReflection = requiresReflection;
        }

        public String toString() {
            StringBuilder baseString = new StringBuilder(this.getDeclaringType().getBeanType().getSimpleName()).append('.');
            baseString.append(this.getName());
            this.outputArguments(baseString, this.arguments);
            return baseString.toString();
        }

        public InjectionPoint getInjectionPoint() {
            return this;
        }

        @Override
        public BeanDefinition getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public boolean requiresReflection() {
            return this.requiresReflection;
        }

        @Override
        public Argument<?>[] getArguments() {
            return this.arguments;
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }
    }

    public static class MethodArgumentSegment
    extends MethodSegment
    implements ArgumentInjectionPoint {
        private final MethodSegment outer;

        public MethodArgumentSegment(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments, boolean requiresReflection, MethodSegment outer) {
            super(declaringType, methodName, argument, arguments, requiresReflection);
            this.outer = outer;
        }

        public CallableInjectionPoint getOuterInjectionPoint() {
            if (this.outer == null) {
                throw new IllegalStateException("Outer argument inaccessible");
            }
            return this.outer;
        }
    }

    public static class ConstructorSegment
    extends AbstractSegment {
        private final String methodName;
        private final Argument[] arguments;
        private final BeanDefinition declaringClass;

        ConstructorSegment(BeanDefinition declaringClass, String methodName, Argument argument, Argument[] arguments) {
            super(declaringClass, declaringClass.getBeanType().getName(), argument);
            this.methodName = methodName;
            this.arguments = arguments;
            this.declaringClass = declaringClass;
        }

        public String toString() {
            StringBuilder baseString;
            if ("<init>".equals(this.methodName)) {
                baseString = new StringBuilder("new ");
                baseString.append(this.getDeclaringType().getBeanType().getSimpleName());
            } else {
                baseString = new StringBuilder(this.getDeclaringType().getBeanType().getSimpleName()).append('.');
                baseString.append(this.methodName);
            }
            this.outputArguments(baseString, this.arguments);
            return baseString.toString();
        }

        public InjectionPoint getInjectionPoint() {
            final ConstructorInjectionPoint constructorInjectionPoint = this.getDeclaringType().getConstructor();
            return new ArgumentInjectionPoint(){

                @NonNull
                public CallableInjectionPoint getOuterInjectionPoint() {
                    return constructorInjectionPoint;
                }

                @NonNull
                public Argument getArgument() {
                    return this.getArgument();
                }

                @Override
                public BeanDefinition getDeclaringBean() {
                    return constructorInjectionPoint.getDeclaringBean();
                }

                @Override
                public boolean requiresReflection() {
                    return constructorInjectionPoint.requiresReflection();
                }

                public AnnotationMetadata getAnnotationMetadata() {
                    return this.getArgument().getAnnotationMetadata();
                }
            };
        }
    }

    public static class ConstructorArgumentSegment
    extends ConstructorSegment
    implements ArgumentInjectionPoint {
        public ConstructorArgumentSegment(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments) {
            super(declaringType, methodName, argument, arguments);
        }

        public CallableInjectionPoint getOuterInjectionPoint() {
            throw new UnsupportedOperationException("Outer injection point inaccessible from here");
        }

        @Override
        public BeanDefinition getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public boolean requiresReflection() {
            return false;
        }
    }

    class DefaultPath
    extends LinkedList<BeanResolutionContext.Segment<?>>
    implements BeanResolutionContext.Path {
        public static final String RIGHT_ARROW = " --> ";

        DefaultPath() {
        }

        @Override
        public String toString() {
            Iterator i = this.descendingIterator();
            StringBuilder path = new StringBuilder();
            while (i.hasNext()) {
                path.append(((BeanResolutionContext.Segment)i.next()).toString());
                if (!i.hasNext()) continue;
                path.append(RIGHT_ARROW);
            }
            return path.toString();
        }

        @Override
        public String toCircularString() {
            Iterator i = this.descendingIterator();
            StringBuilder path = new StringBuilder();
            String ls = System.getProperty("line.separator");
            while (i.hasNext()) {
                String segmentString = ((BeanResolutionContext.Segment)i.next()).toString();
                path.append(segmentString);
                if (i.hasNext()) {
                    path.append(RIGHT_ARROW);
                    continue;
                }
                int totalLength = path.length() - 3;
                String spaces = String.join((CharSequence)"", Collections.nCopies(totalLength, " "));
                path.append(ls).append("^").append(spaces).append("|").append(ls).append("|").append(spaces).append("|").append(ls).append("|").append(spaces).append("|").append(ls).append('+');
                path.append(String.join((CharSequence)"", Collections.nCopies(totalLength, "-"))).append('+');
            }
            return path.toString();
        }

        @Override
        public Optional<BeanResolutionContext.Segment<?>> currentSegment() {
            return Optional.ofNullable(this.peek());
        }

        @Override
        public BeanResolutionContext.Path pushConstructorResolve(BeanDefinition declaringType, Argument argument) {
            ConstructorInjectionPoint constructor = declaringType.getConstructor();
            if (constructor instanceof MethodInjectionPoint) {
                MethodInjectionPoint methodInjectionPoint = (MethodInjectionPoint)((Object)constructor);
                return this.pushConstructorResolve(declaringType, methodInjectionPoint.getName(), argument, constructor.getArguments(), constructor.requiresReflection());
            }
            return this.pushConstructorResolve(declaringType, "<init>", argument, constructor.getArguments(), constructor.requiresReflection());
        }

        @Override
        public BeanResolutionContext.Path pushConstructorResolve(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments, boolean requiresReflection) {
            if ("<init>".equals(methodName)) {
                ConstructorArgumentSegment constructorSegment = new ConstructorArgumentSegment(declaringType, methodName, argument, arguments);
                this.detectCircularDependency(declaringType, argument, constructorSegment);
            } else {
                BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
                MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, methodName, argument, arguments, requiresReflection, previous instanceof MethodSegment ? (MethodSegment)previous : null);
                if (this.contains(methodSegment)) {
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, "Circular dependency detected");
                }
                AbstractBeanResolutionContext.this.path.push(methodSegment);
            }
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushBeanCreate(BeanDefinition<?> declaringType, Argument<?> beanType) {
            return this.pushConstructorResolve(declaringType, beanType);
        }

        @Override
        public BeanResolutionContext.Path pushMethodArgumentResolve(BeanDefinition declaringType, MethodInjectionPoint methodInjectionPoint, Argument argument) {
            BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
            MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, methodInjectionPoint.getName(), argument, methodInjectionPoint.getArguments(), methodInjectionPoint.requiresReflection(), previous instanceof MethodSegment ? (MethodSegment)previous : null);
            if (this.contains(methodSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, methodInjectionPoint, argument, "Circular dependency detected");
            }
            this.push(methodSegment);
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushMethodArgumentResolve(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments, boolean requiresReflection) {
            BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
            MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, methodName, argument, arguments, requiresReflection, previous instanceof MethodSegment ? (MethodSegment)previous : null);
            if (this.contains(methodSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, declaringType, methodName, argument, "Circular dependency detected");
            }
            this.push(methodSegment);
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushFieldResolve(BeanDefinition declaringType, FieldInjectionPoint fieldInjectionPoint) {
            FieldSegment fieldSegment = new FieldSegment(declaringType, fieldInjectionPoint.asArgument(), fieldInjectionPoint.requiresReflection());
            if (this.contains(fieldSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, fieldInjectionPoint, "Circular dependency detected");
            }
            this.push(fieldSegment);
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushFieldResolve(BeanDefinition declaringType, Argument fieldAsArgument, boolean requiresReflection) {
            FieldSegment fieldSegment = new FieldSegment(declaringType, fieldAsArgument, requiresReflection);
            if (this.contains(fieldSegment)) {
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, declaringType, fieldAsArgument.getName(), "Circular dependency detected");
            }
            this.push(fieldSegment);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void detectCircularDependency(BeanDefinition declaringType, Argument argument, BeanResolutionContext.Segment constructorSegment) {
            if (this.contains(constructorSegment)) {
                BeanResolutionContext.Segment last = (BeanResolutionContext.Segment)this.peek();
                if (last == null) throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, "Circular dependency detected");
                BeanDefinition declaringBean = last.getDeclaringType();
                if (!declaringBean.equals(declaringType)) {
                    if (declaringType instanceof ProxyBeanDefinition) {
                        if (!((ProxyBeanDefinition)declaringType).getTargetDefinitionType().equals(declaringBean.getClass())) {
                            throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, "Circular dependency detected");
                        }
                        this.push(constructorSegment);
                        return;
                    } else {
                        if (!(declaringBean instanceof ProxyBeanDefinition)) throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, "Circular dependency detected");
                        if (!((ProxyBeanDefinition)declaringBean).getTargetDefinitionType().equals(declaringType.getClass())) {
                            throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, "Circular dependency detected");
                        }
                        this.push(constructorSegment);
                    }
                    return;
                } else {
                    this.push(constructorSegment);
                }
                return;
            } else {
                this.push(constructorSegment);
            }
        }
    }
}

