/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.NonBinding;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Experimental;
import io.micronaut.core.annotation.InstantiatedMember;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.annotation.AnnotationMapper;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.annotation.AnnotationTransformer;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.annotation.NamedAnnotationTransformer;
import io.micronaut.inject.annotation.TypedAnnotationMapper;
import io.micronaut.inject.annotation.TypedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbstractAnnotationMetadataBuilder<T, A> {
    private static final Map<String, String> DEPRECATED_ANNOTATION_NAMES = Collections.emptyMap();
    private static final Map<String, List<AnnotationMapper<?>>> ANNOTATION_MAPPERS = new HashMap(10);
    private static final Map<String, List<AnnotationTransformer<Annotation>>> ANNOTATION_TRANSFORMERS = new HashMap<String, List<AnnotationTransformer<Annotation>>>(5);
    private static final Map<String, List<AnnotationRemapper>> ANNOTATION_REMAPPERS = new HashMap<String, List<AnnotationRemapper>>(5);
    private static final Map<MetadataKey, AnnotationMetadata> MUTATED_ANNOTATION_METADATA = new HashMap<MetadataKey, AnnotationMetadata>(100);
    private static final Map<String, Set<String>> NON_BINDING_CACHE = new HashMap<String, Set<String>>(50);
    private static final List<String> DEFAULT_ANNOTATE_EXCLUDES = Arrays.asList(Internal.class.getName(), Experimental.class.getName());
    private static final Map<String, Map<String, Object>> ANNOTATION_DEFAULTS = new HashMap<String, Map<String, Object>>(20);
    private boolean validating = true;
    private final Set<T> erroneousElements = new HashSet<T>();

    protected AbstractAnnotationMetadataBuilder() {
    }

    private AnnotationMetadata metadataForError(RuntimeException e) {
        if ("org.eclipse.jdt.internal.compiler.problem.AbortCompilation".equals(e.getClass().getName())) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        throw e;
    }

    public AnnotationMetadata buildDeclared(T element) {
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, true, true, true);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            return this.metadataForError(e);
        }
    }

    public AnnotationMetadata buildDeclared(T element, List<? extends A> annotations, boolean includeTypeAnnotations) {
        if (CollectionUtils.isEmpty(annotations)) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        if (includeTypeAnnotations) {
            this.buildInternal(element, element, annotationMetadata, false, true, true);
        }
        try {
            this.includeAnnotations(annotationMetadata, element, false, true, annotations, true);
            if (annotationMetadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return annotationMetadata;
        }
        catch (RuntimeException e) {
            return this.metadataForError(e);
        }
    }

    public AnnotationMetadata buildOverridden(T element) {
        AnnotationMetadata existing = MUTATED_ANNOTATION_METADATA.get(new MetadataKey<T>(this.getDeclaringType(element), element));
        if (existing != null) {
            return existing;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, false, false, true);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            return this.metadataForError(e);
        }
    }

    public AnnotationMetadata build(T element) {
        String declaringType = this.getDeclaringType(element);
        return this.build(declaringType, element);
    }

    public AnnotationMetadata build(String declaringType, T element) {
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        if (existing != null) {
            return existing;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternal(null, element, annotationMetadata, true, false, true);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            return this.metadataForError(e);
        }
    }

    protected abstract boolean isMethodOrClassElement(T var1);

    @Nullable
    protected abstract String getDeclaringType(@NonNull T var1);

    public AnnotationMetadata buildForMethod(T element) {
        String declaringType = this.getDeclaringType(element);
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        if (existing != null) {
            return existing;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        return this.buildInternal(null, element, annotationMetadata, false, false, true);
    }

    public AnnotationMetadata buildForParent(T parent, T element) {
        return this.buildForParents(parent == null ? Collections.emptyList() : Collections.singletonList(parent), element);
    }

    public AnnotationMetadata buildForParents(List<T> parents, T element) {
        String declaringType = this.getDeclaringType(element);
        return this.buildForParents(declaringType, parents, element);
    }

    public AnnotationMetadata buildForParent(String declaringType, T parent, T element) {
        return this.buildForParents(declaringType, parent == null ? Collections.emptyList() : Collections.singletonList(parent), element);
    }

    public AnnotationMetadata buildForParents(String declaringType, List<T> parents, T element) {
        DefaultAnnotationMetadata annotationMetadata;
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        if (existing instanceof DefaultAnnotationMetadata) {
            annotationMetadata = ((DefaultAnnotationMetadata)existing).clone();
            if (parents.isEmpty()) {
                return annotationMetadata;
            }
        } else if (existing instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadata declaredMetadata = ((AnnotationMetadataHierarchy)existing).getDeclaredMetadata();
            annotationMetadata = declaredMetadata instanceof DefaultAnnotationMetadata ? ((DefaultAnnotationMetadata)declaredMetadata).clone() : new MutableAnnotationMetadata();
            if (parents.isEmpty()) {
                return annotationMetadata;
            }
        } else {
            annotationMetadata = new MutableAnnotationMetadata();
        }
        return this.buildInternalMulti(parents, element, annotationMetadata, false, false, true);
    }

    public AnnotationMetadata buildForParent(T parent, T element, boolean inheritTypeAnnotations) {
        AnnotationMetadata declaredMetadata;
        String declaringType = this.getDeclaringType(element);
        AnnotationMetadata existing = this.lookupExisting(declaringType, element);
        DefaultAnnotationMetadata annotationMetadata = existing instanceof DefaultAnnotationMetadata ? ((DefaultAnnotationMetadata)existing).clone() : (existing instanceof AnnotationMetadataHierarchy ? ((declaredMetadata = existing.getDeclaredMetadata()) instanceof DefaultAnnotationMetadata ? ((DefaultAnnotationMetadata)declaredMetadata).clone() : new MutableAnnotationMetadata()) : new MutableAnnotationMetadata());
        return this.buildInternal(parent, element, annotationMetadata, inheritTypeAnnotations, false, true);
    }

    protected abstract T getTypeForAnnotation(A var1);

    protected abstract boolean hasAnnotation(T var1, Class<? extends Annotation> var2);

    protected abstract boolean hasAnnotation(T var1, String var2);

    protected abstract boolean hasAnnotations(T var1);

    protected abstract String getAnnotationTypeName(A var1);

    protected abstract String getElementName(T var1);

    protected abstract List<? extends A> getAnnotationsForType(T var1);

    protected abstract List<T> buildHierarchy(T var1, boolean var2, boolean var3);

    protected abstract void readAnnotationRawValues(T var1, String var2, T var3, String var4, Object var5, Map<CharSequence, Object> var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAnnotationValue(T originatingElement, String annotationName, T member, final String memberName, Object resolvedValue) {
        if (!this.validating) {
            return;
        }
        AnnotatedElementValidator elementValidator = this.getElementValidator();
        if (elementValidator != null && !this.erroneousElements.contains(member)) {
            boolean shouldValidate;
            boolean bl = shouldValidate = !annotationName.equals(AliasFor.class.getName()) && (!(resolvedValue instanceof String) || !resolvedValue.toString().contains("${"));
            if (shouldValidate) {
                shouldValidate = this.isValidationRequired(member);
            }
            if (shouldValidate) {
                AnnotationMetadata metadata;
                try {
                    this.validating = false;
                    metadata = this.buildDeclared(member);
                }
                finally {
                    this.validating = true;
                }
                Set<String> errors = elementValidator.validatedAnnotatedElement(new AnnotatedElement(){

                    @NonNull
                    public String getName() {
                        return memberName;
                    }

                    public AnnotationMetadata getAnnotationMetadata() {
                        return metadata;
                    }
                }, resolvedValue);
                if (CollectionUtils.isNotEmpty(errors)) {
                    this.erroneousElements.add(member);
                    for (String error : errors) {
                        error = "@" + NameUtils.getSimpleName((String)annotationName) + "." + memberName + ": " + error;
                        this.addError(originatingElement, error);
                    }
                }
            }
        }
    }

    protected abstract boolean isValidationRequired(T var1);

    @Nullable
    protected AnnotatedElementValidator getElementValidator() {
        return null;
    }

    protected abstract void addError(@NonNull T var1, @NonNull String var2);

    protected abstract void addWarning(@NonNull T var1, @NonNull String var2);

    protected abstract Object readAnnotationValue(T var1, T var2, String var3, Object var4);

    protected abstract Map<? extends T, ?> readAnnotationDefaultValues(A var1);

    protected abstract Map<? extends T, ?> readAnnotationDefaultValues(String var1, T var2);

    protected abstract Map<? extends T, ?> readAnnotationRawValues(A var1);

    protected abstract OptionalValues<?> getAnnotationValues(T var1, T var2, Class<?> var3);

    protected abstract String getAnnotationMemberName(T var1);

    @Nullable
    protected abstract String getRepeatableName(A var1);

    @Nullable
    protected abstract String getRepeatableNameForType(T var1);

    protected AnnotationValue readNestedAnnotationValue(T originatingElement, A annotationMirror) {
        AnnotationValue av;
        Map<T, ?> annotationValues = this.readAnnotationRawValues(annotationMirror);
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        if (annotationValues.isEmpty()) {
            av = new AnnotationValue(annotationTypeName);
        } else {
            LinkedHashMap<CharSequence, Object> resolvedValues = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<T, ?> entry : annotationValues.entrySet()) {
                T member = entry.getKey();
                OptionalValues<AliasFor> aliasForValues = this.getAnnotationValues(originatingElement, member, AliasFor.class);
                Object annotationValue = entry.getValue();
                Optional aliasMember = aliasForValues.get((CharSequence)"member");
                Optional aliasAnnotation = aliasForValues.get((CharSequence)"annotation");
                Optional aliasAnnotationName = aliasForValues.get((CharSequence)"annotationName");
                if (aliasMember.isPresent() && !aliasAnnotation.isPresent() && !aliasAnnotationName.isPresent()) {
                    String aliasedNamed = aliasMember.get().toString();
                    this.readAnnotationRawValues(originatingElement, annotationTypeName, member, aliasedNamed, annotationValue, resolvedValues);
                }
                String memberName = this.getAnnotationMemberName(member);
                this.readAnnotationRawValues(originatingElement, annotationTypeName, member, memberName, annotationValue, resolvedValues);
            }
            av = new AnnotationValue(annotationTypeName, resolvedValues);
        }
        return av;
    }

    protected abstract Optional<T> getAnnotationMirror(String var1);

    protected Map<CharSequence, Object> populateAnnotationData(T originatingElement, @Nullable T parent, A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared, RetentionPolicy retentionPolicy, boolean allowAliases) {
        return this.populateAnnotationData(originatingElement, parent == originatingElement, annotationMirror, metadata, isDeclared, retentionPolicy, allowAliases);
    }

    protected Map<CharSequence, Object> populateAnnotationData(T originatingElement, boolean originatingElementIsSameParent, A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared, RetentionPolicy retentionPolicy, boolean allowAliases) {
        LinkedHashMap<CharSequence, Object> annotationValues;
        String annotationName = this.getAnnotationTypeName(annotationMirror);
        if (retentionPolicy == RetentionPolicy.RUNTIME) {
            this.processAnnotationDefaults(originatingElement, metadata, annotationName, () -> this.readAnnotationDefaultValues(annotationMirror));
        }
        ArrayList<String> parentAnnotations = new ArrayList<String>();
        parentAnnotations.add(annotationName);
        Map<T, ?> elementValues = this.readAnnotationRawValues(annotationMirror);
        if (CollectionUtils.isEmpty(elementValues)) {
            annotationValues = new LinkedHashMap<CharSequence, Object>(3);
        } else {
            T annotationType;
            annotationValues = new LinkedHashMap(5);
            HashSet<String> nonBindingMembers = new HashSet<String>(2);
            for (Map.Entry<T, ?> entry : elementValues.entrySet()) {
                T member = entry.getKey();
                if (member == null) continue;
                Object annotationValue = entry.getValue();
                if (this.hasAnnotations(member)) {
                    Object rawValue;
                    String memberName;
                    DefaultAnnotationMetadata memberMetadata = new DefaultAnnotationMetadata();
                    List annotationsForMember = this.getAnnotationsForType(member).stream().filter(a -> !this.getAnnotationTypeName(a).equals(annotationName)).collect(Collectors.toList());
                    this.includeAnnotations(memberMetadata, member, false, true, annotationsForMember, false);
                    boolean isInstantiatedMember = memberMetadata.hasAnnotation(InstantiatedMember.class);
                    if (memberMetadata.hasAnnotation(NonBinding.class)) {
                        memberName = this.getElementName(member);
                        nonBindingMembers.add(memberName);
                    }
                    if (isInstantiatedMember && (rawValue = this.readAnnotationValue(originatingElement, member, memberName = this.getAnnotationMemberName(member), annotationValue)) instanceof AnnotationClassValue) {
                        AnnotationClassValue acv = (AnnotationClassValue)rawValue;
                        annotationValues.put(memberName, new AnnotationClassValue(acv.getName(), true));
                    }
                }
                if (!allowAliases) continue;
                this.handleAnnotationAlias(originatingElement, metadata, isDeclared, annotationName, parentAnnotations, annotationValues, member, annotationValue);
            }
            if (!nonBindingMembers.isEmpty() && (this.hasAnnotation(annotationType = this.getTypeForAnnotation(annotationMirror), "javax.inject.Qualifier") || this.hasAnnotation(annotationType, Qualifier.class))) {
                metadata.addDeclaredStereotype(Collections.singletonList(this.getAnnotationTypeName(annotationMirror)), "javax.inject.Qualifier", Collections.singletonMap("nonBinding", nonBindingMembers));
            }
        }
        List<AnnotationMapper<Annotation>> mappers = this.getAnnotationMappers(annotationName);
        if (mappers != null) {
            AnnotationValue annotationValue = new AnnotationValue(annotationName, annotationValues);
            VisitorContext visitorContext = this.createVisitorContext();
            for (AnnotationMapper<Annotation> mapper : mappers) {
                List<AnnotationValue<?>> mapped = mapper.map((AnnotationValue<Annotation>)annotationValue, visitorContext);
                if (mapped == null) continue;
                for (AnnotationValue<?> o : mapped) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue<?> av = o;
                    retentionPolicy = av.getRetentionPolicy();
                    String mappedAnnotationName = av.getAnnotationName();
                    Optional<Object> mappedMirror = this.getAnnotationMirror(mappedAnnotationName);
                    String repeatableName = mappedMirror.map(this::getRepeatableNameForType).orElse(null);
                    if (repeatableName != null) {
                        if (isDeclared) {
                            metadata.addDeclaredRepeatable(repeatableName, av, retentionPolicy);
                        } else {
                            metadata.addRepeatable(repeatableName, av, retentionPolicy);
                        }
                    } else {
                        Map values = av.getValues();
                        if (isDeclared) {
                            metadata.addDeclaredAnnotation(mappedAnnotationName, values, retentionPolicy);
                        } else {
                            metadata.addAnnotation(mappedAnnotationName, values, retentionPolicy);
                        }
                    }
                    RetentionPolicy finalRetentionPolicy = retentionPolicy;
                    mappedMirror.ifPresent(annMirror -> {
                        Map values = av.getValues();
                        values.forEach((key, value) -> {
                            Object member = this.getAnnotationMember((T)annMirror, (CharSequence)key);
                            if (member != null) {
                                this.handleAnnotationAlias(originatingElement, metadata, isDeclared, mappedAnnotationName, Collections.emptyList(), annotationValues, member, value);
                            }
                        });
                        if (finalRetentionPolicy == RetentionPolicy.RUNTIME) {
                            this.processAnnotationDefaults(originatingElement, metadata, mappedAnnotationName, () -> this.readAnnotationDefaultValues(mappedAnnotationName, annMirror));
                        }
                        ArrayList<String> parents = new ArrayList<String>();
                        this.processAnnotationStereotype(parents, annMirror, mappedAnnotationName, metadata, isDeclared, this.isInheritedAnnotationType(annMirror) || originatingElementIsSameParent);
                    });
                }
            }
        }
        return annotationValues;
    }

    private void handleAnnotationAlias(T originatingElement, DefaultAnnotationMetadata metadata, boolean isDeclared, String annotationName, List<String> parentAnnotations, Map<CharSequence, Object> annotationValues, T member, Object annotationValue) {
        Optional aliases = this.getAnnotationValues(originatingElement, member, Aliases.class).get((CharSequence)"value");
        if (aliases.isPresent()) {
            Object value = aliases.get();
            if (value instanceof AnnotationValue[]) {
                AnnotationValue[] values;
                for (AnnotationValue av : values = (AnnotationValue[])value) {
                    OptionalValues aliasForValues = OptionalValues.of(Object.class, (Map)av.getValues());
                    this.processAnnotationAlias(originatingElement, annotationName, member, metadata, isDeclared, parentAnnotations, annotationValues, annotationValue, aliasForValues);
                }
            }
            this.readAnnotationRawValues(originatingElement, annotationName, member, this.getAnnotationMemberName(member), annotationValue, annotationValues);
        } else {
            OptionalValues<AliasFor> aliasForValues = this.getAnnotationValues(originatingElement, member, AliasFor.class);
            this.processAnnotationAlias(originatingElement, annotationName, member, metadata, isDeclared, parentAnnotations, annotationValues, annotationValue, aliasForValues);
            this.readAnnotationRawValues(originatingElement, annotationName, member, this.getAnnotationMemberName(member), annotationValue, annotationValues);
        }
    }

    @Nullable
    protected abstract T getAnnotationMember(T var1, CharSequence var2);

    @NonNull
    protected List<AnnotationMapper<? extends Annotation>> getAnnotationMappers(@NonNull String annotationName) {
        return ANNOTATION_MAPPERS.get(annotationName);
    }

    @NonNull
    protected List<AnnotationTransformer<Annotation>> getAnnotationTransformers(@NonNull String annotationName) {
        return ANNOTATION_TRANSFORMERS.get(annotationName);
    }

    protected abstract VisitorContext createVisitorContext();

    private void processAnnotationDefaults(T originatingElement, DefaultAnnotationMetadata metadata, String annotationName, Supplier<Map<? extends T, ?>> elementDefaultValues) {
        Map<CharSequence, Object> defaultValues;
        Map<String, Object> defaults = ANNOTATION_DEFAULTS.get(annotationName);
        if (defaults != null) {
            defaultValues = new LinkedHashMap<String, Object>(defaults);
        } else {
            defaultValues = this.getAnnotationDefaults(originatingElement, annotationName, elementDefaultValues.get());
            if (defaultValues != null) {
                ANNOTATION_DEFAULTS.put(annotationName, defaultValues.entrySet().stream().collect(Collectors.toMap(entry -> ((CharSequence)entry.getKey()).toString(), Map.Entry::getValue)));
            } else {
                defaultValues = Collections.emptyMap();
            }
        }
        metadata.addDefaultAnnotationValues(annotationName, defaultValues);
    }

    private Map<CharSequence, Object> getAnnotationDefaults(T originatingElement, String annotationName, Map<? extends T, ?> elementDefaultValues) {
        if (elementDefaultValues != null) {
            LinkedHashMap<CharSequence, Object> defaultValues = new LinkedHashMap<CharSequence, Object>();
            for (Map.Entry<T, ?> entry : elementDefaultValues.entrySet()) {
                T member = entry.getKey();
                String memberName = this.getAnnotationMemberName(member);
                if (defaultValues.containsKey(memberName)) continue;
                Object annotationValue = entry.getValue();
                this.readAnnotationRawValues(originatingElement, annotationName, member, memberName, annotationValue, defaultValues);
            }
            return defaultValues;
        }
        return null;
    }

    private AnnotationMetadata lookupExisting(String declaringType, T element) {
        return MUTATED_ANNOTATION_METADATA.get(new MetadataKey<T>(declaringType, element));
    }

    private void processAnnotationAlias(T originatingElement, String annotationName, T member, DefaultAnnotationMetadata metadata, boolean isDeclared, List<String> parentAnnotations, Map<CharSequence, Object> annotationValues, Object annotationValue, OptionalValues<?> aliasForValues) {
        Optional aliasAnnotation = aliasForValues.get((CharSequence)"annotation");
        Optional aliasAnnotationName = aliasForValues.get((CharSequence)"annotationName");
        Optional aliasMember = aliasForValues.get((CharSequence)"member");
        if (aliasAnnotation.isPresent() || aliasAnnotationName.isPresent()) {
            if (aliasMember.isPresent()) {
                String aliasedAnnotation = aliasAnnotation.isPresent() ? aliasAnnotation.get().toString() : aliasAnnotationName.get().toString();
                String aliasedMemberName = aliasMember.get().toString();
                Object v = this.readAnnotationValue(originatingElement, member, aliasedMemberName, annotationValue);
                if (v != null) {
                    List<AnnotationValue<?>> remappedValues = this.remapAnnotation(aliasedAnnotation);
                    for (AnnotationValue<?> remappedAnnotation : remappedValues) {
                        String aliasedAnnotationName = remappedAnnotation.getAnnotationName();
                        Optional<T> annotationMirror = this.getAnnotationMirror(aliasedAnnotationName);
                        RetentionPolicy retentionPolicy = RetentionPolicy.RUNTIME;
                        String repeatableName = null;
                        if (annotationMirror.isPresent()) {
                            T annotationTypeMirror = annotationMirror.get();
                            this.processAnnotationDefaults(originatingElement, metadata, aliasedAnnotationName, () -> this.readAnnotationDefaultValues(aliasedAnnotationName, annotationTypeMirror));
                            retentionPolicy = this.getRetentionPolicy(annotationTypeMirror);
                            repeatableName = this.getRepeatableNameForType(annotationTypeMirror);
                        }
                        if (isDeclared) {
                            if (StringUtils.isNotEmpty(repeatableName)) {
                                metadata.addDeclaredRepeatableStereotype(parentAnnotations, repeatableName, AnnotationValue.builder((String)aliasedAnnotationName, (RetentionPolicy)retentionPolicy).members(Collections.singletonMap(aliasedMemberName, v)).build());
                            } else {
                                metadata.addDeclaredStereotype(Collections.emptyList(), aliasedAnnotationName, Collections.singletonMap(aliasedMemberName, v), retentionPolicy);
                            }
                        } else if (StringUtils.isNotEmpty(repeatableName)) {
                            metadata.addRepeatableStereotype(parentAnnotations, repeatableName, AnnotationValue.builder((String)aliasedAnnotationName, (RetentionPolicy)retentionPolicy).members(Collections.singletonMap(aliasedMemberName, v)).build());
                        } else {
                            metadata.addStereotype(Collections.emptyList(), aliasedAnnotationName, Collections.singletonMap(aliasedMemberName, v), retentionPolicy);
                        }
                        if (annotationMirror.isPresent()) {
                            T am = annotationMirror.get();
                            this.processAnnotationStereotype(Collections.singletonList(aliasedAnnotationName), am, aliasedAnnotationName, metadata, isDeclared, this.isInheritedAnnotationType(am));
                            continue;
                        }
                        this.processAnnotationStereotype(Collections.singletonList(aliasedAnnotationName), remappedAnnotation, metadata, isDeclared);
                    }
                }
            }
        } else if (aliasMember.isPresent()) {
            String aliasedNamed = aliasMember.get().toString();
            Object v = this.readAnnotationValue(originatingElement, member, aliasedNamed, annotationValue);
            if (v != null) {
                annotationValues.put(aliasedNamed, v);
            }
            this.readAnnotationRawValues(originatingElement, annotationName, member, aliasedNamed, annotationValue, annotationValues);
        }
    }

    @NonNull
    protected abstract RetentionPolicy getRetentionPolicy(@NonNull T var1);

    private AnnotationMetadata buildInternal(T parent, T element, DefaultAnnotationMetadata annotationMetadata, boolean inheritTypeAnnotations, boolean declaredOnly, boolean allowAliases) {
        return this.buildInternalMulti(parent == null ? Collections.emptyList() : Collections.singletonList(parent), element, annotationMetadata, inheritTypeAnnotations, declaredOnly, allowAliases);
    }

    private AnnotationMetadata buildInternalMulti(List<T> parents, T element, DefaultAnnotationMetadata annotationMetadata, boolean inheritTypeAnnotations, boolean declaredOnly, boolean allowAliases) {
        List<T> hierarchy = this.buildHierarchy(element, inheritTypeAnnotations, declaredOnly);
        for (T parent : parents) {
            List<T> parentHierarchy = this.buildHierarchy(parent, inheritTypeAnnotations, declaredOnly);
            if (hierarchy.isEmpty() && !parentHierarchy.isEmpty()) {
                hierarchy = parentHierarchy;
                continue;
            }
            hierarchy.addAll(0, parentHierarchy);
        }
        Collections.reverse(hierarchy);
        for (T currentElement : hierarchy) {
            List<A> annotationHierarchy;
            if (currentElement == null || (annotationHierarchy = this.getAnnotationsForType(currentElement)).isEmpty()) continue;
            this.includeAnnotations(annotationMetadata, currentElement, parents.contains(currentElement), currentElement == element, annotationHierarchy, allowAliases);
        }
        if (!annotationMetadata.hasDeclaredStereotype("javax.inject.Scope") && annotationMetadata.hasDeclaredStereotype(DefaultScope.class)) {
            Optional value = annotationMetadata.stringValue(DefaultScope.class);
            value.ifPresent(name -> annotationMetadata.addDeclaredAnnotation((String)name, Collections.emptyMap()));
        }
        return annotationMetadata;
    }

    private void includeAnnotations(DefaultAnnotationMetadata annotationMetadata, T element, boolean originatingElementIsSameParent, boolean isDeclared, List<? extends A> annotationHierarchy, boolean allowAliases) {
        ArrayList<A> hierarchyCopy = new ArrayList<A>(annotationHierarchy);
        ListIterator<A> listIterator = hierarchyCopy.listIterator();
        while (listIterator.hasNext()) {
            block8: {
                Map<CharSequence, Object> annotationValues;
                T annotationType;
                block7: {
                    A annotationMirror = listIterator.next();
                    String annotationName = this.getAnnotationTypeName(annotationMirror);
                    if (this.isExcludedAnnotation(element, annotationName)) continue;
                    if (DEPRECATED_ANNOTATION_NAMES.containsKey(annotationName)) {
                        this.addWarning(element, "Usages of deprecated annotation " + annotationName + " found. You should use " + DEPRECATED_ANNOTATION_NAMES.get(annotationName) + " instead.");
                    }
                    annotationType = this.getTypeForAnnotation(annotationMirror);
                    RetentionPolicy retentionPolicy = this.getRetentionPolicy(annotationType);
                    annotationValues = this.populateAnnotationData(element, originatingElementIsSameParent, annotationMirror, annotationMetadata, isDeclared, retentionPolicy, allowAliases);
                    if (isDeclared) {
                        this.applyTransformations(listIterator, annotationMetadata, true, annotationType, annotationValues, Collections.emptyList(), null, annotationMetadata::addDeclaredRepeatable, annotationMetadata::addDeclaredAnnotation);
                        continue;
                    }
                    if (this.isInheritedAnnotation(annotationMirror)) break block7;
                    if (!originatingElementIsSameParent) break block8;
                }
                this.applyTransformations(listIterator, annotationMetadata, false, annotationType, annotationValues, Collections.emptyList(), null, annotationMetadata::addRepeatable, annotationMetadata::addAnnotation);
                continue;
            }
            listIterator.remove();
        }
        for (A annotationMirror : hierarchyCopy) {
            String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
            String packageName = NameUtils.getPackageName((String)annotationTypeName);
            if (AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName)) continue;
            this.processAnnotationStereotype(element, originatingElementIsSameParent, annotationMirror, annotationMetadata, isDeclared);
        }
    }

    protected boolean isExcludedAnnotation(@NonNull T element, @NonNull String annotationName) {
        return AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName);
    }

    protected abstract boolean isInheritedAnnotation(@NonNull A var1);

    protected abstract boolean isInheritedAnnotationType(@NonNull T var1);

    private void buildStereotypeHierarchy(List<String> parents, T element, DefaultAnnotationMetadata metadata, boolean isDeclared, boolean isInherited, boolean allowAliases, List<String> excludes) {
        AnnotationMetadata modifiedStereotypes;
        List<A> annotationMirrors = this.getAnnotationsForType(element);
        LinkedList interceptorBindings = new LinkedList();
        String lastParent = (String)CollectionUtils.last(parents);
        if (!annotationMirrors.isEmpty()) {
            ArrayList<Object> topLevel = new ArrayList<Object>();
            ListIterator<A> listIterator = annotationMirrors.listIterator();
            while (listIterator.hasNext()) {
                A annotationMirror = listIterator.next();
                String string = this.getAnnotationTypeName(annotationMirror);
                if (string.equals(this.getElementName(element)) || AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(string) || excludes.contains(string) || AnnotationUtil.ADVICE_STEREOTYPES.contains(lastParent) && "io.micronaut.aop.InterceptorBinding".equals(string)) continue;
                topLevel.add(annotationMirror);
                T annotationTypeMirror = this.getTypeForAnnotation(annotationMirror);
                RetentionPolicy retentionPolicy = this.getRetentionPolicy(annotationTypeMirror);
                Map<CharSequence, Object> data = this.populateAnnotationData(element, null, annotationMirror, metadata, isDeclared, retentionPolicy, allowAliases);
                this.handleAnnotationStereotype(parents, metadata, isDeclared, isInherited, interceptorBindings, lastParent, listIterator, annotationTypeMirror, string, data);
            }
            topLevel.removeIf(a -> !annotationMirrors.contains(a));
            for (Object e : topLevel) {
                this.processAnnotationStereotype(parents, e, metadata, isDeclared, isInherited);
            }
        }
        if (lastParent != null && (modifiedStereotypes = MUTATED_ANNOTATION_METADATA.get(new MetadataKey<T>(lastParent, element))) != null) {
            Set set = modifiedStereotypes.getAnnotationNames();
            for (String string : set) {
                String stereotypeName;
                AnnotationValue a2 = modifiedStereotypes.getAnnotation(string);
                if (a2 == null || AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(stereotypeName = a2.getAnnotationName()) || excludes.contains(stereotypeName)) continue;
                T annotationType = this.getAnnotationMirror(stereotypeName).orElse(null);
                if (annotationType != null) {
                    Map values = a2.getValues();
                    this.handleAnnotationStereotype(parents, metadata, isDeclared, isInherited, interceptorBindings, lastParent, null, annotationType, string, values);
                    continue;
                }
                if (isDeclared) {
                    metadata.addDeclaredStereotype(parents, stereotypeName, a2.getValues(), a2.getRetentionPolicy());
                    continue;
                }
                metadata.addStereotype(parents, stereotypeName, a2.getValues(), a2.getRetentionPolicy());
            }
        }
        if (!interceptorBindings.isEmpty()) {
            for (AnnotationValueBuilder annotationValueBuilder : interceptorBindings) {
                if (isDeclared) {
                    metadata.addDeclaredRepeatable("io.micronaut.aop.InterceptorBindingDefinitions", annotationValueBuilder.build());
                    continue;
                }
                metadata.addRepeatable("io.micronaut.aop.InterceptorBindingDefinitions", annotationValueBuilder.build());
            }
        }
    }

    private void handleAnnotationStereotype(List<String> parents, DefaultAnnotationMetadata metadata, boolean isDeclared, boolean isInherited, LinkedList<AnnotationValueBuilder<?>> interceptorBindings, String lastParent, @Nullable ListIterator<? extends A> listIterator, T annotationType, String annotationName, Map<CharSequence, Object> data) {
        String when;
        boolean hasInterceptorBinding;
        this.addToInterceptorBindingsIfNecessary(interceptorBindings, lastParent, annotationName);
        boolean bl = hasInterceptorBinding = !interceptorBindings.isEmpty();
        if (hasInterceptorBinding && "io.micronaut.aop.InterceptorBinding".equals(annotationName)) {
            this.handleMemberBinding(metadata, lastParent, data);
            interceptorBindings.getLast().members(data);
            return;
        }
        if (annotationName.equals("javax.annotation.Nonnull") && ((when = Objects.toString(data.get("when"))).equals("UNKNOWN") || when.equals("MAYBE") || when.equals("NEVER"))) {
            return;
        }
        if (hasInterceptorBinding && Type.class.getName().equals(annotationName)) {
            AnnotationClassValue[] values2;
            Object o = data.get("value");
            AnnotationClassValue interceptorType = null;
            if (o instanceof AnnotationClassValue) {
                interceptorType = (AnnotationClassValue)o;
            } else if (o instanceof AnnotationClassValue[] && (values2 = (AnnotationClassValue[])o).length > 0) {
                interceptorType = values2[0];
            }
            if (interceptorType != null) {
                for (AnnotationValueBuilder annotationValueBuilder : interceptorBindings) {
                    annotationValueBuilder.member("interceptorType", new AnnotationClassValue[]{interceptorType});
                }
            }
        }
        if (isDeclared) {
            this.applyTransformations(listIterator, metadata, true, annotationType, data, parents, interceptorBindings, (string, av) -> metadata.addDeclaredRepeatableStereotype(parents, (String)string, (AnnotationValue)av), (string, values, rp) -> metadata.addDeclaredStereotype(parents, (String)string, (Map<CharSequence, Object>)values, (RetentionPolicy)((Object)((Object)rp))));
        } else if (isInherited) {
            this.applyTransformations(listIterator, metadata, false, annotationType, data, parents, interceptorBindings, (string, av) -> metadata.addRepeatableStereotype(parents, (String)string, (AnnotationValue)av), (string, values, rp) -> metadata.addStereotype(parents, (String)string, (Map<CharSequence, Object>)values, (RetentionPolicy)((Object)((Object)rp))));
        } else if (listIterator != null) {
            listIterator.remove();
        }
    }

    private void handleMemberBinding(DefaultAnnotationMetadata metadata, String lastParent, Map<CharSequence, Object> data) {
        Map<CharSequence, Object> values;
        Object o;
        if (data.containsKey("bindMembers") && (o = data.remove("bindMembers")) instanceof Boolean && ((Boolean)o).booleanValue() && !(values = metadata.getValues(lastParent)).isEmpty()) {
            Set nonBinding = NON_BINDING_CACHE.computeIfAbsent(lastParent, annotationName -> {
                HashSet nonBindingResult = new HashSet(5);
                Map<String, T> members = this.getAnnotationMembers(lastParent);
                if (CollectionUtils.isNotEmpty(members)) {
                    members.forEach((name, ann) -> {
                        if (this.hasSimpleAnnotation(ann, NonBinding.class.getSimpleName())) {
                            nonBindingResult.add(name);
                        }
                    });
                }
                return nonBindingResult.isEmpty() ? Collections.emptySet() : nonBindingResult;
            });
            if (!nonBinding.isEmpty()) {
                values = new HashMap<CharSequence, Object>(values);
                values.keySet().removeAll(nonBinding);
            }
            AnnotationValueBuilder builder = AnnotationValue.builder((String)lastParent).members(values);
            data.put("bindMembers", builder.build());
        }
    }

    @NonNull
    protected abstract Map<String, ? extends T> getAnnotationMembers(@NonNull String var1);

    protected abstract boolean hasSimpleAnnotation(T var1, String var2);

    private void addToInterceptorBindingsIfNecessary(LinkedList<AnnotationValueBuilder<?>> interceptorBindings, String lastParent, String annotationName) {
        if (lastParent != null) {
            AnnotationValueBuilder interceptorBinding = null;
            if ("io.micronaut.aop.Around".equals(annotationName) || "io.micronaut.aop.InterceptorBinding".equals(annotationName)) {
                interceptorBinding = AnnotationValue.builder((String)"io.micronaut.aop.InterceptorBinding").member("value", new AnnotationClassValue[]{new AnnotationClassValue(lastParent)}).member("kind", "AROUND");
            } else if ("io.micronaut.aop.Introduction".equals(annotationName)) {
                interceptorBinding = AnnotationValue.builder((String)"io.micronaut.aop.InterceptorBinding").member("value", new AnnotationClassValue[]{new AnnotationClassValue(lastParent)}).member("kind", "INTRODUCTION");
            } else if ("io.micronaut.aop.AroundConstruct".equals(annotationName)) {
                interceptorBinding = AnnotationValue.builder((String)"io.micronaut.aop.InterceptorBinding").member("value", new AnnotationClassValue[]{new AnnotationClassValue(lastParent)}).member("kind", "AROUND_CONSTRUCT");
            }
            if (interceptorBinding != null) {
                interceptorBindings.add(interceptorBinding);
            }
        }
    }

    private void buildStereotypeHierarchy(List<String> parents, AnnotationValue<?> annotationValue, DefaultAnnotationMetadata metadata, boolean isDeclared, List<String> excludes) {
        List annotationMirrors = annotationValue.getStereotypes();
        LinkedList interceptorBindings = new LinkedList();
        String lastParent = (String)CollectionUtils.last(parents);
        if (CollectionUtils.isNotEmpty((Collection)annotationMirrors)) {
            ArrayList<AnnotationValue> topLevel = new ArrayList<AnnotationValue>();
            for (AnnotationValue annotationMirror : annotationMirrors) {
                boolean hasInterceptorBinding;
                String annotationName = annotationMirror.getAnnotationName();
                if (annotationName.equals(annotationValue.getAnnotationName()) || AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName) || excludes.contains(annotationName) || AnnotationUtil.ADVICE_STEREOTYPES.contains(lastParent) && "io.micronaut.aop.InterceptorBinding".equals(annotationName)) continue;
                this.addToInterceptorBindingsIfNecessary(interceptorBindings, lastParent, annotationName);
                RetentionPolicy retentionPolicy = annotationMirror.getRetentionPolicy();
                topLevel.add(annotationMirror);
                Map data = annotationMirror.getValues();
                boolean bl = hasInterceptorBinding = !interceptorBindings.isEmpty();
                if (hasInterceptorBinding && "io.micronaut.aop.InterceptorBinding".equals(annotationName)) {
                    this.handleMemberBinding(metadata, lastParent, data);
                    interceptorBindings.getLast().members(data);
                    continue;
                }
                if (hasInterceptorBinding && Type.class.getName().equals(annotationName)) {
                    AnnotationClassValue[] values;
                    Object o = data.get("value");
                    AnnotationClassValue interceptorType = null;
                    if (o instanceof AnnotationClassValue) {
                        interceptorType = (AnnotationClassValue)o;
                    } else if (o instanceof AnnotationClassValue[] && (values = (AnnotationClassValue[])o).length > 0) {
                        interceptorType = values[0];
                    }
                    if (interceptorType != null) {
                        for (AnnotationValueBuilder annotationValueBuilder : interceptorBindings) {
                            annotationValueBuilder.member("interceptorType", new AnnotationClassValue[]{interceptorType});
                        }
                    }
                }
                if (isDeclared) {
                    metadata.addDeclaredStereotype(parents, annotationName, data, retentionPolicy);
                    continue;
                }
                metadata.addStereotype(parents, annotationName, data, retentionPolicy);
            }
            for (AnnotationValue annotationMirror : topLevel) {
                this.processAnnotationStereotype(parents, annotationMirror, metadata, isDeclared);
            }
        }
        if (!interceptorBindings.isEmpty()) {
            for (AnnotationValueBuilder annotationValueBuilder : interceptorBindings) {
                if (isDeclared) {
                    metadata.addDeclaredRepeatable("io.micronaut.aop.InterceptorBindingDefinitions", annotationValueBuilder.build());
                    continue;
                }
                metadata.addRepeatable("io.micronaut.aop.InterceptorBindingDefinitions", annotationValueBuilder.build());
            }
        }
    }

    private void processAnnotationStereotype(T element, boolean originatingElementIsSameParent, A annotationMirror, DefaultAnnotationMetadata annotationMetadata, boolean isDeclared) {
        T annotationType = this.getTypeForAnnotation(annotationMirror);
        String parentAnnotationName = this.getAnnotationTypeName(annotationMirror);
        if (!parentAnnotationName.endsWith(".Nullable")) {
            this.processAnnotationStereotypes(annotationMetadata, isDeclared, this.isInheritedAnnotation(annotationMirror) || originatingElementIsSameParent, annotationType, parentAnnotationName, Collections.emptyList());
        }
    }

    private void processAnnotationStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, boolean isInherited, T annotationType, String annotationName, List<String> excludes) {
        ArrayList<String> parentAnnotations = new ArrayList<String>();
        parentAnnotations.add(annotationName);
        this.buildStereotypeHierarchy(parentAnnotations, annotationType, annotationMetadata, isDeclared, isInherited, true, excludes);
    }

    private void processAnnotationStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, AnnotationValue<?> annotation, List<String> parents) {
        ArrayList<String> parentAnnotations = new ArrayList<String>(parents);
        parentAnnotations.add(annotation.getAnnotationName());
        this.buildStereotypeHierarchy(parentAnnotations, annotation, annotationMetadata, isDeclared, Collections.emptyList());
    }

    private void processAnnotationStereotype(List<String> parents, A annotationMirror, DefaultAnnotationMetadata metadata, boolean isDeclared, boolean isInherited) {
        T typeForAnnotation = this.getTypeForAnnotation(annotationMirror);
        String annotationTypeName = this.getAnnotationTypeName(annotationMirror);
        this.processAnnotationStereotype(parents, typeForAnnotation, annotationTypeName, metadata, isDeclared, isInherited);
    }

    private void processAnnotationStereotype(List<String> parents, T annotationType, String annotationTypeName, DefaultAnnotationMetadata metadata, boolean isDeclared, boolean isInherited) {
        ArrayList<String> stereoTypeParents = new ArrayList<String>(parents);
        stereoTypeParents.add(annotationTypeName);
        this.buildStereotypeHierarchy(stereoTypeParents, annotationType, metadata, isDeclared, isInherited, true, Collections.emptyList());
    }

    private void processAnnotationStereotype(List<String> parents, AnnotationValue<?> annotationType, DefaultAnnotationMetadata metadata, boolean isDeclared) {
        ArrayList<String> stereoTypeParents = new ArrayList<String>(parents);
        stereoTypeParents.add(annotationType.getAnnotationName());
        this.buildStereotypeHierarchy(stereoTypeParents, annotationType, metadata, isDeclared, Collections.emptyList());
    }

    private void applyTransformations(@Nullable ListIterator<? extends A> hierarchyIterator, DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, @NonNull T annotationType, Map<CharSequence, Object> data, List<String> parents, @Nullable LinkedList<AnnotationValueBuilder<?>> interceptorBindings, BiConsumer<String, AnnotationValue> addRepeatableAnnotation, TriConsumer<String, Map<CharSequence, Object>, RetentionPolicy> addAnnotation) {
        this.applyTransformationsForAnnotationType(hierarchyIterator, annotationMetadata, isDeclared, annotationType, data, parents, interceptorBindings, addRepeatableAnnotation, addAnnotation);
    }

    private void applyTransformationsForAnnotationType(@Nullable ListIterator<? extends A> hierarchyIterator, DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, @NonNull T annotationType, Map<CharSequence, Object> data, List<String> parents, @Nullable LinkedList<AnnotationValueBuilder<?>> interceptorBindings, BiConsumer<String, AnnotationValue> addRepeatableAnnotation, TriConsumer<String, Map<CharSequence, Object>, RetentionPolicy> addAnnotation) {
        block25: {
            List<AnnotationTransformer<Annotation>> annotationTransformers;
            String annotationName;
            block28: {
                boolean remapped;
                List<AnnotationRemapper> annotationRemappers;
                RetentionPolicy retentionPolicy;
                block27: {
                    boolean transformed;
                    block23: {
                        String repeatableName;
                        block26: {
                            block24: {
                                annotationName = this.getElementName(annotationType);
                                String packageName = NameUtils.getPackageName((String)annotationName);
                                repeatableName = this.getRepeatableNameForType(annotationType);
                                retentionPolicy = this.getRetentionPolicy(annotationType);
                                annotationRemappers = ANNOTATION_REMAPPERS.get(packageName);
                                annotationTransformers = this.getAnnotationTransformers(annotationName);
                                remapped = CollectionUtils.isNotEmpty(annotationRemappers);
                                transformed = CollectionUtils.isNotEmpty(annotationTransformers);
                                if (repeatableName == null) break block23;
                                if (remapped || transformed) break block24;
                                AnnotationValue av = new AnnotationValue(annotationName, data);
                                addRepeatableAnnotation.accept(repeatableName, av);
                                break block25;
                            }
                            if (!remapped) break block26;
                            VisitorContext visitorContext = this.createVisitorContext();
                            AnnotationValue av = new AnnotationValue(annotationName, data);
                            AnnotationValue repeatableAnn = AnnotationValue.builder((String)repeatableName).values(new AnnotationValue[]{av}).build();
                            boolean wasRemapped = false;
                            for (AnnotationRemapper annotationRemapper : annotationRemappers) {
                                List<AnnotationValue<?>> remappedRepeatable = annotationRemapper.remap(repeatableAnn, visitorContext);
                                List<AnnotationValue<?>> remappedValue = annotationRemapper.remap(av, visitorContext);
                                if (!CollectionUtils.isNotEmpty(remappedRepeatable)) continue;
                                block1: for (AnnotationValue<?> repeatable : remappedRepeatable) {
                                    for (AnnotationValue<?> rmv : remappedValue) {
                                        if (rmv == av && remappedValue.size() == 1) {
                                            addRepeatableAnnotation.accept(repeatableName, av);
                                            continue block1;
                                        }
                                        wasRemapped = true;
                                        addRepeatableAnnotation.accept(repeatable.getAnnotationName(), rmv);
                                    }
                                }
                            }
                            if (!wasRemapped || hierarchyIterator == null) break block25;
                            hierarchyIterator.remove();
                            break block25;
                        }
                        VisitorContext visitorContext = this.createVisitorContext();
                        AnnotationValue av = new AnnotationValue(annotationName, data);
                        AnnotationValue repeatableAnn = AnnotationValue.builder((String)repeatableName).values(new AnnotationValue[]{av}).build();
                        List<AnnotationTransformer<Annotation>> repeatableTransformers = this.getAnnotationTransformers(repeatableName);
                        if (hierarchyIterator != null) {
                            hierarchyIterator.remove();
                        }
                        if (CollectionUtils.isNotEmpty(repeatableTransformers)) {
                            for (AnnotationTransformer<Annotation> repeatableTransformer : repeatableTransformers) {
                                List<AnnotationValue<?>> transformedRepeatable = repeatableTransformer.transform((AnnotationValue<Annotation>)repeatableAnn, visitorContext);
                                for (AnnotationValue<?> annotationValue : transformedRepeatable) {
                                    for (AnnotationTransformer<Annotation> transformer : annotationTransformers) {
                                        List<AnnotationValue<?>> tav = transformer.transform((AnnotationValue<Annotation>)av, visitorContext);
                                        for (AnnotationValue<?> value : tav) {
                                            addRepeatableAnnotation.accept(annotationValue.getAnnotationName(), value);
                                            if (CollectionUtils.isNotEmpty((Collection)value.getStereotypes())) {
                                                this.addTransformedStereotypes(annotationMetadata, isDeclared, value, parents);
                                                continue;
                                            }
                                            this.addTransformedStereotypes(annotationMetadata, isDeclared, value.getAnnotationName(), parents);
                                        }
                                    }
                                }
                            }
                        } else {
                            for (AnnotationTransformer<Annotation> transformer : annotationTransformers) {
                                List<AnnotationValue<?>> tav = transformer.transform((AnnotationValue<Annotation>)av, visitorContext);
                                for (AnnotationValue<?> value : tav) {
                                    addRepeatableAnnotation.accept(repeatableName, value);
                                    if (CollectionUtils.isNotEmpty((Collection)value.getStereotypes())) {
                                        this.addTransformedStereotypes(annotationMetadata, isDeclared, value, parents);
                                        continue;
                                    }
                                    this.addTransformedStereotypes(annotationMetadata, isDeclared, value.getAnnotationName(), parents);
                                }
                            }
                        }
                        break block25;
                    }
                    if (remapped || transformed) break block27;
                    addAnnotation.accept(annotationName, data, retentionPolicy);
                    break block25;
                }
                if (!remapped) break block28;
                AnnotationValue av = new AnnotationValue(annotationName, data);
                VisitorContext visitorContext = this.createVisitorContext();
                boolean wasRemapped = false;
                block9: for (AnnotationRemapper annotationRemapper : annotationRemappers) {
                    List<AnnotationValue<?>> remappedValues = annotationRemapper.remap(av, visitorContext);
                    if (!CollectionUtils.isNotEmpty(remappedValues)) continue;
                    for (AnnotationValue<?> annotationValue : remappedValues) {
                        if (annotationValue == av && remappedValues.size() == 1) {
                            addAnnotation.accept(annotationName, data, retentionPolicy);
                            continue block9;
                        }
                        wasRemapped = true;
                        String transformedAnnotationName = this.handleTransformedAnnotationValue(parents, interceptorBindings, addRepeatableAnnotation, addAnnotation, annotationValue, annotationMetadata);
                        if (CollectionUtils.isNotEmpty((Collection)annotationValue.getStereotypes())) {
                            this.addTransformedStereotypes(annotationMetadata, isDeclared, annotationValue, parents);
                            continue;
                        }
                        this.addTransformedStereotypes(annotationMetadata, isDeclared, transformedAnnotationName, parents);
                    }
                }
                if (!wasRemapped || hierarchyIterator == null) break block25;
                hierarchyIterator.remove();
                break block25;
            }
            AnnotationValue av = new AnnotationValue(annotationName, data);
            VisitorContext visitorContext = this.createVisitorContext();
            if (hierarchyIterator != null) {
                hierarchyIterator.remove();
            }
            for (AnnotationTransformer<Annotation> annotationTransformer : annotationTransformers) {
                List<AnnotationValue<?>> transformedValues = annotationTransformer.transform((AnnotationValue<Annotation>)av, visitorContext);
                for (AnnotationValue<?> transformedValue : transformedValues) {
                    String transformedAnnotationName = this.handleTransformedAnnotationValue(parents, interceptorBindings, addRepeatableAnnotation, addAnnotation, transformedValue, annotationMetadata);
                    if (CollectionUtils.isNotEmpty((Collection)transformedValue.getStereotypes())) {
                        this.addTransformedStereotypes(annotationMetadata, isDeclared, transformedValue, parents);
                        continue;
                    }
                    this.addTransformedStereotypes(annotationMetadata, isDeclared, transformedAnnotationName, parents);
                }
            }
        }
    }

    private String handleTransformedAnnotationValue(List<String> parents, LinkedList<AnnotationValueBuilder<?>> interceptorBindings, BiConsumer<String, AnnotationValue> addRepeatableAnnotation, TriConsumer<String, Map<CharSequence, Object>, RetentionPolicy> addAnnotation, AnnotationValue<?> transformedValue, DefaultAnnotationMetadata annotationMetadata) {
        String transformedRepeatableName;
        String transformedAnnotationName = transformedValue.getAnnotationName();
        this.addTransformedInterceptorBindingsIfNecessary(parents, interceptorBindings, transformedValue, transformedAnnotationName, annotationMetadata);
        if (this.isRepeatableCandidate(transformedAnnotationName)) {
            String resolvedName = null;
            try {
                resolvedName = this.getAnnotationMirror(transformedAnnotationName).map(this::getRepeatableNameForType).orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            transformedRepeatableName = resolvedName;
        } else {
            transformedRepeatableName = null;
        }
        if (transformedRepeatableName != null) {
            addRepeatableAnnotation.accept(transformedRepeatableName, transformedValue);
        } else {
            addAnnotation.accept(transformedAnnotationName, transformedValue.getValues(), transformedValue.getRetentionPolicy());
        }
        return transformedAnnotationName;
    }

    private void addTransformedInterceptorBindingsIfNecessary(List<String> parents, LinkedList<AnnotationValueBuilder<?>> interceptorBindings, AnnotationValue<?> transformedValue, String transformedAnnotationName, DefaultAnnotationMetadata annotationMetadata) {
        if (interceptorBindings != null && !parents.isEmpty() && "io.micronaut.aop.InterceptorBinding".equals(transformedAnnotationName)) {
            AnnotationValueBuilder newBuilder = AnnotationValue.builder((String)transformedAnnotationName, (RetentionPolicy)transformedValue.getRetentionPolicy()).members(transformedValue.getValues());
            if (!transformedValue.contains("value")) {
                newBuilder.value(parents.get(parents.size() - 1));
            }
            if (transformedValue.booleanValue("bindMembers").orElse(false).booleanValue()) {
                String parent = (String)CollectionUtils.last(parents);
                HashMap<CharSequence, Object> data = new HashMap<CharSequence, Object>(transformedValue.getValues());
                this.handleMemberBinding(annotationMetadata, parent, data);
                newBuilder.members(data);
            }
            interceptorBindings.add(newBuilder);
        }
    }

    private List<AnnotationValue<?>> remapAnnotation(String annotationName) {
        String packageName = NameUtils.getPackageName((String)annotationName);
        List<AnnotationRemapper> annotationRemappers = ANNOTATION_REMAPPERS.get(packageName);
        ArrayList mappedAnnotations = new ArrayList();
        if (annotationRemappers == null || annotationRemappers.isEmpty()) {
            mappedAnnotations.add(AnnotationValue.builder((String)annotationName).build());
            return mappedAnnotations;
        }
        VisitorContext visitorContext = this.createVisitorContext();
        AnnotationValue av = new AnnotationValue(annotationName);
        for (AnnotationRemapper annotationRemapper : annotationRemappers) {
            List<AnnotationValue<?>> remappedValues = annotationRemapper.remap(av, visitorContext);
            if (!CollectionUtils.isNotEmpty(remappedValues)) continue;
            for (AnnotationValue<?> annotationValue : remappedValues) {
                if (annotationValue == av && remappedValues.size() == 1) break;
                mappedAnnotations.add(annotationValue);
            }
        }
        return mappedAnnotations;
    }

    private boolean isRepeatableCandidate(String transformedAnnotationName) {
        return !AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(transformedAnnotationName) && !"javax.annotation.Nullable".equals(transformedAnnotationName) && !"javax.annotation.Nonnull".equals(transformedAnnotationName);
    }

    private void addTransformedStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, String transformedAnnotationName, List<String> parents) {
        String packageName;
        if (!AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(transformedAnnotationName) && !AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName = NameUtils.getPackageName((String)transformedAnnotationName))) {
            this.getAnnotationMirror(transformedAnnotationName).ifPresent(a -> this.processAnnotationStereotypes(annotationMetadata, isDeclared, false, a, transformedAnnotationName, parents));
        }
    }

    private void addTransformedStereotypes(DefaultAnnotationMetadata annotationMetadata, boolean isDeclared, AnnotationValue<?> transformedAnnotation, List<String> parents) {
        String packageName;
        String transformedAnnotationName = transformedAnnotation.getAnnotationName();
        if (!AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(transformedAnnotationName) && !AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName = NameUtils.getPackageName((String)transformedAnnotationName))) {
            this.processAnnotationStereotypes(annotationMetadata, isDeclared, transformedAnnotation, parents);
        }
    }

    @Internal
    public static void addMutatedMetadata(String declaringType, Object element, AnnotationMetadata metadata) {
        if (element != null && metadata != null) {
            MUTATED_ANNOTATION_METADATA.put(new MetadataKey<Object>(declaringType, element), metadata);
        }
    }

    @Internal
    public static boolean isMetadataMutated(String declaringType, Object element) {
        if (element != null) {
            return MUTATED_ANNOTATION_METADATA.containsKey(new MetadataKey<Object>(declaringType, element));
        }
        return false;
    }

    @Internal
    public static void clearMutated() {
        MUTATED_ANNOTATION_METADATA.clear();
    }

    @Internal
    public static void clearCaches() {
        ANNOTATION_DEFAULTS.clear();
    }

    @Internal
    public static void copyToRuntime() {
        ANNOTATION_DEFAULTS.forEach(DefaultAnnotationMetadata::registerAnnotationDefaults);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Internal
    public static boolean isAnnotationMapped(@Nullable String annotationName) {
        if (annotationName == null) return false;
        if (ANNOTATION_MAPPERS.containsKey(annotationName)) return true;
        if (ANNOTATION_TRANSFORMERS.containsKey(annotationName)) return true;
        if (!ANNOTATION_TRANSFORMERS.keySet().stream().anyMatch(annotationName::startsWith)) return false;
        return true;
    }

    @Internal
    public static Set<String> getMappedAnnotationNames() {
        HashSet<String> all = new HashSet<String>(ANNOTATION_MAPPERS.keySet());
        all.addAll(ANNOTATION_TRANSFORMERS.keySet());
        return all;
    }

    @Internal
    public static Set<String> getMappedAnnotationPackages() {
        return ANNOTATION_REMAPPERS.keySet();
    }

    public <A2 extends Annotation> AnnotationMetadata annotate(AnnotationMetadata annotationMetadata, AnnotationValue<A2> annotationValue) {
        boolean isReferenceOrEmpty;
        String annotationName = annotationValue.getAnnotationName();
        boolean isReference = annotationMetadata instanceof AnnotationMetadataReference;
        boolean bl = isReferenceOrEmpty = annotationMetadata == AnnotationMetadata.EMPTY_METADATA || isReference;
        if (annotationMetadata instanceof DefaultAnnotationMetadata || isReferenceOrEmpty) {
            DefaultAnnotationMetadata defaultMetadata = isReferenceOrEmpty ? new MutableAnnotationMetadata() : (DefaultAnnotationMetadata)annotationMetadata;
            T annotationMirror = this.getAnnotationMirror(annotationName).orElse(null);
            if (annotationMirror != null) {
                this.applyTransformationsForAnnotationType(null, defaultMetadata, true, annotationMirror, annotationValue.getValues(), Collections.emptyList(), new LinkedList(), defaultMetadata::addDeclaredRepeatable, defaultMetadata::addDeclaredAnnotation);
                this.processAnnotationDefaults(annotationMirror, defaultMetadata, annotationName, () -> this.readAnnotationDefaultValues(annotationName, annotationMirror));
                this.processAnnotationStereotypes(defaultMetadata, true, this.isInheritedAnnotationType(annotationMirror), annotationMirror, annotationName, DEFAULT_ANNOTATE_EXCLUDES);
            } else {
                defaultMetadata.addDeclaredAnnotation(annotationName, annotationValue.getValues());
            }
            if (isReference) {
                AnnotationMetadataReference ref = (AnnotationMetadataReference)annotationMetadata;
                return new AnnotationMetadataHierarchy(new AnnotationMetadata[]{ref, defaultMetadata});
            }
            return defaultMetadata;
        }
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy hierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
            AnnotationMetadata declaredMetadata = this.annotate(hierarchy.getDeclaredMetadata(), annotationValue);
            return hierarchy.createSibling(declaredMetadata);
        }
        return annotationMetadata;
    }

    public AnnotationMetadata removeAnnotation(AnnotationMetadata annotationMetadata, String annotationType) {
        boolean isHierarchy = annotationMetadata instanceof AnnotationMetadataHierarchy;
        AnnotationMetadata declaredMetadata = annotationMetadata;
        if (isHierarchy) {
            declaredMetadata = annotationMetadata.getDeclaredMetadata();
        }
        if (declaredMetadata instanceof DefaultAnnotationMetadata) {
            DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)declaredMetadata;
            T annotationMirror = this.getAnnotationMirror(annotationType).orElse(null);
            if (annotationMirror != null) {
                String repeatableName = this.getRepeatableNameForType(annotationMirror);
                if (repeatableName != null) {
                    defaultMetadata.removeAnnotation(repeatableName);
                } else {
                    defaultMetadata.removeAnnotation(annotationType);
                }
            } else {
                defaultMetadata.removeAnnotation(annotationType);
            }
            if (isHierarchy) {
                return ((AnnotationMetadataHierarchy)annotationMetadata).createSibling(declaredMetadata);
            }
            return declaredMetadata;
        }
        return annotationMetadata;
    }

    public AnnotationMetadata removeStereotype(AnnotationMetadata annotationMetadata, String annotationType) {
        boolean isHierarchy = annotationMetadata instanceof AnnotationMetadataHierarchy;
        AnnotationMetadata declaredMetadata = annotationMetadata;
        if (isHierarchy) {
            declaredMetadata = annotationMetadata.getDeclaredMetadata();
        }
        if (declaredMetadata instanceof DefaultAnnotationMetadata) {
            DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)declaredMetadata;
            T annotationMirror = this.getAnnotationMirror(annotationType).orElse(null);
            if (annotationMirror != null) {
                String repeatableName = this.getRepeatableNameForType(annotationMirror);
                if (repeatableName != null) {
                    defaultMetadata.removeStereotype(repeatableName);
                } else {
                    defaultMetadata.removeStereotype(annotationType);
                }
            } else {
                defaultMetadata.removeStereotype(annotationType);
            }
            if (isHierarchy) {
                return ((AnnotationMetadataHierarchy)annotationMetadata).createSibling(declaredMetadata);
            }
            return declaredMetadata;
        }
        return annotationMetadata;
    }

    @NonNull
    public <T1 extends Annotation> AnnotationMetadata removeAnnotationIf(@NonNull AnnotationMetadata annotationMetadata, @NonNull Predicate<AnnotationValue<T1>> predicate) {
        boolean isHierarchy = annotationMetadata instanceof AnnotationMetadataHierarchy;
        AnnotationMetadata declaredMetadata = annotationMetadata;
        if (isHierarchy) {
            declaredMetadata = annotationMetadata.getDeclaredMetadata();
        }
        if (declaredMetadata instanceof DefaultAnnotationMetadata) {
            DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)declaredMetadata;
            defaultMetadata.removeAnnotationIf(predicate);
            if (isHierarchy) {
                return ((AnnotationMetadataHierarchy)annotationMetadata).createSibling(declaredMetadata);
            }
            return declaredMetadata;
        }
        return annotationMetadata;
    }

    static {
        SoftServiceLoader serviceLoader = SoftServiceLoader.load(AnnotationMapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (Object definition : serviceLoader) {
            if (!definition.isPresent()) continue;
            AnnotationMapper mapper = (AnnotationMapper)definition.load();
            try {
                String name = null;
                if (mapper instanceof TypedAnnotationMapper) {
                    name = ((TypedAnnotationMapper)mapper).annotationType().getName();
                } else if (mapper instanceof NamedAnnotationMapper) {
                    name = ((NamedAnnotationMapper)mapper).getName();
                }
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_MAPPERS.computeIfAbsent(name, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable name) {}
        }
        SoftServiceLoader transformerSoftServiceLoader = SoftServiceLoader.load(AnnotationTransformer.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (ServiceDefinition definition : transformerSoftServiceLoader) {
            if (!definition.isPresent()) continue;
            AnnotationTransformer transformer = (AnnotationTransformer)definition.load();
            try {
                String name = null;
                if (transformer instanceof TypedAnnotationTransformer) {
                    name = ((TypedAnnotationTransformer)transformer).annotationType().getName();
                } else if (transformer instanceof NamedAnnotationTransformer) {
                    name = ((NamedAnnotationTransformer)transformer).getName();
                }
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_TRANSFORMERS.computeIfAbsent(name, s -> new ArrayList(2)).add(transformer);
            }
            catch (Throwable name) {}
        }
        SoftServiceLoader remapperLoader = SoftServiceLoader.load(AnnotationRemapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (ServiceDefinition definition : remapperLoader) {
            if (!definition.isPresent()) continue;
            AnnotationRemapper mapper = (AnnotationRemapper)definition.load();
            try {
                String name = mapper.getPackageName();
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                ANNOTATION_REMAPPERS.computeIfAbsent(name, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable throwable) {}
        }
    }

    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }

    private static class MetadataKey<T> {
        final String declaringName;
        final T element;

        MetadataKey(String declaringName, T element) {
            this.declaringName = declaringName;
            this.element = element;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataKey that = (MetadataKey)o;
            return this.declaringName.equals(that.declaringName) && this.element.equals(that.element);
        }

        public int hashCode() {
            return Objects.hash(this.declaringName, this.element);
        }
    }
}

