/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.QualifierUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
class AnnotationMetadataQualifier<T>
implements Qualifier<T> {
    @NonNull
    final String annotationName;
    @NonNull
    final String annotationSimpleName;
    @Nullable
    final AnnotationValue<Annotation> qualifierAnn;

    AnnotationMetadataQualifier(@NonNull AnnotationMetadata annotationMetadata, @NonNull String name) {
        this(annotationMetadata, name, annotationMetadata.getAnnotationType(name).orElse(null));
    }

    AnnotationMetadataQualifier(@NonNull AnnotationMetadata annotationMetadata, @NonNull Class<? extends Annotation> annotationType) {
        this(annotationMetadata, null, annotationType);
    }

    private AnnotationMetadataQualifier(@NonNull AnnotationMetadata annotationMetadata, @Nullable String annotationTypeName, @Nullable Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            Objects.requireNonNull(annotationTypeName, "Annotation name cannot be null");
            annotationType = annotationMetadata.getAnnotationType(annotationTypeName).orElse(null);
        }
        if (annotationType == null) {
            this.annotationName = annotationTypeName;
            this.annotationSimpleName = NameUtils.getSimpleName((String)this.annotationName);
        } else {
            this.annotationName = annotationType.getName();
            this.annotationSimpleName = annotationType.getSimpleName();
        }
        Set<String> nonBinding = this.resolveNonBindingMembers(annotationMetadata);
        Map<CharSequence, Object> bindingValues = this.resolveBindingValues(annotationMetadata, this.annotationName, nonBinding);
        this.qualifierAnn = CollectionUtils.isNotEmpty(bindingValues) ? new AnnotationValue(this.annotationName, bindingValues) : null;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> {
            if (!QualifierUtils.matchType(beanType, candidate)) {
                return false;
            }
            if (QualifierUtils.matchAny(beanType, candidate)) {
                return true;
            }
            if (this.qualifierAnn == null) {
                if (candidate.getAnnotationMetadata().hasDeclaredAnnotation(this.annotationName)) {
                    return true;
                }
            } else {
                Set<String> nonBinding;
                Map<CharSequence, Object> values;
                AnnotationMetadata annotationMetadata = candidate.getAnnotationMetadata();
                AnnotationValue av = candidate.getAnnotation(this.annotationName);
                if (av != null && this.qualifierAnn.equals((Object)new AnnotationValue(this.annotationName, values = this.resolveBindingValues(annotationMetadata, this.annotationName, nonBinding = this.resolveNonBindingMembers(annotationMetadata))))) {
                    return true;
                }
            }
            return QualifierUtils.matchByCandidateName(candidate, beanType, this.annotationSimpleName);
        });
    }

    @Nullable
    private Map<CharSequence, Object> resolveBindingValues(AnnotationMetadata annotationMetadata, String qualifierName, Set<String> nonBinding) {
        Map bindingValues = annotationMetadata.getValues(qualifierName);
        if (nonBinding == null || bindingValues.isEmpty() || nonBinding.isEmpty()) {
            return bindingValues;
        }
        HashMap<CharSequence, Object> map = new HashMap<CharSequence, Object>();
        for (Map.Entry entry : bindingValues.entrySet()) {
            if (nonBinding.contains(((CharSequence)entry.getKey()).toString()) || map.put((CharSequence)entry.getKey(), entry.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key: " + entry.getKey());
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return QualifierUtils.annotationQualifiersEquals(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.annotationName, this.qualifierAnn);
    }

    @NonNull
    private Set<String> resolveNonBindingMembers(AnnotationMetadata annotationMetadata) {
        Object[] nonBindingArray = annotationMetadata.stringValues("javax.inject.Qualifier", "nonBinding");
        return ArrayUtils.isNotEmpty((Object[])nonBindingArray) ? new HashSet<Object>(Arrays.asList(nonBindingArray)) : Collections.emptySet();
    }

    public String toString() {
        if (this.qualifierAnn != null) {
            return "@" + this.annotationSimpleName + "(" + this.qualifierAnn.getValues().entrySet().stream().map(entry -> entry.getKey() + "=" + this.valueToString((Map.Entry<CharSequence, Object>)entry)).collect(Collectors.joining(", ")) + ")";
        }
        return "@" + this.annotationSimpleName;
    }

    private Object valueToString(Map.Entry<CharSequence, Object> entry) {
        Object v = entry.getValue();
        if (v instanceof Object[]) {
            return Arrays.toString((Object[])v);
        }
        return v;
    }
}

