/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.AbstractBeanDefinitionReference;
import io.micronaut.context.AbstractBeanResolutionContext;
import io.micronaut.context.AnnotationProcessorListener;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfiguration;
import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanDefinitionRegistry;
import io.micronaut.context.BeanDisposingRegistration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultCustomScopeRegistry;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.InitializableBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.NoInjectionBeanDefinition;
import io.micronaut.context.Qualifier;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.context.SingletonScope;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Infrastructure;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.event.BeanDestroyedEvent;
import io.micronaut.context.event.BeanDestroyedEventListener;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanPreDestroyEvent;
import io.micronaut.context.event.BeanPreDestroyEventListener;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanCreationException;
import io.micronaut.context.exceptions.BeanDestructionException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.context.exceptions.NonUniqueBeanException;
import io.micronaut.context.processor.AnnotationProcessor;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.context.scope.BeanCreationContext;
import io.micronaut.context.scope.CreatedBean;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.context.scope.CustomScopeRegistry;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Indexes;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StreamUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionMethodReference;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.ParametrizedBeanFactory;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.proxy.InterceptedBeanProxy;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.Qualified;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanContext
implements InitializableBeanContext {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultBeanContext.class);
    protected static final Logger LOG_LIFECYCLE = LoggerFactory.getLogger((String)(DefaultBeanContext.class.getPackage().getName() + ".lifecycle"));
    private static final Qualifier PROXY_TARGET_QUALIFIER = new Qualifier<Object>(){

        @Override
        public <BT extends BeanType<Object>> Stream<BT> reduce(Class<Object> beanType, Stream<BT> candidates) {
            return candidates.filter(bt -> {
                if (bt instanceof BeanDefinitionDelegate) {
                    return !(((BeanDefinitionDelegate)bt).getDelegate() instanceof ProxyBeanDefinition);
                }
                return !(bt instanceof ProxyBeanDefinition);
            });
        }
    };
    private static final String SCOPED_PROXY_ANN = "io.micronaut.runtime.context.scope.ScopedProxy";
    private static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
    private static final String ADAPTER_TYPE = "io.micronaut.aop.Adapter";
    private static final String NAMED_MEMBER = "named";
    private static final String QUALIFIER_MEMBER = "qualifier";
    private static final String PARALLEL_TYPE = Parallel.class.getName();
    private static final String INDEXES_TYPE = Indexes.class.getName();
    private static final String REPLACES_ANN = Replaces.class.getName();
    private static final Comparator<BeanRegistration<?>> BEAN_REGISTRATION_COMPARATOR = (o1, o2) -> {
        int order1 = OrderUtil.getOrder(o1.getBeanDefinition(), o1.getBean());
        int order2 = OrderUtil.getOrder(o2.getBeanDefinition(), o2.getBean());
        return Integer.compare(order1, order2);
    };
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final AtomicBoolean initializing = new AtomicBoolean(false);
    protected final AtomicBoolean terminating = new AtomicBoolean(false);
    final Map<BeanIdentifier, BeanRegistration<?>> singlesInCreation = new ConcurrentHashMap(5);
    Set<Map.Entry<Class<?>, List<BeanInitializedEventListener>>> beanInitializedEventListeners;
    private final SingletonScope singletonScope = new SingletonScope();
    private final BeanContextConfiguration beanContextConfiguration;
    private final Collection<BeanDefinitionReference> beanDefinitionsClasses = new ConcurrentLinkedQueue<BeanDefinitionReference>();
    private final Map<String, BeanConfiguration> beanConfigurations = new HashMap<String, BeanConfiguration>(10);
    private final Map<BeanKey, Boolean> containsBeanCache = new ConcurrentHashMap<BeanKey, Boolean>(30);
    private final Map<CharSequence, Object> attributes = Collections.synchronizedMap(new HashMap(5));
    private final Map<BeanKey, CollectionHolder> singletonBeanRegistrations = new ConcurrentHashMap<BeanKey, CollectionHolder>(50);
    private final Map<BeanCandidateKey, Optional<BeanDefinition>> beanConcreteCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Argument, Collection<BeanDefinition>> beanCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Class, Collection<BeanDefinitionReference>> beanIndex = new ConcurrentHashMap<Class, Collection<BeanDefinitionReference>>(12);
    private final ClassLoader classLoader;
    private final Set<Class> thisInterfaces = CollectionUtils.setOf((Object[])new Class[]{BeanDefinitionRegistry.class, BeanContext.class, AnnotationMetadataResolver.class, BeanLocator.class, ExecutionHandleLocator.class, ApplicationContext.class, PropertyResolver.class, ValueResolver.class, PropertyPlaceholderResolver.class});
    private final Set<Class> indexedTypes = CollectionUtils.setOf((Object[])new Class[]{ResourceLoader.class, TypeConverter.class, TypeConverterRegistrar.class, ApplicationEventListener.class, BeanCreatedEventListener.class, BeanInitializedEventListener.class});
    private final CustomScopeRegistry customScopeRegistry;
    private final String[] eagerInitStereotypes;
    private final boolean eagerInitStereotypesPresent;
    private final boolean eagerInitSingletons;
    private BeanDefinitionValidator beanValidator;
    private List<BeanDefinitionReference> beanDefinitionReferences;
    private List<BeanConfiguration> beanConfigurationsList;
    private Set<Map.Entry<Class<?>, List<BeanCreatedEventListener<?>>>> beanCreationEventListeners;
    private Set<Map.Entry<Class<?>, List<BeanPreDestroyEventListener>>> beanPreDestroyEventListeners;
    private Set<Map.Entry<Class<?>, List<BeanDestroyedEventListener>>> beanDestroyedEventListeners;

    public DefaultBeanContext() {
        this(BeanContext.class.getClassLoader());
    }

    public DefaultBeanContext(final @NonNull ClassLoader classLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull((String)"classLoader", (Object)classLoader);
                return classLoader;
            }
        });
    }

    public DefaultBeanContext(final @NonNull ClassPathResourceLoader resourceLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull((String)"resourceLoader", (Object)resourceLoader);
                return resourceLoader.getClassLoader();
            }
        });
    }

    public DefaultBeanContext(@NonNull BeanContextConfiguration contextConfiguration) {
        ArgumentUtils.requireNonNull((String)"contextConfiguration", (Object)contextConfiguration);
        System.setProperty("micronaut.classloader.logging", "true");
        this.classLoader = contextConfiguration.getClassLoader();
        this.customScopeRegistry = Objects.requireNonNull(this.createCustomScopeRegistry(), "Scope registry cannot be null");
        Set<Class<? extends Annotation>> eagerInitAnnotated = contextConfiguration.getEagerInitAnnotated();
        ArrayList<String> eagerInitStereotypes = new ArrayList<String>(eagerInitAnnotated.size());
        for (Class<? extends Annotation> ann : eagerInitAnnotated) {
            eagerInitStereotypes.add(ann.getName());
        }
        this.eagerInitStereotypes = eagerInitStereotypes.toArray(new String[0]);
        this.eagerInitStereotypesPresent = !eagerInitStereotypes.isEmpty();
        this.eagerInitSingletons = this.eagerInitStereotypesPresent && (eagerInitStereotypes.contains("javax.inject.Singleton") || eagerInitStereotypes.contains(Singleton.class.getName()));
        this.beanContextConfiguration = contextConfiguration;
    }

    @NonNull
    protected CustomScopeRegistry createCustomScopeRegistry() {
        return new DefaultCustomScopeRegistry(this);
    }

    @Internal
    @NonNull
    CustomScopeRegistry getCustomScopeRegistry() {
        return this.customScopeRegistry;
    }

    @Override
    public boolean isRunning() {
        return this.running.get() && !this.initializing.get();
    }

    @Override
    public synchronized BeanContext start() {
        if (!this.isRunning()) {
            if (this.initializing.compareAndSet(false, true)) {
                String activeConfigurations;
                ((DefaultConversionService)ConversionService.SHARED).reset();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting BeanContext");
                }
                this.finalizeConfiguration();
                if (LOG.isDebugEnabled() && StringUtils.isNotEmpty((CharSequence)(activeConfigurations = this.beanConfigurations.values().stream().filter(config -> config.isEnabled(this)).map(BeanConfiguration::getName).collect(Collectors.joining(","))))) {
                    LOG.debug("Loaded active configurations: {}", (Object)activeConfigurations);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("BeanContext Started.");
                }
                this.publishEvent(new StartupEvent(this));
            }
            this.running.set(true);
            this.initializing.set(false);
        }
        return this;
    }

    @Override
    public synchronized BeanContext stop() {
        if (this.terminating.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping BeanContext");
            }
            this.publishEvent(new ShutdownEvent(this));
            this.attributes.clear();
            List<BeanRegistration> objects = this.topologicalSort(this.singletonScope.getBeanRegistrations());
            Map<Boolean, List<BeanRegistration>> result = objects.stream().collect(Collectors.groupingBy(br -> br.bean != null && (br.bean instanceof BeanPreDestroyEventListener || br.bean instanceof BeanDestroyedEventListener)));
            List<BeanRegistration> listeners = result.get(true);
            if (listeners != null) {
                objects.clear();
                objects.addAll((Collection<BeanRegistration>)result.get(false));
                objects.addAll(listeners);
            }
            HashSet<Integer> processed = new HashSet<Integer>();
            for (BeanRegistration beanRegistration : objects) {
                Object bean = beanRegistration.bean;
                int sysId = System.identityHashCode(bean);
                if (processed.contains(sysId)) continue;
                if (LOG_LIFECYCLE.isDebugEnabled()) {
                    LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", bean, (Object)beanRegistration.identifier);
                }
                processed.add(sysId);
                try {
                    this.destroyBean(beanRegistration);
                }
                catch (BeanDestructionException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            this.singletonBeanRegistrations.clear();
            this.beanConcreteCandidateCache.clear();
            this.beanCandidateCache.clear();
            this.containsBeanCache.clear();
            this.beanConfigurations.clear();
            this.singletonScope.clear();
            this.beanInitializedEventListeners = null;
            this.beanCreationEventListeners = null;
            this.beanPreDestroyEventListeners = null;
            this.beanDestroyedEventListeners = null;
            ((DefaultConversionService)ConversionService.SHARED).reset();
            this.terminating.set(false);
            this.running.set(false);
        }
        return this;
    }

    @NonNull
    public AnnotationMetadata resolveMetadata(Class<?> type) {
        if (type == null) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        return this.findBeanDefinition(Argument.of(type), null, false).map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
    }

    @Override
    public <T> Optional<T> refreshBean(@Nullable BeanIdentifier identifier) {
        if (identifier == null) {
            return Optional.empty();
        }
        BeanRegistration<BeanIdentifier> beanRegistration = this.singletonScope.findBeanRegistration(identifier);
        if (beanRegistration != null) {
            this.refreshBean(beanRegistration);
            return Optional.of(beanRegistration.bean);
        }
        return Optional.empty();
    }

    @Override
    public <T> void refreshBean(@NonNull BeanRegistration<T> beanRegistration) {
        Objects.requireNonNull(beanRegistration, "BeanRegistration cannot be null");
        if (beanRegistration.bean != null) {
            beanRegistration.definition().inject(this, beanRegistration.bean);
        }
    }

    @Override
    public Collection<BeanRegistration<?>> getActiveBeanRegistrations(Qualifier<?> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        return this.singletonScope.getBeanRegistrations(qualifier);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getActiveBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.singletonScope.getBeanRegistrations(beanType);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.getBeanRegistrations(null, Argument.of(beanType), null);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistration(null, Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType, Qualifier<T> qualifier) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.getBeanRegistrations(null, Argument.of(beanType), null);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistrations(null, Objects.requireNonNull(beanType, "Bean type cannot be null"), qualifier);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistration(null, Objects.requireNonNull(beanType, "Bean type cannot be null"), qualifier);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(BeanDefinition<T> beanDefinition) {
        return this.resolveBeanRegistration(null, beanDefinition);
    }

    @Override
    public <T> Optional<BeanRegistration<T>> findBeanRegistration(T bean) {
        if (bean == null) {
            return Optional.empty();
        }
        BeanRegistration<T> beanRegistration = this.singletonScope.findBeanRegistration(bean);
        if (beanRegistration != null) {
            return Optional.of(beanRegistration);
        }
        return this.customScopeRegistry.findBeanRegistration(bean);
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, String method, Class ... arguments) {
        return this.findExecutionHandle(beanType, null, method, arguments);
    }

    public MethodExecutionHandle<?, Object> createExecutionHandle(final BeanDefinition<? extends Object> beanDefinition, final ExecutableMethod<Object, ?> method) {
        return new MethodExecutionHandle<Object, Object>(){
            private Object target;

            @NonNull
            public AnnotationMetadata getAnnotationMetadata() {
                return method.getAnnotationMetadata();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object getTarget() {
                Object target = this.target;
                if (target == null) {
                    4 var2_2 = this;
                    synchronized (var2_2) {
                        target = this.target;
                        if (target == null) {
                            this.target = target = DefaultBeanContext.this.getBean(beanDefinition);
                        }
                    }
                }
                return target;
            }

            @Override
            public Class getDeclaringType() {
                return beanDefinition.getBeanType();
            }

            @Override
            public String getMethodName() {
                return method.getMethodName();
            }

            @Override
            public Argument[] getArguments() {
                return method.getArguments();
            }

            @Override
            public Method getTargetMethod() {
                return method.getTargetMethod();
            }

            public ReturnType getReturnType() {
                return method.getReturnType();
            }

            @Override
            public Object invoke(Object ... arguments) {
                return method.invoke(this.getTarget(), arguments);
            }

            @Override
            @NonNull
            public ExecutableMethod<?, Object> getExecutableMethod() {
                return method;
            }
        };
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, Qualifier<?> qualifier, String method, Class ... arguments) {
        Optional<BeanDefinition<T>> foundBean = this.findBeanDefinition(beanType, qualifier);
        if (foundBean.isPresent()) {
            BeanDefinition<T> beanDefinition = foundBean.get();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod.map(executableMethod -> new BeanExecutionHandle(this, beanType, qualifier, executableMethod));
            }
            return beanDefinition.findPossibleMethods(method).findFirst().filter(m -> {
                Class[] argTypes = m.getArgumentTypes();
                if (argTypes.length == arguments.length) {
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (arguments[i].isAssignableFrom(argTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }).map(executableMethod -> new BeanExecutionHandle(this, beanType, qualifier, executableMethod));
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findExecutableMethod(Class<T> beanType, String method, Class[] arguments) {
        Collection<BeanDefinition<T>> definitions;
        if (beanType != null && !(definitions = this.getBeanDefinitions(beanType)).isEmpty()) {
            BeanDefinition<T> beanDefinition = definitions.iterator().next();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod;
            }
            return beanDefinition.findPossibleMethods(method).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(T bean, String method, Class[] arguments) {
        Optional<BeanDefinition<?>> foundBean;
        if (bean != null && (foundBean = this.findBeanDefinition(bean.getClass())).isPresent()) {
            BeanDefinition<?> beanDefinition = foundBean.get();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod.map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
            }
            return beanDefinition.findPossibleMethods(method).findFirst().map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
        }
        return Optional.empty();
    }

    @Override
    public <T> BeanContext registerSingleton(final @NonNull Class<T> type, @NonNull T singleton, Qualifier<T> qualifier, boolean inject) {
        BeanDefinition<T> beanDefinition;
        this.purgeCacheForBeanInstance(singleton);
        if (inject && this.running.get()) {
            beanDefinition = this.findBeanDefinition(type, qualifier).orElse(null);
            if (beanDefinition == null) {
                this.beanCandidateCache.entrySet().removeIf(entry -> ((Argument)entry.getKey()).isInstance(singleton));
                this.beanConcreteCandidateCache.entrySet().removeIf(entry -> ((BeanCandidateKey)entry.getKey()).beanType.isInstance(singleton));
            }
        } else {
            beanDefinition = null;
        }
        if (beanDefinition != null && beanDefinition.getBeanType().isInstance(singleton)) {
            try (BeanResolutionContext context = this.newResolutionContext(beanDefinition, null);){
                this.doInject(context, singleton, beanDefinition);
                BeanKey key = new BeanKey(beanDefinition.asArgument(), qualifier);
                this.singletonScope.registerSingletonBean(BeanRegistration.of(this, key, beanDefinition, singleton), qualifier);
            }
        } else {
            NoInjectionBeanDefinition<T> dynamicRegistration = new NoInjectionBeanDefinition<T>(singleton.getClass(), qualifier);
            if (qualifier instanceof Named) {
                BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(dynamicRegistration);
                delegate.put(BeanDefinition.NAMED_ATTRIBUTE, ((Named)qualifier).getName());
                beanDefinition = delegate;
            } else {
                beanDefinition = dynamicRegistration;
            }
            this.beanDefinitionsClasses.add(dynamicRegistration);
            BeanKey key = new BeanKey(beanDefinition.asArgument(), qualifier);
            this.singletonScope.registerSingletonBean(BeanRegistration.of(this, key, dynamicRegistration, singleton), qualifier);
            for (Class indexedType : this.indexedTypes) {
                if (indexedType != type && !indexedType.isAssignableFrom(type)) continue;
                Collection<BeanDefinitionReference> indexed = this.resolveTypeIndex(indexedType);
                final BeanDefinition<T> finalBeanDefinition = beanDefinition;
                indexed.add(new AbstractBeanDefinitionReference(type.getName(), type.getName()){

                    @Override
                    protected Class<? extends BeanDefinition<?>> getBeanDefinitionType() {
                        return finalBeanDefinition.getClass();
                    }

                    public BeanDefinition load() {
                        return finalBeanDefinition;
                    }

                    @Override
                    public Class getBeanType() {
                        return type;
                    }
                });
                break;
            }
        }
        return this;
    }

    private <T> void purgeCacheForBeanInstance(T singleton) {
        this.beanCandidateCache.entrySet().removeIf(entry -> ((Argument)entry.getKey()).isInstance(singleton));
        this.beanConcreteCandidateCache.entrySet().removeIf(entry -> ((BeanCandidateKey)entry.getKey()).beanType.isInstance(singleton));
        this.singletonBeanRegistrations.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isInstance(singleton));
        this.containsBeanCache.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isInstance(singleton));
    }

    @NonNull
    final BeanResolutionContext newResolutionContext(BeanDefinition<?> beanDefinition, @Nullable BeanResolutionContext currentContext) {
        if (currentContext == null) {
            return new SingletonBeanResolutionContext(beanDefinition);
        }
        return currentContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public BeanDefinitionValidator getBeanValidator() {
        if (this.beanValidator == null) {
            this.beanValidator = this.findBean(BeanDefinitionValidator.class).orElse(BeanDefinitionValidator.DEFAULT);
        }
        return this.beanValidator;
    }

    @Override
    public Optional<BeanConfiguration> findBeanConfiguration(String configurationName) {
        BeanConfiguration configuration = this.beanConfigurations.get(configurationName);
        if (configuration != null) {
            return Optional.of(configuration);
        }
        return Optional.empty();
    }

    @Override
    public <T> BeanDefinition<T> getBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findBeanDefinition(beanType, qualifier).orElseThrow(() -> new NoSuchBeanException(beanType, qualifier));
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        BeanDefinition<T> beanDefinition = this.singletonScope.findCachedSingletonBeanDefinition(beanType, qualifier);
        if (beanDefinition != null) {
            return Optional.of(beanDefinition);
        }
        return this.findConcreteCandidate(null, beanType, qualifier, true);
    }

    private <T> Optional<BeanDefinition<T>> findBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique) {
        return this.findConcreteCandidate(null, beanType, qualifier, throwNonUnique);
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType) {
        return this.getBeanDefinitions(Argument.of(beanType));
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Argument<T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(null, beanType);
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeanDefinitions(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Argument<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        Collection candidates = this.findBeanCandidatesInternal(null, beanType);
        if (qualifier != null) {
            candidates = qualifier.reduce(beanType.getType(), new ArrayList<BeanDefinition<T>>(candidates).stream()).collect(Collectors.toList());
        }
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> boolean containsBean(@NonNull Class<T> beanType, Qualifier<T> qualifier) {
        return this.containsBean(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> boolean containsBean(Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        if (this.containsBeanCache.containsKey(beanKey)) {
            return this.containsBeanCache.get(beanKey);
        }
        boolean result = this.singletonScope.containsBean(beanType, qualifier) || this.isCandidatePresent(beanKey.beanType, qualifier);
        this.containsBeanCache.put(beanKey, result);
        return result;
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBean(Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Class<T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBean(Argument.of(beanType), null);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        try {
            return this.getBean(null, beanType, qualifier);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getSimpleName(), (Object)e.getMessage());
            }
            throw new NoSuchBeanException(beanType, qualifier);
        }
    }

    @Override
    public <T> Optional<T> findBean(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Optional<T> findBean(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType) {
        return this.getBeansOfType(null, Argument.of(beanType));
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfType(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Argument<T> beanType) {
        return this.getBeansOfType(null, beanType);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfType(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    protected <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(resolutionContext, Argument.of(beanType), qualifier);
    }

    @Internal
    public <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeanRegistrations(resolutionContext, beanType, qualifier).stream().map(BeanRegistration::getBean);
    }

    @Override
    @NonNull
    public <T> T inject(@NonNull T instance) {
        Objects.requireNonNull(instance, "Instance cannot be null");
        Collection<BeanDefinition> candidates = this.findBeanCandidatesForInstance(instance);
        if (candidates.size() == 1) {
            BeanDefinition beanDefinition = candidates.iterator().next();
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                BeanKey beanKey = new BeanKey(beanDefinition.getBeanType(), null, new Class[0]);
                resolutionContext.addInFlightBean(beanKey, new BeanRegistration<T>(beanKey, beanDefinition, instance));
                this.doInject(resolutionContext, instance, beanDefinition);
            }
        } else if (!candidates.isEmpty()) {
            Iterator iterator = candidates.iterator();
            throw new NonUniqueBeanException(instance.getClass(), iterator);
        }
        return instance;
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.createBean(null, beanType, qualifier);
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Optional<BeanDefinition<T>> candidate = this.findBeanDefinition(Argument.of(beanType), qualifier);
        if (candidate.isPresent()) {
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(candidate.get(), null);){
                T t = this.doCreateBean(resolutionContext, candidate.get(), qualifier, argumentValues);
                return t;
            }
        }
        throw new NoSuchBeanException(beanType);
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, Object ... args) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Argument beanArg = Argument.of(beanType);
        Optional<BeanDefinition<T>> candidate = this.findBeanDefinition(beanArg, qualifier);
        if (candidate.isPresent()) {
            BeanDefinition<T> definition = candidate.get();
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(definition, null);){
                T t = this.doCreateBean(resolutionContext, definition, beanArg, qualifier, args);
                return t;
            }
        }
        throw new NoSuchBeanException(beanType);
    }

    @NonNull
    protected <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, Object ... args) {
        Map<String, Object> argumentValues = this.resolveArgumentValues(resolutionContext, definition, args);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed bean argument values: {}", argumentValues);
        }
        return this.doCreateBean(resolutionContext, definition, qualifier, argumentValues);
    }

    @NonNull
    private <T> Map<String, Object> resolveArgumentValues(BeanResolutionContext resolutionContext, BeanDefinition<T> definition, Object[] args) {
        if (!(definition instanceof ParametrizedBeanFactory)) {
            return Collections.emptyMap();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating bean for parameters: {}", (Object)ArrayUtils.toString((Object[])args));
        }
        Argument<?>[] requiredArguments = ((ParametrizedBeanFactory)((Object)definition)).getRequiredArguments();
        LinkedHashMap<String, Object> argumentValues = new LinkedHashMap<String, Object>(requiredArguments.length);
        BeanResolutionContext.Path currentPath = resolutionContext.getPath();
        for (int i = 0; i < requiredArguments.length; ++i) {
            Argument<?> requiredArgument = requiredArguments[i];
            try (BeanResolutionContext.Path ignored = currentPath.pushConstructorResolve(definition, requiredArgument);){
                Class argumentType = requiredArgument.getType();
                if (args.length > i) {
                    Object val = args[i];
                    if (val != null) {
                        if (argumentType.isInstance(val) && !CollectionUtils.isIterableOrMap((Class)argumentType)) {
                            argumentValues.put(requiredArgument.getName(), val);
                            continue;
                        }
                        argumentValues.put(requiredArgument.getName(), ConversionService.SHARED.convert(val, requiredArgument).orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. Cannot convert object [" + val + "] to required type: " + argumentType)));
                        continue;
                    }
                    if (requiredArgument.isDeclaredNullable()) continue;
                    throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. Argument cannot be null");
                }
                Optional<T> existingBean = this.findBean(resolutionContext, argumentType, null);
                if (existingBean.isPresent()) {
                    argumentValues.put(requiredArgument.getName(), existingBean.get());
                    continue;
                }
                if (requiredArgument.isDeclaredNullable()) continue;
                throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. No bean found for type: " + argumentType);
            }
        }
        return argumentValues;
    }

    @Override
    @Nullable
    public <T> T destroyBean(@NonNull Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.findBeanDefinition(beanType, qualifier).map(this::destroyBean).orElse(null);
    }

    @Override
    @NonNull
    public <T> T destroyBean(@NonNull T bean) {
        ArgumentUtils.requireNonNull((String)"bean", bean);
        Optional<BeanRegistration<T>> beanRegistration = this.findBeanRegistration(bean);
        if (beanRegistration.isPresent()) {
            this.destroyBean(beanRegistration.get());
        } else {
            Optional<BeanDefinition<?>> beanDefinition = this.findBeanDefinition(bean.getClass());
            if (beanDefinition.isPresent()) {
                BeanDefinition<?> definition = beanDefinition.get();
                BeanKey key = new BeanKey(definition, definition.getDeclaredQualifier());
                this.destroyBean(BeanRegistration.of(this, key, definition, bean));
            }
        }
        return bean;
    }

    @Override
    @Nullable
    public <T> T destroyBean(@NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.destroyBean(Argument.of(beanType), null);
    }

    @Nullable
    private <T> T destroyBean(@NonNull BeanDefinition<T> beanDefinition) {
        BeanRegistration<T> beanRegistration;
        if (beanDefinition.isSingleton() && (beanRegistration = this.singletonScope.findBeanRegistration(beanDefinition)) != null) {
            this.destroyBean(beanRegistration);
            return beanRegistration.bean;
        }
        throw new IllegalArgumentException("Cannot destroy non-singleton bean using bean definition! Use 'destroyBean(BeanRegistration)` or `destroyBean(<BeanInstance>)`.");
    }

    @Override
    public <T> void destroyBean(@NonNull BeanRegistration<T> registration) {
        this.destroyBean(registration, false);
    }

    private <T> void destroyBean(@NonNull BeanRegistration<T> registration, boolean dependent) {
        BeanDefinition<T> definition;
        T beanToDestroy;
        block18: {
            if (LOG_LIFECYCLE.isDebugEnabled()) {
                LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", registration.bean, (Object)registration.identifier);
            }
            if (registration.beanDefinition instanceof ProxyBeanDefinition) {
                if (registration.bean instanceof InterceptedBeanProxy) {
                    this.destroyProxyTargetBean(registration, dependent);
                    return;
                }
                if (dependent && registration.beanDefinition.isSingleton()) {
                    return;
                }
            }
            beanToDestroy = registration.getBean();
            definition = registration.getBeanDefinition();
            if (beanToDestroy != null) {
                this.purgeCacheForBeanInstance(beanToDestroy);
                if (definition.isSingleton()) {
                    this.singletonScope.purgeCacheForBeanInstance(definition, beanToDestroy);
                }
            }
            beanToDestroy = this.triggerPreDestroyListeners(definition, beanToDestroy);
            if (definition instanceof DisposableBeanDefinition) {
                try {
                    ((DisposableBeanDefinition)definition).dispose(this, beanToDestroy);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block18;
                    LOG.warn("Error disposing bean [" + beanToDestroy + "]... Continuing...", (Throwable)e);
                }
            }
        }
        if (beanToDestroy instanceof LifeCycle) {
            try {
                ((LifeCycle)beanToDestroy).stop();
            }
            catch (Exception e) {
                throw new BeanDestructionException(definition, (Throwable)e);
            }
        }
        if (registration instanceof BeanDisposingRegistration) {
            List<BeanRegistration<?>> dependents = ((BeanDisposingRegistration)registration).getDependents();
            if (CollectionUtils.isNotEmpty(dependents)) {
                ListIterator<BeanRegistration<?>> i = dependents.listIterator(dependents.size());
                while (i.hasPrevious()) {
                    this.destroyBean(i.previous(), true);
                }
            }
        } else {
            try {
                registration.close();
            }
            catch (Exception e) {
                throw new BeanDestructionException(definition, (Throwable)e);
            }
        }
        this.triggerBeanDestroyedListeners(definition, beanToDestroy);
    }

    @NonNull
    private <T> T triggerPreDestroyListeners(@NonNull BeanDefinition<T> beanDefinition, @NonNull T bean) {
        if (this.beanPreDestroyEventListeners == null) {
            this.beanPreDestroyEventListeners = this.loadListeners(BeanPreDestroyEventListener.class).entrySet();
        }
        if (!this.beanPreDestroyEventListeners.isEmpty()) {
            Class<T> beanType = this.getBeanType(beanDefinition);
            for (Map.Entry<Class<?>, List<BeanPreDestroyEventListener>> entry : this.beanPreDestroyEventListeners) {
                if (!entry.getKey().isAssignableFrom(beanType)) continue;
                BeanPreDestroyEvent<T> event = new BeanPreDestroyEvent<T>(this, beanDefinition, bean);
                for (BeanPreDestroyEventListener listener : entry.getValue()) {
                    try {
                        bean = Objects.requireNonNull(listener.onPreDestroy(event), "PreDestroy event listener illegally returned null: " + listener.getClass());
                    }
                    catch (Exception e) {
                        throw new BeanDestructionException(beanDefinition, (Throwable)e);
                    }
                }
            }
        }
        return bean;
    }

    private <T> void destroyProxyTargetBean(@NonNull BeanRegistration<T> registration, boolean dependent) {
        BeanDefinition proxyTargetBeanDefinition;
        Optional<CustomScope<?>> declaredScope;
        BeanDisposingRegistration disposingRegistration;
        Set<Object> destroyed = Collections.emptySet();
        if (registration instanceof BeanDisposingRegistration && (disposingRegistration = (BeanDisposingRegistration)registration).getDependents() != null) {
            destroyed = Collections.newSetFromMap(new IdentityHashMap());
            for (BeanRegistration<?> beanRegistration : disposingRegistration.getDependents()) {
                this.destroyBean(beanRegistration, true);
                destroyed.add(beanRegistration.bean);
            }
        }
        if (!(declaredScope = this.customScopeRegistry.findDeclaredScope(proxyTargetBeanDefinition = this.findProxyTargetBeanDefinition(registration.beanDefinition).orElseThrow(() -> new IllegalStateException("Cannot find a proxy target bean definition for: " + registration.beanDefinition)))).isPresent()) {
            InterceptedBeanProxy interceptedProxy;
            if (proxyTargetBeanDefinition.isSingleton()) {
                return;
            }
            if (registration.bean instanceof InterceptedBeanProxy && (interceptedProxy = (InterceptedBeanProxy)registration.bean).hasCachedInterceptedTarget()) {
                Object interceptedTarget = interceptedProxy.interceptedTarget();
                if (destroyed.contains(interceptedTarget)) {
                    return;
                }
                this.destroyBean(BeanRegistration.of(this, new BeanKey(proxyTargetBeanDefinition, proxyTargetBeanDefinition.getDeclaredQualifier()), proxyTargetBeanDefinition, interceptedTarget, registration instanceof BeanDisposingRegistration ? ((BeanDisposingRegistration)registration).getDependents() : null));
            }
            return;
        }
        CustomScope<?> customScope = declaredScope.get();
        if (dependent) {
            return;
        }
        Optional targetBeanRegistration = customScope.findBeanRegistration(proxyTargetBeanDefinition);
        if (targetBeanRegistration.isPresent()) {
            BeanRegistration targetRegistration = targetBeanRegistration.get();
            customScope.remove(targetRegistration.identifier);
        }
    }

    @NonNull
    private <T> void triggerBeanDestroyedListeners(@NonNull BeanDefinition<T> beanDefinition, @NonNull T bean) {
        if (this.beanDestroyedEventListeners == null) {
            this.beanDestroyedEventListeners = this.loadListeners(BeanDestroyedEventListener.class).entrySet();
        }
        if (!this.beanDestroyedEventListeners.isEmpty()) {
            Class<T> beanType = this.getBeanType(beanDefinition);
            for (Map.Entry<Class<?>, List<BeanDestroyedEventListener>> entry : this.beanDestroyedEventListeners) {
                if (!entry.getKey().isAssignableFrom(beanType)) continue;
                BeanDestroyedEvent<T> event = new BeanDestroyedEvent<T>(this, beanDefinition, bean);
                for (BeanDestroyedEventListener listener : entry.getValue()) {
                    try {
                        listener.onDestroyed(event);
                    }
                    catch (Exception e) {
                        throw new BeanDestructionException(beanDefinition, (Throwable)e);
                    }
                }
            }
        }
    }

    @NonNull
    private <T> Class<T> getBeanType(@NonNull BeanDefinition<T> beanDefinition) {
        if (beanDefinition instanceof ProxyBeanDefinition) {
            return ((ProxyBeanDefinition)beanDefinition).getTargetType();
        }
        return beanDefinition.getBeanType();
    }

    @Nullable
    protected <T> BeanRegistration<T> getActiveBeanRegistration(BeanDefinition<T> beanDefinition, Qualifier qualifier) {
        if (beanDefinition == null) {
            return null;
        }
        return this.singletonScope.findBeanRegistration(beanDefinition, qualifier);
    }

    @NonNull
    protected <T> T createBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Optional<BeanDefinition<T>> concreteCandidate = this.findBeanDefinition(beanType, qualifier);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<T> candidate = concreteCandidate.get();
            try (BeanResolutionContext context = this.newResolutionContext(candidate, resolutionContext);){
                T t = this.doCreateBean(context, candidate, qualifier);
                return t;
            }
        }
        throw new NoSuchBeanException(beanType);
    }

    @Internal
    @NonNull
    protected <T> T inject(@NonNull BeanResolutionContext resolutionContext, @Nullable BeanDefinition<?> requestingBeanDefinition, @NonNull T instance) {
        Class<?> beanType = instance.getClass();
        Optional<BeanDefinition<?>> concreteCandidate = this.findBeanDefinition(beanType, null);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<?> definition = concreteCandidate.get();
            if (requestingBeanDefinition != null && requestingBeanDefinition.equals(definition)) {
                return instance;
            }
            this.doInject(resolutionContext, instance, definition);
        }
        return instance;
    }

    @NonNull
    protected <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType) {
        return this.getBeansOfType(resolutionContext, beanType, null);
    }

    @Internal
    @NonNull
    public <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection<BeanRegistration<T>> beanRegistrations = this.getBeanRegistrations(resolutionContext, beanType, qualifier);
        ArrayList<T> list = new ArrayList<T>(beanRegistrations.size());
        for (BeanRegistration<T> beanRegistration : beanRegistrations) {
            list.add(beanRegistration.getBean());
        }
        return list;
    }

    @Override
    @NonNull
    public <T> T getProxyTargetBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getProxyTargetBean(Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> T getProxyTargetBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        Qualifier proxyQualifier = qualifier != null ? Qualifiers.byQualifiers(qualifier, PROXY_TARGET_QUALIFIER) : PROXY_TARGET_QUALIFIER;
        return this.resolveBeanRegistration(null, definition, beanType, proxyQualifier).bean;
    }

    @NonNull
    public <T> T getProxyTargetBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        Qualifier proxyQualifier = qualifier != null ? Qualifiers.byQualifiers(qualifier, PROXY_TARGET_QUALIFIER) : PROXY_TARGET_QUALIFIER;
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, definition, beanType, proxyQualifier).bean;
    }

    @Override
    @NonNull
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Class<T> beanType, @NonNull String method, @NonNull Class[] arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, null);
        return definition.findMethod(method, arguments);
    }

    @Override
    @NonNull
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Class<T> beanType, Qualifier<T> qualifier, @NonNull String method, Class ... arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Argument<T> beanType, Qualifier<T> qualifier, @NonNull String method, Class ... arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findProxyTargetBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Qualifier proxyQualifier = qualifier != null ? Qualifiers.byQualifiers(qualifier, PROXY_TARGET_QUALIFIER) : PROXY_TARGET_QUALIFIER;
        BeanCandidateKey<T> key = new BeanCandidateKey<T>(beanType, proxyQualifier, true);
        Optional<BeanDefinition<T>> beanDefinition = this.beanConcreteCandidateCache.get(key);
        if (beanDefinition == null) {
            BeanRegistration<T> beanRegistration = this.singletonScope.findCachedSingletonBeanRegistration(beanType, qualifier);
            if (beanRegistration != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved existing bean [{}] for type [{}] and qualifier [{}]", new Object[]{beanRegistration.bean, beanType, qualifier});
                }
                beanDefinition = Optional.of(beanRegistration.beanDefinition);
            } else {
                beanDefinition = this.findConcreteCandidateNoCache(null, beanType, proxyQualifier, true, false);
            }
            this.beanConcreteCandidateCache.put(key, beanDefinition);
        }
        return beanDefinition;
    }

    @Override
    @NonNull
    public Collection<BeanDefinition<?>> getBeanDefinitions(@Nullable Qualifier<Object> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for qualifier: {}", qualifier);
        }
        if (this.beanDefinitionsClasses.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<BeanDefinitionReference> reduced = qualifier.reduce(Object.class, this.beanDefinitionsClasses.stream());
        Stream<BeanDefinition> candidateStream = qualifier.reduce(Object.class, reduced.map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)));
        Collection candidates = candidateStream.collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)candidates)) {
            this.filterProxiedTypes(candidates, true, true, null);
            this.filterReplacedBeans(null, candidates);
        }
        return candidates;
    }

    @Override
    @NonNull
    public Collection<BeanDefinition<?>> getAllBeanDefinitions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding all bean definitions");
        }
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List<BeanDefinition<?>> collection = this.beanDefinitionsClasses.stream().map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)).collect(Collectors.toList());
            return collection;
        }
        return (Collection)((Object)Collections.emptyMap());
    }

    @Override
    @NonNull
    public Collection<BeanDefinitionReference<?>> getBeanDefinitionReferences() {
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List refs = this.beanDefinitionsClasses.stream().filter(ref -> ref.isEnabled(this)).collect(Collectors.toList());
            return Collections.unmodifiableList(refs);
        }
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public <B> BeanContext registerBeanDefinition(@NonNull RuntimeBeanDefinition<B> definition) {
        Objects.requireNonNull(definition, "Bean definition cannot be null");
        this.beanDefinitionsClasses.add(definition);
        this.beanCandidateCache.entrySet().removeIf(entry -> ((Argument)entry.getKey()).isAssignableFrom(definition.getBeanType()));
        this.beanConcreteCandidateCache.entrySet().removeIf(entry -> ((BeanCandidateKey)entry.getKey()).beanType.isAssignableFrom(definition.getBeanType()));
        this.singletonBeanRegistrations.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isAssignableFrom(definition.getBeanType()));
        this.containsBeanCache.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isAssignableFrom(definition.getBeanType()));
        return this;
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getBean(resolutionContext, Argument.of(beanType), null);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull BeanDefinition<T> definition) {
        ArgumentUtils.requireNonNull((String)"definition", definition);
        return this.resolveBeanRegistration(null, definition).bean;
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.getBean(resolutionContext, Argument.of(beanType), qualifier);
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, beanType, qualifier, (boolean)true).bean;
    }

    @Internal
    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanDefinition", beanDefinition);
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, beanDefinition, beanType, qualifier).bean;
    }

    @NonNull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findBean(resolutionContext, Argument.of(beanType), qualifier);
    }

    @Internal
    @NonNull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        if (this.thisInterfaces.contains(beanType.getType())) {
            return Optional.of(this);
        }
        try {
            BeanRegistration<T> beanRegistration = this.resolveBeanRegistration(resolutionContext, beanType, qualifier, false);
            if (beanRegistration == null || beanRegistration.bean == null) {
                return Optional.empty();
            }
            return Optional.of(beanRegistration.bean);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getSimpleName(), (Object)e.getMessage());
            }
            return Optional.empty();
        }
    }

    @Override
    public BeanContextConfiguration getContextConfiguration() {
        return this.beanContextConfiguration;
    }

    @Override
    public void publishEvent(@NonNull Object event) {
        if (event != null) {
            ((ApplicationEventPublisher)this.getBean(Argument.of(ApplicationEventPublisher.class, (Class[])new Class[]{event.getClass()}))).publishEvent(event);
        }
    }

    @Override
    @NonNull
    public Future<Void> publishEventAsync(@NonNull Object event) {
        Objects.requireNonNull(event, "Event cannot be null");
        return ((ApplicationEventPublisher)this.getBean(Argument.of(ApplicationEventPublisher.class, (Class[])new Class[]{event.getClass()}))).publishEventAsync(event);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.findProxyBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        for (BeanDefinition<T> beanDefinition : this.getBeanDefinitions(beanType, qualifier)) {
            if (!beanDefinition.isProxy()) continue;
            return Optional.of(beanDefinition);
        }
        return Optional.empty();
    }

    @Internal
    protected void invalidateCaches() {
        this.beanCandidateCache.clear();
        this.beanConcreteCandidateCache.clear();
        this.singletonBeanRegistrations.clear();
    }

    @NonNull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
        if (this.beanDefinitionReferences == null) {
            SoftServiceLoader definitions = SoftServiceLoader.load(BeanDefinitionReference.class, (ClassLoader)this.classLoader);
            this.beanDefinitionReferences = new ArrayList<BeanDefinitionReference>(300);
            definitions.collectAll(this.beanDefinitionReferences, BeanDefinitionReference::isPresent);
        }
        return this.beanDefinitionReferences;
    }

    @NonNull
    @Deprecated
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences(@Nullable Predicate<BeanDefinitionReference> predicate) {
        if (predicate != null) {
            List<BeanDefinitionReference> allRefs = this.resolveBeanDefinitionReferences();
            ArrayList<BeanDefinitionReference> newRefs = new ArrayList<BeanDefinitionReference>(allRefs.size());
            for (BeanDefinitionReference reference : allRefs) {
                if (!predicate.test(reference)) continue;
                newRefs.add(reference);
            }
            return newRefs;
        }
        return this.resolveBeanDefinitionReferences();
    }

    @NonNull
    protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
        if (this.beanConfigurationsList == null) {
            SoftServiceLoader definitions = SoftServiceLoader.load(BeanConfiguration.class, (ClassLoader)this.classLoader);
            this.beanConfigurationsList = new ArrayList<BeanConfiguration>(300);
            definitions.collectAll(this.beanConfigurationsList, null);
        }
        return this.beanConfigurationsList;
    }

    protected void initializeEventListeners() {
        Map<Class<?>, List<BeanCreatedEventListener<?>>> beanCreatedListeners = this.loadCreatedListeners();
        beanCreatedListeners.put(AnnotationProcessor.class, Collections.singletonList(new AnnotationProcessorListener()));
        Map<Class<?>, List<BeanInitializedEventListener>> beanInitializedListeners = this.loadListeners(BeanInitializedEventListener.class);
        this.beanCreationEventListeners = beanCreatedListeners.entrySet();
        this.beanInitializedEventListeners = beanInitializedListeners.entrySet();
    }

    private void handleEagerInitializedDependencies(BeanDefinition<?> listener, Argument<?> listensTo, List<List<Argument<?>>> targets) {
        if (LOG.isWarnEnabled()) {
            ArrayList<String> paths = new ArrayList<String>(targets.size());
            for (List<Argument<?>> line : targets) {
                paths.add("    " + line.stream().map(TypeInformation::getType).map(Class::getName).collect(Collectors.joining(" --> ")));
            }
            LOG.warn("The bean created event listener {} will not be executed because one or more other bean created event listeners inject {}:\n{}\nChange at least one point in the path to be lazy initialized by injecting a provider to avoid this issue", new Object[]{listener.getBeanType().getName(), listensTo.getType().getName(), String.join((CharSequence)"\n", paths)});
        }
    }

    @NonNull
    private Map<Class<?>, List<BeanCreatedEventListener<?>>> loadCreatedListeners() {
        Collection<BeanDefinition<BeanCreatedEventListener>> beanDefinitions = this.getBeanDefinitions(BeanCreatedEventListener.class);
        HashMap typeToListener = new HashMap(beanDefinitions.size(), 1.0f);
        if (beanDefinitions.isEmpty()) {
            return typeToListener;
        }
        HashMap<BeanDefinition, List> invalidListeners = new HashMap<BeanDefinition, List>();
        HashMap<BeanDefinition<BeanCreatedEventListener>, Argument> beanCreationTargets = new HashMap<BeanDefinition<BeanCreatedEventListener>, Argument>();
        for (BeanDefinition<BeanCreatedEventListener> beanDefinition : beanDefinitions) {
            List<Argument<BeanCreatedEventListener>> typeArguments = beanDefinition.getTypeArguments(BeanCreatedEventListener.class);
            Argument argument = (Argument)CollectionUtils.last(typeArguments);
            if (argument == null) {
                argument = Argument.OBJECT_ARGUMENT;
            }
            beanCreationTargets.put(beanDefinition, argument);
        }
        for (BeanDefinition<BeanCreatedEventListener> beanDefinition : beanDefinitions) {
            try (ScanningBeanResolutionContext context = new ScanningBeanResolutionContext(beanDefinition, beanCreationTargets);){
                BeanCreatedEventListener listener = (BeanCreatedEventListener)this.resolveBeanRegistration((BeanResolutionContext)context, beanDefinition).bean;
                List<Argument<BeanCreatedEventListener>> typeArguments = beanDefinition.getTypeArguments(BeanCreatedEventListener.class);
                Argument argument = (Argument)CollectionUtils.last(typeArguments);
                if (argument == null) {
                    argument = Argument.OBJECT_ARGUMENT;
                }
                typeToListener.computeIfAbsent(argument.getType(), aClass -> new ArrayList(10)).add(listener);
                Map<BeanDefinition<?>, List<List<Argument<?>>>> foundTargets = context.getFoundTargets();
                for (Map.Entry<BeanDefinition<?>, List<List<Argument<?>>>> entry : foundTargets.entrySet()) {
                    invalidListeners.computeIfAbsent(entry.getKey(), key -> new ArrayList()).addAll((Collection)entry.getValue());
                }
            }
        }
        for (List list : typeToListener.values()) {
            OrderUtil.sort((List)list);
        }
        for (Map.Entry entry : invalidListeners.entrySet()) {
            this.handleEagerInitializedDependencies((BeanDefinition)entry.getKey(), (Argument)beanCreationTargets.get(entry.getKey()), (List)entry.getValue());
        }
        return typeToListener;
    }

    @NonNull
    private <T extends EventListener> Map<Class<?>, List<T>> loadListeners(@NonNull Class<T> listenerType) {
        Collection<BeanDefinition<T>> beanDefinitions = this.getBeanDefinitions(listenerType);
        HashMap typeToListener = new HashMap(beanDefinitions.size(), 1.0f);
        for (BeanDefinition<T> beanCreatedDefinition : beanDefinitions) {
            BeanResolutionContext context = this.newResolutionContext(beanCreatedDefinition, null);
            try {
                EventListener listener = (EventListener)this.resolveBeanRegistration((BeanResolutionContext)context, beanCreatedDefinition).bean;
                List<Argument<T>> typeArguments = beanCreatedDefinition.getTypeArguments(listenerType);
                Argument argument = (Argument)CollectionUtils.last(typeArguments);
                if (argument == null) {
                    argument = Argument.OBJECT_ARGUMENT;
                }
                typeToListener.computeIfAbsent(argument.getType(), aClass -> new ArrayList(10)).add(listener);
            }
            finally {
                if (context == null) continue;
                context.close();
            }
        }
        for (List listenerList : typeToListener.values()) {
            OrderUtil.sort((List)listenerList);
        }
        return typeToListener;
    }

    protected void initializeContext(@NonNull List<BeanDefinitionReference> contextScopeBeans, @NonNull List<BeanDefinitionReference> processedBeans, @NonNull List<BeanDefinitionReference> parallelBeans) {
        if (CollectionUtils.isNotEmpty(contextScopeBeans)) {
            ArrayList contextBeans = new ArrayList(contextScopeBeans.size());
            for (BeanDefinitionReference beanDefinitionReference : contextScopeBeans) {
                try {
                    this.loadContextScopeBean(beanDefinitionReference, contextBeans::add);
                }
                catch (Throwable e) {
                    throw new BeanInstantiationException("Bean definition [" + beanDefinitionReference.getName() + "] could not be loaded: " + e.getMessage(), e);
                }
            }
            this.filterProxiedTypes(contextBeans, true, false, null);
            this.filterReplacedBeans(null, contextBeans);
            OrderUtil.sort(contextBeans);
            for (BeanDefinition beanDefinition2 : contextBeans) {
                try {
                    this.loadContextScopeBean(beanDefinition2);
                }
                catch (DisabledBeanException e) {
                    if (!AbstractBeanContextConditional.LOG.isDebugEnabled()) continue;
                    AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanDefinition2.getBeanType().getSimpleName(), (Object)e.getMessage());
                }
                catch (Throwable e) {
                    throw new BeanInstantiationException("Bean definition [" + beanDefinition2.getName() + "] could not be loaded: " + e.getMessage(), e);
                }
            }
        }
        if (!processedBeans.isEmpty()) {
            Stream methodStream = processedBeans.stream().filter(ref -> ref.isEnabled(this)).map(reference -> {
                try {
                    return reference.load(this);
                }
                catch (Exception e) {
                    throw new BeanInstantiationException("Bean definition [" + reference.getName() + "] could not be loaded: " + e.getMessage(), (Throwable)e);
                }
            }).filter(bean -> bean.isEnabled(this)).flatMap(beanDefinition -> beanDefinition.getExecutableMethods().parallelStream().filter(method -> method.hasStereotype(Executable.class)).map(executableMethod -> BeanDefinitionMethodReference.of(beanDefinition, executableMethod)));
            HashMap<Class, List> byAnnotation = new HashMap<Class, List>(processedBeans.size());
            methodStream.forEach(reference -> {
                List annotations = reference.getAnnotationTypesByStereotype(Executable.class);
                annotations.forEach(annotation -> byAnnotation.compute((Class)annotation, (ann, list) -> {
                    if (list == null) {
                        list = new ArrayList<BeanDefinitionMethodReference>(10);
                    }
                    list.add(reference);
                    return list;
                }));
            });
            byAnnotation.forEach((annotationType, methods) -> this.streamOfType(ExecutableMethodProcessor.class, Qualifiers.byTypeArguments(annotationType)).forEach(processor -> {
                if (processor instanceof LifeCycle) {
                    ((LifeCycle)((Object)processor)).start();
                }
                for (BeanDefinitionMethodReference method : methods) {
                    BeanDefinition beanDefinition = method.getBeanDefinition();
                    if (beanDefinition.hasStereotype((Class)annotationType)) continue;
                    if (method.hasDeclaredStereotype(Parallel.class)) {
                        ForkJoinPool.commonPool().execute(() -> {
                            block3: {
                                try {
                                    processor.process((BeanDefinition<?>)beanDefinition, method);
                                }
                                catch (Throwable e) {
                                    Boolean shutdownOnError;
                                    if (LOG.isErrorEnabled()) {
                                        LOG.error("Error processing bean method " + beanDefinition + "." + method + " with processor (" + processor + "): " + e.getMessage(), e);
                                    }
                                    if (!(shutdownOnError = method.booleanValue(Parallel.class, "shutdownOnError").orElse(true)).booleanValue()) break block3;
                                    this.stop();
                                }
                            }
                        });
                        continue;
                    }
                    processor.process((BeanDefinition<?>)beanDefinition, method);
                }
                if (processor instanceof LifeCycle) {
                    ((LifeCycle)((Object)processor)).stop();
                }
            }));
        }
        if (CollectionUtils.isNotEmpty(parallelBeans)) {
            this.processParallelBeans(parallelBeans);
        }
        Runnable runnable = () -> this.beanDefinitionsClasses.removeIf(beanDefinitionReference -> !beanDefinitionReference.isEnabled(this));
        ForkJoinPool.commonPool().execute(runnable);
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@NonNull Class<T> beanType, @Nullable BeanDefinition<?> filter) {
        return this.findBeanCandidates(null, Argument.of(beanType), filter, true);
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable BeanDefinition<?> filter, boolean filterProxied) {
        Predicate<BeanDefinition<BeanDefinition<BeanDefinition<BeanDefinition<T>>>>> predicate = filter == null ? null : definition -> !definition.equals(filter);
        return this.findBeanCandidates(resolutionContext, beanType, filterProxied, predicate);
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, boolean filterProxied, Predicate<BeanDefinition<T>> predicate) {
        Set<BeanDefinition<T>> candidates;
        Collection<BeanDefinitionReference> beanDefinitionsClasses;
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Class beanClass = beanType.getType();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for type: {}", beanType);
        }
        if (this.indexedTypes.contains(beanClass)) {
            beanDefinitionsClasses = this.beanIndex.get(beanClass);
            if (beanDefinitionsClasses == null) {
                beanDefinitionsClasses = Collections.emptyList();
            }
        } else {
            beanDefinitionsClasses = this.beanDefinitionsClasses;
        }
        if (!beanDefinitionsClasses.isEmpty()) {
            candidates = new HashSet();
            for (BeanDefinitionReference beanDefinitionReference : beanDefinitionsClasses) {
                BeanDefinition loadedBean;
                if (!beanDefinitionReference.isCandidateBean(beanType) || !beanDefinitionReference.isEnabled(this, resolutionContext)) continue;
                try {
                    loadedBean = beanDefinitionReference.load(this);
                }
                catch (Throwable e) {
                    throw new BeanContextException("Error loading bean [" + beanDefinitionReference.getName() + "]: " + e.getMessage(), e);
                }
                if (!loadedBean.isCandidateBean(beanType) || predicate != null && !predicate.test(loadedBean) || !loadedBean.isEnabled(this, resolutionContext)) continue;
                candidates.add(loadedBean);
            }
            if (!candidates.isEmpty()) {
                if (filterProxied) {
                    this.filterProxiedTypes(candidates, true, false, null);
                }
                this.filterReplacedBeans(resolutionContext, candidates);
            }
        } else {
            candidates = Collections.emptySet();
        }
        if (LOG.isDebugEnabled()) {
            if (candidates.isEmpty()) {
                LOG.debug("No bean candidates found for type: {}", beanType);
            } else {
                for (BeanDefinition beanDefinition : candidates) {
                    LOG.debug("  {} {} {}", new Object[]{beanDefinition.getBeanType(), beanDefinition.getDeclaredQualifier(), beanDefinition});
                }
            }
        }
        return candidates;
    }

    protected <T> Collection<BeanDefinition<T>> transformIterables(BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> candidates, boolean filterProxied) {
        return candidates;
    }

    @NonNull
    protected <T> Collection<BeanDefinition> findBeanCandidatesForInstance(@NonNull T instance) {
        ArgumentUtils.requireNonNull((String)"instance", instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for instance: {}", instance);
        }
        Collection<BeanDefinitionReference> beanDefinitionsClasses = this.beanDefinitionsClasses;
        Class<?> beanClass = instance.getClass();
        Argument beanType = Argument.of(beanClass);
        Collection<BeanDefinition> beanDefinitions = this.beanCandidateCache.get(beanType);
        if (beanDefinitions == null) {
            if (!beanDefinitionsClasses.isEmpty()) {
                List candidates = new ArrayList<BeanDefinition>();
                for (BeanDefinitionReference reference : beanDefinitionsClasses) {
                    BeanDefinition candidate2;
                    Class candidateType;
                    if (!reference.isEnabled(this) || (candidateType = reference.getBeanType()) == null || !candidateType.isInstance(instance) || !(candidate2 = reference.load(this)).isEnabled(this)) continue;
                    candidates.add(candidate2);
                }
                if (candidates.size() > 1) {
                    candidates = candidates.stream().filter(candidate -> !(candidate instanceof NoInjectionBeanDefinition) && candidate.getBeanType() == beanClass).collect(Collectors.toList());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved bean candidates {} for instance: {}", candidates, instance);
                }
                beanDefinitions = candidates;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No bean candidates found for instance: {}", instance);
                }
                beanDefinitions = Collections.emptySet();
            }
            this.beanCandidateCache.put(beanType, beanDefinitions);
        }
        return beanDefinitions;
    }

    protected synchronized void registerConfiguration(@NonNull BeanConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.beanConfigurations.put(configuration.getName(), configuration);
    }

    @Internal
    @NonNull
    private <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        return this.doCreateBean(resolutionContext, beanDefinition, qualifier, Argument.of(beanDefinition.getBeanType()), false, argumentValues);
    }

    @Internal
    @NonNull
    final <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier) {
        return this.doCreateBean(resolutionContext, beanDefinition, qualifier, Argument.of(beanDefinition.getBeanType()), false, null);
    }

    @Internal
    @NonNull
    @Deprecated
    protected <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, boolean isSingleton, @Nullable Map<String, Object> argumentValues) {
        return this.doCreateBean(resolutionContext, beanDefinition, qualifier, Argument.of(beanDefinition.getBeanType()), isSingleton, argumentValues);
    }

    @Internal
    @NonNull
    @Deprecated
    protected <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @Nullable Argument<T> qualifierBeanType, boolean isSingleton, @Nullable Map<String, Object> argumentValues) {
        T bean = beanDefinition instanceof BeanFactory ? this.resolveByBeanFactory(resolutionContext, beanDefinition, qualifier, argumentValues) : this.resolveByBeanDefinition(resolutionContext, beanDefinition);
        return this.postBeanCreated(resolutionContext, beanDefinition, qualifier, bean);
    }

    @NonNull
    private <T> T resolveByBeanDefinition(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition) {
        T bean;
        ConstructorInjectionPoint<T> constructor = beanDefinition.getConstructor();
        Argument<?>[] requiredConstructorArguments = constructor.getArguments();
        if (requiredConstructorArguments.length == 0) {
            bean = constructor.invoke(new Object[0]);
        } else {
            Object[] constructorArgs = new Object[requiredConstructorArguments.length];
            for (int i = 0; i < requiredConstructorArguments.length; ++i) {
                Class argument = requiredConstructorArguments[i].getType();
                constructorArgs[i] = this.getBean(resolutionContext, argument);
            }
            bean = constructor.invoke(constructorArgs);
        }
        this.inject(resolutionContext, null, bean);
        return bean;
    }

    @NonNull
    private <T> T resolveByBeanFactory(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        BeanFactory beanFactory = (BeanFactory)((Object)beanDefinition);
        Qualifier<T> declaredQualifier = beanDefinition.getDeclaredQualifier();
        boolean propagateQualifier = beanDefinition.isProxy() && declaredQualifier instanceof Named;
        Qualifier<?> prevQualifier = resolutionContext.getCurrentQualifier();
        try {
            T bean;
            if (propagateQualifier) {
                resolutionContext.setAttribute(BeanDefinition.NAMED_ATTRIBUTE, ((Named)declaredQualifier).getName());
            }
            resolutionContext.setCurrentQualifier(declaredQualifier != null && !AnyQualifier.INSTANCE.equals(declaredQualifier) ? declaredQualifier : qualifier);
            if (beanFactory instanceof ParametrizedBeanFactory) {
                ParametrizedBeanFactory parametrizedBeanFactory = (ParametrizedBeanFactory)((Object)beanDefinition);
                Map<String, Object> convertedValues = this.getRequiredArgumentValues(resolutionContext, parametrizedBeanFactory.getRequiredArguments(), argumentValues, beanDefinition);
                bean = parametrizedBeanFactory.build(resolutionContext, this, beanDefinition, convertedValues);
            } else {
                bean = beanFactory.build(resolutionContext, this, beanDefinition);
            }
            if (bean == null) {
                throw new BeanInstantiationException(resolutionContext, "Bean Factory [" + beanFactory + "] returned null");
            }
            if (bean instanceof Qualified) {
                ((Qualified)bean).$withBeanQualifier(declaredQualifier);
            }
            T t = bean;
            return t;
        }
        catch (BeanInstantiationException | DependencyInjectionException | DisabledBeanException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!resolutionContext.getPath().isEmpty()) {
                throw new BeanInstantiationException(resolutionContext, e);
            }
            throw new BeanInstantiationException(beanDefinition, e);
        }
        finally {
            resolutionContext.setCurrentQualifier(prevQualifier);
            if (propagateQualifier) {
                resolutionContext.removeAttribute(BeanDefinition.NAMED_ATTRIBUTE);
            }
        }
    }

    @NonNull
    private <T> T postBeanCreated(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @NonNull T bean) {
        Qualifier<T> finalQualifier = qualifier != null ? qualifier : beanDefinition.getDeclaredQualifier();
        bean = this.triggerBeanCreatedEventListener(resolutionContext, beanDefinition, bean, finalQualifier);
        if (beanDefinition instanceof ValidatedBeanDefinition) {
            bean = ((ValidatedBeanDefinition)beanDefinition).validate(resolutionContext, bean);
        }
        if (LOG_LIFECYCLE.isDebugEnabled()) {
            LOG_LIFECYCLE.debug("Created bean [{}] from definition [{}] with qualifier [{}]", new Object[]{bean, beanDefinition, finalQualifier});
        }
        return bean;
    }

    @NonNull
    private <T> T triggerBeanCreatedEventListener(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @NonNull T bean, @Nullable Qualifier<T> finalQualifier) {
        Class<T> beanType = beanDefinition.getBeanType();
        if (!(bean instanceof BeanCreatedEventListener) && CollectionUtils.isNotEmpty(this.beanCreationEventListeners)) {
            for (Map.Entry<Class<?>, List<BeanCreatedEventListener<?>>> entry : this.beanCreationEventListeners) {
                if (!entry.getKey().isAssignableFrom(beanType)) continue;
                BeanKey<T> beanKey = new BeanKey<T>(beanDefinition, finalQualifier);
                for (BeanCreatedEventListener<?> listener : entry.getValue()) {
                    bean = listener.onCreated(new BeanCreatedEvent<T>(this, beanDefinition, beanKey, bean));
                    if (bean != null) continue;
                    throw new BeanInstantiationException(resolutionContext, "Listener [" + listener + "] returned null from onCreated event");
                }
            }
        }
        return bean;
    }

    @NonNull
    private <T> Map<String, Object> getRequiredArgumentValues(@NonNull BeanResolutionContext resolutionContext, @NonNull Argument<?>[] requiredArguments, @Nullable Map<String, Object> argumentValues, @NonNull BeanDefinition<T> beanDefinition) {
        LinkedHashMap<String, Object> convertedValues;
        if (argumentValues == null) {
            convertedValues = requiredArguments.length == 0 ? null : new LinkedHashMap<String, Object>();
            argumentValues = Collections.emptyMap();
        } else {
            convertedValues = new LinkedHashMap<String, Object>();
        }
        if (convertedValues != null) {
            for (Argument<?> requiredArgument : requiredArguments) {
                String argumentName = requiredArgument.getName();
                Object val = argumentValues.get(argumentName);
                if (val == null) {
                    if (requiredArgument.isDeclaredNullable()) continue;
                    throw new BeanInstantiationException(resolutionContext, "Missing bean argument [" + requiredArgument + "] for type: " + beanDefinition.getBeanType().getName() + ". Required arguments: " + ArrayUtils.toString((Object[])requiredArguments));
                }
                Object convertedValue = requiredArgument.getType().isInstance(val) ? val : ConversionService.SHARED.convert(val, requiredArgument).orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid bean argument [" + requiredArgument + "]. Cannot convert object [" + val + "] to required type: " + requiredArgument.getType()));
                convertedValues.put(argumentName, convertedValue);
            }
            return convertedValues;
        }
        return Collections.emptyMap();
    }

    @NonNull
    protected <T> BeanDefinition<T> findConcreteCandidate(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull Collection<BeanDefinition<T>> candidates) {
        if (qualifier instanceof AnyQualifier) {
            return candidates.iterator().next();
        }
        throw new NonUniqueBeanException(beanType, candidates.iterator());
    }

    protected void processParallelBeans(List<BeanDefinitionReference> parallelBeans) {
        List finalParallelBeans;
        if (!parallelBeans.isEmpty() && !(finalParallelBeans = parallelBeans.stream().filter(bdr -> bdr.isEnabled(this)).collect(Collectors.toList())).isEmpty()) {
            new Thread(() -> {
                ArrayList<BeanDefinition<BeanDefinition>> parallelDefinitions = new ArrayList<BeanDefinition<BeanDefinition>>();
                finalParallelBeans.forEach(beanDefinitionReference -> {
                    block2: {
                        try {
                            this.loadContextScopeBean((BeanDefinitionReference)beanDefinitionReference, parallelDefinitions::add);
                        }
                        catch (Throwable e) {
                            LOG.error("Parallel Bean definition [" + beanDefinitionReference.getName() + "] could not be loaded: " + e.getMessage(), e);
                            Boolean shutdownOnError = beanDefinitionReference.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                            if (!shutdownOnError.booleanValue()) break block2;
                            this.stop();
                        }
                    }
                });
                this.filterProxiedTypes(parallelDefinitions, true, false, null);
                this.filterReplacedBeans(null, parallelDefinitions);
                parallelDefinitions.forEach(beanDefinition -> ForkJoinPool.commonPool().execute(() -> {
                    block2: {
                        try {
                            this.loadContextScopeBean((BeanDefinition)beanDefinition);
                        }
                        catch (Throwable e) {
                            LOG.error("Parallel Bean definition [" + beanDefinition.getName() + "] could not be loaded: " + e.getMessage(), e);
                            Boolean shutdownOnError = beanDefinition.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                            if (!shutdownOnError.booleanValue()) break block2;
                            this.stop();
                        }
                    }
                }));
                parallelDefinitions.clear();
            }).start();
        }
    }

    private <T> void filterReplacedBeans(BeanResolutionContext resolutionContext, Collection<? extends BeanType<T>> candidates) {
        if (candidates.size() > 1) {
            ArrayList replacementTypes = new ArrayList(2);
            for (BeanType<T> candidate : candidates) {
                if (!candidate.getAnnotationMetadata().hasStereotype(REPLACES_ANN)) continue;
                replacementTypes.add(candidate);
            }
            if (!replacementTypes.isEmpty()) {
                candidates.removeIf(definition -> this.checkIfReplacementExists(resolutionContext, replacementTypes, (BeanType)definition));
            }
        }
    }

    private <T> boolean checkIfReplacementExists(BeanResolutionContext resolutionContext, List<BeanType<T>> replacementTypes, BeanType<T> definitionToBeReplaced) {
        if (!definitionToBeReplaced.isEnabled(this, resolutionContext)) {
            return true;
        }
        AnnotationMetadata annotationMetadata = definitionToBeReplaced.getAnnotationMetadata();
        if (annotationMetadata.hasDeclaredStereotype(Infrastructure.class)) {
            return false;
        }
        for (BeanType<T> replacementType : replacementTypes) {
            if (!this.isNotTheSameDefinition(replacementType, definitionToBeReplaced) || !this.isNotProxy(replacementType, definitionToBeReplaced) || !this.checkIfReplaces(replacementType, definitionToBeReplaced, annotationMetadata)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean isNotTheSameDefinition(BeanType<T> replacingCandidate, BeanType<T> definitionToBeReplaced) {
        return replacingCandidate != definitionToBeReplaced;
    }

    private <T> boolean isNotProxy(BeanType<T> replacingCandidate, BeanType<T> definitionToBeReplaced) {
        return !(replacingCandidate instanceof ProxyBeanDefinition) || ((ProxyBeanDefinition)replacingCandidate).getTargetDefinitionType() != definitionToBeReplaced.getClass();
    }

    private <T> boolean checkIfReplaces(BeanType<T> replacingCandidate, BeanType<T> definitionToBeReplaced, AnnotationMetadata annotationMetadata) {
        Optional declaringType;
        AnnotationValue replacesAnnotation = replacingCandidate.getAnnotation(Replaces.class);
        Class<T> replacedBeanType = replacesAnnotation.classValue().orElse(this.getCanonicalBeanType(replacingCandidate));
        Optional named = replacesAnnotation.stringValue(NAMED_MEMBER);
        Optional qualifier = replacesAnnotation.annotationClassValue(QUALIFIER_MEMBER);
        if (named.isPresent() && qualifier.isPresent()) {
            throw new ConfigurationException("Both \"named\" and \"qualifier\" should not be present: " + replacesAnnotation);
        }
        if (named.isPresent()) {
            String name = (String)named.get();
            if (this.qualifiedByNamed(definitionToBeReplaced, replacedBeanType, name)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean [{}] replaces existing bean of type [{}] qualified by name [{}]", new Object[]{replacingCandidate.getBeanType(), definitionToBeReplaced.getBeanType(), name});
                }
                return true;
            }
            return false;
        }
        if (qualifier.isPresent()) {
            AnnotationClassValue qualifierClassValue = (AnnotationClassValue)qualifier.get();
            if (this.qualifiedByQualifier(definitionToBeReplaced, replacedBeanType, qualifierClassValue)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean [{}] replaces existing bean of type [{}] qualified by qualifier [{}]", new Object[]{replacingCandidate.getBeanType(), definitionToBeReplaced.getBeanType(), qualifierClassValue});
                }
                return true;
            }
            return false;
        }
        Optional factory = replacesAnnotation.classValue("factory");
        Optional<Object> optional = declaringType = definitionToBeReplaced instanceof BeanDefinition ? ((BeanDefinition)definitionToBeReplaced).getDeclaringType() : Optional.empty();
        if (factory.isPresent() && declaringType.isPresent()) {
            boolean factoryReplaces;
            boolean bl = factoryReplaces = factory.get() == declaringType.get() && this.checkIfTypeMatches(definitionToBeReplaced, annotationMetadata, replacedBeanType);
            if (factoryReplaces) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean [{}] replaces existing bean of type [{}] in factory type [{}]", new Object[]{replacingCandidate.getBeanType(), replacedBeanType, factory.get()});
                }
                return true;
            }
            return false;
        }
        boolean isTypeMatches = this.checkIfTypeMatches(definitionToBeReplaced, annotationMetadata, replacedBeanType);
        if (isTypeMatches && LOG.isDebugEnabled()) {
            LOG.debug("Bean [{}] replaces existing bean of type [{}]", replacingCandidate.getBeanType(), replacedBeanType);
        }
        return isTypeMatches;
    }

    private <T> boolean qualifiedByQualifier(BeanType<T> definitionToBeReplaced, Class<T> replacedBeanType, AnnotationClassValue<?> qualifier) {
        Class qualifierClass = qualifier.getType().orElse(null);
        if (qualifierClass != null && !qualifierClass.isAssignableFrom(Annotation.class)) {
            return Qualifiers.byStereotype(qualifierClass).qualify(replacedBeanType, Stream.of(definitionToBeReplaced)).isPresent();
        }
        throw new ConfigurationException(String.format("Default qualifier value was used while replacing %s", replacedBeanType));
    }

    private <T> boolean qualifiedByNamed(BeanType<T> definitionToBeReplaced, Class replacedBeanType, String named) {
        return Qualifiers.byName(named).qualify(replacedBeanType, Stream.of(definitionToBeReplaced)).isPresent();
    }

    private <T> Class<T> getCanonicalBeanType(BeanType<T> beanType) {
        if (beanType instanceof AdvisedBeanType) {
            return ((AdvisedBeanType)beanType).getInterceptedType();
        }
        if (beanType instanceof ProxyBeanDefinition) {
            return ((ProxyBeanDefinition)beanType).getTargetType();
        }
        AnnotationMetadata annotationMetadata = beanType.getAnnotationMetadata();
        Class<T> bt = beanType.getBeanType();
        if (annotationMetadata.hasStereotype(INTRODUCTION_TYPE)) {
            Class<T> superclass = bt.getSuperclass();
            if (superclass == Object.class || superclass == null) {
                return bt;
            }
            return superclass;
        }
        if (annotationMetadata.hasStereotype("io.micronaut.aop.Around")) {
            Class<T> superclass = bt.getSuperclass();
            if (superclass != null) {
                return superclass;
            }
            return bt;
        }
        return bt;
    }

    private <T> boolean checkIfTypeMatches(BeanType<T> definitionToBeReplaced, AnnotationMetadata annotationMetadata, Class replacingCandidate) {
        Class bt;
        if (definitionToBeReplaced instanceof ProxyBeanDefinition) {
            bt = ((ProxyBeanDefinition)definitionToBeReplaced).getTargetType();
        } else if (definitionToBeReplaced instanceof AdvisedBeanType) {
            bt = ((AdvisedBeanType)definitionToBeReplaced).getInterceptedType();
        } else {
            bt = definitionToBeReplaced.getBeanType();
            if (annotationMetadata.hasStereotype(INTRODUCTION_TYPE)) {
                Class superclass = bt.getSuperclass();
                if (superclass == Object.class) {
                    return replacingCandidate.isAssignableFrom(bt);
                }
                return replacingCandidate == superclass;
            }
            if (annotationMetadata.hasStereotype("io.micronaut.aop.Around")) {
                Class superclass = bt.getSuperclass();
                return replacingCandidate == superclass || replacingCandidate == bt;
            }
        }
        if (annotationMetadata.hasAnnotation(DefaultImplementation.class)) {
            Optional defaultImpl = annotationMetadata.classValue(DefaultImplementation.class);
            if (!defaultImpl.isPresent()) {
                defaultImpl = annotationMetadata.classValue(DefaultImplementation.class, "name");
            }
            if (defaultImpl.filter(impl -> impl == bt).isPresent()) {
                return replacingCandidate.isAssignableFrom(bt);
            }
            return replacingCandidate == bt;
        }
        return replacingCandidate != Object.class && replacingCandidate.isAssignableFrom(bt);
    }

    private <T> void doInject(BeanResolutionContext resolutionContext, T instance, BeanDefinition definition) {
        definition.inject(resolutionContext, this, instance);
        if (definition instanceof InitializingBeanDefinition) {
            ((InitializingBeanDefinition)definition).initialize(resolutionContext, this, instance);
        }
    }

    private void loadContextScopeBean(BeanDefinitionReference contextScopeBean, Consumer<BeanDefinition> beanDefinitionConsumer) {
        if (contextScopeBean.isEnabled(this)) {
            BeanDefinition beanDefinition = contextScopeBean.load(this);
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                if (beanDefinition.isEnabled(this, resolutionContext)) {
                    beanDefinitionConsumer.accept(beanDefinition);
                }
            }
        }
    }

    private void loadContextScopeBean(BeanDefinition beanDefinition) {
        if (beanDefinition.isIterable() || beanDefinition.hasStereotype(ConfigurationReader.class.getName())) {
            Collection beanCandidates = this.transformIterables(null, Collections.singleton(beanDefinition), true);
            for (BeanDefinition beanCandidate : beanCandidates) {
                this.findOrCreateSingletonBeanRegistration(null, beanCandidate, beanCandidate.asArgument(), beanCandidate.hasAnnotation(Context.class) ? null : beanDefinition.getDeclaredQualifier());
            }
        } else {
            this.findOrCreateSingletonBeanRegistration(null, beanDefinition, beanDefinition.asArgument(), null);
        }
    }

    @Nullable
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, boolean throwNoSuchBean) {
        BeanRegistration<T> registration;
        BeanRegistration inFlightBeanRegistration;
        Class beanClass = beanType.getType();
        if (this.thisInterfaces.contains(beanClass)) {
            return new BeanRegistration<DefaultBeanContext>(BeanIdentifier.of(beanClass.getName()), null, this);
        }
        if (InjectionPoint.class.isAssignableFrom(beanClass)) {
            return this.provideInjectionPoint(resolutionContext, beanType, qualifier, throwNoSuchBean);
        }
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing bean for key: {}", beanKey);
        }
        BeanRegistration beanRegistration = inFlightBeanRegistration = resolutionContext != null ? resolutionContext.getInFlightBean(beanKey) : null;
        if (inFlightBeanRegistration != null) {
            return inFlightBeanRegistration;
        }
        BeanRegistration<T> beanRegistration2 = this.singletonScope.findCachedSingletonBeanRegistration(beanType, qualifier);
        if (beanRegistration2 != null) {
            return beanRegistration2;
        }
        Optional<BeanDefinition<T>> concreteCandidate = this.findBeanDefinition(beanType, qualifier);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<T> definition = concreteCandidate.get();
            if (definition.isContainerType() && beanClass != definition.getBeanType()) {
                throw new NonUniqueBeanException(beanClass, Collections.singletonList(definition).iterator());
            }
            registration = this.resolveBeanRegistration(resolutionContext, definition, beanType, qualifier);
        } else {
            registration = null;
        }
        if ((registration == null || registration.bean == null) && throwNoSuchBean) {
            throw new NoSuchBeanException(beanType, qualifier);
        }
        return registration;
    }

    @Nullable
    private <T> BeanRegistration<T> provideInjectionPoint(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier, boolean throwNoSuchBean) {
        BeanResolutionContext.Path path = resolutionContext != null ? resolutionContext.getPath() : null;
        BeanResolutionContext.Segment injectionPointSegment = null;
        if (CollectionUtils.isNotEmpty((Collection)path)) {
            InjectionPoint ip;
            Iterator i = path.iterator();
            injectionPointSegment = (BeanResolutionContext.Segment)i.next();
            BeanResolutionContext.Segment segment = null;
            if (i.hasNext() && (segment = (BeanResolutionContext.Segment)i.next()).getDeclaringType().hasStereotype(INTRODUCTION_TYPE)) {
                BeanResolutionContext.Segment segment2 = segment = i.hasNext() ? (BeanResolutionContext.Segment)i.next() : null;
            }
            if (segment != null && (ip = segment.getInjectionPoint()) != null && beanType.isInstance(ip)) {
                return new BeanRegistration(BeanIdentifier.of(InjectionPoint.class.getName()), null, ip);
            }
        }
        if (injectionPointSegment == null || !injectionPointSegment.getArgument().isNullable()) {
            throw new BeanContextException("Failed to obtain injection point. No valid injection path present in path: " + path);
        }
        if (throwNoSuchBean) {
            throw new NoSuchBeanException(beanType, qualifier);
        }
        return null;
    }

    @NonNull
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition) {
        return this.resolveBeanRegistration(resolutionContext, definition, definition.asArgument(), definition.getDeclaredQualifier());
    }

    @NonNull
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        boolean isScopedProxyDefinition = definition.hasStereotype(SCOPED_PROXY_ANN);
        if (qualifier != null && AnyQualifier.INSTANCE.equals(definition.getDeclaredQualifier())) {
            definition = BeanDefinitionDelegate.create(definition, qualifier);
        }
        if (definition.isSingleton() && !isScopedProxyDefinition) {
            return this.findOrCreateSingletonBeanRegistration(resolutionContext, definition, beanType, qualifier);
        }
        boolean isProxy = definition.isProxy();
        if (isProxy && isScopedProxyDefinition && (qualifier == null || !qualifier.contains(PROXY_TARGET_QUALIFIER))) {
            Qualifier<T> q = qualifier;
            if (q == null) {
                q = definition.getDeclaredQualifier();
            }
            BeanRegistration<T> registration = this.createRegistration(resolutionContext, beanType, q, definition, true);
            Object bean = registration.bean;
            if (bean instanceof Qualified) {
                ((Qualified)bean).$withBeanQualifier(q);
            }
            return registration;
        }
        CustomScope<?> customScope = this.findCustomScope(resolutionContext, definition, isProxy, isScopedProxyDefinition);
        if (customScope != null) {
            if (isProxy) {
                definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
            }
            return this.getOrCreateScopedRegistration(resolutionContext, customScope, qualifier, beanType, definition);
        }
        return this.createRegistration(resolutionContext, beanType, qualifier, definition, true);
    }

    @NonNull
    private <T> BeanRegistration<T> findOrCreateSingletonBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanRegistration<T> beanRegistration = this.singletonScope.findBeanRegistration(definition, beanType, qualifier);
        if (beanRegistration != null) {
            return beanRegistration;
        }
        return this.singletonScope.getOrCreate(this, resolutionContext, definition, beanType, qualifier);
    }

    @Nullable
    private <T> CustomScope<?> findCustomScope(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, boolean isProxy, boolean isScopedProxyDefinition) {
        Argument argument;
        BeanResolutionContext.Segment currentSegment;
        CustomScope customScope;
        Optional<Class<Annotation>> scope = definition.getScope();
        if (scope.isPresent()) {
            Class<Annotation> scopeAnnotation = scope.get();
            if (scopeAnnotation == Prototype.class) {
                return null;
            }
            CustomScope customScope2 = this.customScopeRegistry.findScope(scopeAnnotation).orElse(null);
            if (customScope2 != null) {
                return customScope2;
            }
        } else {
            Optional<String> scopeName = definition.getScopeName();
            if (scopeName.isPresent()) {
                String scopeAnnotation = scopeName.get();
                if (Prototype.class.getName().equals(scopeAnnotation)) {
                    return null;
                }
                customScope = this.customScopeRegistry.findScope(scopeAnnotation).orElse(null);
                if (customScope != null) {
                    return customScope;
                }
            }
        }
        if (resolutionContext != null && (currentSegment = (BeanResolutionContext.Segment)resolutionContext.getPath().currentSegment().orElse(null)) != null && (customScope = (CustomScope)this.customScopeRegistry.findDeclaredScope(argument = currentSegment.getArgument()).orElse(null)) != null) {
            return customScope;
        }
        if (!isScopedProxyDefinition || !isProxy) {
            return this.customScopeRegistry.findDeclaredScope(definition).orElse(null);
        }
        return null;
    }

    @NonNull
    private <T> BeanRegistration<T> getOrCreateScopedRegistration(final @Nullable BeanResolutionContext resolutionContext, @NonNull CustomScope<?> registeredScope, final @Nullable Qualifier<T> qualifier, final @NonNull Argument<T> beanType, final @NonNull BeanDefinition<T> definition) {
        final BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        Object bean = registeredScope.getOrCreate(new BeanCreationContext<T>(){

            @Override
            @NonNull
            public BeanDefinition<T> definition() {
                return definition;
            }

            @Override
            @NonNull
            public BeanIdentifier id() {
                return beanKey;
            }

            @Override
            @NonNull
            public CreatedBean<T> create() throws BeanCreationException {
                return DefaultBeanContext.this.createRegistration(resolutionContext == null ? null : resolutionContext.copy(), beanType, qualifier, definition, true);
            }
        });
        return BeanRegistration.of(this, beanKey, definition, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @Internal
    final <T> BeanRegistration<T> createRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull BeanDefinition<T> definition, boolean dependent) {
        try (BeanResolutionContext context = this.newResolutionContext(definition, resolutionContext);){
            BeanRegistration<T> beanRegistration;
            block13: {
                BeanResolutionContext.Path path = context.getPath();
                boolean isNewPath = path.isEmpty();
                if (isNewPath) {
                    path.pushBeanCreate(definition, beanType);
                }
                try {
                    List<BeanRegistration<?>> parentDependentBeans = context.popDependentBeans();
                    T bean = this.doCreateBean(context, definition, qualifier);
                    BeanRegistration<?> dependentFactoryBean = context.getAndResetDependentFactoryBean();
                    if (dependentFactoryBean != null) {
                        this.destroyBean(dependentFactoryBean);
                    }
                    BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
                    List<BeanRegistration<?>> dependentBeans = context.getAndResetDependentBeans();
                    BeanRegistration<T> beanRegistration2 = BeanRegistration.of(this, beanKey, definition, bean, dependentBeans);
                    context.pushDependentBeans(parentDependentBeans);
                    if (dependent) {
                        context.addDependentBean(beanRegistration2);
                    }
                    beanRegistration = beanRegistration2;
                    if (!isNewPath) break block13;
                }
                catch (Throwable throwable) {
                    if (isNewPath) {
                        path.pop();
                    }
                    throw throwable;
                }
                path.pop();
            }
            return beanRegistration;
        }
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidate(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, boolean throwNonUnique) {
        if (beanType.getType() == Object.class && qualifier == null) {
            return Optional.empty();
        }
        BeanCandidateKey<T> bk = new BeanCandidateKey<T>(beanType, qualifier, throwNonUnique);
        Optional<BeanDefinition<T>> beanDefinition = this.beanConcreteCandidateCache.get(bk);
        if (beanDefinition == null) {
            beanDefinition = this.findConcreteCandidateNoCache(resolutionContext, beanType, qualifier, throwNonUnique, true);
            this.beanConcreteCandidateCache.put(bk, beanDefinition);
        }
        return beanDefinition;
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidateNoCache(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, final @Nullable Qualifier<T> qualifier, boolean throwNonUnique, boolean filterProxied) {
        Predicate predicate = new Predicate<BeanDefinition<T>>(){

            @Override
            public boolean test(BeanDefinition<T> candidate) {
                if (candidate.isAbstract()) {
                    return false;
                }
                if (qualifier != null && candidate instanceof NoInjectionBeanDefinition) {
                    NoInjectionBeanDefinition noInjectionBeanDefinition = (NoInjectionBeanDefinition)candidate;
                    return qualifier.contains(noInjectionBeanDefinition.getQualifier());
                }
                return true;
            }
        };
        ArrayList<BeanDefinition<T>> candidates = new ArrayList<BeanDefinition<T>>(this.findBeanCandidates(resolutionContext, beanType, filterProxied, predicate));
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        this.filterProxiedTypes(candidates, filterProxied, false, predicate);
        int size = candidates.size();
        BeanDefinition<T> definition = null;
        if (size > 0) {
            if (qualifier != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Qualifying bean [{}] for qualifier: {} ", (Object)beanType.getName(), qualifier);
                }
                Stream<BeanDefinition> candidateStream = candidates.stream().filter(c -> {
                    if (!c.isAbstract()) {
                        if (c instanceof NoInjectionBeanDefinition) {
                            NoInjectionBeanDefinition noInjectionBeanDefinition = (NoInjectionBeanDefinition)c;
                            return qualifier.contains(noInjectionBeanDefinition.getQualifier());
                        }
                        return true;
                    }
                    return false;
                });
                Stream<BeanDefinition> qualified = qualifier.reduce(beanType.getType(), candidateStream);
                List<BeanDefinition<T>> beanDefinitionList = qualified.collect(Collectors.toList());
                if (beanDefinitionList.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No qualifying beans of type [{}] found for qualifier: {} ", (Object)beanType.getName(), qualifier);
                    }
                    return Optional.empty();
                }
                definition = this.lastChanceResolve(beanType, qualifier, throwNonUnique, beanDefinitionList);
            } else if (candidates.size() == 1) {
                definition = (BeanDefinition<T>)candidates.iterator().next();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for @Primary for type [{}] from candidates: {} ", (Object)beanType.getName(), candidates);
                }
                definition = this.lastChanceResolve(beanType, qualifier, throwNonUnique, candidates);
            }
        }
        if (LOG.isDebugEnabled() && definition != null) {
            if (qualifier != null) {
                LOG.debug("Found concrete candidate [{}] for type: {} {} ", new Object[]{definition, qualifier, beanType.getName()});
            } else {
                LOG.debug("Found concrete candidate [{}] for type: {} ", (Object)definition, (Object)beanType.getName());
            }
        }
        return Optional.ofNullable(definition);
    }

    private <T> void filterProxiedTypes(Collection<BeanDefinition<T>> candidates, boolean filterProxied, boolean filterDelegates, Predicate<BeanDefinition<T>> predicate) {
        ArrayList delegates;
        int count = candidates.size();
        HashSet proxiedTypes = new HashSet(count);
        Iterator<BeanDefinition<T>> i = candidates.iterator();
        ArrayList arrayList = delegates = filterDelegates ? new ArrayList(count) : Collections.emptyList();
        while (i.hasNext()) {
            BeanDefinition<T> candidate2 = i.next();
            if (candidate2 instanceof ProxyBeanDefinition) {
                if (filterProxied) {
                    proxiedTypes.add(((ProxyBeanDefinition)candidate2).getTargetDefinitionType());
                    continue;
                }
                proxiedTypes.add(candidate2.getClass());
                continue;
            }
            if (!(candidate2 instanceof BeanDefinitionDelegate)) continue;
            BeanDefinition delegate = ((BeanDefinitionDelegate)candidate2).getDelegate();
            if (filterDelegates) {
                i.remove();
                if (delegates.contains(delegate) || predicate != null && !predicate.test(delegate)) continue;
                delegates.add(delegate);
                continue;
            }
            if (!filterProxied || !(delegate instanceof ProxyBeanDefinition)) continue;
            proxiedTypes.add(((ProxyBeanDefinition)delegate).getTargetDefinitionType());
        }
        if (filterDelegates) {
            candidates.addAll(delegates);
        }
        if (!proxiedTypes.isEmpty()) {
            candidates.removeIf(candidate -> {
                if (candidate instanceof BeanDefinitionDelegate) {
                    return proxiedTypes.contains(((BeanDefinitionDelegate)candidate).getDelegate().getClass());
                }
                return proxiedTypes.contains(candidate.getClass());
            });
        }
    }

    private <T> BeanDefinition<T> lastChanceResolve(Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, Collection<BeanDefinition<T>> candidates) {
        List primary;
        Class beanClass = beanType.getType();
        if (candidates.size() > 1 && !(primary = candidates.stream().filter(BeanType::isPrimary).collect(Collectors.toList())).isEmpty()) {
            candidates = primary;
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        BeanDefinition<T> definition = null;
        if ((candidates = (Collection)candidates.stream().filter(candidate -> !candidate.hasDeclaredStereotype(Secondary.class)).collect(Collectors.toList())).size() == 1) {
            return (BeanDefinition)candidates.iterator().next();
        }
        if (candidates.stream().anyMatch(candidate -> candidate.hasAnnotation(Order.class))) {
            Iterator i = candidates.stream().sorted((bean1, bean2) -> {
                int order1 = OrderUtil.getOrder((AnnotationMetadata)bean1.getAnnotationMetadata());
                int order2 = OrderUtil.getOrder((AnnotationMetadata)bean2.getAnnotationMetadata());
                return Integer.compare(order1, order2);
            }).iterator();
            if (i.hasNext()) {
                BeanDefinition bean = (BeanDefinition)i.next();
                if (i.hasNext()) {
                    BeanDefinition next = (BeanDefinition)i.next();
                    if (OrderUtil.getOrder((AnnotationMetadata)bean.getAnnotationMetadata()) == OrderUtil.getOrder((AnnotationMetadata)next.getAnnotationMetadata())) {
                        throw new NonUniqueBeanException(beanType.getType(), candidates.iterator());
                    }
                }
                LOG.debug("Picked bean {} with the highest precedence for type {} and qualifier {}", new Object[]{bean, beanType, qualifier});
                return bean;
            }
            throw new NonUniqueBeanException(beanType.getType(), candidates.iterator());
        }
        Collection<BeanDefinition<T>> exactMatches = this.filterExactMatch(beanClass, candidates);
        if (exactMatches.size() == 1) {
            definition = exactMatches.iterator().next();
        } else if (throwNonUnique) {
            definition = this.findConcreteCandidate(beanClass, qualifier, candidates);
        }
        return definition;
    }

    private void readAllBeanConfigurations() {
        Iterable<BeanConfiguration> beanConfigurations = this.resolveBeanConfigurations();
        for (BeanConfiguration beanConfiguration : beanConfigurations) {
            this.registerConfiguration(beanConfiguration);
        }
    }

    private <T> Collection<BeanDefinition<T>> filterExactMatch(Class<T> beanType, Collection<BeanDefinition<T>> candidates) {
        ArrayList<BeanDefinition<T>> list = new ArrayList<BeanDefinition<T>>(candidates.size());
        for (BeanDefinition<T> candidate : candidates) {
            if (candidate.getBeanType() != beanType) continue;
            list.add(candidate);
        }
        return list;
    }

    private void readAllBeanDefinitionClasses() {
        ArrayList<BeanDefinitionReference> contextScopeBeans = new ArrayList<BeanDefinitionReference>(20);
        ArrayList<BeanDefinitionReference> processedBeans = new ArrayList<BeanDefinitionReference>(10);
        ArrayList<BeanDefinitionReference> parallelBeans = new ArrayList<BeanDefinitionReference>(10);
        List<BeanDefinitionReference> beanDefinitionReferences = this.resolveBeanDefinitionReferences();
        this.beanDefinitionsClasses.addAll(beanDefinitionReferences);
        HashSet<BeanConfiguration> configurationsDisabled = new HashSet<BeanConfiguration>();
        for (BeanConfiguration bc : this.beanConfigurations.values()) {
            if (bc.isEnabled(this)) continue;
            configurationsDisabled.add(bc);
        }
        block1: for (BeanDefinitionReference beanDefinitionReference : beanDefinitionReferences) {
            Class aClass;
            for (BeanConfiguration disableConfiguration : configurationsDisabled) {
                if (!disableConfiguration.isWithin(beanDefinitionReference)) continue;
                this.beanDefinitionsClasses.remove(beanDefinitionReference);
                continue block1;
            }
            AnnotationMetadata annotationMetadata = beanDefinitionReference.getAnnotationMetadata();
            Class[] indexes = annotationMetadata.classValues(INDEXES_TYPE);
            if (indexes.length > 0) {
                for (int i = 0; i < indexes.length; ++i) {
                    Class indexedType = indexes[i];
                    this.resolveTypeIndex(indexedType).add(beanDefinitionReference);
                }
            } else if (annotationMetadata.hasStereotype(ADAPTER_TYPE) && this.indexedTypes.contains(aClass = (Class)annotationMetadata.classValue(ADAPTER_TYPE, "value").orElse(null))) {
                this.resolveTypeIndex(aClass).add(beanDefinitionReference);
            }
            if (this.isEagerInit(beanDefinitionReference)) {
                contextScopeBeans.add(beanDefinitionReference);
            } else if (annotationMetadata.hasDeclaredStereotype(PARALLEL_TYPE)) {
                parallelBeans.add(beanDefinitionReference);
            }
            if (!beanDefinitionReference.requiresMethodProcessing()) continue;
            processedBeans.add(beanDefinitionReference);
        }
        this.beanDefinitionReferences = null;
        this.beanConfigurationsList = null;
        this.initializeEventListeners();
        this.initializeContext(contextScopeBeans, processedBeans, parallelBeans);
    }

    private boolean isEagerInit(BeanDefinitionReference beanDefinitionReference) {
        return beanDefinitionReference.isContextScope() || this.eagerInitSingletons && beanDefinitionReference.isSingleton() || this.eagerInitStereotypesPresent && beanDefinitionReference.getAnnotationMetadata().hasDeclaredStereotype(this.eagerInitStereotypes);
    }

    @NonNull
    private Collection<BeanDefinitionReference> resolveTypeIndex(Class<?> indexedType) {
        return this.beanIndex.computeIfAbsent(indexedType, aClass -> {
            this.indexedTypes.add(indexedType);
            return new ArrayList(20);
        });
    }

    private <T> Collection<BeanDefinition<T>> findBeanCandidatesInternal(BeanResolutionContext resolutionContext, Argument<T> beanType) {
        Collection<BeanDefinition<T>> beanDefinitions = this.beanCandidateCache.get(beanType);
        if (beanDefinitions == null) {
            beanDefinitions = this.findBeanCandidates(resolutionContext, beanType, true, null);
            this.beanCandidateCache.put(beanType, beanDefinitions);
        }
        return beanDefinitions;
    }

    @Internal
    public <T> BeanRegistration<T> getBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.resolveBeanRegistration(resolutionContext, beanType, qualifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection<BeanRegistration<T>> beanRegistrations;
        CollectionHolder existing;
        boolean hasQualifier;
        boolean bl = hasQualifier = qualifier != null;
        if (LOG.isDebugEnabled()) {
            if (hasQualifier) {
                LOG.debug("Resolving beans for type: {} {} ", qualifier, (Object)beanType.getTypeName());
            } else {
                LOG.debug("Resolving beans for type: {}", (Object)beanType.getTypeName());
            }
        }
        BeanKey<T> key = new BeanKey<T>(beanType, qualifier);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing beans for key: {}", key);
        }
        if ((existing = this.singletonBeanRegistrations.get(key)) != null && existing.registrations != null) {
            this.logResolvedExistingBeanRegistrations(beanType, qualifier, existing.registrations);
            return existing.registrations;
        }
        Collection beanDefinitions = this.findBeanCandidatesInternal(resolutionContext, beanType);
        Stream candidateStream = this.applyBeanResolutionFilters(resolutionContext, beanDefinitions.stream());
        if (qualifier != null) {
            candidateStream = qualifier.reduce(beanType.getType(), candidateStream);
        }
        if ((beanDefinitions = (Collection)candidateStream.collect(Collectors.toList())).isEmpty()) {
            beanRegistrations = Collections.emptySet();
        } else {
            boolean allCandidatesAreSingleton = true;
            for (BeanDefinition definition : beanDefinitions) {
                if (definition.isSingleton()) continue;
                allCandidatesAreSingleton = false;
            }
            if (allCandidatesAreSingleton) {
                CollectionHolder holder;
                CollectionHolder collectionHolder = holder = this.singletonBeanRegistrations.computeIfAbsent(key, beanKey -> new CollectionHolder());
                synchronized (collectionHolder) {
                    if (holder.registrations != null) {
                        this.logResolvedExistingBeanRegistrations(beanType, qualifier, holder.registrations);
                        return holder.registrations;
                    }
                    holder.registrations = this.resolveBeanRegistrations(resolutionContext, beanDefinitions, beanType, qualifier);
                    return holder.registrations;
                }
            }
            beanRegistrations = this.resolveBeanRegistrations(resolutionContext, beanDefinitions, beanType, qualifier);
        }
        if (LOG.isDebugEnabled() && !beanRegistrations.isEmpty()) {
            if (hasQualifier) {
                LOG.debug("Found {} bean registrations for type [{} {}]", new Object[]{beanRegistrations.size(), qualifier, beanType.getName()});
            } else {
                LOG.debug("Found {} bean registrations for type [{}]", (Object)beanRegistrations.size(), (Object)beanType.getName());
            }
            for (BeanRegistration<T> beanRegistration : beanRegistrations) {
                LOG.debug("  {} {}", beanRegistration.definition(), beanRegistration.definition().getDeclaredQualifier());
            }
        }
        return beanRegistrations;
    }

    private <T> Collection<BeanRegistration<T>> resolveBeanRegistrations(BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> beanDefinitions, Argument<T> beanType, Qualifier<T> qualifier) {
        boolean hasOrderAnnotation = false;
        HashSet<BeanRegistration<T>> beansOfTypeList = new HashSet<BeanRegistration<T>>();
        for (BeanDefinition<T> definition : beanDefinitions) {
            if (!hasOrderAnnotation && definition.hasAnnotation(Order.class)) {
                hasOrderAnnotation = true;
            }
            this.addCandidateToList(resolutionContext, definition, beanType, qualifier, beansOfTypeList);
        }
        Collection<BeanRegistration<Object>> result = beansOfTypeList;
        if (beansOfTypeList != Collections.EMPTY_SET) {
            Stream<Object> stream = beansOfTypeList.stream();
            if (Ordered.class.isAssignableFrom(beanType.getType())) {
                result = (Collection)stream.sorted(OrderUtil.COMPARATOR).collect(StreamUtils.toImmutableCollection());
            } else {
                if (hasOrderAnnotation) {
                    stream = stream.sorted(BEAN_REGISTRATION_COMPARATOR);
                }
                result = (Collection)stream.collect(StreamUtils.toImmutableCollection());
            }
        }
        return result;
    }

    private <T> void logResolvedExistingBeanRegistrations(Argument<T> beanType, Qualifier<T> qualifier, Collection<BeanRegistration<T>> existing) {
        if (LOG.isDebugEnabled()) {
            if (qualifier == null) {
                LOG.debug("Found {} existing beans for type [{}]: {} ", new Object[]{existing.size(), beanType.getName(), existing});
            } else {
                LOG.debug("Found {} existing beans for type [{} {}]: {} ", new Object[]{existing.size(), qualifier, beanType.getName(), existing});
            }
        }
    }

    private <T> Stream<BeanDefinition<T>> applyBeanResolutionFilters(@Nullable BeanResolutionContext resolutionContext, Stream<BeanDefinition<T>> candidateStream) {
        BeanResolutionContext.Segment segment;
        BeanResolutionContext.Segment segment2 = segment = resolutionContext != null ? (BeanResolutionContext.Segment)resolutionContext.getPath().peek() : null;
        if (segment instanceof AbstractBeanResolutionContext.ConstructorSegment || segment instanceof AbstractBeanResolutionContext.MethodSegment) {
            BeanDefinition declaringBean = segment.getDeclaringType();
            candidateStream = candidateStream.filter(c -> {
                if (c.equals(declaringBean)) {
                    return false;
                }
                if (declaringBean instanceof ProxyBeanDefinition) {
                    return !((ProxyBeanDefinition)declaringBean).getTargetDefinitionType().equals(c.getClass());
                }
                return true;
            });
        }
        return candidateStream.filter(c -> !c.isAbstract());
    }

    private <T> void addCandidateToList(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> candidate, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull Collection<BeanRegistration<T>> beansOfTypeList) {
        BeanRegistration<T> beanRegistration;
        block9: {
            beanRegistration = null;
            try {
                beanRegistration = this.resolveBeanRegistration(resolutionContext, candidate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found a registration {} for candidate: {} with qualifier: {}", new Object[]{beanRegistration, candidate, qualifier});
                }
            }
            catch (DisabledBeanException e) {
                if (!AbstractBeanContextConditional.LOG.isDebugEnabled()) break block9;
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getTypeName(), (Object)e.getMessage());
            }
        }
        if (beanRegistration != null) {
            if (candidate.isContainerType()) {
                Object container = beanRegistration.bean;
                if (container instanceof Object[]) {
                    container = Arrays.asList((Object[])container);
                }
                if (container instanceof Iterable) {
                    Iterable iterable = (Iterable)container;
                    int i = 0;
                    for (Object o : iterable) {
                        if (o == null || !beanType.isInstance(o)) continue;
                        beansOfTypeList.add(BeanRegistration.of(this, new BeanKey<T>(beanType, Qualifiers.byQualifiers(Qualifiers.byName(String.valueOf(i++)), qualifier)), candidate, o));
                    }
                }
            } else {
                beansOfTypeList.add(beanRegistration);
            }
        }
    }

    private <T> boolean isCandidatePresent(Argument<T> beanType, Qualifier<T> qualifier) {
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidates(null, beanType, true, null);
        if (!candidates.isEmpty()) {
            this.filterReplacedBeans(null, candidates);
            Stream<BeanDefinition<T>> stream = candidates.stream();
            if (qualifier != null && !(qualifier instanceof AnyQualifier)) {
                stream = qualifier.reduce(beanType.getType(), stream);
            }
            return stream.findAny().isPresent();
        }
        return false;
    }

    private static <T> List<T> nullSafe(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private List<BeanRegistration> topologicalSort(Collection<BeanRegistration> beans) {
        Map<Boolean, List<BeanRegistration>> initial = beans.stream().sorted(Comparator.comparing(s -> s.getBeanDefinition().getRequiredComponents().size())).collect(Collectors.groupingBy(b -> b.getBeanDefinition().getRequiredComponents().isEmpty()));
        ArrayList<BeanRegistration> sorted = new ArrayList<BeanRegistration>(DefaultBeanContext.nullSafe(initial.get(true)));
        ArrayList<BeanRegistration> unsorted = new ArrayList<BeanRegistration>(DefaultBeanContext.nullSafe(initial.get(false)));
        HashSet satisfied = new HashSet();
        HashSet unsatisfied = new HashSet();
        while (!unsorted.isEmpty()) {
            boolean acyclic = false;
            unsatisfied.clear();
            Iterator i = unsorted.iterator();
            while (i.hasNext()) {
                BeanRegistration bean = (BeanRegistration)i.next();
                boolean found = false;
                Collection<Class<?>> components = bean.getBeanDefinition().getRequiredComponents();
                for (Class<?> clazz : components) {
                    block6: {
                        block5: {
                            if (satisfied.contains(clazz)) continue;
                            if (unsatisfied.contains(clazz)) break block5;
                            if (!unsorted.stream().map(BeanRegistration::getBeanDefinition).map(BeanDefinition::getBeanType).anyMatch(clazz::isAssignableFrom)) break block6;
                        }
                        found = true;
                        unsatisfied.add(clazz);
                        break;
                    }
                    satisfied.add(clazz);
                }
                if (found) continue;
                acyclic = true;
                i.remove();
                sorted.add(0, bean);
            }
            if (acyclic) continue;
            sorted.add(0, (BeanRegistration)unsorted.remove(0));
        }
        return sorted;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return MutableConvertibleValues.of(this.attributes);
    }

    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        if (name != null) {
            return Optional.ofNullable(this.attributes.get(name));
        }
        return Optional.empty();
    }

    @NonNull
    public <T> Optional<T> getAttribute(CharSequence name, Class<T> type) {
        if (name != null) {
            Object o = this.attributes.get(name);
            if (type.isInstance(o)) {
                return Optional.of(o);
            }
            if (o != null) {
                return ConversionService.SHARED.convert(o, type);
            }
        }
        return Optional.empty();
    }

    @NonNull
    public BeanContext setAttribute(@NonNull CharSequence name, @Nullable Object value) {
        if (name != null) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
        }
        return this;
    }

    @NonNull
    public <T> Optional<T> removeAttribute(@NonNull CharSequence name, @NonNull Class<T> type) {
        Object o = this.attributes.remove(name);
        if (type.isInstance(o)) {
            return Optional.of(o);
        }
        return Optional.empty();
    }

    @Override
    public void finalizeConfiguration() {
        this.readAllBeanConfigurations();
        this.readAllBeanDefinitionClasses();
    }

    private final class ScanningBeanResolutionContext
    extends SingletonBeanResolutionContext {
        private final HashMap<BeanDefinition<?>, Argument<?>> beanCreationTargets;
        private final Map<BeanDefinition<?>, List<List<Argument<?>>>> foundTargets;

        private ScanningBeanResolutionContext(BeanDefinition<?> beanDefinition, HashMap<BeanDefinition<?>, Argument<?>> beanCreationTargets) {
            super(beanDefinition);
            this.foundTargets = new HashMap();
            this.beanCreationTargets = beanCreationTargets;
        }

        private List<Argument<?>> getHierarchy() {
            ArrayList hierarchy = new ArrayList(this.path.size());
            Iterator it = this.path.descendingIterator();
            while (it.hasNext()) {
                BeanResolutionContext.Segment segment = (BeanResolutionContext.Segment)it.next();
                hierarchy.add(segment.getArgument());
            }
            return hierarchy;
        }

        @Override
        protected void onNewSegment(BeanResolutionContext.Segment<?> segment) {
            Argument argument = segment.getArgument();
            if (argument.isContainerType() && (argument = (Argument)argument.getFirstTypeVariable().orElse(null)) == null) {
                return;
            }
            if (argument.isProvider()) {
                return;
            }
            for (Map.Entry<BeanDefinition<?>, Argument<?>> entry : this.beanCreationTargets.entrySet()) {
                if (!argument.isAssignableFrom(entry.getValue())) continue;
                this.foundTargets.computeIfAbsent(entry.getKey(), bd -> new ArrayList(5)).add(this.getHierarchy());
            }
        }

        Map<BeanDefinition<?>, List<List<Argument<?>>>> getFoundTargets() {
            return this.foundTargets;
        }
    }

    private static final class CollectionHolder<T> {
        Collection<BeanRegistration<T>> registrations;

        private CollectionHolder() {
        }
    }

    private class SingletonBeanResolutionContext
    extends AbstractBeanResolutionContext {
        public SingletonBeanResolutionContext(BeanDefinition<?> beanDefinition) {
            super(DefaultBeanContext.this, beanDefinition);
        }

        @Override
        public BeanResolutionContext copy() {
            SingletonBeanResolutionContext copy = new SingletonBeanResolutionContext(this.rootDefinition);
            copy.copyStateFrom(this);
            return copy;
        }

        @Override
        public <T> void addInFlightBean(BeanIdentifier beanIdentifier, BeanRegistration<T> beanRegistration) {
            DefaultBeanContext.this.singlesInCreation.put(beanIdentifier, beanRegistration);
        }

        @Override
        public void removeInFlightBean(BeanIdentifier beanIdentifier) {
            DefaultBeanContext.this.singlesInCreation.remove(beanIdentifier);
        }

        @Override
        @Nullable
        public <T> BeanRegistration<T> getInFlightBean(BeanIdentifier beanIdentifier) {
            return DefaultBeanContext.this.singlesInCreation.get(beanIdentifier);
        }
    }

    static final class BeanCandidateKey<T> {
        private final Argument<T> beanType;
        private final Qualifier<T> qualifier;
        private final boolean throwNonUnique;
        private final int hashCode;

        BeanCandidateKey(Argument<T> argument, Qualifier<T> qualifier, boolean throwNonUnique) {
            this.beanType = argument;
            this.qualifier = qualifier;
            this.hashCode = argument.typeHashCode();
            this.throwNonUnique = throwNonUnique;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanCandidateKey beanKey = (BeanCandidateKey)o;
            return this.beanType.equalsType(beanKey.beanType) && Objects.equals(this.qualifier, beanKey.qualifier) && this.throwNonUnique == beanKey.throwNonUnique;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static final class BeanKey<T>
    implements BeanIdentifier {
        final Argument<T> beanType;
        private final Qualifier<T> qualifier;
        private final int hashCode;

        BeanKey(BeanDefinition<T> definition, Qualifier<T> qualifier) {
            this(definition.asArgument(), qualifier);
        }

        BeanKey(Argument<T> argument, Qualifier<T> qualifier) {
            this.beanType = argument;
            this.qualifier = qualifier;
            this.hashCode = argument.typeHashCode();
        }

        BeanKey(Class<T> beanType, Qualifier<T> qualifier, Class ... typeArguments) {
            this(Argument.of(beanType, (Class[])typeArguments), qualifier);
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            return (this.qualifier != null ? this.qualifier + " " : "") + this.beanType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanKey beanKey = (BeanKey)o;
            return this.beanType.equalsType(beanKey.beanType) && Objects.equals(this.qualifier, beanKey.qualifier);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String getName() {
            if (this.qualifier instanceof Named) {
                return ((Named)this.qualifier).getName();
            }
            return Primary.SIMPLE_NAME;
        }
    }

    private static final class BeanExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R> {
        private final BeanContext beanContext;
        private final Class<T> beanType;
        private final Qualifier<T> qualifier;
        private final boolean isSingleton;
        private T target;

        BeanExecutionHandle(BeanContext beanContext, Class<T> beanType, Qualifier<T> qualifier, ExecutableMethod<T, R> method) {
            super(method);
            this.beanContext = beanContext;
            this.beanType = beanType;
            this.qualifier = qualifier;
            this.isSingleton = beanContext.findBeanDefinition(beanType, qualifier).map(BeanDefinition::isSingleton).orElse(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getTarget() {
            T target = this.target;
            if (target == null) {
                BeanExecutionHandle beanExecutionHandle = this;
                synchronized (beanExecutionHandle) {
                    target = this.target;
                    if (target == null) {
                        this.target = target = this.beanContext.getBean(this.beanType, this.qualifier);
                    }
                }
            }
            return target;
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.beanType;
        }

        @Override
        public R invoke(Object ... arguments) {
            if (this.isSingleton) {
                T target = this.getTarget();
                return (R)this.method.invoke(target, arguments);
            }
            return (R)this.method.invoke(this.beanContext.getBean(this.beanType, this.qualifier), arguments);
        }
    }

    private static final class ObjectExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R> {
        private final T target;

        ObjectExecutionHandle(T target, ExecutableMethod<T, R> method) {
            super(method);
            this.target = target;
        }

        @Override
        public T getTarget() {
            return this.target;
        }

        @Override
        public R invoke(Object ... arguments) {
            return (R)this.method.invoke(this.target, arguments);
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.target.getClass();
        }
    }

    private static abstract class AbstractExecutionHandle<T, R>
    implements MethodExecutionHandle<T, R> {
        protected final ExecutableMethod<T, R> method;

        AbstractExecutionHandle(ExecutableMethod<T, R> method) {
            this.method = method;
        }

        @Override
        @NonNull
        public ExecutableMethod<?, R> getExecutableMethod() {
            return this.method;
        }

        @Override
        public Argument[] getArguments() {
            return this.method.getArguments();
        }

        public String toString() {
            return this.method.toString();
        }

        @Override
        public String getMethodName() {
            return this.method.getMethodName();
        }

        @Override
        public ReturnType<R> getReturnType() {
            return this.method.getReturnType();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }
}

