/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.LifeCycle;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.BeanIntrospectionScanner;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.inject.BeanConfiguration;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public interface Environment
extends PropertyResolver,
LifeCycle<Environment>,
MutableConversionService,
ResourceLoader {
    public static final String MICRONAUT = "micronaut";
    public static final String TEST = "test";
    public static final String DEVELOPMENT = "dev";
    public static final String ANDROID = "android";
    public static final String CLI = "cli";
    public static final String CLOUD = "cloud";
    public static final String FUNCTION = "function";
    public static final String BOOTSTRAP_NAME_PROPERTY = "micronaut.bootstrap.name";
    public static final String BOOTSTRAP_CONTEXT_PROPERTY = "micronaut.bootstrap.context";
    public static final String CLOUD_PLATFORM_PROPERTY = "micronaut.cloud.platform";
    public static final String ENVIRONMENTS_PROPERTY = "micronaut.environments";
    public static final String ENVIRONMENTS_ENV = "MICRONAUT_ENVIRONMENTS";
    public static final String BOOTSTRAP_NAME = "bootstrap";
    public static final String DEFAULT_NAME = "application";
    public static final String GOOGLE_COMPUTE = "gcp";
    public static final String GAE = "gae";
    public static final String AMAZON_EC2 = "ec2";
    public static final String AZURE = "azure";
    public static final String ORACLE_CLOUD = "oraclecloud";
    public static final String DIGITAL_OCEAN = "digitalocean";
    public static final String BARE_METAL = "baremetal";
    public static final String IBM = "ibm";
    public static final String KUBERNETES = "k8s";
    public static final String CLOUD_FOUNDRY = "pcf";
    public static final String HEROKU = "heroku";
    public static final String PROPERTY_SOURCES_KEY = "micronaut.config.files";
    public static final String HOSTNAME = "HOSTNAME";
    public static final String DEDUCE_ENVIRONMENT_PROPERTY = "micronaut.env.deduction";
    public static final String DEDUCE_ENVIRONMENT_ENV = "MICRONAUT_ENV_DEDUCTION";

    public Set<String> getActiveNames();

    public Collection<PropertySource> getPropertySources();

    public Environment addPropertySource(PropertySource var1);

    public Environment removePropertySource(PropertySource var1);

    public Environment addPackage(String var1);

    public Environment addConfigurationExcludes(String ... var1);

    public Environment addConfigurationIncludes(String ... var1);

    public Collection<String> getPackages();

    public PropertyPlaceholderResolver getPlaceholderResolver();

    public Map<String, Object> refreshAndDiff();

    default public Environment addPropertySource(String name, @Nullable Map<String, ? super Object> values) {
        if (StringUtils.isNotEmpty((CharSequence)name) && CollectionUtils.isNotEmpty(values)) {
            return this.addPropertySource(PropertySource.of(name, values));
        }
        return this;
    }

    default public Environment addPackage(Package pkg) {
        this.addPackage(pkg.getName());
        return this;
    }

    default public Stream<Class<?>> scan(Class<? extends Annotation> annotation) {
        BeanIntrospectionScanner scanner = new BeanIntrospectionScanner();
        return scanner.scan(annotation, this.getPackages());
    }

    default public Stream<Class<?>> scan(Class<? extends Annotation> annotation, String ... packages) {
        BeanIntrospectionScanner scanner = new BeanIntrospectionScanner();
        return scanner.scan(annotation, Arrays.asList(packages));
    }

    default public ClassLoader getClassLoader() {
        return Environment.class.getClassLoader();
    }

    default public boolean isPresent(String className) {
        return ClassUtils.isPresent((String)className, (ClassLoader)this.getClassLoader());
    }

    public boolean isActive(BeanConfiguration var1);

    public Collection<PropertySourceLoader> getPropertySourceLoaders();
}

