/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.env.ActiveEnvironment;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.ComputePlatform;
import io.micronaut.context.env.ConstantPropertySources;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.EnvironmentPropertySource;
import io.micronaut.context.env.KubernetesEnvironmentPropertySource;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.PropertySourcePropertyResolver;
import io.micronaut.context.env.SystemPropertiesPropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.file.DefaultFileSystemResourceLoader;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.BeanIntrospectionScanner;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultEnvironment
extends PropertySourcePropertyResolver
implements Environment {
    private static final List<PropertySource> CONSTANT_PROPERTY_SOURCES = StaticOptimizations.get(ConstantPropertySources.class).map(ConstantPropertySources::getSources).orElse(Collections.emptyList());
    private static final String EC2_LINUX_HYPERVISOR_FILE = "/sys/hypervisor/uuid";
    private static final String EC2_LINUX_BIOS_VENDOR_FILE = "/sys/devices/virtual/dmi/id/bios_vendor";
    private static final String EC2_WINDOWS_HYPERVISOR_CMD = "wmic path win32_computersystemproduct get uuid";
    private static final String FILE_SEPARATOR = ",";
    private static final String AWS_LAMBDA_FUNCTION_NAME_ENV = "AWS_LAMBDA_FUNCTION_NAME";
    private static final String K8S_ENV = "KUBERNETES_SERVICE_HOST";
    private static final String PCF_ENV = "VCAP_SERVICES";
    private static final String HEROKU_DYNO = "DYNO";
    private static final String GOOGLE_APPENGINE_ENVIRONMENT = "GAE_ENV";
    private static final int DEFAULT_READ_TIMEOUT = 500;
    private static final int DEFAULT_CONNECT_TIMEOUT = 500;
    private static final String GOOGLE_COMPUTE_METADATA = "metadata.google.internal";
    private static final String ORACLE_CLOUD_ASSET_TAG_FILE = "/sys/devices/virtual/dmi/id/chassis_asset_tag";
    private static final String ORACLE_CLOUD_WINDOWS_ASSET_TAG_CMD = "wmic systemenclosure get smbiosassettag";
    private static final String DO_SYS_VENDOR_FILE = "/sys/devices/virtual/dmi/id/sys_vendor";
    private static final Boolean DEDUCE_ENVIRONMENT_DEFAULT = true;
    private static final List<String> DEFAULT_CONFIG_LOCATIONS = Arrays.asList("classpath:/", "file:config/");
    protected final ClassPathResourceLoader resourceLoader;
    protected final List<PropertySource> refreshablePropertySources = new ArrayList<PropertySource>(10);
    protected final MutableConversionService mutableConversionService;
    private EnvironmentsAndPackage environmentsAndPackage;
    private final Set<String> names;
    private final ClassLoader classLoader;
    private final Collection<String> packages = new ConcurrentLinkedQueue<String>();
    private final BeanIntrospectionScanner annotationScanner;
    private final Collection<String> configurationIncludes = new HashSet<String>(3);
    private final Collection<String> configurationExcludes = new HashSet<String>(3);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Collection<PropertySourceLoader> propertySourceLoaderList;
    private final Map<String, PropertySourceLoader> loaderByFormatMap = new ConcurrentHashMap<String, PropertySourceLoader>();
    private final Map<String, Boolean> presenceCache = new ConcurrentHashMap<String, Boolean>();
    private final AtomicBoolean reading = new AtomicBoolean(false);
    private final Boolean deduceEnvironments;
    private final ApplicationContextConfiguration configuration;
    private final Collection<String> configLocations;

    public DefaultEnvironment(@NonNull ApplicationContextConfiguration configuration) {
        this(configuration, true);
    }

    public DefaultEnvironment(@NonNull ApplicationContextConfiguration configuration, boolean logEnabled) {
        super((ConversionService)configuration.getConversionService().orElseGet(MutableConversionService::create));
        this.mutableConversionService = (MutableConversionService)this.conversionService;
        this.configuration = configuration;
        this.resourceLoader = configuration.getResourceLoader();
        LinkedHashSet<String> environments = new LinkedHashSet<String>(3);
        List<String> specifiedNames = new ArrayList<String>(configuration.getEnvironments());
        specifiedNames.addAll(0, Stream.of(CachedEnvironment.getProperty("micronaut.environments"), CachedEnvironment.getenv("MICRONAUT_ENVIRONMENTS")).filter(StringUtils::isNotEmpty).flatMap(s -> Arrays.stream(s.split(FILE_SEPARATOR))).map(String::trim).collect(Collectors.toList()));
        this.deduceEnvironments = configuration.getDeduceEnvironments().orElse(null);
        EnvironmentsAndPackage environmentsAndPackage = this.getEnvironmentsAndPackage(specifiedNames);
        if (environmentsAndPackage.enviroments.isEmpty() && specifiedNames.isEmpty()) {
            specifiedNames = configuration.getDefaultEnvironments();
        }
        environments.addAll(environmentsAndPackage.enviroments);
        String aPackage = environmentsAndPackage.aPackage;
        if (aPackage != null) {
            this.packages.add(aPackage);
        }
        specifiedNames.forEach(environments::remove);
        environments.addAll(specifiedNames);
        this.classLoader = configuration.getClassLoader();
        this.annotationScanner = this.createAnnotationScanner(this.classLoader);
        this.names = environments;
        if (!environments.isEmpty()) {
            this.log.info("Established active environments: {}", environments);
        }
        List<String> configLocations = configuration.getOverrideConfigLocations() == null ? new ArrayList<String>(DEFAULT_CONFIG_LOCATIONS) : configuration.getOverrideConfigLocations();
        Collections.reverse(configLocations);
        this.configLocations = configLocations;
    }

    @Override
    public boolean isPresent(String className) {
        return this.presenceCache.computeIfAbsent(className, s -> ClassUtils.isPresent((String)className, (ClassLoader)this.getClassLoader()));
    }

    @Override
    public PropertyPlaceholderResolver getPlaceholderResolver() {
        return this.propertyPlaceholderResolver;
    }

    @Override
    public Stream<Class<?>> scan(Class<? extends Annotation> annotation) {
        return this.annotationScanner.scan(annotation, this.getPackages());
    }

    @Override
    public Stream<Class<?>> scan(Class<? extends Annotation> annotation, String ... packages) {
        return this.annotationScanner.scan(annotation, packages);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isActive(BeanConfiguration configuration) {
        String name = configuration.getName();
        return !this.configurationExcludes.contains(name) && (this.configurationIncludes.isEmpty() || this.configurationIncludes.contains(name));
    }

    @Override
    public DefaultEnvironment addPropertySource(PropertySource propertySource) {
        this.propertySources.put(propertySource.getName(), propertySource);
        if (this.isRunning() && !this.reading.get()) {
            this.resetCaches();
            this.processPropertySource(propertySource, PropertySource.PropertyConvention.JAVA_PROPERTIES);
        }
        return this;
    }

    @Override
    public Environment removePropertySource(PropertySource propertySource) {
        this.propertySources.remove(propertySource.getName());
        if (this.isRunning() && !this.reading.get()) {
            this.resetCaches();
        }
        return this;
    }

    @Override
    public DefaultEnvironment addPropertySource(String name, Map<String, ? super Object> values) {
        return (DefaultEnvironment)super.addPropertySource(name, values);
    }

    @Override
    public Environment addPackage(String pkg) {
        if (!this.packages.contains(pkg)) {
            this.packages.add(pkg);
        }
        return this;
    }

    @Override
    public Environment addConfigurationExcludes(String ... names) {
        if (names != null) {
            this.configurationExcludes.addAll(Arrays.asList(names));
        }
        return this;
    }

    @Override
    public Environment addConfigurationIncludes(String ... names) {
        if (names != null) {
            this.configurationIncludes.addAll(Arrays.asList(names));
        }
        return this;
    }

    @Override
    public Collection<String> getPackages() {
        return Collections.unmodifiableCollection(this.packages);
    }

    @Override
    public Set<String> getActiveNames() {
        return this.names;
    }

    @Override
    public Collection<PropertySource> getPropertySources() {
        return Collections.unmodifiableCollection(this.propertySources.values());
    }

    @Override
    public Environment start() {
        if (this.running.compareAndSet(false, true)) {
            this.log.debug("Starting environment {} for active names {}", (Object)this, this.getActiveNames());
            if (this.reading.compareAndSet(false, true)) {
                this.readPropertySources(this.getPropertySourceRootName());
                this.reading.set(false);
            }
        }
        return this;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Environment stop() {
        this.running.set(false);
        this.reading.set(false);
        this.propertySources.values().removeAll(this.refreshablePropertySources);
        Map[] mapArray = this.catalog;
        synchronized (this.catalog) {
            for (int i = 0; i < this.catalog.length; ++i) {
                this.catalog[i] = null;
            }
            this.resetCaches();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this;
        }
    }

    @Override
    public Map<String, Object> refreshAndDiff() {
        Map<String, Object>[] copiedCatalog = this.copyCatalog();
        this.refresh();
        return this.diffCatalog(copiedCatalog, this.catalog);
    }

    public <T> Optional<T> convert(Object object, Class<T> targetType, ConversionContext context) {
        return this.mutableConversionService.convert(object, targetType, context);
    }

    public <S, T> boolean canConvert(Class<S> sourceType, Class<T> targetType) {
        return this.mutableConversionService.canConvert(sourceType, targetType);
    }

    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        this.mutableConversionService.addConverter(sourceType, targetType, typeConverter);
    }

    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> typeConverter) {
        this.mutableConversionService.addConverter(sourceType, targetType, typeConverter);
    }

    public Optional<InputStream> getResourceAsStream(String path) {
        return this.resourceLoader.getResourceAsStream(path);
    }

    public Optional<URL> getResource(String path) {
        return this.resourceLoader.getResource(path);
    }

    public Stream<URL> getResources(String path) {
        return this.resourceLoader.getResources(path);
    }

    public boolean supportsPrefix(String path) {
        return this.resourceLoader.supportsPrefix(path);
    }

    public ResourceLoader forBase(String basePath) {
        return this.resourceLoader.forBase(basePath);
    }

    protected boolean shouldDeduceEnvironments() {
        if (this.deduceEnvironments != null) {
            this.log.debug("Environment deduction was set explicitly via builder to: {}", (Object)this.deduceEnvironments);
            return this.deduceEnvironments;
        }
        if (this.configuration.isEnableDefaultPropertySources()) {
            String deduceProperty = CachedEnvironment.getProperty("micronaut.env.deduction");
            String deduceEnv = CachedEnvironment.getenv("MICRONAUT_ENV_DEDUCTION");
            if (StringUtils.isNotEmpty((CharSequence)deduceEnv)) {
                boolean deduce = Boolean.parseBoolean(deduceEnv);
                this.log.debug("Environment deduction was set via environment variable to: {}", (Object)deduce);
                return deduce;
            }
            if (StringUtils.isNotEmpty((CharSequence)deduceProperty)) {
                boolean deduce = Boolean.parseBoolean(deduceProperty);
                this.log.debug("Environment deduction was set via system property to: {}", (Object)deduce);
                return deduce;
            }
            boolean deduceDefault = DEDUCE_ENVIRONMENT_DEFAULT;
            this.log.debug("Environment deduction is using the default of: {}", (Object)deduceDefault);
            return deduceDefault;
        }
        return false;
    }

    protected boolean shouldDeduceCloudEnvironment() {
        String deduceEnv = CachedEnvironment.getenv("MICRONAUT_ENV_CLOUD_DEDUCTION");
        if (StringUtils.isNotEmpty((CharSequence)deduceEnv)) {
            boolean deduce = Boolean.parseBoolean(deduceEnv);
            this.log.debug("Cloud environment deduction was set via environment variable to: {}", (Object)deduce);
            return deduce;
        }
        String deduceProperty = CachedEnvironment.getProperty("micronaut.env.cloud-deduction");
        if (StringUtils.isNotEmpty((CharSequence)deduceProperty)) {
            boolean deduce = Boolean.parseBoolean(deduceProperty);
            this.log.debug("Cloud environment deduction was set via system property to: {}", (Object)deduce);
            return deduce;
        }
        return this.configuration.isDeduceCloudEnvironment();
    }

    protected BeanIntrospectionScanner createAnnotationScanner(ClassLoader classLoader) {
        return new BeanIntrospectionScanner();
    }

    protected String getPropertySourceRootName() {
        return "application";
    }

    protected void readPropertySources(String name) {
        List<PropertySource> propertySources;
        this.refreshablePropertySources.clear();
        if (this.configuration.isEnableDefaultPropertySources()) {
            String propertySourcesEnv;
            propertySources = this.readPropertySourceList(name);
            this.addDefaultPropertySources(propertySources);
            String propertySourcesSystemProperty = CachedEnvironment.getProperty("micronaut.config.files");
            if (propertySourcesSystemProperty != null) {
                propertySources.addAll(this.readPropertySourceListFromFiles(propertySourcesSystemProperty));
            }
            if ((propertySourcesEnv = this.readPropertySourceListKeyFromEnvironment()) != null) {
                propertySources.addAll(this.readPropertySourceListFromFiles(propertySourcesEnv));
            }
            this.refreshablePropertySources.addAll(propertySources);
            this.readConstantPropertySources(name, propertySources);
        } else {
            propertySources = new ArrayList<PropertySource>(this.propertySources.size());
        }
        propertySources.addAll(this.propertySources.values());
        OrderUtil.sort(propertySources);
        for (PropertySource propertySource : propertySources) {
            this.log.debug("Processing property source: {}", (Object)propertySource.getName());
            this.processPropertySource(propertySource, propertySource.getConvention());
        }
    }

    private void readConstantPropertySources(String name, List<PropertySource> propertySources) {
        Set<String> activeNames = this.getActiveNames();
        HashSet propertySourceNames = CollectionUtils.newHashSet((int)(activeNames.size() + 1));
        propertySourceNames.add(name);
        for (String env : activeNames) {
            propertySourceNames.add(name + "-" + env);
        }
        for (PropertySource p : this.getConstantPropertySources()) {
            if (!propertySourceNames.contains(p.getName())) continue;
            propertySources.add(p);
        }
    }

    protected List<PropertySource> getConstantPropertySources() {
        return CONSTANT_PROPERTY_SOURCES;
    }

    protected String readPropertySourceListKeyFromEnvironment() {
        return CachedEnvironment.getenv(StringUtils.convertDotToUnderscore((String)"micronaut.config.files"));
    }

    protected List<PropertySource> readPropertySourceListFromFiles(String files) {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        Collection<PropertySourceLoader> propertySourceLoaders = this.getPropertySourceLoaders();
        Optional<Collection> filePathList = Optional.ofNullable(files).filter(value -> !value.isEmpty()).map(value -> value.split(FILE_SEPARATOR)).map(Arrays::asList).map(Collections::unmodifiableList);
        filePathList.ifPresent(list -> {
            if (!list.isEmpty()) {
                int order = -250;
                for (String filePath : list) {
                    if (propertySourceLoaders.isEmpty()) continue;
                    String extension = NameUtils.extension((String)filePath);
                    String fileName = NameUtils.filename((String)filePath);
                    Optional<PropertySourceLoader> propertySourceLoader = Optional.ofNullable(this.loaderByFormatMap.get(extension));
                    if (propertySourceLoader.isPresent()) {
                        this.log.debug("Reading property sources from loader: {}", propertySourceLoader);
                        Optional<Map<String, Object>> properties = this.readPropertiesFromLoader(fileName, filePath, propertySourceLoader.get());
                        if (properties.isPresent()) {
                            propertySources.add(PropertySource.of(filePath, properties.get(), order));
                        }
                        ++order;
                        continue;
                    }
                    throw new ConfigurationException("Unsupported properties file format while reading " + fileName + "." + extension + " from " + filePath);
                }
            }
        });
        return propertySources;
    }

    protected List<PropertySource> readPropertySourceList(String name) {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        for (String configLocation : this.configLocations) {
            DefaultEnvironment resourceLoader;
            if (configLocation.equals("classpath:/")) {
                resourceLoader = this;
            } else if (configLocation.startsWith("classpath:")) {
                resourceLoader = this.forBase(configLocation);
            } else if (configLocation.startsWith("file:")) {
                Path configLocationPath = Paths.get(configLocation = configLocation.substring(5), new String[0]);
                if (!Files.exists(configLocationPath, new LinkOption[0]) || !Files.isDirectory(configLocationPath, new LinkOption[0]) || !Files.isReadable(configLocationPath)) continue;
                resourceLoader = new DefaultFileSystemResourceLoader(configLocationPath);
            } else {
                throw new ConfigurationException("Unsupported config location format: " + configLocation);
            }
            this.readPropertySourceList(name, resourceLoader, propertySources);
        }
        return propertySources;
    }

    private void readPropertySourceList(String name, ResourceLoader resourceLoader, List<PropertySource> propertySources) {
        Collection<PropertySourceLoader> propertySourceLoaders = this.getPropertySourceLoaders();
        if (propertySourceLoaders.isEmpty()) {
            this.loadPropertySourceFromLoader(name, new PropertiesPropertySourceLoader(), propertySources, resourceLoader);
        } else {
            for (PropertySourceLoader propertySourceLoader : propertySourceLoaders) {
                this.log.debug("Reading property sources from loader: {}", (Object)propertySourceLoader);
                this.loadPropertySourceFromLoader(name, propertySourceLoader, propertySources, resourceLoader);
            }
        }
    }

    protected void addDefaultPropertySources(List<PropertySource> propertySources) {
        if (!this.propertySources.containsKey("system")) {
            propertySources.add(new SystemPropertiesPropertySource());
        }
        if (!this.propertySources.containsKey("env") && this.configuration.isEnvironmentPropertySource()) {
            List<String> includes = this.configuration.getEnvironmentVariableIncludes();
            List<String> excludes = this.configuration.getEnvironmentVariableExcludes();
            if (this.names.contains("k8s")) {
                propertySources.add(new KubernetesEnvironmentPropertySource(includes, excludes));
            } else {
                propertySources.add(new EnvironmentPropertySource(includes, excludes));
            }
        }
    }

    protected SoftServiceLoader<PropertySourceLoader> readPropertySourceLoaders() {
        return SoftServiceLoader.load(PropertySourceLoader.class, (ClassLoader)this.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PropertySourceLoader> getPropertySourceLoaders() {
        Collection<PropertySourceLoader> propertySourceLoaderList = this.propertySourceLoaderList;
        if (propertySourceLoaderList == null) {
            DefaultEnvironment defaultEnvironment = this;
            synchronized (defaultEnvironment) {
                propertySourceLoaderList = this.propertySourceLoaderList;
                if (propertySourceLoaderList == null) {
                    this.propertySourceLoaderList = propertySourceLoaderList = this.evaluatePropertySourceLoaders();
                }
            }
        }
        return propertySourceLoaderList;
    }

    private Collection<PropertySourceLoader> evaluatePropertySourceLoaders() {
        SoftServiceLoader<PropertySourceLoader> definitions = this.readPropertySourceLoaders();
        List allLoaders = definitions.collectAll();
        for (PropertySourceLoader propertySourceLoader : allLoaders) {
            Set extensions = propertySourceLoader.getExtensions();
            for (String extension : extensions) {
                this.loaderByFormatMap.put(extension, propertySourceLoader);
            }
        }
        return allLoaders;
    }

    private void loadPropertySourceFromLoader(String name, PropertySourceLoader propertySourceLoader, List<PropertySource> propertySources, ResourceLoader resourceLoader) {
        Optional<PropertySource> defaultPropertySource = propertySourceLoader.load(name, resourceLoader);
        defaultPropertySource.ifPresent(propertySources::add);
        Set<String> activeNames = this.getActiveNames();
        int i = 0;
        for (String activeName : activeNames) {
            Optional<PropertySource> propertySource = propertySourceLoader.loadEnv(name, resourceLoader, ActiveEnvironment.of(activeName, i));
            propertySource.ifPresent(propertySources::add);
            ++i;
        }
    }

    private Optional<Map<String, Object>> readPropertiesFromLoader(String fileName, String filePath, PropertySourceLoader propertySourceLoader) throws ConfigurationException {
        ResourceLoader loader = (ResourceLoader)new ResourceResolver().getSupportingLoader(filePath).orElse(FileSystemResourceLoader.defaultLoader());
        try {
            Optional inputStream = loader.getResourceAsStream(filePath);
            if (inputStream.isPresent()) {
                return Optional.of(propertySourceLoader.read(fileName, (InputStream)inputStream.get()));
            }
            throw new ConfigurationException("Failed to read configuration file: " + filePath);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unsupported properties file: " + fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnvironmentsAndPackage getEnvironmentsAndPackage(List<String> specifiedNames) {
        boolean deduceCloudEnvironmentUsingProbes;
        EnvironmentsAndPackage environmentsAndPackage = this.environmentsAndPackage;
        boolean isNotFunction = !specifiedNames.contains("function");
        boolean deduceEnvironment = this.shouldDeduceEnvironments();
        boolean bl = deduceCloudEnvironmentUsingProbes = isNotFunction && this.shouldDeduceCloudEnvironment();
        if (environmentsAndPackage != null) return environmentsAndPackage;
        Class<EnvironmentsAndPackage> clazz = EnvironmentsAndPackage.class;
        synchronized (EnvironmentsAndPackage.class) {
            environmentsAndPackage = this.environmentsAndPackage;
            if (environmentsAndPackage != null) return environmentsAndPackage;
            this.environmentsAndPackage = environmentsAndPackage = DefaultEnvironment.deduceEnvironmentsAndPackage(deduceEnvironment, deduceCloudEnvironmentUsingProbes, isNotFunction, !deduceCloudEnvironmentUsingProbes);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return environmentsAndPackage;
        }
    }

    private static EnvironmentsAndPackage deduceEnvironmentsAndPackage(boolean deduceEnvironments, boolean deduceComputePlatform, boolean inspectTrace, boolean deduceFunctionPlatform) {
        EnvironmentsAndPackage environmentsAndPackage = new EnvironmentsAndPackage();
        Set<String> environments = environmentsAndPackage.enviroments;
        if (inspectTrace) {
            DefaultEnvironment.performStackTraceInspection(deduceEnvironments, environmentsAndPackage, environments);
        }
        if (deduceEnvironments && !environments.contains("android")) {
            DefaultEnvironment.performEnvironmentDeduction(deduceComputePlatform, environments);
        }
        if (deduceFunctionPlatform) {
            DefaultEnvironment.performFunctionDeduction(environments);
        }
        return environmentsAndPackage;
    }

    private static void performFunctionDeduction(Set<String> environments) {
        if (StringUtils.isNotEmpty((CharSequence)CachedEnvironment.getenv(AWS_LAMBDA_FUNCTION_NAME_ENV))) {
            environments.add("ec2");
            environments.add("cloud");
        }
    }

    private static void performEnvironmentDeduction(boolean deduceComputePlatform, Set<String> environments) {
        if (StringUtils.isNotEmpty((CharSequence)CachedEnvironment.getenv(K8S_ENV))) {
            environments.add("k8s");
            environments.add("cloud");
        }
        if (StringUtils.isNotEmpty((CharSequence)CachedEnvironment.getenv(PCF_ENV))) {
            environments.add("pcf");
            environments.add("cloud");
        }
        if (StringUtils.isNotEmpty((CharSequence)CachedEnvironment.getenv(HEROKU_DYNO))) {
            environments.add("heroku");
            environments.add("cloud");
            deduceComputePlatform = false;
        }
        if (StringUtils.isNotEmpty((CharSequence)CachedEnvironment.getenv(GOOGLE_APPENGINE_ENVIRONMENT))) {
            environments.add("gae");
            environments.add("gcp");
            deduceComputePlatform = false;
        }
        if (deduceComputePlatform) {
            DefaultEnvironment.performComputePlatformDeduction(environments);
        }
    }

    private static void performComputePlatformDeduction(Set<String> environments) {
        ComputePlatform computePlatform = DefaultEnvironment.determineCloudProvider();
        if (computePlatform != null) {
            switch (computePlatform) {
                case GOOGLE_COMPUTE: {
                    environments.add("gcp");
                    environments.add("cloud");
                    break;
                }
                case AMAZON_EC2: {
                    environments.add("ec2");
                    environments.add("cloud");
                    break;
                }
                case ORACLE_CLOUD: {
                    environments.add("oraclecloud");
                    environments.add("cloud");
                    break;
                }
                case AZURE: {
                    environments.add("azure");
                    environments.add("cloud");
                    break;
                }
                case IBM: {
                    environments.add("ibm");
                    environments.add("cloud");
                    break;
                }
                case DIGITAL_OCEAN: {
                    environments.add("digitalocean");
                    environments.add("cloud");
                    break;
                }
                case OTHER: {
                    break;
                }
            }
        }
    }

    private static void performStackTraceInspection(boolean deduceEnvironments, EnvironmentsAndPackage environmentsAndPackage, Set<String> environments) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int len = stackTrace.length;
        for (int i = 0; i < len; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            DefaultEnvironment.analyzeStackTraceElement(deduceEnvironments, environmentsAndPackage, environments, stackTrace, len, i, stackTraceElement, className);
        }
    }

    private static void analyzeStackTraceElement(boolean deduceEnvironments, EnvironmentsAndPackage environmentsAndPackage, Set<String> environments, StackTraceElement[] stackTrace, int len, int i, StackTraceElement stackTraceElement, String className) {
        StackTraceElement next;
        int nextIndex;
        if (className.startsWith("io.micronaut") && (nextIndex = i + 1) < len && !(next = stackTrace[nextIndex]).getClassName().startsWith("io.micronaut")) {
            environmentsAndPackage.aPackage = NameUtils.getPackageName((String)next.getClassName());
        }
        if (stackTraceElement.getMethodName().contains("$spock_")) {
            environmentsAndPackage.aPackage = NameUtils.getPackageName((String)className);
        }
        if (deduceEnvironments) {
            if (Stream.of("org.spockframework", "org.junit", "io.kotlintest", "io.kotest").anyMatch(className::startsWith)) {
                environments.add("test");
            }
            if (className.startsWith("com.android")) {
                environments.add("android");
            }
        }
    }

    private Map<String, Object> diffCatalog(Map<String, Object>[] original, Map<String, Object>[] newCatalog) {
        LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
        for (int i = 0; i < original.length; ++i) {
            boolean hasOld;
            Map<String, Object> map = original[i];
            Map<String, Object> newMap = newCatalog[i];
            boolean hasNew = newMap != null;
            boolean bl = hasOld = map != null;
            if (!hasOld && hasNew) {
                changes.putAll(newMap);
                continue;
            }
            if (!hasNew && hasOld) {
                changes.putAll(map);
                continue;
            }
            if (!hasOld || !hasNew) continue;
            this.diffMap(map, newMap, changes);
        }
        if (!changes.isEmpty()) {
            LinkedHashMap placeholdersAltered = new LinkedHashMap();
            for (Map<String, Object> map : newCatalog) {
                if (map == null) continue;
                map.forEach((key, v) -> {
                    if (v instanceof String) {
                        String val = (String)v;
                        for (String changed : changes.keySet()) {
                            if (!val.contains(changed)) continue;
                            placeholdersAltered.put(key, v);
                        }
                    }
                });
            }
            changes.putAll(placeholdersAltered);
        }
        return changes;
    }

    private void diffMap(Map<String, Object> map, Map<String, Object> newMap, Map<String, Object> changes) {
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            boolean hasOld;
            String key = entry.getKey();
            Object newValue = entry.getValue();
            if (!map.containsKey(key)) {
                changes.put(key, newValue);
                continue;
            }
            Object oldValue = map.get(key);
            boolean hasNew = newValue != null;
            boolean bl = hasOld = oldValue != null;
            if (hasNew && !hasOld) {
                changes.put(key, null);
                continue;
            }
            if (hasOld && !hasNew) {
                changes.put(key, oldValue);
                continue;
            }
            if (!hasNew || !hasOld || !DefaultEnvironment.hasChanged(newValue, oldValue)) continue;
            changes.put(key, oldValue);
        }
    }

    private static boolean hasChanged(Object newValue, Object oldValue) {
        return !Objects.deepEquals(newValue, oldValue);
    }

    private Map<String, Object>[] copyCatalog() {
        Map[] newCatalog = new Map[this.catalog.length];
        for (int i = 0; i < this.catalog.length; ++i) {
            Map entry = this.catalog[i];
            if (entry == null) continue;
            newCatalog[i] = new LinkedHashMap(entry);
        }
        return newCatalog;
    }

    private static ComputePlatform determineCloudProvider() {
        String computePlatform = CachedEnvironment.getProperty("micronaut.cloud.platform");
        if (computePlatform != null) {
            try {
                return ComputePlatform.valueOf(computePlatform);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Illegal value specified for [micronaut.cloud.platform]: " + computePlatform);
            }
        }
        boolean isWindows = CachedEnvironment.getProperty("os.name").toLowerCase().startsWith("windows");
        if (isWindows ? DefaultEnvironment.isEC2Windows() : DefaultEnvironment.isEC2Linux()) {
            return ComputePlatform.AMAZON_EC2;
        }
        if (DefaultEnvironment.isGoogleCompute()) {
            return ComputePlatform.GOOGLE_COMPUTE;
        }
        if (isWindows ? DefaultEnvironment.isOracleCloudWindows() : DefaultEnvironment.isOracleCloudLinux()) {
            return ComputePlatform.ORACLE_CLOUD;
        }
        if (DefaultEnvironment.isDigitalOcean()) {
            return ComputePlatform.DIGITAL_OCEAN;
        }
        return ComputePlatform.BARE_METAL;
    }

    private static boolean isGoogleCompute() {
        try {
            InetAddress.getByName(GOOGLE_COMPUTE_METADATA);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isOracleCloudLinux() {
        return DefaultEnvironment.readFile(ORACLE_CLOUD_ASSET_TAG_FILE).toLowerCase().contains("oraclecloud");
    }

    private static Optional<Process> runWindowsCmd(String cmd) {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("cmd.exe", "/c", cmd);
            builder.redirectErrorStream(true);
            builder.directory(new File(CachedEnvironment.getProperty("user.home")));
            Process process = builder.start();
            return Optional.of(process);
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }

    private static StringBuilder readProcessStream(Process process) {
        StringBuilder stdout = new StringBuilder();
        try {
            String line;
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                stdout.append(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stdout;
    }

    private static boolean isOracleCloudWindows() {
        Optional<Process> optionalProcess = DefaultEnvironment.runWindowsCmd(ORACLE_CLOUD_WINDOWS_ASSET_TAG_CMD);
        if (!optionalProcess.isPresent()) {
            return false;
        }
        Process process = optionalProcess.get();
        StringBuilder stdout = DefaultEnvironment.readProcessStream(process);
        try {
            int exitValue = process.waitFor();
            if (exitValue == 0 && stdout.toString().toLowerCase().contains("oraclecloud")) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    private static boolean isEC2Linux() {
        if (DefaultEnvironment.readFile(EC2_LINUX_HYPERVISOR_FILE).startsWith("ec2")) {
            return true;
        }
        return DefaultEnvironment.readFile(EC2_LINUX_BIOS_VENDOR_FILE).toLowerCase().startsWith("amazon ec2");
    }

    private static String readFile(String path) {
        try {
            Path pathPath = Paths.get(path, new String[0]);
            if (!Files.exists(pathPath, new LinkOption[0])) {
                return "";
            }
            return new String(Files.readAllBytes(pathPath)).trim();
        }
        catch (IOException e) {
            return "";
        }
    }

    private static boolean isEC2Windows() {
        Optional<Process> optionalProcess = DefaultEnvironment.runWindowsCmd(EC2_WINDOWS_HYPERVISOR_CMD);
        if (!optionalProcess.isPresent()) {
            return false;
        }
        Process process = optionalProcess.get();
        StringBuilder stdout = DefaultEnvironment.readProcessStream(process);
        try {
            int exitValue = process.waitFor();
            if (exitValue == 0 && stdout.toString().startsWith("EC2")) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    private static boolean isDigitalOcean() {
        return "digitalocean".equalsIgnoreCase(DefaultEnvironment.readFile(DO_SYS_VENDOR_FILE));
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close!", e);
        }
        this.stop();
    }

    private static class EnvironmentsAndPackage {
        String aPackage;
        Set<String> enviroments = new LinkedHashSet<String>(1);

        private EnvironmentsAndPackage() {
        }
    }
}

