/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfigurable;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DefaultConstructorInjectionPoint;
import io.micronaut.context.DefaultFieldConstructorInjectionPoint;
import io.micronaut.context.DefaultFieldInjectionPoint;
import io.micronaut.context.DefaultMethodConstructorInjectionPoint;
import io.micronaut.context.DefaultMethodInjectionPoint;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.ExpressionsAwareArgument;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.env.ConfigurationPath;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanInitializingEvent;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ExecutableMethodsDefinition;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InjectableBeanDefinition;
import io.micronaut.inject.InstantiatableBeanDefinition;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.EvaluatedAnnotationMetadata;
import io.micronaut.inject.qualifiers.InterceptorBindingQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.qualifiers.TypeAnnotationQualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractInitializableBeanDefinition<T>
extends AbstractBeanContextConditional
implements InstantiatableBeanDefinition<T>,
InjectableBeanDefinition<T>,
EnvironmentConfigurable,
BeanContextConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInitializableBeanDefinition.class);
    private static final Optional<Class<? extends Annotation>> SINGLETON_SCOPE = Optional.of(Singleton.class);
    private final Class<T> type;
    private final AnnotationMetadata annotationMetadata;
    private final PrecalculatedInfo precalculatedInfo;
    @Nullable
    private final MethodOrFieldReference constructor;
    @Nullable
    private final MethodReference[] methodInjection;
    @Nullable
    private final FieldReference[] fieldInjection;
    @Nullable
    private final ExecutableMethodsDefinition<T> executableMethodsDefinition;
    @Nullable
    private final Map<String, Argument<?>[]> typeArgumentsMap;
    @Nullable
    private AnnotationReference[] annotationInjection;
    @Nullable
    private Environment environment;
    @Nullable
    private Optional<Argument<?>> containerElement;
    @Nullable
    private ConstructorInjectionPoint<T> constructorInjectionPoint;
    @Nullable
    private List<MethodInjectionPoint<T, ?>> methodInjectionPoints;
    @Nullable
    private List<FieldInjectionPoint<T, ?>> fieldInjectionPoints;
    @Nullable
    private List<MethodInjectionPoint<T, ?>> postConstructMethods;
    @Nullable
    private List<MethodInjectionPoint<T, ?>> preDestroyMethods;
    @Nullable
    private Collection<Class<?>> requiredComponents;
    @Nullable
    private Argument<?>[] requiredParametrizedArguments;
    private Qualifier<T> declaredQualifier;

    @Internal
    protected AbstractInitializableBeanDefinition(Class<T> beanType, @Nullable MethodOrFieldReference constructor, @Nullable AnnotationMetadata annotationMetadata, @Nullable MethodReference[] methodInjection, @Nullable FieldReference[] fieldInjection, @Nullable AnnotationReference[] annotationInjection, @Nullable ExecutableMethodsDefinition<T> executableMethodsDefinition, @Nullable Map<String, Argument<?>[]> typeArgumentsMap, @NonNull PrecalculatedInfo precalculatedInfo) {
        this.type = beanType;
        if (annotationMetadata == null || annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
            this.annotationMetadata = AnnotationMetadata.EMPTY_METADATA;
        } else {
            AnnotationMetadata beanAnnotationMetadata = annotationMetadata;
            if (annotationMetadata.hasPropertyExpressions()) {
                beanAnnotationMetadata = new BeanAnnotationMetadata(annotationMetadata);
            }
            this.annotationMetadata = EvaluatedAnnotationMetadata.wrapIfNecessary(beanAnnotationMetadata);
        }
        this.constructor = constructor;
        this.methodInjection = methodInjection;
        this.fieldInjection = fieldInjection;
        this.annotationInjection = annotationInjection;
        this.executableMethodsDefinition = executableMethodsDefinition;
        this.typeArgumentsMap = typeArgumentsMap;
        this.precalculatedInfo = precalculatedInfo;
    }

    @Override
    public final boolean isConfigurationProperties() {
        return this.precalculatedInfo.isConfigurationProperties;
    }

    @Override
    public Qualifier<T> getDeclaredQualifier() {
        if (this.declaredQualifier == null) {
            this.declaredQualifier = InstantiatableBeanDefinition.super.getDeclaredQualifier();
        }
        return this.declaredQualifier;
    }

    @Override
    public final boolean isContainerType() {
        return this.precalculatedInfo.isContainerType;
    }

    @Override
    public final Optional<Argument<?>> getContainerElement() {
        if (this.precalculatedInfo.isContainerType) {
            if (this.containerElement != null) {
                return this.containerElement;
            }
            if (this.getBeanType().isArray()) {
                this.containerElement = Optional.of(Argument.of(this.getBeanType().getComponentType()));
            } else {
                List iterableArguments = this.getTypeArguments(Iterable.class);
                if (!iterableArguments.isEmpty()) {
                    this.containerElement = Optional.of((Argument)iterableArguments.iterator().next());
                }
            }
            return this.containerElement;
        }
        return Optional.empty();
    }

    @Override
    public final boolean hasPropertyExpressions() {
        return this.getAnnotationMetadata().hasPropertyExpressions();
    }

    public boolean hasEvaluatedExpressions() {
        return this.precalculatedInfo.hasEvaluatedExpressions();
    }

    @Override
    @NonNull
    public final List<Argument<?>> getTypeArguments(String type) {
        if (type == null || this.typeArgumentsMap == null) {
            return Collections.emptyList();
        }
        Argument<?>[] arguments = this.typeArgumentsMap.get(type);
        if (arguments != null) {
            return Arrays.asList(arguments);
        }
        return Collections.emptyList();
    }

    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public boolean isAbstract() {
        return this.precalculatedInfo.isAbstract;
    }

    @Override
    public boolean isIterable() {
        return this.precalculatedInfo.isIterable;
    }

    @Override
    public boolean isPrimary() {
        return this.precalculatedInfo.isPrimary;
    }

    @Override
    public boolean requiresMethodProcessing() {
        return this.precalculatedInfo.requiresMethodProcessing;
    }

    @Override
    public final <R> Optional<ExecutableMethod<T, R>> findMethod(String name, Class<?> ... argumentTypes) {
        if (this.executableMethodsDefinition == null) {
            return Optional.empty();
        }
        return this.executableMethodsDefinition.findMethod(name, argumentTypes);
    }

    @Override
    public final <R> Stream<ExecutableMethod<T, R>> findPossibleMethods(String name) {
        if (this.executableMethodsDefinition == null) {
            return Stream.empty();
        }
        return this.executableMethodsDefinition.findPossibleMethods(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        Class declaringType = this.constructor == null ? this.type : this.constructor.declaringType;
        return "Definition: " + declaringType.getName();
    }

    @Override
    public boolean isSingleton() {
        return this.precalculatedInfo.isSingleton;
    }

    @Override
    public final Optional<Class<? extends Annotation>> getScope() {
        return this.precalculatedInfo.scope.flatMap(scopeClassName -> {
            if (Singleton.class.getName().equals(scopeClassName)) {
                return SINGLETON_SCOPE;
            }
            return ClassUtils.forName((String)scopeClassName, (ClassLoader)this.getClass().getClassLoader());
        });
    }

    @Override
    public final Optional<String> getScopeName() {
        return this.precalculatedInfo.scope;
    }

    @Override
    public final Class<T> getBeanType() {
        return this.type;
    }

    @Override
    @NonNull
    public Set<Class<?>> getExposedTypes() {
        return Collections.EMPTY_SET;
    }

    @Override
    public final Optional<Class<?>> getDeclaringType() {
        if (this.constructor == null) {
            return Optional.of(this.type);
        }
        return Optional.of(this.constructor.declaringType);
    }

    @Override
    public final ConstructorInjectionPoint<T> getConstructor() {
        if (this.constructorInjectionPoint != null) {
            return this.constructorInjectionPoint;
        }
        if (this.constructor == null) {
            DefaultConstructorInjectionPoint<T> point = new DefaultConstructorInjectionPoint<T>(this, this.getBeanType(), AnnotationMetadata.EMPTY_METADATA, Argument.ZERO_ARGUMENTS);
            if (this.environment != null) {
                point.configure(this.environment);
            }
            this.constructorInjectionPoint = point;
        } else {
            Object point = this.constructor;
            if (point instanceof MethodReference) {
                MethodReference methodConstructor = (MethodReference)point;
                if ("<init>".equals(methodConstructor.methodName)) {
                    point = new DefaultConstructorInjectionPoint(this, methodConstructor.declaringType, methodConstructor.annotationMetadata, methodConstructor.arguments);
                    if (this.environment != null) {
                        ((DefaultConstructorInjectionPoint)point).configure(this.environment);
                    }
                    this.constructorInjectionPoint = point;
                } else {
                    point = new DefaultMethodConstructorInjectionPoint(this, (Class<?>)methodConstructor.declaringType, methodConstructor.methodName, (Argument<?>[])methodConstructor.arguments, methodConstructor.annotationMetadata);
                    if (this.environment != null) {
                        ((DefaultMethodInjectionPoint)point).configure(this.environment);
                    }
                    this.constructorInjectionPoint = point;
                }
            } else {
                point = this.constructor;
                if (point instanceof FieldReference) {
                    FieldReference fieldConstructor = (FieldReference)point;
                    point = new DefaultFieldConstructorInjectionPoint<T>(this, fieldConstructor.declaringType, this.type, fieldConstructor.argument.getName(), fieldConstructor.argument.getAnnotationMetadata());
                    if (this.environment != null) {
                        ((DefaultFieldInjectionPoint)point).configure(this.environment);
                    }
                    this.constructorInjectionPoint = point;
                }
            }
        }
        return this.constructorInjectionPoint;
    }

    @Override
    public final Collection<Class<?>> getRequiredComponents() {
        Argument[] argumentArray;
        if (this.requiredComponents != null) {
            return this.requiredComponents;
        }
        HashSet requiredComponents = new HashSet();
        Consumer<Argument> argumentConsumer = argument -> {
            if (!argument.isContainerType() && !argument.isProvider()) {
                requiredComponents.add(argument.getType());
                return;
            }
            argument.getFirstTypeVariable().map(TypeInformation::getType).ifPresent(requiredComponents::add);
        };
        if (this.constructor != null && (argumentArray = this.constructor) instanceof MethodReference) {
            MethodReference methodConstructor = (MethodReference)argumentArray;
            if (methodConstructor.arguments != null && methodConstructor.arguments.length > 0) {
                argumentArray = methodConstructor.arguments;
                int n = argumentArray.length;
                for (int i = 0; i < n; ++i) {
                    Argument argument2 = argumentArray[i];
                    argumentConsumer.accept(argument2);
                }
            }
        }
        if (this.methodInjection != null) {
            for (MethodReference methodReference : this.methodInjection) {
                if (!methodReference.annotationMetadata.hasDeclaredAnnotation("jakarta.inject.Inject") || methodReference.arguments == null || methodReference.arguments.length <= 0) continue;
                for (Argument argument3 : methodReference.arguments) {
                    argumentConsumer.accept(argument3);
                }
            }
        }
        if (this.fieldInjection != null) {
            for (FieldReference fieldReference : this.fieldInjection) {
                if (this.annotationMetadata == null || !this.annotationMetadata.hasDeclaredAnnotation("jakarta.inject.Inject")) continue;
                argumentConsumer.accept(fieldReference.argument);
            }
        }
        if (this.annotationInjection != null) {
            for (AnnotationReference annotationReference : this.annotationInjection) {
                if (annotationReference.argument == null) continue;
                argumentConsumer.accept(annotationReference.argument);
            }
        }
        this.requiredComponents = Collections.unmodifiableSet(requiredComponents);
        return this.requiredComponents;
    }

    @Override
    public final List<MethodInjectionPoint<T, ?>> getInjectedMethods() {
        if (this.methodInjection == null) {
            return Collections.emptyList();
        }
        if (this.methodInjectionPoints != null) {
            return this.methodInjectionPoints;
        }
        ArrayList methodInjectionPoints = new ArrayList(this.methodInjection.length);
        for (MethodReference methodReference : this.methodInjection) {
            DefaultMethodInjectionPoint methodInjectionPoint = new DefaultMethodInjectionPoint(this, methodReference.declaringType, methodReference.methodName, methodReference.arguments, methodReference.annotationMetadata);
            methodInjectionPoints.add(methodInjectionPoint);
            if (this.environment == null) continue;
            ((EnvironmentConfigurable)methodInjectionPoint).configure(this.environment);
        }
        this.methodInjectionPoints = Collections.unmodifiableList(methodInjectionPoints);
        return this.methodInjectionPoints;
    }

    @Override
    public final List<FieldInjectionPoint<T, ?>> getInjectedFields() {
        if (this.fieldInjection == null) {
            return Collections.emptyList();
        }
        if (this.fieldInjectionPoints != null) {
            return this.fieldInjectionPoints;
        }
        ArrayList fieldInjectionPoints = new ArrayList(this.fieldInjection.length);
        for (FieldReference fieldReference : this.fieldInjection) {
            DefaultFieldInjectionPoint fieldInjectionPoint = new DefaultFieldInjectionPoint(this, fieldReference.declaringType, fieldReference.argument.getType(), fieldReference.argument.getName(), fieldReference.argument.getAnnotationMetadata(), fieldReference.argument.getTypeParameters());
            if (this.environment != null) {
                ((EnvironmentConfigurable)fieldInjectionPoint).configure(this.environment);
            }
            fieldInjectionPoints.add(fieldInjectionPoint);
        }
        this.fieldInjectionPoints = Collections.unmodifiableList(fieldInjectionPoints);
        return this.fieldInjectionPoints;
    }

    @Override
    public final List<MethodInjectionPoint<T, ?>> getPostConstructMethods() {
        if (this.methodInjection == null) {
            return Collections.emptyList();
        }
        if (this.postConstructMethods != null) {
            return this.postConstructMethods;
        }
        ArrayList<MethodInjectionPoint> postConstructMethods = new ArrayList<MethodInjectionPoint>(1);
        for (MethodInjectionPoint methodInjectionPoint : this.getInjectedMethods()) {
            if (!methodInjectionPoint.isPostConstructMethod()) continue;
            postConstructMethods.add(methodInjectionPoint);
        }
        this.postConstructMethods = Collections.unmodifiableList(postConstructMethods);
        return this.postConstructMethods;
    }

    @Override
    public final List<MethodInjectionPoint<T, ?>> getPreDestroyMethods() {
        if (this.methodInjection == null) {
            return Collections.emptyList();
        }
        if (this.preDestroyMethods != null) {
            return this.preDestroyMethods;
        }
        ArrayList<MethodInjectionPoint> preDestroyMethods = new ArrayList<MethodInjectionPoint>(1);
        for (MethodInjectionPoint methodInjectionPoint : this.getInjectedMethods()) {
            if (!methodInjectionPoint.isPreDestroyMethod()) continue;
            preDestroyMethods.add(methodInjectionPoint);
        }
        this.preDestroyMethods = Collections.unmodifiableList(preDestroyMethods);
        return this.preDestroyMethods;
    }

    @Override
    @NonNull
    public final String getName() {
        return this.getBeanType().getName();
    }

    @Override
    public T inject(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
        return bean;
    }

    @Override
    public final Collection<ExecutableMethod<T, ?>> getExecutableMethods() {
        if (this.executableMethodsDefinition == null) {
            return Collections.emptyList();
        }
        return this.executableMethodsDefinition.getExecutableMethods();
    }

    @Override
    @Internal
    public final void configure(Environment environment) {
        if (environment != null) {
            ExecutableMethodsDefinition<T> executableMethodsDefinition;
            EnvironmentConfigurable environmentConfigurable;
            this.environment = environment;
            ConstructorInjectionPoint<T> constructorInjectionPoint = this.constructorInjectionPoint;
            if (constructorInjectionPoint instanceof EnvironmentConfigurable) {
                Iterator<FieldInjectionPoint<T, ?>> environmentConfigurable2 = (EnvironmentConfigurable)((Object)constructorInjectionPoint);
                environmentConfigurable2.configure(environment);
            }
            if (this.methodInjectionPoints != null) {
                for (MethodInjectionPoint methodInjectionPoint : this.methodInjectionPoints) {
                    if (!(methodInjectionPoint instanceof EnvironmentConfigurable)) continue;
                    environmentConfigurable = (EnvironmentConfigurable)((Object)methodInjectionPoint);
                    environmentConfigurable.configure(environment);
                }
            }
            if (this.fieldInjectionPoints != null) {
                for (FieldInjectionPoint<T, ?> fieldInjectionPoint : this.fieldInjectionPoints) {
                    if (!(fieldInjectionPoint instanceof EnvironmentConfigurable)) continue;
                    environmentConfigurable = (EnvironmentConfigurable)((Object)fieldInjectionPoint);
                    environmentConfigurable.configure(environment);
                }
            }
            if ((executableMethodsDefinition = this.executableMethodsDefinition) instanceof EnvironmentConfigurable) {
                EnvironmentConfigurable environmentConfigurable2 = (EnvironmentConfigurable)((Object)executableMethodsDefinition);
                environmentConfigurable2.configure(environment);
            }
        }
    }

    @Override
    public void configure(BeanContext beanContext) {
        ExecutableMethodsDefinition<T> executableMethodsDefinition;
        AnnotationMetadata annotationMetadata;
        Object eam;
        if (beanContext == null || !this.hasEvaluatedExpressions()) {
            return;
        }
        AnnotationMetadata object = this.annotationMetadata;
        if (object instanceof EvaluatedAnnotationMetadata) {
            eam = (MethodReference[])object;
            ((EvaluatedAnnotationMetadata)eam).configure(beanContext);
            ((EvaluatedAnnotationMetadata)eam).setBeanDefinition(this);
        }
        if (this.constructor != null) {
            MethodOrFieldReference methodOrFieldReference;
            MethodOrFieldReference methodOrFieldReference2 = this.constructor;
            if (methodOrFieldReference2 instanceof MethodReference) {
                MethodReference mr = (MethodReference)methodOrFieldReference2;
                methodOrFieldReference = mr.annotationMetadata;
                if (methodOrFieldReference instanceof EvaluatedAnnotationMetadata) {
                    EvaluatedAnnotationMetadata evaluatedAnnotationMetadata = (EvaluatedAnnotationMetadata)((Object)methodOrFieldReference);
                    evaluatedAnnotationMetadata.configure(beanContext);
                    evaluatedAnnotationMetadata.setBeanDefinition(this);
                }
                if (mr.arguments != null) {
                    for (Argument argument : mr.arguments) {
                        if (!(argument instanceof ExpressionsAwareArgument)) continue;
                        ExpressionsAwareArgument exprArg2 = (ExpressionsAwareArgument)argument;
                        exprArg2.configure(beanContext);
                        exprArg2.setBeanDefinition(this);
                    }
                }
            }
            if ((methodOrFieldReference = this.constructor) instanceof FieldReference) {
                FieldReference fr = (FieldReference)methodOrFieldReference;
                methodOrFieldReference = fr.argument;
                if (methodOrFieldReference instanceof ExpressionsAwareArgument) {
                    ExpressionsAwareArgument expressionsAwareArgument = (ExpressionsAwareArgument)((Object)methodOrFieldReference);
                    expressionsAwareArgument.configure(beanContext);
                    expressionsAwareArgument.setBeanDefinition(this);
                }
            }
        }
        if (this.constructorInjectionPoint != null && (annotationMetadata = this.constructorInjectionPoint.getAnnotationMetadata()) instanceof EvaluatedAnnotationMetadata) {
            eam = (EvaluatedAnnotationMetadata)annotationMetadata;
            ((EvaluatedAnnotationMetadata)eam).configure(beanContext);
            ((EvaluatedAnnotationMetadata)eam).setBeanDefinition(this);
        }
        if (this.methodInjection != null) {
            for (MethodReference methodReference : this.methodInjection) {
                AnnotationMetadata annotationMetadata2 = methodReference.annotationMetadata;
                if (annotationMetadata2 instanceof EvaluatedAnnotationMetadata) {
                    Argument[] eam3 = (Argument[])annotationMetadata2;
                    eam3.configure(beanContext);
                    eam3.setBeanDefinition(this);
                }
                if (methodReference.arguments == null) continue;
                for (Argument argument : methodReference.arguments) {
                    if (!(argument instanceof ExpressionsAwareArgument)) continue;
                    ExpressionsAwareArgument exprArg3 = (ExpressionsAwareArgument)argument;
                    exprArg3.configure(beanContext);
                    exprArg3.setBeanDefinition(this);
                }
            }
        }
        if (this.methodInjectionPoints != null) {
            for (MethodInjectionPoint methodInjectionPoint : this.methodInjectionPoints) {
                AnnotationMetadata methodReference = methodInjectionPoint.getAnnotationMetadata();
                if (!(methodReference instanceof EvaluatedAnnotationMetadata)) continue;
                EvaluatedAnnotationMetadata eam4 = (EvaluatedAnnotationMetadata)methodReference;
                eam4.configure(beanContext);
                eam4.setBeanDefinition(this);
            }
        }
        if (this.fieldInjection != null) {
            for (FieldReference fieldReference : this.fieldInjection) {
                Argument argument = fieldReference.argument;
                if (!(argument instanceof ExpressionsAwareArgument)) continue;
                ExpressionsAwareArgument exprArg4 = (ExpressionsAwareArgument)argument;
                exprArg4.configure(beanContext);
                exprArg4.setBeanDefinition(this);
            }
        }
        if (this.fieldInjectionPoints != null) {
            for (FieldInjectionPoint fieldInjectionPoint : this.fieldInjectionPoints) {
                AnnotationMetadata annotationMetadata3 = fieldInjectionPoint.getAnnotationMetadata();
                if (!(annotationMetadata3 instanceof EvaluatedAnnotationMetadata)) continue;
                EvaluatedAnnotationMetadata eam5 = (EvaluatedAnnotationMetadata)annotationMetadata3;
                eam5.configure(beanContext);
                eam5.setBeanDefinition(this);
            }
        }
        if ((executableMethodsDefinition = this.executableMethodsDefinition) instanceof BeanContextConfigurable) {
            BeanContextConfigurable ctxConfigurable = (BeanContextConfigurable)((Object)executableMethodsDefinition);
            ctxConfigurable.configure(beanContext);
        }
    }

    @Internal
    protected final void warn(String message) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(message);
        }
    }

    @Internal
    protected final void warnMissingProperty(Class type, String method, String property) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Configuration property [{}] could not be set as the underlying method [{}] does not exist on builder [{}]. This usually indicates the configuration option was deprecated and has been removed by the builder implementation (potentially a third-party library).", new Object[]{property, method, type});
        }
    }

    public final Argument<?>[] getRequiredArguments() {
        if (this.requiredParametrizedArguments != null) {
            return this.requiredParametrizedArguments;
        }
        ConstructorInjectionPoint<T> ctor = this.getConstructor();
        this.requiredParametrizedArguments = ctor != null ? (Argument[])Arrays.stream(ctor.getArguments()).filter(arg -> {
            Optional qualifierType = AnnotationUtil.findQualifierAnnotation((AnnotationMetadata)arg.getAnnotationMetadata());
            return qualifierType.isPresent() && ((String)qualifierType.get()).equals(Parameter.class.getName());
        }).toArray(Argument[]::new) : Argument.ZERO_ARGUMENTS;
        return this.requiredParametrizedArguments;
    }

    public final T instantiate(BeanResolutionContext resolutionContext, BeanContext context, Map<String, Object> requiredArgumentValues) throws BeanInstantiationException {
        requiredArgumentValues = requiredArgumentValues != null ? new LinkedHashMap<String, Object>(requiredArgumentValues) : Collections.emptyMap();
        Optional eachBeanType = null;
        for (Argument<?> requiredArgument : this.getRequiredArguments()) {
            try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, requiredArgument);){
                boolean requiresConversion;
                String argumentName = requiredArgument.getName();
                Object value = requiredArgumentValues.get(argumentName);
                if (value == null && !requiredArgument.isNullable()) {
                    if (eachBeanType == null) {
                        eachBeanType = this.classValue(EachBean.class);
                    }
                    if (eachBeanType.filter(type -> type == requiredArgument.getType()).isPresent()) {
                        throw new DisabledBeanException("@EachBean parameter disabled for argument: " + requiredArgument.getName());
                    }
                    throw new BeanInstantiationException(resolutionContext, "Missing bean argument value: " + argumentName);
                }
                boolean bl = requiresConversion = value != null && !requiredArgument.getType().isInstance(value);
                if (!requiresConversion) continue;
                Optional converted = context.getConversionService().convert(value, requiredArgument.getType(), (ConversionContext)ConversionContext.of(requiredArgument));
                Object finalValue = value;
                value = converted.orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid value [" + finalValue + "] for argument: " + argumentName));
                requiredArgumentValues.put(argumentName, value);
            }
        }
        return this.doInstantiate(resolutionContext, context, requiredArgumentValues);
    }

    @Internal
    protected T doInstantiate(BeanResolutionContext resolutionContext, BeanContext context, Map<String, Object> requiredArgumentValues) {
        throw new IllegalStateException("Method must be implemented for 'ParametrizedInstantiatableBeanDefinition' instance!");
    }

    @Internal
    protected Object postConstruct(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        List<Map.Entry<Class<?>, DefaultBeanContext.ListenersSupplier<BeanInitializedEventListener>>> beanInitializedEventListeners = ((DefaultBeanContext)context).beanInitializedEventListeners;
        if (CollectionUtils.isNotEmpty(beanInitializedEventListeners)) {
            for (Map.Entry<Class<?>, DefaultBeanContext.ListenersSupplier<BeanInitializedEventListener>> entry : beanInitializedEventListeners) {
                if (!entry.getKey().isAssignableFrom(this.getBeanType())) continue;
                for (BeanInitializedEventListener listener : entry.getValue().get(resolutionContext)) {
                    bean = listener.onInitialized(new BeanInitializingEvent<Object>(context, this, bean));
                    if (bean != null) continue;
                    throw new BeanInstantiationException(resolutionContext, "Listener [" + listener + "] returned null from onInitialized event");
                }
            }
        }
        if (bean instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)bean;
            bean = lifeCycle.start();
        }
        return bean;
    }

    @Internal
    protected Object preDestroy(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        if (bean instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)bean;
            bean = lifeCycle.stop();
        }
        return bean;
    }

    @Internal
    protected boolean isInnerConfiguration(Class<?> clazz) {
        return false;
    }

    @Internal
    protected void checkIfShouldLoad(BeanResolutionContext resolutionContext, BeanContext context) {
    }

    @Internal
    protected final void checkInjectedBeanPropertyValue(String injectedBeanPropertyName, @Nullable Object beanPropertyValue, @Nullable String requiredValue, @Nullable String notEqualsValue) {
        String convertedValue;
        if (beanPropertyValue instanceof Optional) {
            Optional optional = (Optional)beanPropertyValue;
            beanPropertyValue = optional.orElse(null);
        }
        if ((convertedValue = (String)ConversionService.SHARED.convert(beanPropertyValue, String.class).orElse(null)) == null && notEqualsValue == null) {
            throw new DisabledBeanException("Bean [" + this.getBeanType() + "] is disabled since required bean property [" + injectedBeanPropertyName + "] id not set");
        }
        if (convertedValue != null) {
            if (requiredValue != null && !convertedValue.equals(requiredValue)) {
                throw new DisabledBeanException("Bean [" + this.getBeanType() + "] is disabled since bean property [" + injectedBeanPropertyName + "] value is not equal to [" + requiredValue + "]");
            }
            if (requiredValue == null && convertedValue.equals(notEqualsValue)) {
                throw new DisabledBeanException("Bean [" + this.getBeanType() + "] is disabled since bean property [" + injectedBeanPropertyName + "] value is equal to [" + notEqualsValue + "]");
            }
        }
    }

    @Internal
    protected final void invokeMethodWithReflection(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, Object bean, Object[] methodArgs) {
        Argument[] methodArgumentTypes;
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument[] argumentArray = methodArgumentTypes = methodRef.arguments == null ? Argument.ZERO_ARGUMENTS : methodRef.arguments;
        if (ClassUtils.REFLECTION_LOGGER.isDebugEnabled()) {
            ClassUtils.REFLECTION_LOGGER.debug("Bean of type [" + this.getBeanType() + "] uses reflection to inject method: '" + methodRef.methodName + "'");
        }
        try {
            Method method = (Method)ReflectionUtils.getMethod((Class)methodRef.declaringType, (String)methodRef.methodName, (Class[])Argument.toClassArray((Argument[])methodArgumentTypes)).orElseThrow(() -> ReflectionUtils.newNoSuchMethodError((Class)methodRef.declaringType, (String)methodRef.methodName, (Class[])Argument.toClassArray((Argument[])methodArgumentTypes)));
            method.setAccessible(true);
            ReflectionUtils.invokeMethod((Object)bean, (Method)method, (Object[])methodArgs);
        }
        catch (Throwable e) {
            if (e instanceof BeanContextException) {
                BeanContextException exception = (BeanContextException)e;
                throw exception;
            }
            throw new DependencyInjectionException(resolutionContext, "Error invoking method: " + methodRef.methodName, e);
        }
    }

    @Internal
    protected final void setFieldWithReflection(BeanResolutionContext resolutionContext, BeanContext context, int index, Object object, Object value) {
        FieldReference fieldRef = this.fieldInjection[index];
        try {
            if (ClassUtils.REFLECTION_LOGGER.isDebugEnabled()) {
                ClassUtils.REFLECTION_LOGGER.debug("Bean of type [" + this.getBeanType() + "] uses reflection to inject field: '" + fieldRef.argument.getName() + "'");
            }
            Field field = ReflectionUtils.getRequiredField((Class)fieldRef.declaringType, (String)fieldRef.argument.getName());
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Throwable e) {
            if (e instanceof BeanContextException) {
                BeanContextException exception = (BeanContextException)e;
                throw exception;
            }
            throw new DependencyInjectionException(resolutionContext, "Error setting field value: " + e.getMessage(), e);
        }
    }

    @Internal
    @Deprecated
    protected final Object getValueForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, Qualifier qualifier) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument argument = methodRef.arguments[argIndex];
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            Object object = this.resolveValue(resolutionContext, context, methodRef.annotationMetadata, argument, qualifier);
            return object;
        }
    }

    @Internal
    protected final Object getPropertyValueForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, String propertyValue, String cliProperty) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument argument = methodRef.arguments[argIndex];
        try (BeanResolutionContext.Path path = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            Object val = this.resolvePropertyValue(resolutionContext, context, argument, propertyValue, cliProperty, false);
            AbstractInitializableBeanDefinition abstractInitializableBeanDefinition = this;
            if (abstractInitializableBeanDefinition instanceof ValidatedBeanDefinition) {
                ValidatedBeanDefinition validatedBeanDefinition = (ValidatedBeanDefinition)((Object)abstractInitializableBeanDefinition);
                validatedBeanDefinition.validateBeanArgument(resolutionContext, Objects.requireNonNull((BeanResolutionContext.Segment)path.peek()).getInjectionPoint(), argument, argIndex, val);
            }
            Object object = val;
            return object;
        }
    }

    @Internal
    protected final Object getPropertyPlaceholderValueForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, String value) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument argument = methodRef.arguments[argIndex];
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            Object object = this.resolvePropertyValue(resolutionContext, context, argument, value, null, true);
            return object;
        }
    }

    @Internal
    protected final Object getEvaluatedExpressionValueForMethodArgument(int methodIndex, int argIndex) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument argument = methodRef.arguments[argIndex];
        return this.getExpressionValueForArgument(argument);
    }

    @Internal
    protected final Object getPropertyValueForSetter(BeanResolutionContext resolutionContext, BeanContext context, String setterName, Argument<?> argument, String propertyValue, String cliProperty) {
        try (BeanResolutionContext.Path path = resolutionContext.getPath().pushMethodArgumentResolve(this, setterName, argument, new Argument[]{argument});){
            Object val = this.resolvePropertyValue(resolutionContext, context, argument, propertyValue, cliProperty, false);
            AbstractInitializableBeanDefinition abstractInitializableBeanDefinition = this;
            if (abstractInitializableBeanDefinition instanceof ValidatedBeanDefinition) {
                ValidatedBeanDefinition validatedBeanDefinition = (ValidatedBeanDefinition)((Object)abstractInitializableBeanDefinition);
                validatedBeanDefinition.validateBeanArgument(resolutionContext, Objects.requireNonNull((BeanResolutionContext.Segment)path.peek()).getInjectionPoint(), argument, 0, val);
            }
            Object object = val;
            return object;
        }
    }

    @Internal
    protected final Object getPropertyPlaceholderValueForSetter(BeanResolutionContext resolutionContext, BeanContext context, String setterName, Argument<?> argument, String value) {
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, setterName, argument, new Argument[]{argument});){
            Object object = this.resolvePropertyValue(resolutionContext, context, argument, value, null, true);
            return object;
        }
    }

    @Internal
    @Deprecated
    protected final boolean containsValueForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, boolean isValuePrefix) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        AnnotationMetadata parentAnnotationMetadata = methodRef.annotationMetadata;
        Argument argument = methodRef.arguments[argIndex];
        return this.resolveContainsValue(resolutionContext, context, parentAnnotationMetadata, argument, isValuePrefix);
    }

    @Internal
    protected final <K> K getBeanForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, Qualifier<K> qualifier) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument<K> argument = this.resolveArgument(context, argIndex, methodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            K k = this.resolveBean(resolutionContext, argument, qualifier);
            return k;
        }
    }

    @Internal
    protected final <K, R extends Collection<K>> R getBeansOfTypeForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argumentIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument<K> argument = this.resolveArgument(context, argumentIndex, methodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            K k = this.resolveBeansOfType(resolutionContext, context, argument, this.resolveArgument(context, genericType), qualifier);
            return (R)k;
        }
    }

    @Internal
    protected final Object getBeanForSetter(BeanResolutionContext resolutionContext, BeanContext context, String setterName, Argument argument, Qualifier qualifier) {
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, setterName, argument, new Argument[]{argument});){
            Object k = this.resolveBean(resolutionContext, argument, qualifier);
            return k;
        }
    }

    @Internal
    protected final Collection<Object> getBeansOfTypeForSetter(BeanResolutionContext resolutionContext, BeanContext context, String setterName, Argument argument, Argument genericType, Qualifier qualifier) {
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, setterName, argument, new Argument[]{argument});){
            Object r = this.resolveBeansOfType(resolutionContext, context, argument, this.resolveArgument(context, genericType), qualifier);
            return r;
        }
    }

    @Internal
    protected final <K> Optional<K> findBeanForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument<K> argument = this.resolveArgument(context, argIndex, methodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            Optional<K> optional = this.resolveOptionalBean(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return optional;
        }
    }

    @Internal
    protected final Stream<?> getStreamOfTypeForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, Argument genericType, Qualifier qualifier) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument argument = this.resolveArgument(context, argIndex, methodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            Stream stream = this.resolveStreamOfType(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return stream;
        }
    }

    @Internal
    protected final <V> Map<String, V> getMapOfTypeForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, Argument<V> genericType, Qualifier<V> qualifier) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument argument = this.resolveArgument(context, argIndex, methodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            Map<String, V> map = this.resolveMapOfType(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return map;
        }
    }

    @Internal
    protected final Object getBeanForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex, Qualifier qualifier) {
        BeanResolutionContext.Segment current;
        MethodReference constructorMethodRef = (MethodReference)this.constructor;
        Argument argument = this.resolveArgument(context, argIndex, constructorMethodRef.arguments);
        if (argument != null && argument.isDeclaredNullable() && (current = (BeanResolutionContext.Segment)resolutionContext.getPath().peek()) != null && current.getArgument().equals(argument)) {
            return null;
        }
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);){
            Object k = this.resolveBean(resolutionContext, argument, qualifier);
            return k;
        }
    }

    @Internal
    @Deprecated
    protected final Object getValueForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex, Qualifier qualifier) {
        MethodReference constructorRef = (MethodReference)this.constructor;
        Argument argument = constructorRef.arguments[argIndex];
        BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);
        try {
            Object result = this.resolveValue(resolutionContext, context, constructorRef.annotationMetadata, argument, qualifier);
            AbstractInitializableBeanDefinition abstractInitializableBeanDefinition = this;
            if (abstractInitializableBeanDefinition instanceof ValidatedBeanDefinition) {
                ValidatedBeanDefinition validatedBeanDefinition = (ValidatedBeanDefinition)((Object)abstractInitializableBeanDefinition);
                validatedBeanDefinition.validateBeanArgument(resolutionContext, this.getConstructor(), argument, argIndex, result);
            }
            Object object = result;
            return object;
        }
        catch (BeanInstantiationException | NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
        finally {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Internal
    protected final Object getPropertyValueForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex, String propertyValue, String cliProperty) {
        MethodReference constructorRef = (MethodReference)this.constructor;
        Argument argument = constructorRef.arguments[argIndex];
        BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);
        try {
            Object result = this.resolvePropertyValue(resolutionContext, context, argument, propertyValue, cliProperty, false);
            AbstractInitializableBeanDefinition abstractInitializableBeanDefinition = this;
            if (abstractInitializableBeanDefinition instanceof ValidatedBeanDefinition) {
                ValidatedBeanDefinition validatedBeanDefinition = (ValidatedBeanDefinition)((Object)abstractInitializableBeanDefinition);
                validatedBeanDefinition.validateBeanArgument(resolutionContext, this.getConstructor(), argument, argIndex, result);
            }
            Object object = result;
            return object;
        }
        catch (BeanInstantiationException | NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
        finally {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Internal
    protected final Object getEvaluatedExpressionValueForConstructorArgument(int argIndex) {
        MethodReference constructorRef = (MethodReference)this.constructor;
        Argument argument = constructorRef.arguments[argIndex];
        return this.getExpressionValueForArgument(argument);
    }

    @Internal
    protected final Object getPropertyPlaceholderValueForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex, String propertyValue) {
        MethodReference constructorRef = (MethodReference)this.constructor;
        Argument argument = constructorRef.arguments[argIndex];
        BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);
        try {
            Object result = this.resolvePropertyValue(resolutionContext, context, argument, propertyValue, null, true);
            AbstractInitializableBeanDefinition abstractInitializableBeanDefinition = this;
            if (abstractInitializableBeanDefinition instanceof ValidatedBeanDefinition) {
                ValidatedBeanDefinition validatedBeanDefinition = (ValidatedBeanDefinition)((Object)abstractInitializableBeanDefinition);
                validatedBeanDefinition.validateBeanArgument(resolutionContext, this.getConstructor(), argument, argIndex, result);
            }
            Object object = result;
            return object;
        }
        catch (BeanInstantiationException | NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
        finally {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Internal
    protected final Collection<Object> getBeansOfTypeForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argumentIndex, Argument genericType, Qualifier qualifier) {
        MethodReference constructorMethodRef = (MethodReference)this.constructor;
        Argument argument = this.resolveArgument(context, argumentIndex, constructorMethodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);){
            Object k = this.resolveBeansOfType(resolutionContext, context, argument, this.resolveArgument(context, genericType), qualifier);
            return k;
        }
    }

    @Internal
    protected final <K, R extends Collection<BeanRegistration<K>>> R getBeanRegistrationsForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argumentIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        MethodReference constructorMethodRef = (MethodReference)this.constructor;
        Argument<K> argument = this.resolveArgument(context, argumentIndex, constructorMethodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);){
            K k = this.resolveBeanRegistrations(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return (R)k;
        }
    }

    @Internal
    protected final <K> BeanRegistration<K> getBeanRegistrationForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argumentIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        MethodReference constructorMethodRef = (MethodReference)this.constructor;
        Argument<K> argument = this.resolveArgument(context, argumentIndex, constructorMethodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);){
            BeanRegistration<K> beanRegistration = this.resolveBeanRegistration(resolutionContext, context, argument, this.resolveArgument(context, genericType), qualifier);
            return beanRegistration;
        }
    }

    @Internal
    protected final <K, R extends Collection<BeanRegistration<K>>> R getBeanRegistrationsForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        MethodReference methodReference = this.methodInjection[methodIndex];
        Argument<K> argument = this.resolveArgument(context, argIndex, methodReference.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodReference.methodName, argument, methodReference.arguments);){
            K k = this.resolveBeanRegistrations(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return (R)k;
        }
    }

    @Internal
    protected final <K> BeanRegistration<K> getBeanRegistrationForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        MethodReference methodRef = this.methodInjection[methodIndex];
        Argument<K> argument = this.resolveArgument(context, argIndex, methodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushMethodArgumentResolve(this, methodRef.methodName, argument, methodRef.arguments);){
            BeanRegistration<K> beanRegistration = this.resolveBeanRegistration(resolutionContext, context, argument, this.resolveArgument(context, genericType), qualifier);
            return beanRegistration;
        }
    }

    @Internal
    protected final <K> Stream<K> getStreamOfTypeForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        MethodReference constructorMethodRef = (MethodReference)this.constructor;
        Argument<K> argument = this.resolveArgument(context, argIndex, constructorMethodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);){
            Stream<K> stream = this.resolveStreamOfType(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return stream;
        }
    }

    @Internal
    protected final <V> Map<String, V> getMapOfTypeForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex, Argument<V> genericType, Qualifier<V> qualifier) {
        MethodReference constructorMethodRef = (MethodReference)this.constructor;
        if (constructorMethodRef == null) {
            throw new IllegalStateException("No constructor found for bean: " + this.getBeanType());
        }
        Argument argument = this.resolveArgument(context, argIndex, constructorMethodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);){
            Map<String, V> map = this.resolveMapOfType(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return map;
        }
    }

    @Internal
    protected final <K> Optional<K> findBeanForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        MethodReference constructorMethodRef = (MethodReference)this.constructor;
        Argument<K> argument = this.resolveArgument(context, argIndex, constructorMethodRef.arguments);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(this, argument);){
            Optional<K> optional = this.resolveOptionalBean(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return optional;
        }
    }

    @Internal
    protected final <K> K getBeanForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, Qualifier<K> qualifier) {
        Argument<K> argument = this.resolveArgument(context, this.fieldInjection[fieldIndex].argument);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            K k = this.resolveBean(resolutionContext, argument, qualifier);
            return k;
        }
    }

    @Internal
    protected final <K> K getBeanForAnnotation(BeanResolutionContext resolutionContext, BeanContext context, int annotationBeanIndex, Qualifier<K> qualifier) {
        Argument<K> argument = this.resolveArgument(context, this.annotationInjection[annotationBeanIndex].argument);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushAnnotationResolve(this, argument);){
            K k = this.resolveBean(resolutionContext, argument, qualifier);
            return k;
        }
    }

    @Internal
    @Deprecated
    protected final Object getValueForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, Qualifier qualifier) {
        FieldReference fieldRef = this.fieldInjection[fieldIndex];
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, fieldRef.argument);){
            Object object = this.resolveValue(resolutionContext, context, fieldRef.argument.getAnnotationMetadata(), fieldRef.argument, qualifier);
            return object;
        }
    }

    @Internal
    @Deprecated
    protected final Object getPropertyValueForField(BeanResolutionContext resolutionContext, BeanContext context, Argument argument, String propertyValue, String cliProperty) {
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            Object object = this.resolvePropertyValue(resolutionContext, context, argument, propertyValue, cliProperty, false);
            return object;
        }
    }

    @Internal
    @Deprecated
    protected final Object getPropertyPlaceholderValueForField(BeanResolutionContext resolutionContext, BeanContext context, Argument argument, String placeholder) {
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            Object object = this.resolvePropertyValue(resolutionContext, context, argument, placeholder, null, true);
            return object;
        }
    }

    @Internal
    protected final <T1> Optional<T1> getValueForPath(BeanResolutionContext resolutionContext, BeanContext context, Argument<T1> propertyType, String propertyPath) {
        if (context instanceof PropertyResolver) {
            PropertyResolver propertyResolver = (PropertyResolver)context;
            String valString = this.substituteWildCards(resolutionContext, propertyPath);
            return propertyResolver.getProperty(valString, ConversionContext.of(propertyType));
        }
        return Optional.empty();
    }

    @Internal
    @Deprecated
    protected final boolean containsValueForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, boolean isValuePrefix) {
        FieldReference fieldRef = this.fieldInjection[fieldIndex];
        return this.resolveContainsValue(resolutionContext, context, fieldRef.argument.getAnnotationMetadata(), fieldRef.argument, isValuePrefix);
    }

    @Internal
    protected final boolean containsProperties(BeanResolutionContext resolutionContext, BeanContext context) {
        return this.containsProperties(resolutionContext, context, null);
    }

    @Internal
    protected final boolean containsProperties(BeanResolutionContext resolutionContext, BeanContext context, String subProperty) {
        return this.precalculatedInfo.isConfigurationProperties;
    }

    @Internal
    protected final <K, R extends Collection<K>> Object getBeansOfTypeForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        FieldReference fieldRef = this.fieldInjection[fieldIndex];
        Argument<K> argument = this.resolveArgument(context, fieldRef.argument);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            K k = this.resolveBeansOfType(resolutionContext, context, argument, this.resolveArgument(context, genericType), qualifier);
            return k;
        }
    }

    @Internal
    protected final <K, R extends Collection<BeanRegistration<K>>> R getBeanRegistrationsForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        FieldReference fieldRef = this.fieldInjection[fieldIndex];
        Argument<K> argument = this.resolveArgument(context, fieldRef.argument);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            K k = this.resolveBeanRegistrations(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return (R)k;
        }
    }

    @Internal
    protected final <K> BeanRegistration<K> getBeanRegistrationForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        FieldReference fieldRef = this.fieldInjection[fieldIndex];
        Argument<K> argument = this.resolveArgument(context, fieldRef.argument);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            BeanRegistration<K> beanRegistration = this.resolveBeanRegistration(resolutionContext, context, argument, this.resolveArgument(context, genericType), qualifier);
            return beanRegistration;
        }
    }

    @Internal
    protected final <K> Optional<K> findBeanForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        FieldReference fieldRef = this.fieldInjection[fieldIndex];
        Argument<K> argument = this.resolveArgument(context, fieldRef.argument);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            Optional<K> optional = this.resolveOptionalBean(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return optional;
        }
    }

    @Internal
    protected final <K> Stream<K> getStreamOfTypeForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, Argument<K> genericType, Qualifier<K> qualifier) {
        FieldReference fieldRef = this.fieldInjection[fieldIndex];
        Argument<K> argument = this.resolveArgument(context, fieldRef.argument);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            Stream<K> stream = this.resolveStreamOfType(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return stream;
        }
    }

    @Internal
    protected final <V> Map<String, V> getMapOfTypeForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex, Argument<V> genericType, Qualifier<V> qualifier) {
        FieldReference fieldRef = this.fieldInjection[fieldIndex];
        Argument argument = this.resolveArgument(context, fieldRef.argument);
        try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushFieldResolve((BeanDefinition)this, argument);){
            Map<String, V> map = this.resolveMapOfType(resolutionContext, argument, this.resolveArgument(context, genericType), qualifier);
            return map;
        }
    }

    @Internal
    protected final boolean containsPropertiesValue(BeanResolutionContext resolutionContext, BeanContext context, String value) {
        if (!(context instanceof ApplicationContext)) {
            return false;
        }
        ApplicationContext applicationContext = (ApplicationContext)context;
        value = this.substituteWildCards(resolutionContext, value);
        return applicationContext.containsProperties(value);
    }

    @Internal
    protected final boolean containsPropertyValue(BeanResolutionContext resolutionContext, BeanContext context, String value) {
        if (!(context instanceof ApplicationContext)) {
            return false;
        }
        ApplicationContext applicationContext = (ApplicationContext)context;
        value = this.substituteWildCards(resolutionContext, value);
        return applicationContext.containsProperty(value);
    }

    private boolean resolveContainsValue(BeanResolutionContext resolutionContext, BeanContext context, AnnotationMetadata parentAnnotationMetadata, Argument argument, boolean isValuePrefix) {
        String cliOption;
        boolean result;
        if (!(context instanceof ApplicationContext)) {
            return false;
        }
        ApplicationContext applicationContext = (ApplicationContext)context;
        String valueAnnStr = argument.getAnnotationMetadata().stringValue(Value.class).orElse(null);
        String valString = this.resolvePropertyValueName(resolutionContext, parentAnnotationMetadata, argument, valueAnnStr);
        boolean bl = result = isValuePrefix ? applicationContext.containsProperties(valString) : applicationContext.containsProperty(valString);
        if (!result && this.precalculatedInfo.isConfigurationProperties && (cliOption = this.resolveCliOption(argument.getName())) != null) {
            result = applicationContext.containsProperty(cliOption);
        }
        return result;
    }

    private Object resolveValue(BeanResolutionContext resolutionContext, BeanContext context, AnnotationMetadata parentAnnotationMetadata, Argument<?> argument, Qualifier qualifier) {
        Argument argumentType;
        if (!(context instanceof PropertyResolver)) {
            throw new DependencyInjectionException(resolutionContext, "@Value requires a BeanContext that implements PropertyResolver");
        }
        AnnotationMetadata argumentAnnotationMetadata = argument.getAnnotationMetadata();
        if (argumentAnnotationMetadata.hasEvaluatedExpressions()) {
            boolean isOptional = argument.isOptional();
            if (isOptional) {
                Argument t = isOptional ? argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT) : argument;
                Object v = argumentAnnotationMetadata.getValue(Value.class, t).orElse(null);
                return Optional.ofNullable(v);
            }
            return argumentAnnotationMetadata.getValue(Value.class, argument).orElse(null);
        }
        String valueAnnVal = argumentAnnotationMetadata.stringValue(Value.class).orElse(null);
        boolean isCollection = false;
        boolean wrapperType = argument.isWrapperType();
        Class argumentJavaType = argument.getType();
        if (Collection.class.isAssignableFrom(argumentJavaType)) {
            argumentType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            isCollection = true;
        } else {
            argumentType = wrapperType ? argument.getWrappedType() : argument;
        }
        if (this.isInnerConfiguration(argumentType)) {
            Qualifier qualifier2 = qualifier = qualifier == null ? this.resolveQualifier(resolutionContext, argumentType, argument) : qualifier;
            if (isCollection) {
                Collection beans = resolutionContext.getBeansOfType(argumentType, qualifier);
                return this.coerceCollectionToCorrectType(argumentJavaType, beans, resolutionContext, argument);
            }
            return resolutionContext.getBean(argumentType, qualifier);
        }
        String valString = this.resolvePropertyValueName(resolutionContext, parentAnnotationMetadata, argumentAnnotationMetadata, valueAnnVal);
        ArgumentConversionContext conversionContext = wrapperType ? ConversionContext.of((Argument)argumentType) : ConversionContext.of((Argument)argument);
        Optional value = this.resolveValue((ApplicationContext)context, conversionContext, valueAnnVal != null, valString);
        if (argument.isOptional()) {
            if (value.isEmpty()) {
                return value;
            }
            Object convertedOptional = value.get();
            if (convertedOptional instanceof Optional) {
                return convertedOptional;
            }
            return value;
        }
        if (wrapperType) {
            Object v = value.orElse(null);
            if (OptionalInt.class == argumentJavaType) {
                OptionalInt optionalInt;
                if (v instanceof Integer) {
                    Integer i = v;
                    optionalInt = OptionalInt.of(i);
                } else {
                    optionalInt = OptionalInt.empty();
                }
                return optionalInt;
            }
            if (OptionalLong.class == argumentJavaType) {
                OptionalLong optionalLong;
                if (v instanceof Long) {
                    Long l = v;
                    optionalLong = OptionalLong.of(l);
                } else {
                    optionalLong = OptionalLong.empty();
                }
                return optionalLong;
            }
            if (OptionalDouble.class == argumentJavaType) {
                OptionalDouble optionalDouble;
                if (v instanceof Double) {
                    Double d = v;
                    optionalDouble = OptionalDouble.of(d);
                } else {
                    optionalDouble = OptionalDouble.empty();
                }
                return optionalDouble;
            }
        }
        if (value.isPresent()) {
            return value.get();
        }
        if (argument.isDeclaredNullable()) {
            return null;
        }
        return argumentAnnotationMetadata.getValue(Bindable.class, "defaultValue", argument).orElseThrow(() -> DependencyInjectionException.missingProperty(resolutionContext, conversionContext, valString));
    }

    private Object resolvePropertyValue(BeanResolutionContext resolutionContext, BeanContext context, Argument<?> argument, String stringValue, String cliProperty, boolean isPlaceholder) {
        Optional value;
        ArgumentConversionContext conversionContext;
        if (!(context instanceof PropertyResolver)) {
            throw new DependencyInjectionException(resolutionContext, "@Value requires a BeanContext that implements PropertyResolver");
        }
        ApplicationContext applicationContext = (ApplicationContext)context;
        Argument argumentType = argument;
        Class wrapperType = null;
        Class type = argument.getType();
        if (type == Optional.class) {
            wrapperType = Optional.class;
            argumentType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        } else if (type == OptionalInt.class) {
            wrapperType = OptionalInt.class;
            argumentType = Argument.INT;
        } else if (type == OptionalLong.class) {
            wrapperType = OptionalLong.class;
            argumentType = Argument.LONG;
        } else if (type == OptionalDouble.class) {
            wrapperType = OptionalDouble.class;
            argumentType = Argument.DOUBLE;
        }
        ArgumentConversionContext argumentConversionContext = conversionContext = wrapperType != null ? ConversionContext.of((Argument)argumentType) : ConversionContext.of((Argument)argument);
        if (isPlaceholder) {
            value = applicationContext.resolvePlaceholders(stringValue).flatMap(v -> applicationContext.getConversionService().convert(v, conversionContext));
        } else {
            value = applicationContext.getProperty(stringValue = this.substituteWildCards(resolutionContext, stringValue), conversionContext);
            if (value.isEmpty() && cliProperty != null) {
                value = applicationContext.getProperty(cliProperty, conversionContext);
            }
        }
        if (argument.isOptional()) {
            if (value.isEmpty()) {
                return value;
            }
            Object convertedOptional = value.get();
            if (convertedOptional instanceof Optional) {
                return convertedOptional;
            }
            return value;
        }
        if (wrapperType != null) {
            Object v2 = value.orElse(null);
            if (OptionalInt.class == wrapperType) {
                OptionalInt optionalInt;
                if (v2 instanceof Integer) {
                    Integer i = v2;
                    optionalInt = OptionalInt.of(i);
                } else {
                    optionalInt = OptionalInt.empty();
                }
                return optionalInt;
            }
            if (OptionalLong.class == wrapperType) {
                OptionalLong optionalLong;
                if (v2 instanceof Long) {
                    Long l = v2;
                    optionalLong = OptionalLong.of(l);
                } else {
                    optionalLong = OptionalLong.empty();
                }
                return optionalLong;
            }
            if (OptionalDouble.class == wrapperType) {
                OptionalDouble optionalDouble;
                if (v2 instanceof Double) {
                    Double d = v2;
                    optionalDouble = OptionalDouble.of(d);
                } else {
                    optionalDouble = OptionalDouble.empty();
                }
                return optionalDouble;
            }
        }
        if (value.isPresent()) {
            return value.get();
        }
        if (argument.isDeclaredNullable()) {
            return null;
        }
        String finalStringValue = stringValue;
        return argument.getAnnotationMetadata().getValue(Bindable.class, "defaultValue", argument).orElseThrow(() -> DependencyInjectionException.missingProperty(resolutionContext, conversionContext, finalStringValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <K> K resolveBean(BeanResolutionContext resolutionContext, Argument<K> argument, @Nullable Qualifier<K> qualifier) {
        qualifier = qualifier == null ? this.resolveQualifier(resolutionContext, argument, argument) : qualifier;
        Class t = argument.getType();
        if (Qualifier.class.isAssignableFrom(t)) {
            return (K)qualifier;
        }
        try {
            boolean isNotInnerConfiguration = !this.precalculatedInfo.isConfigurationProperties || !this.isInnerConfiguration(argument);
            ConfigurationPath previousPath = isNotInnerConfiguration ? resolutionContext.setConfigurationPath(null) : null;
            try {
                if (argument.isDeclaredNullable()) {
                    K k = resolutionContext.findBean(argument, qualifier).orElse(null);
                    return k;
                }
                K k = resolutionContext.getBean(argument, qualifier);
                return k;
            }
            finally {
                if (previousPath != null) {
                    resolutionContext.setConfigurationPath(previousPath);
                }
            }
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)argument.getTypeName(), (Object)e.getMessage());
            }
            if (!this.isIterable()) throw new DependencyInjectionException(resolutionContext, (Throwable)e);
            if (!this.getAnnotationMetadata().hasDeclaredAnnotation(EachBean.class)) throw new DependencyInjectionException(resolutionContext, (Throwable)e);
            throw new DisabledBeanException("Bean [" + this.getBeanType().getSimpleName() + "] disabled by parent: " + e.getMessage());
        }
        catch (NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, (Throwable)e);
        }
    }

    private <K> Optional<K> resolveValue(ApplicationContext context, ArgumentConversionContext<K> argument, boolean hasValueAnnotation, String valString) {
        String cliOption;
        if (hasValueAnnotation) {
            return context.resolvePlaceholders(valString).flatMap(v -> context.getConversionService().convert(v, argument));
        }
        Optional value = context.getProperty(valString, argument);
        if (value.isEmpty() && this.precalculatedInfo.isConfigurationProperties && (cliOption = this.resolveCliOption(argument.getArgument().getName())) != null) {
            return context.getProperty(cliOption, argument);
        }
        return value;
    }

    private String resolvePropertyValueName(BeanResolutionContext resolutionContext, AnnotationMetadata parentAnnotationMetadata, Argument argument, String valueAnnStr) {
        return this.resolvePropertyValueName(resolutionContext, parentAnnotationMetadata, argument.getAnnotationMetadata(), valueAnnStr);
    }

    private String resolvePropertyValueName(BeanResolutionContext resolutionContext, AnnotationMetadata parentAnnotationMetadata, AnnotationMetadata annotationMetadata, String valueAnnStr) {
        if (valueAnnStr != null) {
            return valueAnnStr;
        }
        String valString = this.getProperty(resolutionContext, parentAnnotationMetadata, annotationMetadata);
        return this.substituteWildCards(resolutionContext, valString);
    }

    private String getProperty(BeanResolutionContext resolutionContext, AnnotationMetadata parentAnnotationMetadata, AnnotationMetadata annotationMetadata) {
        Optional property = parentAnnotationMetadata.stringValue(Property.class, "name");
        if (property.isPresent()) {
            return (String)property.get();
        }
        if (parentAnnotationMetadata != annotationMetadata && (property = annotationMetadata.stringValue(Property.class, "name")).isPresent()) {
            return (String)property.get();
        }
        throw new DependencyInjectionException(resolutionContext, "Value resolution attempted but @Value annotation is missing");
    }

    private String substituteWildCards(BeanResolutionContext resolutionContext, String valString) {
        ConfigurationPath configurationPath = resolutionContext.getConfigurationPath();
        if (configurationPath.isNotEmpty()) {
            return configurationPath.resolveValue(valString);
        }
        return valString;
    }

    private String resolveCliOption(String name) {
        String attr = "cliPrefix";
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        if (annotationMetadata.isPresent(ConfigurationProperties.class, attr)) {
            return annotationMetadata.stringValue(ConfigurationProperties.class, attr).map(val -> val + name).orElse(null);
        }
        return null;
    }

    private <K, R extends Collection<K>> R resolveBeansOfType(BeanResolutionContext resolutionContext, BeanContext context, Argument<R> returnType, Argument<K> beanType, Qualifier<K> qualifier) {
        if (beanType == null) {
            throw AbstractInitializableBeanDefinition.noGenericsError(resolutionContext, returnType);
        }
        qualifier = qualifier == null ? this.resolveQualifier(resolutionContext, beanType, returnType) : qualifier;
        Collection<K> beansOfType = resolutionContext.getBeansOfType(this.resolveArgument(context, beanType), qualifier);
        return (R)this.coerceCollectionToCorrectType(returnType.getType(), beansOfType, resolutionContext, returnType);
    }

    @NonNull
    private static <K, R> DependencyInjectionException noGenericsError(BeanResolutionContext resolutionContext, Argument<R> returnType) {
        return new DependencyInjectionException(resolutionContext, "Type " + returnType.getType() + " has no generic argument");
    }

    private <R> boolean isInnerConfiguration(@Nullable Argument<R> argument) {
        if (argument == null || !this.precalculatedInfo.isConfigurationProperties) {
            return false;
        }
        if (argument.isContainerType() || argument.isOptional() || argument.isProvider()) {
            return this.isInnerConfiguration((Argument<R>)argument.getFirstTypeVariable().orElse(null));
        }
        if (this.precalculatedInfo.isIterable && this.isEachBeanParent(argument)) {
            return true;
        }
        return this.isInnerConfiguration(argument.getType());
    }

    private <R> boolean isEachBeanParent(Argument<R> argument) {
        Class t = this.getAnnotationMetadata().classValue(EachBean.class).orElse(null);
        return t != null && t.equals(argument.getType());
    }

    private <K> Stream<K> resolveStreamOfType(BeanResolutionContext resolutionContext, Argument<K> returnType, Argument<K> beanType, Qualifier<K> qualifier) {
        if (beanType == null) {
            throw AbstractInitializableBeanDefinition.noGenericsError(resolutionContext, returnType);
        }
        qualifier = qualifier == null ? this.resolveQualifier(resolutionContext, beanType, returnType) : qualifier;
        return resolutionContext.streamOfType(beanType, qualifier);
    }

    private <V> Map<String, V> resolveMapOfType(BeanResolutionContext resolutionContext, Argument<Map<String, V>> returnType, Argument<V> beanType, Qualifier<V> qualifier) {
        if (beanType == null) {
            throw AbstractInitializableBeanDefinition.noGenericsError(resolutionContext, returnType);
        }
        Map<String, V> map = resolutionContext.mapOfType(beanType, qualifier = qualifier == null ? this.resolveQualifier(resolutionContext, beanType, returnType) : qualifier);
        if (returnType.isInstance(map)) {
            return map;
        }
        return (Map)resolutionContext.getContext().getConversionService().convertRequired(map, returnType);
    }

    private <K> Optional<K> resolveOptionalBean(BeanResolutionContext resolutionContext, Argument<K> returnType, Argument<K> beanType, Qualifier<K> qualifier) {
        if (beanType == null) {
            throw AbstractInitializableBeanDefinition.noGenericsError(resolutionContext, returnType);
        }
        qualifier = qualifier == null ? this.resolveQualifier(resolutionContext, beanType, returnType) : qualifier;
        return resolutionContext.findBean(beanType, qualifier);
    }

    private <I, K extends Collection<BeanRegistration<I>>> K resolveBeanRegistrations(BeanResolutionContext resolutionContext, Argument<K> returnType, Argument<I> beanType, Qualifier<I> qualifier) {
        try {
            if (beanType == null) {
                throw new DependencyInjectionException(resolutionContext, "Cannot resolve bean registrations. Argument [" + returnType + "] missing generic type information.");
            }
            qualifier = qualifier == null ? this.resolveQualifier(resolutionContext, beanType, returnType) : qualifier;
            Collection<BeanRegistration<I>> beanRegistrations = resolutionContext.getBeanRegistrations(beanType, qualifier);
            return this.coerceCollectionToCorrectType(returnType.getType(), beanRegistrations, resolutionContext, returnType);
        }
        catch (NoSuchBeanException e) {
            if (returnType.isNullable()) {
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, (Throwable)e);
        }
    }

    private <K> Argument<K> resolveArgument(BeanContext context, int argIndex, Argument<?>[] arguments) {
        if (arguments == null) {
            return null;
        }
        return this.resolveArgument(context, arguments[argIndex]);
    }

    private <K> Argument<K> resolveArgument(BeanContext context, Argument<K> argument) {
        return ExpressionsAwareArgument.wrapIfNecessary(argument, context, this);
    }

    private <B> BeanRegistration<B> resolveBeanRegistration(BeanResolutionContext resolutionContext, BeanContext context, @NonNull Argument<B> returnType, Argument<B> beanType, Qualifier<B> qualifier) {
        try {
            if (beanType == null) {
                throw new DependencyInjectionException(resolutionContext, "Cannot resolve bean registration. Argument [" + returnType + "] missing generic type information.");
            }
            qualifier = qualifier == null ? this.resolveQualifier(resolutionContext, beanType, returnType) : qualifier;
            return context.getBeanRegistration(beanType, qualifier);
        }
        catch (NoSuchBeanException e) {
            if (returnType.isNullable()) {
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, returnType, (Throwable)e);
        }
    }

    @Nullable
    private <B, R> Qualifier<B> resolveQualifier(BeanResolutionContext resolutionContext, Argument<B> beanType, Argument<R> resultType) {
        if (this.isInnerConfiguration(beanType)) {
            ConfigurationPath configurationPath = resolutionContext.getConfigurationPath();
            Qualifier q = configurationPath.beanQualifier();
            if (q instanceof Named) {
                Named named = (Named)q;
                if (resultType.isContainerType()) {
                    return Qualifiers.byNamePrefix(named.getName());
                }
            }
            if (q == null && this.isEachBeanParent(beanType)) {
                return resolutionContext.getCurrentQualifier();
            }
            return q;
        }
        if (Qualifier.class == resultType.getType()) {
            Qualifier<?> currentQualifier = resolutionContext.getCurrentQualifier();
            if (currentQualifier != null && currentQualifier.getClass() != InterceptorBindingQualifier.class && currentQualifier.getClass() != TypeAnnotationQualifier.class) {
                return currentQualifier;
            }
            return resolutionContext.getConfigurationPath().beanQualifier();
        }
        if (this.precalculatedInfo.isIterable && resultType.isAnnotationPresent(Parameter.class)) {
            return resolutionContext.getCurrentQualifier();
        }
        return null;
    }

    private <I, K extends Collection<I>> K coerceCollectionToCorrectType(Class<K> collectionType, Collection<I> beansOfType, BeanResolutionContext resolutionContext, Argument<?> argument) {
        if (argument.isArray() || collectionType.isInstance(beansOfType)) {
            return (K)beansOfType;
        }
        return (K)((Collection)CollectionUtils.convertCollection(collectionType, beansOfType).orElseThrow(() -> new DependencyInjectionException(resolutionContext, "Cannot create a collection of type: " + collectionType.getName())));
    }

    private Object getExpressionValueForArgument(Argument<?> argument) {
        Argument t = argument.isOptional() ? argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT) : argument;
        Optional expressionValue = argument.getAnnotationMetadata().getValue(Value.class, t);
        return expressionValue.orElse(null);
    }

    private final class BeanAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        BeanAnnotationMetadata(AnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return AbstractInitializableBeanDefinition.this.environment;
        }
    }

    @Internal
    public static abstract class MethodOrFieldReference {
        final Class declaringType;

        public MethodOrFieldReference(Class<?> declaringType) {
            this.declaringType = declaringType;
        }
    }

    @Internal
    public static final class MethodReference
    extends MethodOrFieldReference {
        public final String methodName;
        public final Argument[] arguments;
        public final AnnotationMetadata annotationMetadata;
        public final boolean isPreDestroyMethod;
        public final boolean isPostConstructMethod;

        public MethodReference(Class declaringType, String methodName, Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata) {
            this(declaringType, methodName, arguments, annotationMetadata, false, false);
        }

        public MethodReference(Class declaringType, String methodName, Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata, boolean isPostConstructMethod, boolean isPreDestroyMethod) {
            super(declaringType);
            this.methodName = methodName;
            this.isPostConstructMethod = isPostConstructMethod;
            this.isPreDestroyMethod = isPreDestroyMethod;
            if (arguments != null) {
                for (int i = 0; i < arguments.length; ++i) {
                    Argument argument = arguments[i];
                    if (!argument.getAnnotationMetadata().hasEvaluatedExpressions()) continue;
                    arguments[i] = ExpressionsAwareArgument.wrapIfNecessary(argument);
                }
            }
            this.arguments = arguments;
            this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : EvaluatedAnnotationMetadata.wrapIfNecessary(annotationMetadata);
        }
    }

    @Internal
    public static final class FieldReference
    extends MethodOrFieldReference {
        public final Argument argument;

        public FieldReference(Class declaringType, Argument argument) {
            super(declaringType);
            this.argument = ExpressionsAwareArgument.wrapIfNecessary(argument);
        }
    }

    @Internal
    public static final class AnnotationReference {
        public final Argument argument;

        public AnnotationReference(Argument argument) {
            this.argument = ExpressionsAwareArgument.wrapIfNecessary(argument);
        }
    }

    @Internal
    public record PrecalculatedInfo(Optional<String> scope, boolean isAbstract, boolean isIterable, boolean isSingleton, boolean isPrimary, boolean isConfigurationProperties, boolean isContainerType, boolean requiresMethodProcessing, boolean hasEvaluatedExpressions) {
        public PrecalculatedInfo(Optional<String> scope, boolean isAbstract, boolean isIterable, boolean isSingleton, boolean isPrimary, boolean isConfigurationProperties, boolean isContainerType, boolean requiresMethodProcessing) {
            this(scope, isAbstract, isIterable, isSingleton, isPrimary, isConfigurationProperties, isContainerType, requiresMethodProcessing, false);
        }
    }
}

