/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.QualifierUtils;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
class NameQualifier<T>
implements Qualifier<T>,
Named {
    protected final Class<? extends Annotation> annotationType;
    private final String name;

    NameQualifier(AnnotationMetadata annotationMetadata, String name) {
        this.annotationType = annotationMetadata != null ? (Class)annotationMetadata.getAnnotationType(name).orElse(null) : null;
        this.name = Objects.requireNonNull(this.annotationType == null ? name : this.annotationType.getSimpleName(), "Argument [name] cannot be null");
    }

    NameQualifier(Class<? extends Annotation> annotationType) {
        this.name = Objects.requireNonNull(annotationType.getSimpleName(), "Argument [name] cannot be null");
        this.annotationType = annotationType;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        ArgumentUtils.check((String)"beanType", beanType).notNull();
        ArgumentUtils.check((String)"candidates", candidates).notNull();
        return candidates.filter(candidate -> {
            BeanDefinition definition;
            Qualifier qualifier;
            if (!QualifierUtils.matchType(beanType, candidate)) {
                return false;
            }
            if (QualifierUtils.matchAny(beanType, candidate)) {
                return true;
            }
            AnnotationMetadata annotationMetadata = candidate.getAnnotationMetadata();
            String thisName = annotationMetadata.findDeclaredAnnotation("jakarta.inject.Named").flatMap(AnnotationValue::stringValue).orElse(null);
            if (thisName == null && candidate instanceof BeanDefinition && (qualifier = (definition = (BeanDefinition)candidate).getDeclaredQualifier()) != null && qualifier.contains(this)) {
                return true;
            }
            if (thisName == null) {
                if (candidate instanceof NameResolver) {
                    NameResolver resolver = (NameResolver)candidate;
                    Optional resolvedName = resolver.resolveName();
                    thisName = resolvedName.orElse(candidate.getBeanType().getSimpleName());
                } else {
                    thisName = candidate.getBeanType().getSimpleName();
                }
            }
            return thisName.equalsIgnoreCase(this.name) || thisName.equalsIgnoreCase(this.name + beanType.getSimpleName());
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !NameQualifier.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        NameQualifier that = (NameQualifier)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        return "@Named('" + this.name + "')";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }
}

