/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;

@Internal
public final class EachBeanQualifier<T>
extends FilteringQualifier<T> {
    private final BeanDefinition<?> beanDefinition;

    public EachBeanQualifier(BeanDefinition<?> beanDefinition) {
        this.beanDefinition = beanDefinition;
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        return candidate.equals(this.beanDefinition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !EachBeanQualifier.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        EachBeanQualifier that = (EachBeanQualifier)o;
        return this.beanDefinition.equals(that.beanDefinition);
    }

    public String toString() {
        return "EachBeanQualifier('" + this.beanDefinition + "')";
    }

    public int hashCode() {
        return this.beanDefinition.hashCode();
    }
}

