/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@Internal
final class SingletonScope {
    private final Map<BeanDefinitionIdentity, Object> singletonsInCreationLocks = new ConcurrentHashMap<BeanDefinitionIdentity, Object>(5, 1.0f);
    private final Map<BeanDefinitionIdentity, BeanRegistration> singletonByBeanDefinition = new ConcurrentHashMap<BeanDefinitionIdentity, BeanRegistration>(100);
    private final Map<DefaultBeanContext.BeanKey, BeanRegistration> singletonByArgumentAndQualifier = new ConcurrentHashMap<DefaultBeanContext.BeanKey, BeanRegistration>(100);

    SingletonScope() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    <T> BeanRegistration<T> getOrCreate(@NonNull DefaultBeanContext beanContext, @Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Object lock;
        BeanRegistration<T> beanRegistration = this.findBeanRegistration(definition, beanType, qualifier);
        if (beanRegistration != null) {
            return beanRegistration;
        }
        BeanDefinitionIdentity identity = BeanDefinitionIdentity.of(definition);
        BeanRegistration existingRegistration = this.singletonByBeanDefinition.get(identity);
        if (existingRegistration != null) {
            return existingRegistration;
        }
        Object object = lock = this.singletonsInCreationLocks.computeIfAbsent(identity, beanDefinitionIdentity -> new Object());
        synchronized (object) {
            try {
                existingRegistration = this.singletonByBeanDefinition.get(identity);
                if (existingRegistration != null) {
                    BeanRegistration beanRegistration2 = existingRegistration;
                    return beanRegistration2;
                }
                BeanRegistration<T> newRegistration = beanContext.createRegistration(resolutionContext, beanType, qualifier, definition, false);
                this.registerSingletonBean(newRegistration, qualifier);
                BeanRegistration<T> beanRegistration3 = newRegistration;
                return beanRegistration3;
            }
            finally {
                this.singletonsInCreationLocks.remove(identity);
            }
        }
    }

    @NonNull
    <T> BeanRegistration<T> registerSingletonBean(@NonNull BeanRegistration<T> registration, Qualifier qualifier) {
        DefaultBeanContext.BeanKey beanKey;
        BeanDefinition beanDefinition = registration.beanDefinition;
        this.singletonByBeanDefinition.put(BeanDefinitionIdentity.of(beanDefinition), registration);
        if (!beanDefinition.isSingleton()) {
            beanKey = new DefaultBeanContext.BeanKey(beanDefinition, qualifier);
            this.singletonByArgumentAndQualifier.put(beanKey, registration);
        }
        if (beanDefinition instanceof BeanDefinitionDelegate || beanDefinition instanceof RuntimeBeanDefinition) {
            beanKey = new DefaultBeanContext.BeanKey(beanDefinition, beanDefinition.getDeclaredQualifier());
            this.singletonByArgumentAndQualifier.put(beanKey, registration);
        }
        return registration;
    }

    <T> boolean containsBean(Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        DefaultBeanContext.BeanKey<T> beanKey = new DefaultBeanContext.BeanKey<T>(beanType, qualifier);
        return this.singletonByArgumentAndQualifier.containsKey(beanKey);
    }

    @NonNull
    Collection<BeanRegistration> getBeanRegistrations() {
        return this.singletonByBeanDefinition.values();
    }

    @NonNull
    Collection<BeanRegistration<?>> getBeanRegistrations(@NonNull Qualifier<?> qualifier) {
        ArrayList beanRegistrations = new ArrayList();
        for (BeanRegistration beanRegistration : this.singletonByBeanDefinition.values()) {
            BeanDefinition beanDefinition = beanRegistration.beanDefinition;
            if (!qualifier.doesQualify(beanDefinition.getBeanType(), beanDefinition)) continue;
            beanRegistrations.add(beanRegistration);
        }
        return beanRegistrations;
    }

    @NonNull
    <T> Collection<BeanRegistration<T>> getBeanRegistrations(@NonNull Class<T> beanType) {
        ArrayList<BeanRegistration<T>> beanRegistrations = new ArrayList<BeanRegistration<T>>();
        for (BeanRegistration beanRegistration : this.singletonByBeanDefinition.values()) {
            BeanDefinition beanDefinition = beanRegistration.beanDefinition;
            if (!beanType.isAssignableFrom(beanDefinition.getBeanType())) continue;
            beanRegistrations.add(beanRegistration);
        }
        return beanRegistrations;
    }

    @Nullable
    <T> BeanRegistration<T> findBeanRegistration(@NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier) {
        return this.findBeanRegistration(beanDefinition, beanDefinition.asArgument(), qualifier);
    }

    @Nullable
    <T> BeanRegistration<T> findBeanRegistration(@NonNull BeanIdentifier identifier) {
        for (BeanRegistration registration : this.singletonByBeanDefinition.values()) {
            if (!registration.identifier.equals(identifier)) continue;
            return registration;
        }
        return null;
    }

    @Nullable
    <T> BeanRegistration<T> findBeanRegistration(@Nullable T bean) {
        if (bean == null) {
            return null;
        }
        for (BeanRegistration beanRegistration : this.singletonByBeanDefinition.values()) {
            if (bean != beanRegistration.getBean()) continue;
            return beanRegistration;
        }
        return null;
    }

    @Nullable
    <T> BeanRegistration<T> findBeanRegistration(@NonNull BeanDefinition<T> definition) {
        return this.singletonByBeanDefinition.get(BeanDefinitionIdentity.of(definition));
    }

    @Nullable
    <T> BeanRegistration<T> findBeanRegistration(@NonNull BeanDefinition<T> beanDefinition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanRegistration beanRegistration = this.singletonByBeanDefinition.get(BeanDefinitionIdentity.of(beanDefinition));
        if (beanRegistration == null) {
            return this.findCachedSingletonBeanRegistration(beanType, qualifier);
        }
        return beanRegistration;
    }

    @Nullable
    <T> BeanRegistration<T> findCachedSingletonBeanRegistration(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        DefaultBeanContext.BeanKey<T> beanKey = new DefaultBeanContext.BeanKey<T>(beanType, qualifier);
        BeanRegistration beanRegistration = this.singletonByArgumentAndQualifier.get(beanKey);
        if (beanRegistration != null && beanRegistration.bean != null) {
            return beanRegistration;
        }
        return null;
    }

    @Nullable
    <T> BeanDefinition<T> findCachedSingletonBeanDefinition(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanRegistration<T> reg = this.findCachedSingletonBeanRegistration(beanType, qualifier);
        if (reg != null) {
            return reg.getBeanDefinition();
        }
        return null;
    }

    synchronized <T> void purgeCacheForBeanInstance(BeanDefinition<T> beanDefinition, T bean) {
        this.singletonByBeanDefinition.remove(BeanDefinitionIdentity.of(beanDefinition));
        this.singletonByArgumentAndQualifier.entrySet().removeIf(entry -> ((DefaultBeanContext.BeanKey)entry.getKey()).beanType.isInstance(bean));
    }

    void clear() {
        this.singletonByBeanDefinition.clear();
        this.singletonByArgumentAndQualifier.clear();
    }

    static interface BeanDefinitionIdentity {
        public static BeanDefinitionIdentity of(BeanDefinition<?> beanDefinition) {
            if (beanDefinition instanceof BeanDefinitionDelegate) {
                BeanDefinitionDelegate definitionDelegate = (BeanDefinitionDelegate)beanDefinition;
                return new BeanDefinitionDelegatedIdentity(definitionDelegate);
            }
            if (beanDefinition instanceof RuntimeBeanDefinition) {
                RuntimeBeanDefinition runtimeBeanDefinition = (RuntimeBeanDefinition)beanDefinition;
                return new RuntimeBeanDefinitionIdentity(runtimeBeanDefinition);
            }
            return new SimpleBeanDefinitionIdentity(beanDefinition);
        }
    }

    static final class SimpleBeanDefinitionIdentity
    implements BeanDefinitionIdentity {
        private final Class<?> beanDefinitionClass;

        SimpleBeanDefinitionIdentity(BeanDefinition<?> beanDefinition) {
            this.beanDefinitionClass = beanDefinition.getClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleBeanDefinitionIdentity that = (SimpleBeanDefinitionIdentity)o;
            return this.beanDefinitionClass == that.beanDefinitionClass;
        }

        public int hashCode() {
            return this.beanDefinitionClass.hashCode();
        }
    }

    static final class RuntimeBeanDefinitionIdentity
    implements BeanDefinitionIdentity {
        private final RuntimeBeanDefinition<?> beanDefinition;

        RuntimeBeanDefinitionIdentity(RuntimeBeanDefinition<?> beanDefinition) {
            this.beanDefinition = beanDefinition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuntimeBeanDefinitionIdentity that = (RuntimeBeanDefinitionIdentity)o;
            if (this.beanDefinition.getBeanType() != that.beanDefinition.getBeanType()) {
                return false;
            }
            return this.beanDefinition.getBeanDefinitionName().equals(that.beanDefinition.getBeanDefinitionName());
        }

        public int hashCode() {
            return this.beanDefinition.getBeanDefinitionName().hashCode();
        }
    }

    static final class BeanDefinitionDelegatedIdentity
    implements BeanDefinitionIdentity {
        private final BeanDefinitionDelegate<?> beanDefinitionDelegate;

        BeanDefinitionDelegatedIdentity(BeanDefinitionDelegate<?> beanDefinitionDelegate) {
            this.beanDefinitionDelegate = beanDefinitionDelegate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanDefinitionDelegatedIdentity that = (BeanDefinitionDelegatedIdentity)o;
            if (this.beanDefinitionDelegate.definition.getClass() != that.beanDefinitionDelegate.definition.getClass()) {
                return false;
            }
            return Objects.equals(this.beanDefinitionDelegate.getDeclaredQualifier(), that.beanDefinitionDelegate.getDeclaredQualifier());
        }

        public int hashCode() {
            return ObjectUtils.hash((Object)this.beanDefinitionDelegate.getBeanType(), this.beanDefinitionDelegate.getDeclaredQualifier());
        }
    }
}

