/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Internal
abstract class AbstractAnnotationMetadata
implements AnnotationMetadata {
    private volatile Map<String, Annotation> annotationMap;
    private volatile Map<String, Annotation> declaredAnnotationMap;
    private volatile Annotation[] allAnnotationArray;
    private volatile Annotation[] declaredAnnotationArray;

    protected AbstractAnnotationMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Annotation> getAnnotationMap() {
        Map<String, Annotation> map = this.annotationMap;
        if (map == null) {
            AbstractAnnotationMetadata abstractAnnotationMetadata = this;
            synchronized (abstractAnnotationMetadata) {
                map = this.annotationMap;
                if (map == null) {
                    this.annotationMap = new ConcurrentHashMap<String, Annotation>();
                    return this.annotationMap;
                }
            }
        }
        return this.annotationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Annotation> getDeclaredAnnotationMap() {
        Map<String, Annotation> map = this.declaredAnnotationMap;
        if (map == null) {
            AbstractAnnotationMetadata abstractAnnotationMetadata = this;
            synchronized (abstractAnnotationMetadata) {
                map = this.declaredAnnotationMap;
                if (map == null) {
                    this.declaredAnnotationMap = new ConcurrentHashMap<String, Annotation>();
                    return this.declaredAnnotationMap;
                }
            }
        }
        return this.declaredAnnotationMap;
    }

    @Nullable
    public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull((String)"annotationClass", annotationClass);
        if (this.hasAnnotation(annotationClass) || this.hasStereotype(annotationClass)) {
            String annotationName = annotationClass.getName();
            return (T)this.getAnnotationMap().computeIfAbsent(annotationName, s -> {
                AnnotationValue annotationValue = this.findAnnotation(annotationClass).orElse(null);
                return AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
            });
        }
        return null;
    }

    @Nullable
    public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass, @NonNull String sourceAnnotation) {
        ArgumentUtils.requireNonNull((String)"annotationClass", annotationClass);
        ArgumentUtils.requireNonNull((String)"sourceAnnotation", (Object)sourceAnnotation);
        if (this.hasAnnotation(sourceAnnotation) || this.hasStereotype(sourceAnnotation)) {
            String annotationName = annotationClass.getName();
            return (T)this.getAnnotationMap().computeIfAbsent(annotationName, s -> {
                AnnotationValue annotationValue = this.findAnnotation(sourceAnnotation).orElse(null);
                return AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
            });
        }
        return null;
    }

    @Nullable
    public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass, @NonNull String sourceAnnotation) {
        ArgumentUtils.requireNonNull((String)"annotationClass", annotationClass);
        ArgumentUtils.requireNonNull((String)"sourceAnnotation", (Object)sourceAnnotation);
        String annotationName = annotationClass.getName();
        if (this.hasDeclaredAnnotation(sourceAnnotation) || this.hasDeclaredStereotype(sourceAnnotation)) {
            return (T)this.getDeclaredAnnotationMap().computeIfAbsent(annotationName, s -> {
                AnnotationValue annotationValue = this.findDeclaredAnnotation(sourceAnnotation).orElse(null);
                return AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
            });
        }
        return null;
    }

    @Nullable
    public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull((String)"annotationClass", annotationClass);
        String annotationName = annotationClass.getName();
        if (this.hasDeclaredAnnotation(annotationName) || this.hasDeclaredStereotype(annotationName)) {
            return (T)this.getDeclaredAnnotationMap().computeIfAbsent(annotationName, s -> {
                AnnotationValue annotationValue = this.findDeclaredAnnotation(annotationClass).orElse(null);
                return AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Annotation[] synthesizeAll() {
        Annotation[] annotations = this.allAnnotationArray;
        if (annotations == null) {
            AbstractAnnotationMetadata abstractAnnotationMetadata = this;
            synchronized (abstractAnnotationMetadata) {
                annotations = this.allAnnotationArray;
                if (annotations == null) {
                    annotations = this.initializeAnnotations(this.getAnnotationNames());
                    this.allAnnotationArray = annotations;
                }
            }
        }
        return annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Annotation[] synthesizeDeclared() {
        Annotation[] annotations = this.declaredAnnotationArray;
        if (annotations == null) {
            AbstractAnnotationMetadata abstractAnnotationMetadata = this;
            synchronized (abstractAnnotationMetadata) {
                annotations = this.declaredAnnotationArray;
                if (annotations == null) {
                    annotations = this.initializeAnnotations(this.getDeclaredAnnotationNames());
                    this.declaredAnnotationArray = annotations;
                }
            }
        }
        return annotations;
    }

    private Annotation[] initializeAnnotations(Set<String> names) {
        if (CollectionUtils.isEmpty(names)) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        ArrayList annotations = new ArrayList(names.size());
        for (String name : names) {
            Object ann;
            Class aClass = ClassUtils.forName((String)name, (ClassLoader)this.getClass().getClassLoader()).orElse(null);
            if (aClass == null || (ann = this.synthesize(aClass)) == null) continue;
            annotations.add(ann);
        }
        return annotations.toArray(AnnotationUtil.ZERO_ANNOTATIONS);
    }
}

