/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.BootstrapContextAccess;
import io.micronaut.context.ConfigurableApplicationContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.env.BootstrapPropertySourceLocator;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.ConfigurationPath;
import io.micronaut.context.env.DefaultEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.naming.Named;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.qualifiers.EachBeanQualifier;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import io.micronaut.inject.qualifiers.PrimaryQualifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultApplicationContext
extends DefaultBeanContext
implements ConfigurableApplicationContext {
    private final ClassPathResourceLoader resourceLoader;
    private final ApplicationContextConfiguration configuration;
    private Environment environment;
    private boolean environmentManaged;

    public DefaultApplicationContext(String ... environmentNames) {
        this(ClassPathResourceLoader.defaultLoader((ClassLoader)DefaultApplicationContext.class.getClassLoader()), environmentNames);
    }

    public DefaultApplicationContext(final @NonNull ClassPathResourceLoader resourceLoader, final String ... environmentNames) {
        this(new ApplicationContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                return this.getResourceLoader().getClassLoader();
            }

            @Override
            @NonNull
            public ClassPathResourceLoader getResourceLoader() {
                ArgumentUtils.requireNonNull((String)"resourceLoader", (Object)resourceLoader);
                return resourceLoader;
            }

            @Override
            @NonNull
            public List<String> getEnvironments() {
                ArgumentUtils.requireNonNull((String)"environmentNames", (Object)environmentNames);
                return Arrays.asList(environmentNames);
            }
        });
    }

    public DefaultApplicationContext(@NonNull ApplicationContextConfiguration configuration) {
        super(configuration);
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.configuration = configuration;
        this.resourceLoader = configuration.getResourceLoader();
    }

    @Override
    @Internal
    final void configureContextInternal() {
        super.configureContextInternal();
        this.configuration.getContextConfigurer().ifPresent(configurer -> configurer.configure(this));
    }

    @Override
    @NonNull
    public <T> ApplicationContext registerSingleton(@NonNull Class<T> type, @NonNull T singleton, @Nullable Qualifier<T> qualifier, boolean inject) {
        return (ApplicationContext)super.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, inject);
    }

    @NonNull
    protected Environment createEnvironment(@NonNull ApplicationContextConfiguration configuration) {
        if (configuration.isEnableDefaultPropertySources()) {
            return new RuntimeConfiguredEnvironment(configuration, this.isBootstrapEnabled(configuration));
        }
        return new DefaultEnvironment(configuration);
    }

    private boolean isBootstrapEnabled(ApplicationContextConfiguration configuration) {
        String bootstrapContextProp = System.getProperty("micronaut.bootstrap.context");
        if (bootstrapContextProp != null) {
            return Boolean.parseBoolean(bootstrapContextProp);
        }
        Boolean configBootstrapEnabled = configuration.isBootstrapEnvironmentEnabled();
        return Objects.requireNonNullElseGet(configBootstrapEnabled, this::isBootstrapPropertySourceLocatorPresent);
    }

    private boolean isBootstrapPropertySourceLocatorPresent() {
        for (BeanDefinitionReference beanDefinitionReference : this.resolveBeanDefinitionReferences()) {
            if (!BootstrapPropertySourceLocator.class.isAssignableFrom(beanDefinitionReference.getBeanType())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public MutableConversionService getConversionService() {
        return this.getEnvironment();
    }

    @Override
    @NonNull
    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment(this.configuration);
            this.environmentManaged = true;
        }
        return this.environment;
    }

    @Internal
    public void setEnvironment(Environment environment) {
        this.environment = environment;
        this.environmentManaged = false;
    }

    @Override
    @NonNull
    public synchronized ApplicationContext start() {
        this.startEnvironment();
        return (ApplicationContext)super.start();
    }

    @Override
    protected void registerConversionService() {
    }

    @Override
    @NonNull
    public synchronized ApplicationContext stop() {
        ApplicationContext stop = (ApplicationContext)super.stop();
        if (this.environment != null && this.environmentManaged) {
            this.environment.stop();
        }
        this.environment = null;
        this.environmentManaged = false;
        return stop;
    }

    public boolean containsProperty(String name) {
        return this.getEnvironment().containsProperty(name);
    }

    public boolean containsProperties(String name) {
        return this.getEnvironment().containsProperties(name);
    }

    public <T> Optional<T> getProperty(String name, ArgumentConversionContext<T> conversionContext) {
        return this.getEnvironment().getProperty(name, conversionContext);
    }

    @NonNull
    public Collection<String> getPropertyEntries(@NonNull String name) {
        return this.getEnvironment().getPropertyEntries(name);
    }

    @NonNull
    public Map<String, Object> getProperties(@Nullable String name, @Nullable StringConvention keyFormat) {
        return this.getEnvironment().getProperties(name, keyFormat);
    }

    public Collection<List<String>> getPropertyPathMatches(String pathPattern) {
        return this.getEnvironment().getPropertyPathMatches(pathPattern);
    }

    @Override
    protected synchronized void registerConfiguration(BeanConfiguration configuration) {
        if (this.getEnvironment().isActive(configuration)) {
            super.registerConfiguration(configuration);
        }
    }

    protected void startEnvironment() {
        RuntimeBeanDefinition.Builder<Environment> definition;
        Environment defaultEnvironment = this.getEnvironment();
        defaultEnvironment.start();
        if (defaultEnvironment instanceof DefaultEnvironment) {
            DefaultEnvironment de = (DefaultEnvironment)defaultEnvironment;
            definition = RuntimeBeanDefinition.builder(DefaultEnvironment.class, () -> de);
        } else {
            definition = RuntimeBeanDefinition.builder(Environment.class, () -> defaultEnvironment);
        }
        definition = definition.singleton(true).qualifier(PrimaryQualifier.INSTANCE);
        RuntimeBeanDefinition<Environment> beanDefinition = definition.build();
        BeanDefinition existing = this.findBeanDefinition(beanDefinition.getBeanType()).orElse(null);
        if (existing instanceof RuntimeBeanDefinition) {
            RuntimeBeanDefinition runtimeBeanDefinition = (RuntimeBeanDefinition)existing;
            this.removeBeanDefinition(runtimeBeanDefinition);
        }
        this.registerBeanDefinition(beanDefinition);
    }

    @Override
    protected void initializeContext(List<DefaultBeanContext.BeanDefinitionProducer> contextScopeBeans, List<DefaultBeanContext.BeanDefinitionProducer> processedBeans, List<DefaultBeanContext.BeanDefinitionProducer> parallelBeans) {
        this.initializeTypeConverters(this);
        super.initializeContext(contextScopeBeans, processedBeans, parallelBeans);
    }

    @Override
    protected <T> NoSuchBeanException newNoSuchBeanException(@Nullable BeanResolutionContext resolutionContext, Argument<T> beanType, @Nullable Qualifier<T> qualifier, @Nullable String message) {
        if (message == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String ls = CachedEnvironment.getProperty("line.separator");
            this.appendBeanMissingMessage("", stringBuilder, ls, resolutionContext, beanType, qualifier);
            message = stringBuilder.toString();
        }
        return super.newNoSuchBeanException(resolutionContext, beanType, qualifier, message);
    }

    private <T> void appendBeanMissingMessage(String linePrefix, StringBuilder messageBuilder, String lineSeparator, @Nullable BeanResolutionContext resolutionContext, Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        if (linePrefix.length() == 10) {
            return;
        }
        List<BeanDefinition> beanCandidates = this.findBeanCandidates(resolutionContext, beanType, false, definition -> !definition.isAbstract()).stream().sorted(Comparator.comparing(BeanDefinition::getName)).toList();
        for (BeanDefinition definition2 : beanCandidates) {
            if (definition2 == null || !definition2.isIterable()) continue;
            if (definition2.hasDeclaredAnnotation(EachProperty.class)) {
                this.appendEachPropertyMissingBeanMessage(linePrefix, messageBuilder, lineSeparator, resolutionContext, beanType, qualifier, definition2);
                continue;
            }
            if (!definition2.hasDeclaredAnnotation(EachBean.class)) continue;
            this.appendMissingEachBeanMessage(linePrefix, messageBuilder, lineSeparator, resolutionContext, beanType, qualifier, definition2);
        }
        this.resolveDisabledBeanMessage(linePrefix, messageBuilder, lineSeparator, resolutionContext, beanType, qualifier);
    }

    private <T> void appendMissingEachBeanMessage(String linePrefix, StringBuilder messageBuilder, String lineSeparator, @Nullable BeanResolutionContext resolutionContext, Argument<T> beanType, @Nullable Qualifier<T> qualifier, BeanDefinition<T> definition) {
        Class dependentBean = (Class)definition.classValue(EachBean.class).orElseThrow();
        messageBuilder.append(lineSeparator).append(linePrefix).append("* [").append(beanType.getTypeString(true)).append("] requires the presence of a bean of type [").append(dependentBean.getName()).append("]");
        if (qualifier != null) {
            messageBuilder.append(" with qualifier [").append(qualifier).append("]");
        }
        messageBuilder.append(".");
        this.appendBeanMissingMessage(linePrefix + " ", messageBuilder, lineSeparator, resolutionContext, Argument.of((Class)dependentBean), qualifier);
    }

    @Nullable
    private <T> BeanDefinition<T> findAnyBeanDefinition(BeanResolutionContext resolutionContext, Argument<T> beanType) {
        Collection<BeanDefinition<T>> existing = super.findBeanCandidates(resolutionContext, beanType, false, definition -> !definition.isAbstract());
        BeanDefinition<T> definition2 = null;
        if (existing.size() == 1) {
            definition2 = existing.iterator().next();
        }
        return definition2;
    }

    private List<BeanDefinition<?>> calculateEachPropertyChain(BeanResolutionContext resolutionContext, BeanDefinition<?> definition) {
        ArrayList chain = new ArrayList();
        while (definition != null) {
            BeanDefinition dependent;
            chain.add(definition);
            Class<?> declaringClass = definition.getBeanType().getDeclaringClass();
            if (declaringClass == null || (dependent = this.findAnyBeanDefinition(resolutionContext, Argument.of(declaringClass))) == null || !dependent.isConfigurationProperties()) break;
            definition = dependent;
        }
        return chain;
    }

    @NonNull
    private <T> void appendEachPropertyMissingBeanMessage(String linePrefix, StringBuilder messageBuilder, String lineSeparator, @Nullable BeanResolutionContext resolutionContext, Argument<T> beanType, @Nullable Qualifier<T> qualifier, BeanDefinition<?> definition) {
        String prefix = this.calculatePrefix(resolutionContext, qualifier, definition);
        messageBuilder.append(lineSeparator).append(linePrefix).append("* [").append(definition.asArgument().getTypeString(true));
        if (!definition.getBeanType().equals(beanType.getType())) {
            messageBuilder.append("] a candidate of [").append(beanType.getTypeString(true));
        }
        messageBuilder.append("] is disabled because:").append(lineSeparator);
        messageBuilder.append(linePrefix).append(" - ").append("Configuration requires entries under the prefix: [").append(prefix).append("]");
    }

    private <T> String calculatePrefix(BeanResolutionContext resolutionContext, Qualifier<T> qualifier, BeanDefinition<?> definition) {
        Object prefix;
        List<BeanDefinition<?>> chain = this.calculateEachPropertyChain(resolutionContext, definition);
        if (chain.size() > 1) {
            Collections.reverse(chain);
            ConfigurationPath path = ConfigurationPath.of((BeanDefinition[])chain.toArray(BeanDefinition[]::new));
            prefix = path.path();
        } else {
            prefix = definition.stringValue(EachProperty.class).orElse("");
            if (qualifier != null) {
                if (qualifier instanceof Named) {
                    Named named = (Named)qualifier;
                    prefix = (String)prefix + "." + named.getName();
                } else {
                    prefix = (String)prefix + ".*";
                }
            } else {
                prefix = (String)prefix + "." + definition.stringValue(EachProperty.class, "primary").orElse("*");
            }
        }
        return prefix;
    }

    @Override
    protected <T> void collectIterableBeans(BeanResolutionContext resolutionContext, BeanDefinition<T> iterableBean, Set<BeanDefinition<T>> targetSet) {
        try (BeanResolutionContext rc = this.newResolutionContext(iterableBean, resolutionContext);){
            if (iterableBean.hasDeclaredStereotype(EachProperty.class)) {
                this.transformEachPropertyBeanDefinition(rc, iterableBean, targetSet);
            } else if (iterableBean.hasDeclaredStereotype(EachBean.class)) {
                this.transformEachBeanBeanDefinition(rc, iterableBean, targetSet);
            } else {
                this.transformConfigurationReaderBeanDefinition(rc, iterableBean, targetSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void transformConfigurationReaderBeanDefinition(BeanResolutionContext resolutionContext, BeanDefinition<T> candidate, Set<BeanDefinition<T>> transformedCandidates) {
        block12: {
            try {
                String prefix = candidate.stringValue(ConfigurationReader.class, "prefix").orElse(null);
                ConfigurationPath configurationPath = resolutionContext.getConfigurationPath();
                if (prefix == null) break block12;
                if (configurationPath.isNotEmpty()) {
                    if (configurationPath.isWithin(prefix)) {
                        ConfigurationPath newPath = configurationPath.copy();
                        newPath.pushConfigurationReader(candidate);
                        newPath.traverseResolvableSegments(this.getEnvironment(), subPath -> this.createAndAddDelegate(resolutionContext, candidate, transformedCandidates, (ConfigurationPath)subPath));
                        break block12;
                    }
                    ConfigurationPath newPath = ConfigurationPath.newPath();
                    resolutionContext.setConfigurationPath(newPath);
                    try {
                        newPath.pushConfigurationReader(candidate);
                        newPath.traverseResolvableSegments(this.getEnvironment(), subPath -> this.createAndAddDelegate(resolutionContext, candidate, transformedCandidates, (ConfigurationPath)subPath));
                        break block12;
                    }
                    finally {
                        resolutionContext.setConfigurationPath(configurationPath);
                    }
                }
                if (prefix.indexOf(42) == -1) {
                    transformedCandidates.add(candidate);
                } else {
                    Class<?> declaringClass = candidate.getBeanType().getDeclaringClass();
                    if (declaringClass != null) {
                        Collection beanCandidates = this.findBeanCandidates(resolutionContext, Argument.of(declaringClass), null);
                        for (BeanDefinition beanCandidate : beanCandidates) {
                            ConfigurationPath cp;
                            if (beanCandidate instanceof BeanDefinitionDelegate) {
                                BeanDefinitionDelegate delegate = (BeanDefinitionDelegate)beanCandidate;
                                cp = delegate.getConfigurationPath().orElse(configurationPath).copy();
                                cp.traverseResolvableSegments(this.getEnvironment(), subPath -> {
                                    subPath.pushConfigurationReader(candidate);
                                    if (this.getEnvironment().containsProperties(subPath.prefix())) {
                                        this.createAndAddDelegate(resolutionContext, candidate, transformedCandidates, (ConfigurationPath)subPath);
                                    }
                                });
                                continue;
                            }
                            cp = configurationPath.copy();
                            cp.pushConfigurationReader(beanCandidate);
                            cp.pushConfigurationReader(candidate);
                            cp.traverseResolvableSegments(this.getEnvironment(), subPath -> {
                                if (this.getEnvironment().containsProperties(subPath.prefix())) {
                                    this.createAndAddDelegate(resolutionContext, candidate, transformedCandidates, (ConfigurationPath)subPath);
                                }
                            });
                        }
                    }
                }
            }
            catch (IllegalStateException e) {
                throw new DependencyInjectionException(resolutionContext, e.getMessage(), (Throwable)e);
            }
        }
    }

    private <T> void transformEachBeanBeanDefinition(@NonNull BeanResolutionContext resolutionContext, BeanDefinition<T> originBeanDefinition, Set<BeanDefinition<T>> transformedCandidates) {
        AnnotationValue annotationValue = originBeanDefinition.getAnnotation(EachBean.class);
        if (annotationValue == null) {
            transformedCandidates.add(originBeanDefinition);
            return;
        }
        Class dependentType = (Class)annotationValue.getRequiredValue(Class.class);
        List remapGenerics = annotationValue.getAnnotations("remapGenerics");
        Collection dependentCandidates = this.findBeanCandidates(resolutionContext, Argument.of((Class)dependentType), true, null);
        if (!dependentCandidates.isEmpty()) {
            for (BeanDefinition dependentCandidate : dependentCandidates) {
                BeanDefinitionDelegate<T> delegate;
                ConfigurationPath dependentPath = null;
                if (dependentCandidate instanceof BeanDefinitionDelegate) {
                    BeanDefinitionDelegate delegate2 = (BeanDefinitionDelegate)dependentCandidate;
                    dependentPath = delegate2.getConfigurationPath().orElse(null);
                }
                if (dependentPath != null) {
                    this.createAndAddDelegate(resolutionContext, originBeanDefinition, transformedCandidates, dependentPath);
                    continue;
                }
                FilteringQualifier qualifier = dependentCandidate.getDeclaredQualifier();
                if (qualifier == null) {
                    qualifier = dependentCandidate.isPrimary() ? PrimaryQualifier.INSTANCE : new EachBeanQualifier(dependentCandidate);
                }
                Map<String, List<Argument<?>>> delegateTypeArguments = Map.of();
                if (remapGenerics != null) {
                    LinkedHashMap typeArguments = new LinkedHashMap();
                    List<Argument<?>> dependentArguments = dependentCandidate.getTypeArguments(dependentType);
                    for (AnnotationValue remapGeneric : remapGenerics) {
                        Class type = (Class)remapGeneric.getRequiredValue("type", Class.class);
                        String name = (String)remapGeneric.getRequiredValue("name", String.class);
                        String to = remapGeneric.stringValue("to").orElse(name);
                        dependentArguments.stream().filter(argument -> argument.getName().equals(name)).findFirst().ifPresent(argument -> typeArguments.computeIfAbsent(type.getName(), k -> new ArrayList()).add(argument.withName(to)));
                    }
                    delegateTypeArguments = typeArguments;
                }
                if (!(delegate = BeanDefinitionDelegate.create(originBeanDefinition, qualifier, delegateTypeArguments)).isEnabled(this, resolutionContext)) continue;
                transformedCandidates.add(delegate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void transformEachPropertyBeanDefinition(@NonNull BeanResolutionContext resolutionContext, BeanDefinition<T> candidate, Set<BeanDefinition<T>> transformedCandidates) {
        block9: {
            try {
                String prefix = candidate.stringValue(ConfigurationReader.class, "prefix").orElse(null);
                if (prefix == null) break block9;
                ConfigurationPath configurationPath = resolutionContext.getConfigurationPath();
                if (configurationPath.isWithin(prefix)) {
                    configurationPath.pushEachPropertyRoot(candidate);
                    try {
                        ConfigurationPath rootConfig = resolutionContext.getConfigurationPath();
                        rootConfig.traverseResolvableSegments(this.getEnvironment(), subPath -> this.createAndAddDelegate(resolutionContext, candidate, transformedCandidates, (ConfigurationPath)subPath));
                        break block9;
                    }
                    finally {
                        configurationPath.removeLast();
                    }
                }
                ConfigurationPath newPath = ConfigurationPath.newPath();
                resolutionContext.setConfigurationPath(newPath);
                try {
                    newPath.pushEachPropertyRoot(candidate);
                    newPath.traverseResolvableSegments(this.getEnvironment(), subPath -> this.createAndAddDelegate(resolutionContext, candidate, transformedCandidates, (ConfigurationPath)subPath));
                }
                finally {
                    resolutionContext.setConfigurationPath(configurationPath);
                }
            }
            catch (IllegalStateException e) {
                throw new DependencyInjectionException(resolutionContext, e.getMessage(), (Throwable)e);
            }
        }
    }

    private <T> void createAndAddDelegate(BeanResolutionContext resolutionContext, BeanDefinition<T> candidate, Set<BeanDefinition<T>> transformedCandidates, ConfigurationPath path) {
        BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(candidate, path.beanQualifier(), path);
        if (delegate.isEnabled(this, resolutionContext)) {
            transformedCandidates.add(delegate);
        }
    }

    @Override
    protected <T> BeanDefinition<T> findConcreteCandidate(Class<T> beanType, Qualifier<T> qualifier, Collection<BeanDefinition<T>> candidates) {
        if (!(qualifier instanceof Named)) {
            return super.findConcreteCandidate(beanType, qualifier, candidates);
        }
        for (BeanDefinition<T> candidate : candidates) {
            if (candidate.isIterable()) continue;
            return super.findConcreteCandidate(beanType, qualifier, candidates);
        }
        BeanDefinition<T> possibleCandidate = null;
        for (BeanDefinition<T> candidate : candidates) {
            Qualifier<T> delegateQualifier;
            if (!(candidate instanceof BeanDefinitionDelegate) || (delegateQualifier = candidate.resolveDynamicQualifier()) == null || !delegateQualifier.equals(qualifier)) continue;
            if (possibleCandidate == null) {
                possibleCandidate = candidate;
                continue;
            }
            return super.findConcreteCandidate(beanType, qualifier, candidates);
        }
        if (possibleCandidate != null) {
            return possibleCandidate;
        }
        return super.findConcreteCandidate(beanType, qualifier, candidates);
    }

    @Override
    public Optional<String> resolvePlaceholders(String str) {
        return this.getEnvironment().getPlaceholderResolver().resolvePlaceholders(str);
    }

    @Override
    public String resolveRequiredPlaceholders(String str) throws ConfigurationException {
        return this.getEnvironment().getPlaceholderResolver().resolveRequiredPlaceholders(str);
    }

    @Override
    protected <T> void destroyLifeCycleBean(LifeCycle<?> cycle, BeanDefinition<T> definition) {
        if (cycle != this.environment) {
            super.destroyLifeCycleBean(cycle, definition);
        }
    }

    protected void initializeTypeConverters(BeanContext beanContext) {
        DefaultMutableConversionService defaultMutableConversionService = (DefaultMutableConversionService)((DefaultEnvironment)this.getEnvironment()).getMutableConversionService();
        for (BeanRegistration<TypeConverter> typeConverterRegistration : beanContext.getBeanRegistrations(TypeConverter.class)) {
            TypeConverter typeConverter = typeConverterRegistration.getBean();
            List<Argument<TypeConverter>> typeArguments = typeConverterRegistration.getBeanDefinition().getTypeArguments(TypeConverter.class);
            if (typeArguments.size() != 2) continue;
            Class source = typeArguments.get(0).getType();
            Class target = typeArguments.get(1).getType();
            if (source == Object.class && target == Object.class) continue;
            defaultMutableConversionService.addInternalConverter(source, target, typeConverter);
        }
        defaultMutableConversionService.registerInternalTypeConverters(beanContext.getBeansOfType(TypeConverterRegistrar.class));
    }

    private final class RuntimeConfiguredEnvironment
    extends DefaultEnvironment {
        private final ApplicationContextConfiguration configuration;
        private BootstrapPropertySourceLocator bootstrapPropertySourceLocator;
        private BootstrapEnvironment bootstrapEnvironment;
        private final boolean bootstrapEnabled;

        RuntimeConfiguredEnvironment(ApplicationContextConfiguration configuration, boolean bootstrapEnabled) {
            super(configuration);
            this.configuration = configuration;
            this.bootstrapEnabled = bootstrapEnabled;
        }

        boolean isRuntimeConfigured() {
            return this.bootstrapEnabled;
        }

        @Override
        public Environment stop() {
            if (this.bootstrapEnvironment != null) {
                this.bootstrapEnvironment.stop();
            }
            return super.stop();
        }

        @Override
        public Environment start() {
            if (this.bootstrapEnvironment == null && this.isRuntimeConfigured()) {
                this.bootstrapEnvironment = this.createBootstrapEnvironment(this.getActiveNames().toArray(StringUtils.EMPTY_STRING_ARRAY));
                this.startBootstrapEnvironment();
            }
            return super.start();
        }

        @Override
        protected synchronized List<PropertySource> readPropertySourceList(String name) {
            if (this.bootstrapEnvironment != null) {
                DefaultBeanContext.LOG.info("Reading bootstrap environment configuration");
                this.refreshablePropertySources.addAll(this.bootstrapEnvironment.getRefreshablePropertySources());
                String[] environmentNamesArray = this.getActiveNames().toArray(StringUtils.EMPTY_STRING_ARRAY);
                BootstrapPropertySourceLocator bootstrapPropertySourceLocator = this.resolveBootstrapPropertySourceLocator(environmentNamesArray);
                for (PropertySource propertySource : bootstrapPropertySourceLocator.findPropertySources(this.bootstrapEnvironment)) {
                    this.addPropertySource(propertySource);
                    this.refreshablePropertySources.add(propertySource);
                }
                Collection<PropertySource> bootstrapPropertySources = this.bootstrapEnvironment.getPropertySources();
                for (PropertySource bootstrapPropertySource : bootstrapPropertySources) {
                    this.addPropertySource(bootstrapPropertySource);
                }
            }
            return super.readPropertySourceList(name);
        }

        private BootstrapPropertySourceLocator resolveBootstrapPropertySourceLocator(String ... environmentNames) {
            if (this.bootstrapPropertySourceLocator == null) {
                BootstrapApplicationContext bootstrapContext = new BootstrapApplicationContext(this.bootstrapEnvironment, environmentNames);
                bootstrapContext.start();
                if (bootstrapContext.containsBean(BootstrapPropertySourceLocator.class)) {
                    DefaultApplicationContext.this.initializeTypeConverters(bootstrapContext);
                    this.bootstrapPropertySourceLocator = bootstrapContext.getBean(BootstrapPropertySourceLocator.class);
                } else {
                    this.bootstrapPropertySourceLocator = BootstrapPropertySourceLocator.EMPTY_LOCATOR;
                }
            }
            return this.bootstrapPropertySourceLocator;
        }

        private BootstrapEnvironment createBootstrapEnvironment(String ... environmentNames) {
            return new BootstrapEnvironment(this.resourceLoader, this.mutableConversionService, this.configuration, environmentNames);
        }

        private void startBootstrapEnvironment() {
            for (PropertySource source : this.propertySources.values()) {
                this.bootstrapEnvironment.addPropertySource(source);
            }
            this.bootstrapEnvironment.start();
            for (String pkg : this.bootstrapEnvironment.getPackages()) {
                this.addPackage(pkg);
            }
        }
    }

    private final class BootstrapApplicationContext
    extends DefaultApplicationContext {
        private final BootstrapEnvironment bootstrapEnvironment;

        BootstrapApplicationContext(BootstrapEnvironment bootstrapEnvironment, String ... activeEnvironments) {
            super(DefaultApplicationContext.this.resourceLoader, activeEnvironments);
            this.bootstrapEnvironment = bootstrapEnvironment;
        }

        @Override
        @NonNull
        public Environment getEnvironment() {
            return this.bootstrapEnvironment;
        }

        @Override
        @NonNull
        protected BootstrapEnvironment createEnvironment(@NonNull ApplicationContextConfiguration configuration) {
            return this.bootstrapEnvironment;
        }

        @Override
        @NonNull
        protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
            List<BeanDefinitionReference> refs = DefaultApplicationContext.this.resolveBeanDefinitionReferences();
            ArrayList<BeanDefinitionReference> beanDefinitionReferences = new ArrayList<BeanDefinitionReference>(100);
            for (BeanDefinitionReference reference : refs) {
                if (!reference.isAnnotationPresent(BootstrapContextCompatible.class)) continue;
                beanDefinitionReferences.add(reference);
            }
            return beanDefinitionReferences;
        }

        @Override
        @NonNull
        protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
            return DefaultApplicationContext.this.resolveBeanConfigurations();
        }

        @Override
        protected void startEnvironment() {
            this.registerSingleton(Environment.class, this.bootstrapEnvironment, (Qualifier)null, false);
            this.registerSingleton(BootstrapContextAccess.class, () -> DefaultApplicationContext.this, (Qualifier)null, false);
        }

        @Override
        protected void initializeEventListeners() {
        }

        @Override
        protected void initializeContext(List<DefaultBeanContext.BeanDefinitionProducer> contextScopeBeans, List<DefaultBeanContext.BeanDefinitionProducer> processedBeans, List<DefaultBeanContext.BeanDefinitionProducer> parallelBeans) {
        }

        @Override
        protected void processParallelBeans(List<DefaultBeanContext.BeanDefinitionProducer> parallelBeans) {
        }

        @Override
        public void publishEvent(@NonNull Object event) {
        }
    }

    private static final class BootstrapEnvironment
    extends DefaultEnvironment {
        private List<PropertySource> propertySourceList;

        BootstrapEnvironment(final ClassPathResourceLoader resourceLoader, final MutableConversionService conversionService, final ApplicationContextConfiguration configuration, final String ... activeEnvironments) {
            super(new ApplicationContextConfiguration(){

                @Override
                public Optional<Boolean> getDeduceEnvironments() {
                    return Optional.of(false);
                }

                @Override
                @NonNull
                public ClassLoader getClassLoader() {
                    return resourceLoader.getClassLoader();
                }

                @Override
                @NonNull
                public List<String> getEnvironments() {
                    return Arrays.asList(activeEnvironments);
                }

                @Override
                public boolean isEnvironmentPropertySource() {
                    return configuration.isEnvironmentPropertySource();
                }

                @Override
                @Nullable
                public List<String> getEnvironmentVariableIncludes() {
                    return configuration.getEnvironmentVariableIncludes();
                }

                @Override
                @Nullable
                public List<String> getEnvironmentVariableExcludes() {
                    return configuration.getEnvironmentVariableExcludes();
                }

                @Override
                @NonNull
                public Optional<MutableConversionService> getConversionService() {
                    return Optional.of(conversionService);
                }

                @Override
                @NonNull
                public ClassPathResourceLoader getResourceLoader() {
                    return resourceLoader;
                }
            });
        }

        @Override
        protected String getPropertySourceRootName() {
            String bootstrapName = CachedEnvironment.getProperty("micronaut.bootstrap.name");
            return StringUtils.isNotEmpty((CharSequence)bootstrapName) ? bootstrapName : "bootstrap";
        }

        @Override
        protected boolean shouldDeduceEnvironments() {
            return false;
        }

        public List<PropertySource> getRefreshablePropertySources() {
            return this.refreshablePropertySources;
        }

        @Override
        protected List<PropertySource> readPropertySourceList(String name) {
            if (this.propertySourceList == null) {
                this.propertySourceList = super.readPropertySourceList(name).stream().map(BootstrapPropertySource::new).collect(Collectors.toList());
            }
            return this.propertySourceList;
        }
    }

    private static final class BootstrapPropertySource
    implements PropertySource {
        private final PropertySource delegate;

        BootstrapPropertySource(PropertySource bootstrapPropertySource) {
            this.delegate = bootstrapPropertySource;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public PropertySource.PropertyConvention getConvention() {
            return this.delegate.getConvention();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Object get(String key) {
            return this.delegate.get(key);
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegate.iterator();
        }

        public int getOrder() {
            return this.delegate.getOrder() + 10;
        }
    }
}

