/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.exceptions;

import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;

public class NoSuchBeanException
extends BeanContextException {
    private static final String MESSAGE_PREFIX = "No bean of type [";
    private static final String MESSAGE_SUFFIX = "] exists.";
    private static final String MESSAGE_EXISTS = "] exists";
    private static final String MESSAGE_FOR_THE_GIVEN_QUALIFIER = " for the given qualifier: ";

    public NoSuchBeanException(@NonNull Class<?> beanType) {
        super(MESSAGE_PREFIX + beanType.getName() + MESSAGE_SUFFIX + NoSuchBeanException.additionalMessage());
    }

    public NoSuchBeanException(@NonNull Argument<?> beanType) {
        super(MESSAGE_PREFIX + beanType.getTypeName() + MESSAGE_SUFFIX + NoSuchBeanException.additionalMessage());
    }

    public <T> NoSuchBeanException(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        super(MESSAGE_PREFIX + beanType.getName() + MESSAGE_EXISTS + (String)(qualifier != null ? MESSAGE_FOR_THE_GIVEN_QUALIFIER + qualifier : "") + "." + NoSuchBeanException.additionalMessage());
    }

    public <T> NoSuchBeanException(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        super(MESSAGE_PREFIX + beanType.getTypeName() + MESSAGE_EXISTS + (String)(qualifier != null ? MESSAGE_FOR_THE_GIVEN_QUALIFIER + qualifier : "") + "." + NoSuchBeanException.additionalMessage());
    }

    public <T> NoSuchBeanException(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, String message) {
        super(MESSAGE_PREFIX + beanType.getTypeName() + MESSAGE_EXISTS + (String)(qualifier != null ? MESSAGE_FOR_THE_GIVEN_QUALIFIER + qualifier : "") + ". " + message);
    }

    protected NoSuchBeanException(String message) {
        super(message);
    }

    @NonNull
    private static String additionalMessage() {
        return " Make sure the bean is not disabled by bean requirements (enable trace logging for 'io.micronaut.context.condition' to check) and if the bean is enabled then ensure the class is declared a bean and annotation processing is enabled (for Java and Kotlin the 'micronaut-inject-java' dependency should be configured as an annotation processor).";
    }
}

