/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.Internal;
import java.util.Arrays;
import java.util.Objects;

@Internal
public record MatchesPresenceOfClassesCondition(AnnotationClassValue<?>[] classes) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        for (AnnotationClassValue<?> classValue : this.classes) {
            if (!classValue.getType().isEmpty()) continue;
            context.fail("Class [" + classValue.getName() + "] is not present");
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesPresenceOfClassesCondition that = (MatchesPresenceOfClassesCondition)o;
        return Objects.deepEquals(this.classes, that.classes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.classes);
    }

    @Override
    public String toString() {
        return "MatchesPresenceOfClassesCondition{classes=" + Arrays.toString(this.classes) + "}";
    }
}

