/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import java.util.Objects;

@Internal
public record MatchesPropertyCondition(@NonNull String property, @Nullable String value, @Nullable String defaultValue, @NonNull Condition condition) implements io.micronaut.context.condition.Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof PropertyResolver) {
            PropertyResolver propertyResolver = (PropertyResolver)beanContext;
            boolean contains = propertyResolver.containsProperties(this.property);
            if (!contains && StringUtils.isEmpty((CharSequence)this.defaultValue)) {
                switch (this.condition) {
                    case CONTAINS: 
                    case PATTERN: {
                        context.fail("Required property [" + this.property + "] not present");
                        break;
                    }
                    case EQUALS: {
                        context.fail("Required property [" + this.property + "] with value [" + this.value + "] not present");
                        break;
                    }
                    case NOT_EQUALS: {
                        return true;
                    }
                }
                return false;
            }
            if (this.condition == Condition.CONTAINS) {
                return true;
            }
            String resolved = this.resolvePropertyValue(this.property, propertyResolver, this.defaultValue);
            return switch (this.condition) {
                case Condition.EQUALS -> {
                    boolean result;
                    boolean v0 = result = resolved != null && resolved.equals(this.value);
                    if (!result) {
                        context.fail("Property [" + this.property + "] with value [" + resolved + "] does not equal required value: " + this.value);
                    }
                    yield result;
                }
                case Condition.NOT_EQUALS -> {
                    boolean result;
                    boolean v2 = result = resolved == null || !resolved.equals(this.value);
                    if (!result) {
                        context.fail("Property [" + this.property + "] with value [" + resolved + "] should not equal: " + this.value);
                    }
                    yield result;
                }
                case Condition.PATTERN -> {
                    boolean result;
                    boolean v3 = result = resolved != null && resolved.matches(this.value);
                    if (!result) {
                        context.fail("Property [" + this.property + "] with value [" + resolved + "] does not match required pattern: " + this.value);
                    }
                    yield result;
                }
                default -> throw new IllegalStateException("Unexpected value: " + this.condition);
            };
        }
        context.fail("Bean requires property but BeanContext does not support property resolution");
        return false;
    }

    private String resolvePropertyValue(String property, PropertyResolver propertyResolver, String defaultValue) {
        return propertyResolver.getProperty(property, ConversionContext.STRING).orElse(defaultValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesPropertyCondition that = (MatchesPropertyCondition)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.property, that.property) && Objects.equals(this.defaultValue, that.defaultValue) && this.condition == that.condition;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.property, this.value, this.defaultValue, this.condition});
    }

    @Override
    public String toString() {
        return "MatchesPropertyCondition{property='" + this.property + "', value='" + this.value + "', defaultValue='" + this.defaultValue + "', condition=" + this.condition + "}";
    }

    public static enum Condition {
        CONTAINS,
        EQUALS,
        NOT_EQUALS,
        PATTERN;

    }
}

