/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import java.util.Arrays;
import java.util.Objects;

@Internal
class DefaultConstructorInjectionPoint<T>
implements ConstructorInjectionPoint<T>,
EnvironmentConfigurable {
    private final BeanDefinition<T> declaringBean;
    private final Class<T> declaringType;
    private final Class<?>[] argTypes;
    private final AnnotationMetadata annotationMetadata;
    private final Argument<?>[] arguments;
    private Environment environment;

    DefaultConstructorInjectionPoint(BeanDefinition<T> declaringBean, Class<T> declaringType, AnnotationMetadata annotationMetadata, Argument<?>[] arguments) {
        this.argTypes = Argument.toClassArray(arguments);
        this.declaringBean = declaringBean;
        this.declaringType = declaringType;
        this.annotationMetadata = !(annotationMetadata instanceof DefaultAnnotationMetadata) ? AnnotationMetadata.EMPTY_METADATA : (annotationMetadata.hasPropertyExpressions() ? new ConstructorAnnotationMetadata((DefaultAnnotationMetadata)annotationMetadata) : annotationMetadata);
        this.arguments = arguments == null ? Argument.ZERO_ARGUMENTS : arguments;
    }

    @Override
    public final boolean hasPropertyExpressions() {
        return this.annotationMetadata.hasPropertyExpressions();
    }

    @Override
    public void configure(Environment environment) {
        this.environment = environment;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    @NonNull
    public Argument<?>[] getArguments() {
        return this.arguments;
    }

    @Override
    @NonNull
    public BeanDefinition<T> getDeclaringBean() {
        return this.declaringBean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConstructorInjectionPoint that = (DefaultConstructorInjectionPoint)o;
        return Objects.equals(this.declaringType, that.declaringType) && Arrays.equals(this.argTypes, that.argTypes);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.declaringType, this.argTypes);
    }

    public String toString() {
        return this.declaringType.getName() + "(" + Argument.toString(this.arguments) + ")";
    }

    private final class ConstructorAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        ConstructorAnnotationMetadata(DefaultAnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return DefaultConstructorInjectionPoint.this.environment;
        }
    }
}

